/*
 * Decompiled with CFR 0.152.
 */
package minium;

import com.google.common.base.Objects;
import minium.Dimension;
import minium.Point;
import minium.Rectangle;
import minium.internal.InternalOffsets;

public class Offsets {
    public static Offset at(HorizontalOffset horizontal, VerticalOffset vertical) {
        return new InternalOffsets.OffsetImpl(horizontal, vertical);
    }

    public static Offset at(String pos) throws ParseException {
        return new InternalOffsets.Parser().parse(pos);
    }

    public static enum HorizontalReference implements HorizontalOffset
    {
        LEFT("left"){

            @Override
            public double apply(double width) {
                return 0.0;
            }
        }
        ,
        CENTER("center"){

            @Override
            public double apply(double width) {
                return width / 2.0;
            }
        }
        ,
        RIGHT("right"){

            @Override
            public double apply(double width) {
                return width;
            }
        }
        ,
        MINUS_INF("-inf"){

            @Override
            public double apply(double width) {
                return Double.NEGATIVE_INFINITY;
            }

            @Override
            public UnitHorizontalOffset plus(double val) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HorizontalOffset plus(double val, Unit unit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public UnitHorizontalOffset minus(double val) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HorizontalOffset minus(double val, Unit unit) {
                throw new UnsupportedOperationException();
            }
        }
        ,
        PLUS_INF("+inf"){

            @Override
            public double apply(double width) {
                return Double.POSITIVE_INFINITY;
            }

            @Override
            public UnitHorizontalOffset plus(double val) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HorizontalOffset plus(double val, Unit unit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public UnitHorizontalOffset minus(double val) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HorizontalOffset minus(double val, Unit unit) {
                throw new UnsupportedOperationException();
            }
        };

        private final String name;

        private HorizontalReference(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static HorizontalReference of(String name) {
            for (HorizontalReference ref : HorizontalReference.values()) {
                if (!Objects.equal((Object)ref.name, (Object)name)) continue;
                return ref;
            }
            return null;
        }

        @Override
        public UnitHorizontalOffset plus(double val) {
            return new InternalOffsets.UnitHorizontalOffsetImpl(this, val);
        }

        @Override
        public HorizontalOffset plus(double val, Unit unit) {
            return new InternalOffsets.AbstractHorizontalOffset(this, val, unit);
        }

        @Override
        public UnitHorizontalOffset minus(double val) {
            return this.plus(-val);
        }

        @Override
        public HorizontalOffset minus(double val, Unit unit) {
            return this.plus(-val, unit);
        }
    }

    public static enum VerticalReference implements VerticalOffset
    {
        TOP("top"){

            @Override
            public double apply(double height) {
                return 0.0;
            }
        }
        ,
        MIDDLE("center"){

            @Override
            public double apply(double height) {
                return height / 2.0;
            }
        }
        ,
        BOTTOM("bottom"){

            @Override
            public double apply(double height) {
                return height;
            }
        }
        ,
        MINUS_INF("-inf"){

            @Override
            public double apply(double height) {
                return Double.NEGATIVE_INFINITY;
            }

            @Override
            public UnitVerticalOffset plus(double val) {
                throw new UnsupportedOperationException();
            }

            @Override
            public VerticalOffset plus(double val, Unit unit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public UnitVerticalOffset minus(double val) {
                throw new UnsupportedOperationException();
            }

            @Override
            public VerticalOffset minus(double val, Unit unit) {
                throw new UnsupportedOperationException();
            }
        }
        ,
        PLUS_INF("+inf"){

            @Override
            public double apply(double height) {
                return Double.POSITIVE_INFINITY;
            }

            @Override
            public UnitVerticalOffset plus(double val) {
                throw new UnsupportedOperationException();
            }

            @Override
            public VerticalOffset plus(double val, Unit unit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public UnitVerticalOffset minus(double val) {
                throw new UnsupportedOperationException();
            }

            @Override
            public VerticalOffset minus(double val, Unit unit) {
                throw new UnsupportedOperationException();
            }
        };

        private final String name;

        private VerticalReference(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static VerticalReference of(String name) {
            for (VerticalReference ref : VerticalReference.values()) {
                if (!Objects.equal((Object)ref.name, (Object)name)) continue;
                return ref;
            }
            return null;
        }

        @Override
        public UnitVerticalOffset plus(double val) {
            return new InternalOffsets.UnitVerticalOffsetImpl(this, val);
        }

        @Override
        public VerticalOffset plus(double val, Unit unit) {
            return new InternalOffsets.AbstractVerticalOffset(this, val, unit);
        }

        @Override
        public UnitVerticalOffset minus(double val) {
            return this.plus(-val);
        }

        @Override
        public VerticalOffset minus(double val, Unit unit) {
            return this.plus(-val, unit);
        }
    }

    public static enum Unit {
        PIXEL("px"),
        PERCENT("%");

        private final String name;

        private Unit(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Unit of(String name) {
            for (Unit unit : Unit.values()) {
                if (!Objects.equal((Object)unit.name, (Object)name)) continue;
                return unit;
            }
            return null;
        }
    }

    public static interface UnitVerticalOffset {
        public VerticalOffset percent();

        public VerticalOffset pixels();
    }

    public static interface VerticalOffset {
        public UnitVerticalOffset plus(double var1);

        public VerticalOffset plus(double var1, Unit var3);

        public UnitVerticalOffset minus(double var1);

        public VerticalOffset minus(double var1, Unit var3);

        public double apply(double var1);
    }

    public static interface UnitHorizontalOffset
    extends HorizontalOffset {
        public HorizontalOffset percent();

        public HorizontalOffset pixels();
    }

    public static interface HorizontalOffset {
        public UnitHorizontalOffset plus(double var1);

        public HorizontalOffset plus(double var1, Unit var3);

        public UnitHorizontalOffset minus(double var1);

        public HorizontalOffset minus(double var1, Unit var3);

        public double apply(double var1);
    }

    public static interface Offset {
        public HorizontalOffset horizontal();

        public VerticalOffset vertical();

        public Point apply(Rectangle var1);

        public Point offset(Dimension var1);
    }

    public static class ParseException
    extends RuntimeException {
        private static final long serialVersionUID = 866185720502410258L;

        public ParseException() {
        }

        public ParseException(String message, Throwable cause) {
            super(message, cause);
        }

        public ParseException(String message) {
            super(message);
        }

        public ParseException(Throwable cause) {
            super(cause);
        }
    }
}

