/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.ext.web.Router;
import io.vertx.test.core.VertxTestBase;
import org.junit.Assume;
import org.junit.Test;

public class VirtualThreadTest
extends VertxTestBase {
    @Test
    public void testBlockingHandler() {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        HttpServer server = this.vertx.createHttpServer();
        HttpClient client = this.vertx.createHttpClient();
        Router router = Router.router((Vertx)this.vertx);
        server.requestHandler((Handler)router);
        router.get("/").blockingHandler(request -> {
            Future.await((Future)this.vertx.timer(200L));
            request.response().end("Hello");
        });
        ContextInternal context = ((VertxInternal)this.vertx).createVirtualThreadContext();
        context.runOnContext(v -> {
            Future.await((Future)server.listen(8080, "localhost"));
            long now = System.currentTimeMillis();
            Buffer body = (Buffer)Future.await((Future)client.request(HttpMethod.GET, 8080, "localhost", "/").compose(req -> req.send().compose(HttpClientResponse::body)));
            this.assertEquals("Hello", body.toString());
            this.assertTrue(System.currentTimeMillis() - now >= 200L);
            this.testComplete();
        });
        this.await();
    }
}

