/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.RegistrationInfo;
import io.vertx.core.spi.cluster.WrappedClusterManager;
import io.vertx.ext.bridge.BridgeEventType;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.EventbusBridgeTest;
import io.vertx.ext.web.handler.sockjs.SockJSBridgeOptions;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakecluster.FakeClusterManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SlowClusterEventbusBridgeTest
extends VertxTestBase {
    private final EventbusBridgeTest.Transport transport;
    private VertxInternal node1;
    private VertxInternal node2;
    private Router router;
    private HttpServer server;
    private HttpClient client;
    protected SockJSHandler sockJS;

    @Parameterized.Parameters(name="{index}: transport = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({EventbusBridgeTest.Transport.RAW_WS}, {EventbusBridgeTest.Transport.WS});
    }

    public SlowClusterEventbusBridgeTest(EventbusBridgeTest.Transport transport) {
        this.transport = transport;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.startNodes(2);
        this.node1 = (VertxInternal)this.vertices[0];
        this.node2 = (VertxInternal)this.vertices[1];
        this.router = Router.router((Vertx)this.node1);
        this.server = this.node1.createHttpServer();
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler((Handler)this.router).listen(0).onComplete(this.onSuccess(res -> latch.countDown()));
        this.awaitLatch(latch);
        this.client = this.node1.createHttpClient(new HttpClientOptions().setDefaultPort(this.server.actualPort()));
        this.sockJS = SockJSHandler.create((Vertx)this.node1);
    }

    protected ClusterManager getClusterManager() {
        return new SlowClusterManager(this.vertx);
    }

    @Test
    public void testRegistration() throws Exception {
        String payload = "hello slinkydeveloper!";
        String addr = "someaddress";
        String websocketURI = "/eventbus/websocket";
        AtomicInteger step = new AtomicInteger();
        SockJSBridgeOptions allAccessOptions = new SockJSBridgeOptions().addInboundPermitted(new PermittedOptions()).addOutboundPermitted(new PermittedOptions());
        this.router.route("/eventbus/*").subRouter(this.sockJS.bridge(allAccessOptions, be -> {
            if (be.type() == BridgeEventType.REGISTER) {
                this.assertTrue(step.compareAndSet(0, 1));
                this.assertNotNull(be.socket());
                JsonObject raw = be.getRawMessage();
                this.assertEquals(addr, raw.getString("address"));
            } else if (be.type() == BridgeEventType.REGISTERED) {
                this.assertTrue(step.compareAndSet(1, 2));
                this.assertNotNull(be.socket());
                JsonObject raw = be.getRawMessage();
                this.assertEquals(addr, raw.getString("address"));
                this.node2.eventBus().send(addr, (Object)payload);
            }
            be.complete((Object)true);
        }));
        EventbusBridgeTest.BridgeClient bridgeClient = new EventbusBridgeTest.BridgeClient(this.client, this.transport);
        bridgeClient.handler((address, received) -> {
            this.assertTrue(step.compareAndSet(2, 3));
            this.assertEquals(addr, address);
            this.assertEquals(payload, received.getString("body"));
            bridgeClient.close().onComplete(this.onSuccess(v -> this.complete()));
        });
        this.waitFor(2);
        bridgeClient.connect(websocketURI).compose(v -> bridgeClient.register(addr)).onComplete(this.onSuccess(v -> this.complete()));
        this.await();
    }

    @Test
    public void testNoOrphanClusteredSubscription() throws Exception {
        String addr = "someaddress";
        String websocketURI = "/eventbus/websocket";
        SockJSBridgeOptions allAccessOptions = new SockJSBridgeOptions().addInboundPermitted(new PermittedOptions()).addOutboundPermitted(new PermittedOptions());
        this.router.route("/eventbus/*").subRouter(this.sockJS.bridge(allAccessOptions));
        EventbusBridgeTest.BridgeClient bridgeClient = new EventbusBridgeTest.BridgeClient(this.client, this.transport);
        bridgeClient.connect(websocketURI).compose(v -> bridgeClient.register(addr)).compose(v -> bridgeClient.unregister(addr)).onComplete(this.onSuccess(v -> {
            Promise promise = Promise.promise();
            this.node1.setTimer(1500L, l -> {
                this.node1.getClusterManager().getRegistrations(addr, promise);
                promise.future().onComplete(this.onSuccess(registrationInfos -> {
                    this.assertTrue(registrationInfos == null || registrationInfos.isEmpty());
                    this.testComplete();
                }));
            });
        }));
        this.await();
    }

    private static class SlowClusterManager
    extends WrappedClusterManager {
        final Vertx vertx;

        SlowClusterManager(Vertx vertx) {
            super((ClusterManager)new FakeClusterManager());
            this.vertx = vertx;
        }

        public void addRegistration(String address, RegistrationInfo registrationInfo, Promise<Void> promise) {
            this.vertx.setTimer(1000L, l -> super.addRegistration(address, registrationInfo, promise));
        }
    }
}

