/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthorizationHandler;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CorsHandler;
import io.vertx.ext.web.handler.OAuth2AuthHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.sockjs.SockJSBridgeOptions;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.ext.web.sstore.SessionStore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class RouterValidationTest {
    @Rule
    public final RunTestOnContext rule = new RunTestOnContext();

    @Test
    public void addBodyHandler() {
        Router router = Router.router((Vertx)this.rule.vertx());
        router.route().handler((Handler)BodyHandler.create());
    }

    @Test
    public void addBodyHandlerAndUserHandler() {
        Router router = Router.router((Vertx)this.rule.vertx());
        router.route().handler((Handler)BodyHandler.create()).handler(RoutingContext::end);
    }

    @Test(expected=IllegalStateException.class)
    public void addBodyHandlerAndUserHandlerBadOrder() {
        Router router = Router.router((Vertx)this.rule.vertx());
        router.route().handler(RoutingContext::end).handler((Handler)BodyHandler.create());
    }

    @Test
    public void addBodyHandlerAndAuthn() {
        Router router = Router.router((Vertx)this.rule.vertx());
        router.route().handler((Handler)BodyHandler.create()).handler((Handler)OAuth2AuthHandler.create((Vertx)this.rule.vertx(), (OAuth2Auth)OAuth2Auth.create((Vertx)this.rule.vertx(), (OAuth2Options)new OAuth2Options().setClientId("test-id"))));
    }

    @Test
    public void addBodyHandlerAndAuthnAuthz() {
        Router router = Router.router((Vertx)this.rule.vertx());
        router.route().handler((Handler)SessionHandler.create((SessionStore)SessionStore.create((Vertx)this.rule.vertx()))).handler((Handler)OAuth2AuthHandler.create((Vertx)this.rule.vertx(), (OAuth2Auth)OAuth2Auth.create((Vertx)this.rule.vertx(), (OAuth2Options)new OAuth2Options().setClientId("test-id")))).handler((Handler)AuthorizationHandler.create((Authorization)RoleBasedAuthorization.create((String)"my-role")));
    }

    @Test(expected=IllegalStateException.class)
    public void addBodyHandlerAndAuthnAuthzBadOrder() {
        Router router = Router.router((Vertx)this.rule.vertx());
        router.route().handler((Handler)SessionHandler.create((SessionStore)SessionStore.create((Vertx)this.rule.vertx()))).handler((Handler)AuthorizationHandler.create((Authorization)RoleBasedAuthorization.create((String)"my-role"))).handler((Handler)OAuth2AuthHandler.create((Vertx)this.rule.vertx(), (OAuth2Auth)OAuth2Auth.create((Vertx)this.rule.vertx(), (OAuth2Options)new OAuth2Options().setClientId("test-id"))));
    }

    @Test(expected=IllegalStateException.class)
    public void addBodyHandlerAndAuthnAuthzBadOrder2() {
        Router router = Router.router((Vertx)this.rule.vertx());
        router.route().handler((Handler)OAuth2AuthHandler.create((Vertx)this.rule.vertx(), (OAuth2Auth)OAuth2Auth.create((Vertx)this.rule.vertx(), (OAuth2Options)new OAuth2Options().setClientId("test-id")))).handler((Handler)AuthorizationHandler.create((Authorization)RoleBasedAuthorization.create((String)"my-role"))).handler((Handler)SessionHandler.create((SessionStore)SessionStore.create((Vertx)this.rule.vertx())));
    }

    @Test
    public void addSecurityPolicyAndUserHandlers() {
        Router router = Router.router((Vertx)this.rule.vertx());
        router.route().handler((Handler)CorsHandler.create()).subRouter(SockJSHandler.create((Vertx)this.rule.vertx()).bridge(new SockJSBridgeOptions()));
    }

    @Test(expected=IllegalStateException.class)
    public void addSecurityPolicyAndUserHandlersBadOrder() {
        Router router = Router.router((Vertx)this.rule.vertx());
        router.route().subRouter(SockJSHandler.create((Vertx)this.rule.vertx()).bridge(new SockJSBridgeOptions())).handler((Handler)CorsHandler.create());
    }

    @Test(expected=IllegalStateException.class)
    public void addSecurityPolicyAndUserHandlersBadOrder2() {
        Router router = Router.router((Vertx)this.rule.vertx());
        router.route().handler(RoutingContext::end).handler((Handler)CorsHandler.create());
    }
}

