/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.it;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.file.FileSystem;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.webauthn.Attestation;
import io.vertx.ext.auth.webauthn.AuthenticatorAttachment;
import io.vertx.ext.auth.webauthn.RelyingParty;
import io.vertx.ext.auth.webauthn.UserVerification;
import io.vertx.ext.auth.webauthn.WebAuthn;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.WebAuthnHandler;
import io.vertx.ext.web.impl.RoutingContextInternal;
import io.vertx.ext.web.it.AuthenticatorStore;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import java.util.ArrayList;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class FIDO2TCK {
    private static final String ORIGIN;
    private static final String[] MDS3;
    private static final String[] MDS2;
    private static final String MDS3_ROOT_CERTIFICATE = "MIICaDCCAe6gAwIBAgIPBCqih0DiJLW7+UHXx/o1MAoGCCqGSM49BAMDMGcxCzAJBgNVBAYTAlVTMRYwFAYDVQQKDA1GSURPIEFsbGlhbmNlMScwJQYDVQQLDB5GQUtFIE1ldGFkYXRhIDMgQkxPQiBST09UIEZBS0UxFzAVBgNVBAMMDkZBS0UgUm9vdCBGQUtFMB4XDTE3MDIwMTAwMDAwMFoXDTQ1MDEzMTIzNTk1OVowZzELMAkGA1UEBhMCVVMxFjAUBgNVBAoMDUZJRE8gQWxsaWFuY2UxJzAlBgNVBAsMHkZBS0UgTWV0YWRhdGEgMyBCTE9CIFJPT1QgRkFLRTEXMBUGA1UEAwwORkFLRSBSb290IEZBS0UwdjAQBgcqhkjOPQIBBgUrgQQAIgNiAASKYiz3YltC6+lmxhPKwA1WFZlIqnX8yL5RybSLTKFAPEQeTD9O6mOz+tg8wcSdnVxHzwnXiQKJwhrav70rKc2ierQi/4QUrdsPes8TEirZOkCVJurpDFbXZOgs++pa4XmjYDBeMAsGA1UdDwQEAwIBBjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBQGcfeCs0Y8D+lh6U5B2xSrR74eHTAfBgNVHSMEGDAWgBQGcfeCs0Y8D+lh6U5B2xSrR74eHTAKBggqhkjOPQQDAwNoADBlAjEA/xFsgri0xubSa3y3v5ormpPqCwfqn9s0MLBAtzCIgxQ/zkzPKctkiwoPtDzI51KnAjAmeMygX2S5Ht8+e+EQnezLJBJXtnkRWY+Zt491wgt/AwSs5PHHMv5QgjELOuMxQBc=";
    private static final String MDS2_ROOT_CERTIFICATE = "MIICZzCCAe6gAwIBAgIPBF0rd3WL/GExWV/szYNVMAoGCCqGSM49BAMDMGcxCzAJBgNVBAYTAlVTMRYwFAYDVQQKDA1GSURPIEFsbGlhbmNlMScwJQYDVQQLDB5GQUtFIE1ldGFkYXRhIFRPQyBTaWduaW5nIEZBS0UxFzAVBgNVBAMMDkZBS0UgUm9vdCBGQUtFMB4XDTE3MDIwMTAwMDAwMFoXDTQ1MDEzMTIzNTk1OVowZzELMAkGA1UEBhMCVVMxFjAUBgNVBAoMDUZJRE8gQWxsaWFuY2UxJzAlBgNVBAsMHkZBS0UgTWV0YWRhdGEgVE9DIFNpZ25pbmcgRkFLRTEXMBUGA1UEAwwORkFLRSBSb290IEZBS0UwdjAQBgcqhkjOPQIBBgUrgQQAIgNiAARcVLd6r4fnNHzs5K2zfbg//4X9/oBqmsdRVtZ9iXhlgM9vFYaKviYtqmwkq0D3Lihg3qefeZgXXYi4dFgvzU7ZLBapSNM3CT8RDBe/MBJqsPwaRQbIsGmmItmt/ESNQD6jYDBeMAsGA1UdDwQEAwIBBjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBTd95rIHO/hX9Oh69szXzD0ahmZWTAfBgNVHSMEGDAWgBTd95rIHO/hX9Oh69szXzD0ahmZWTAKBggqhkjOPQQDAwNnADBkAjBkP3L99KEXQzviJVGytDMWBmITMBYv1LgNXXiSilWixTyQqHrYrFpLvNFyPZQvS6sCMFMAOUCwAch/515XH0XlDbMgdIe2N4zzdY77TVwiHmsxTFWRT0FtS7fUk85c/LzSPQ==";
    private static final String MDS3_MDSCA_1_CRL = "MIIB7DCCAZICAQEwCgYIKoZIzj0EAwIwbzELMAkGA1UEBhMCVVMxFjAUBgNVBAoMDUZJRE8gQWxsaWFuY2UxLzAtBgNVBAsMJkZBS0UgTWV0YWRhdGEgMyBCTE9CIElOVEVSTUVESUFURSBGQUtFMRcwFQYDVQQDDA5GQUtFIENBLTEgRkFLRRcNMTgwMjAxMDAwMDAwWhcNMjIwMjAxMDAwMDAwWjCBwDAuAg8ELS9CzLtxNJTOFTHXiV8XDTE2MDQxMzAwMDAwMFowDDAKBgNVHRUEAwoBADAuAg8ExejzukpclaXnFLGvxDEXDTE3MDMyNTAwMDAwMFowDDAKBgNVHRUEAwoBADAuAg8Er13ouX8KNf3VOr4OzQEXDTE2MDMwMTAwMDAwMFowDDAKBgNVHRUEAwoBADAuAg8EgGdJ3jB7vVF1om1z9fMXDTE4MDMyNTAwMDAwMFowDDAKBgNVHRUEAwoBAKAvMC0wCgYDVR0UBAMCAQEwHwYDVR0jBBgwFoAUo4SnpGSiiTwKvxeeog3wEhqm18swCgYIKoZIzj0EAwIDSAAwRQIgDgtshLf5/82mHcOgl2TsUizHsjLCslmQVDdSPcolS8UCIQDa5MSjQbX1v8MkCPpzxbrBb1I510aSTuZB0RUuwPnOYw==";
    private static final String MDS3_MDSROOT_CRL = "MIIB1zCCAV0CAQEwCgYIKoZIzj0EAwMwZzELMAkGA1UEBhMCVVMxFjAUBgNVBAoMDUZJRE8gQWxsaWFuY2UxJzAlBgNVBAsMHkZBS0UgTWV0YWRhdGEgMyBCTE9CIFJPT1QgRkFLRTEXMBUGA1UEAwwORkFLRSBSb290IEZBS0UXDTE4MDIwMTAwMDAwMFoXDTIwMDIwMTAwMDAwMFowgZMwLwIQBCZYfWbvAtCiCiDkzlVBNhcNMTQwMzAxMDAwMDAwWjAMMAoGA1UdFQQDCgEAMC8CEDB1uuLr+thg94Dk2tjuTl0XDTE0MDQxMzAwMDAwMFowDDAKBgNVHRUEAwoBADAvAhBZqgqFaRNC66FNnJfk9beCFw0xNTAzMjUwMDAwMDBaMAwwCgYDVR0VBAMKAQCgLzAtMAoGA1UdFAQDAgEBMB8GA1UdIwQYMBaAFAZx94KzRjwP6WHpTkHbFKtHvh4dMAoGCCqGSM49BAMDA2gAMGUCMHK+tW8lZLZ3qMxwVcOEgZiX3oEaM7WteieaoKg+R54cCzsgS/GmgIfn/dzWDKYhmgIxAKr6/S8asTsF9yoon6hvzh+qzseltavkr7iu7BVs2dMG6WStr9P9gRvhk2UCxbk6Wg==";
    @Rule
    public RunTestOnContext rule = new RunTestOnContext();
    AuthenticatorStore database;

    @Before
    public void init() {
        this.database = new AuthenticatorStore(this.rule.vertx().getOrCreateContext());
    }

    @Test(timeout=300000L)
    @Ignore(value="This test needs to be executed manually against the Conformance Tools")
    public void testServerForFIDO2TCK(TestContext should) {
        Async test = should.async();
        Vertx vertx = this.rule.vertx();
        FileSystem fs = vertx.fileSystem();
        this.database.clear();
        WebAuthnOptions config = new WebAuthnOptions().setRelyingParty(new RelyingParty().setName("Vert.x Conformance Test 4.3.4")).putRootCertificate("mds", MDS3_ROOT_CERTIFICATE).addRootCrl(MDS3_MDSCA_1_CRL);
        WebAuthn webAuthN = WebAuthn.create((Vertx)vertx, (WebAuthnOptions)config).authenticatorFetcher(this.database::fetcher).authenticatorUpdater(this.database::updater);
        if (fs.existsBlocking("metadataStatements")) {
            for (String f : fs.readDirBlocking("metadataStatements")) {
                System.out.println("Loading metadata statement: " + f);
                webAuthN.metaDataService().addStatement(new JsonObject(fs.readFileBlocking(f)));
            }
        } else {
            should.fail("test metadata statements are not in the filesystem!");
            return;
        }
        ArrayList<Future> futures = new ArrayList<Future>();
        for (String el : MDS3) {
            System.out.println("Loading toc: " + el);
            futures.add(webAuthN.metaDataService().fetchTOC(el));
        }
        CompositeFuture.all(futures).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(done -> {
            Router app = Router.router((Vertx)vertx);
            app.post().handler((Handler)BodyHandler.create());
            app.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)vertx)));
            app.post("/attestation/options").handler(ctx -> {
                JsonObject authenticatorSelection;
                JsonObject json = ctx.body().asJsonObject();
                if (json.containsKey("username")) {
                    String username = json.getString("username");
                    json.remove("username");
                    json.put("name", (Object)username);
                    ((RoutingContextInternal)ctx).setBody(json.toBuffer());
                }
                if ((authenticatorSelection = json.getJsonObject("authenticatorSelection")) != null) {
                    if (authenticatorSelection.containsKey("requireResidentKey")) {
                        config.setRequireResidentKey(authenticatorSelection.getBoolean("requireResidentKey").booleanValue());
                    }
                    if (authenticatorSelection.containsKey("authenticatorAttachment")) {
                        config.setAuthenticatorAttachment(AuthenticatorAttachment.of((String)authenticatorSelection.getString("authenticatorAttachment")));
                    }
                    if (authenticatorSelection.containsKey("userVerification")) {
                        config.setUserVerification(UserVerification.of((String)authenticatorSelection.getString("userVerification")));
                    }
                }
                config.setAttestation(Attestation.of((String)json.getString("attestation")));
                config.setExtensions(json.getJsonObject("extensions"));
                ctx.next();
            });
            app.post("/attestation/result").handler(ctx -> ctx.reroute("/callback"));
            app.post("/assertion/options").handler(ctx -> {
                JsonObject json = ctx.body().asJsonObject();
                if (json.containsKey("username")) {
                    String username = json.getString("username");
                    json.remove("username");
                    json.put("name", (Object)username);
                    ((RoutingContextInternal)ctx).setBody(json.toBuffer());
                }
                config.setUserVerification(UserVerification.of((String)json.getString("userVerification", "discouraged")));
                config.setExtensions(json.getJsonObject("extensions"));
                ctx.next();
            });
            app.post("/assertion/result").handler(ctx -> ctx.reroute("/callback"));
            WebAuthnHandler webAuthnHandler = WebAuthnHandler.create((WebAuthn)webAuthN).setOrigin(ORIGIN).setupCallback(app.post("/callback")).setupCredentialsCreateCallback(app.post("/attestation/options")).setupCredentialsGetCallback(app.post("/assertion/options"));
            app.route().handler((Handler)webAuthnHandler);
            app.route().failureHandler(ctx -> {
                ctx.failure().printStackTrace();
                ctx.response().setStatusCode(500);
                ctx.json((Object)new JsonObject().put("status", (Object)"failed").put("errorMessage", (Object)ctx.failure().getMessage()));
            });
            vertx.createHttpServer().requestHandler((Handler)app).listen(8080, "0.0.0.0").onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(v -> {
                System.out.printf("Server listening at: %s%n", ORIGIN);
                System.out.println("-----------------------------------");
                System.out.println("Run the FIDO2 Conformance tool now!");
                System.out.println("-----------------------------------");
            });
        });
    }

    static {
        System.setProperty("io.vertx.ext.web.fido2.conformance.test", "true");
        System.setProperty("vertxweb.environment", "dev");
        ORIGIN = System.getProperty("ORIGIN", "http://192.168.178.183:8080");
        MDS3 = new String[]{"https://mds3.certinfra.fidoalliance.org/execute/12eaf6d06bc2f6c1bf169e837ca01cd7bc6c0c257bf060d9d3f4f6683601b44b", "https://mds3.certinfra.fidoalliance.org/execute/588ca39f3f089fd07793fefae80ccebe9070ff00b9b77e9083b0ba0e12e17295", "https://mds3.certinfra.fidoalliance.org/execute/91b7c26cebf103c2e502a36bad0193ea52753439a1c12d75b16775f22c1cea68", "https://mds3.certinfra.fidoalliance.org/execute/ab47a97c090c7cbf515d6e95dcf39bcf021146cad3445bc0c764b9e32490ac59", "https://mds3.certinfra.fidoalliance.org/execute/b2bc6a0c7ee5c054c4aa7fd4fa04b5089b5295859b7b373c34fe375e6d540912"};
        MDS2 = new String[]{"https://mds.certinfra.fidoalliance.org/execute/333b32fad3d882a9d2163faa14cfc82ac42ddd4cbf4032052a526daae2334fa0", "https://mds.certinfra.fidoalliance.org/execute/61984215c66217158500e6ccb341bf18f98facb5ea46f01918d02eefaafcef0a", "https://mds.certinfra.fidoalliance.org/execute/c7a1295798026b93b9c0b3139e984f206dc6984d0d58bd452c5844cf4606d960", "https://mds.certinfra.fidoalliance.org/execute/d22387051125832d8365cbf1521b6c79df2390859a004524aef5ce42b1d58707", "https://mds.certinfra.fidoalliance.org/execute/f04a888fccf28a71f458db8e820523e24156333b2210e16aa49ad55c640ad491"};
    }
}

