/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.otp.Authenticator;
import io.vertx.ext.auth.otp.hotp.HotpAuth;
import io.vertx.ext.auth.properties.PropertyFileAuthentication;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.OtpAuthHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class OtpHandlerTest
extends WebTestBase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.router.post().handler((Handler)BodyHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)).setCookieSameSite(CookieSameSite.STRICT));
        this.router.route().handler((Handler)BasicAuthHandler.create((AuthenticationProvider)PropertyFileAuthentication.create((Vertx)this.vertx, (String)"login/loginusers.properties")));
    }

    @Test
    public void testWithoutReroute() throws Exception {
        DummyDatabase db = new DummyDatabase();
        OtpAuthHandler otp = OtpAuthHandler.create((HotpAuth)HotpAuth.create().authenticatorFetcher(db::fetch).authenticatorUpdater(db::upsert)).issuer("Vert.x Demo").setupRegisterCallback(this.router.post("/otp/register")).setupCallback(this.router.post("/otp/verify"));
        this.router.route().handler((Handler)otp);
        this.router.route().handler(ctx -> ctx.end("OTP OK"));
        this.testRequest(HttpMethod.GET, "/protected", 401, "Unauthorized");
        this.testRequest(HttpMethod.GET, "/protected", (HttpClientRequest req) -> req.putHeader("Authorization", "Basic dGltOmRlbGljaW91czpzYXVzYWdlcw=="), 401, "Unauthorized", "Unauthorized");
    }

    @Test
    public void testWithReroute() throws Exception {
        DummyDatabase db = new DummyDatabase();
        OtpAuthHandler otp = OtpAuthHandler.create((HotpAuth)HotpAuth.create().authenticatorFetcher(db::fetch).authenticatorUpdater(db::upsert)).issuer("Vert.x Demo").verifyUrl("/otp/verify.html").setupRegisterCallback(this.router.post("/otp/register")).setupCallback(this.router.post("/otp/verify"));
        this.router.route().handler((Handler)otp);
        this.router.route().handler(ctx -> ctx.end("OTP OK"));
        this.testRequest(HttpMethod.GET, "/protected", 401, "Unauthorized");
        this.testRequest(HttpMethod.GET, "/protected", (HttpClientRequest req) -> req.putHeader("Authorization", "Basic dGltOmRlbGljaW91czpzYXVzYWdlcw=="), 302, "Found", "Redirecting to /otp/verify.html.");
    }

    @Test
    public void testRegisterAuthenticator() throws Exception {
        DummyDatabase db = new DummyDatabase();
        OtpAuthHandler otp = OtpAuthHandler.create((HotpAuth)HotpAuth.create().authenticatorFetcher(db::fetch).authenticatorUpdater(db::upsert)).issuer("Vert.x Demo").verifyUrl("/otp/verify.html").setupRegisterCallback(this.router.post("/otp/register")).setupCallback(this.router.post("/otp/verify"));
        this.router.route().handler((Handler)otp);
        this.router.route().handler(ctx -> ctx.end("OTP OK"));
        this.testRequest(HttpMethod.POST, "/otp/register", req -> req.putHeader("Authorization", "Basic dGltOmRlbGljaW91czpzYXVzYWdlcw=="), res -> res.body().onFailure(arg_0 -> ((OtpHandlerTest)this).fail(arg_0)).onSuccess(body -> {
            try {
                JsonObject json = new JsonObject(body);
                this.assertEquals("Vert.x Demo", json.getString("issuer"));
                this.assertNotNull(json.getString("url"));
                this.assertTrue(json.getString("url").startsWith("otpauth://hotp/Vert.x+Demo:tim?secret="));
                this.assertTrue(json.getString("url").endsWith("&counter=0"));
                this.testComplete();
            }
            catch (Exception e) {
                this.fail(e);
            }
        }), 200, "OK", null);
        this.await();
    }

    @Test
    public void testVerifyAuthenticatorBadCode() throws Exception {
        DummyDatabase db = new DummyDatabase();
        db.fixture(new Authenticator().setAlgorithm("SHA1").setCounter(0L).setIdentifier("tim").setKey("FNQTLXVB74MKCGYYHXBKEKCGAHPXK7ED"));
        OtpAuthHandler otp = OtpAuthHandler.create((HotpAuth)HotpAuth.create().authenticatorFetcher(db::fetch).authenticatorUpdater(db::upsert)).issuer("Vert.x Demo").verifyUrl("/otp/verify.html").setupRegisterCallback(this.router.post("/otp/register")).setupCallback(this.router.post("/otp/verify"));
        this.router.route().handler((Handler)otp);
        this.router.route().handler(ctx -> ctx.end("OTP OK"));
        this.testRequest(HttpMethod.POST, "/otp/verify", (HttpClientRequest req) -> {
            req.putHeader("Authorization", "Basic dGltOmRlbGljaW91czpzYXVzYWdlcw==");
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            Buffer buffer = Buffer.buffer();
            String str = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"code\"\r\n\r\n000000\r\n--" + boundary + "--\r\n";
            buffer.appendString(str);
            req.putHeader("content-length", String.valueOf(buffer.length()));
            req.putHeader("content-type", "multipart/form-data; boundary=" + boundary);
            req.write((Object)buffer);
        }, 401, "Unauthorized", null);
    }

    @Test
    public void testVerifyAuthenticatorGoodCode() throws Exception {
        DummyDatabase db = new DummyDatabase();
        db.fixture(new Authenticator().setAlgorithm("SHA1").setCounter(0L).setIdentifier("tim").setKey("FNQTLXVB74MKCGYYHXBKEKCGAHPXK7ED"));
        OtpAuthHandler otp = OtpAuthHandler.create((HotpAuth)HotpAuth.create().authenticatorFetcher(db::fetch).authenticatorUpdater(db::upsert)).issuer("Vert.x Demo").verifyUrl("/otp/verify.html").setupRegisterCallback(this.router.post("/otp/register")).setupCallback(this.router.post("/otp/verify"));
        this.router.route().handler((Handler)otp);
        this.router.route().handler(ctx -> ctx.end("OTP OK"));
        AtomicReference rSetCookie = new AtomicReference();
        this.testRequest(HttpMethod.POST, "/otp/verify", req -> {
            req.putHeader("Authorization", "Basic dGltOmRlbGljaW91czpzYXVzYWdlcw==");
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            Buffer buffer = Buffer.buffer();
            String str = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"code\"\r\n\r\n793127\r\n--" + boundary + "--\r\n";
            buffer.appendString(str);
            req.putHeader("content-length", String.valueOf(buffer.length()));
            req.putHeader("content-type", "multipart/form-data; boundary=" + boundary);
            req.write((Object)buffer);
        }, res -> {
            String setCookie = res.headers().get("set-cookie");
            rSetCookie.set(setCookie);
        }, 302, "Found", "Redirecting to /.");
        this.testRequest(HttpMethod.GET, "/", (HttpClientRequest req) -> req.putHeader("cookie", (String)rSetCookie.get()), 200, "OK", "OTP OK");
    }

    static class DummyDatabase {
        private final Map<String, Authenticator> DB = new ConcurrentHashMap<String, Authenticator>();

        DummyDatabase() {
        }

        public Future<Authenticator> fetch(String id) {
            if (this.DB.containsKey(id)) {
                return Future.succeededFuture((Object)this.DB.get(id));
            }
            return Future.succeededFuture();
        }

        public Future<Void> upsert(Authenticator authenticator) {
            this.DB.put(authenticator.getIdentifier(), authenticator);
            return Future.succeededFuture();
        }

        public DummyDatabase fixture(Authenticator authenticator) {
            this.DB.put(authenticator.getIdentifier(), authenticator);
            return this;
        }

        public void dump() {
            this.DB.values().forEach(authr -> System.out.println(authr.toJson().encodePrettily()));
        }
    }
}

