/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CSRFHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.StaticHandler;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.junit.AfterClass;
import org.junit.Test;

public class CSRFHandlerTest
extends WebTestBase {
    private final Map<String, String> cookieJar = Collections.synchronizedMap(new HashMap());

    @AfterClass
    public static void oneTimeTearDown() throws IOException {
        CSRFHandlerTest.cleanupFileUploadDir();
    }

    @Test
    public void testGetCookie() throws Exception {
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.get().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(1L, cookies.size());
            this.assertEquals("XSRF-TOKEN", ((String)cookies.get(0)).substring(0, ((String)cookies.get(0)).indexOf(61)));
        }, 200, "OK", null);
    }

    @Test
    public void testPostWithoutHeader() throws Exception {
        this.router.route().handler((Handler)BodyHandler.create()).handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route().handler(rc -> rc.response().end());
        this.router.errorHandler(403, rc -> this.testComplete());
        this.testRequest(HttpMethod.POST, "/", null, null, 403, "Forbidden", null);
        this.await();
    }

    private void storeCookies(HttpClientResponse resp) {
        for (String value : resp.headers().getAll("set-cookie")) {
            int eq = value.indexOf(61);
            String cookieName = value.substring(0, eq);
            int sc = value.indexOf(59, eq + 1);
            String cookieValue = value.substring(eq + 1, sc > 0 ? sc : value.length());
            this.cookieJar.put(cookieName, cookieValue);
        }
    }

    private String encodeCookies() {
        return this.cookieJar.entrySet().stream().map(cookie -> (String)cookie.getKey() + "=" + (String)cookie.getValue()).collect(Collectors.joining(";"));
    }

    @Test
    public void testPostWithHeader() throws Exception {
        this.router.route().handler((Handler)StaticHandler.create());
        this.router.route("/xsrf").handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route("/xsrf").handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/xsrf", null, this::storeCookies, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/xsrf", req -> req.headers().set("X-XSRF-TOKEN", this.cookieJar.get("XSRF-TOKEN")).set("Cookie", this.encodeCookies()), null, 200, "OK", null);
    }

    @Test
    public void testPostWithExpiredCookie() throws Exception {
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra").setTimeout(1L));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.POST, "/", req -> req.putHeader("X-XSRF-TOKEN", "4CYp9vQsr2VSQEsi/oVsMu35Ho9TlR0EovcYovlbiBw=.1437037602082.41jwU0FPl/n7ZNZAZEA07GyIUnpKSTKQ8Eju7Nicb34="), null, 403, "Forbidden", null);
    }

    @Test
    public void testPostWithFormAttribute() throws Exception {
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, this::storeCookies, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            Buffer buffer = Buffer.buffer();
            String str = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"" + "X-XSRF-TOKEN" + "\"\r\n\r\n" + this.cookieJar.get("XSRF-TOKEN") + "\r\n--" + boundary + "--\r\n";
            buffer.appendString(str);
            req.headers().set("content-length", String.valueOf(buffer.length()));
            req.headers().set("content-type", "multipart/form-data; boundary=" + boundary);
            req.putHeader("Cookie", this.encodeCookies());
            req.write((Object)buffer);
        }, null, 200, "OK", null);
    }

    @Test
    public void testPostWithFormAttributeWithoutCookies() throws Exception {
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route().handler(rc -> {
            String token = (String)rc.get("X-XSRF-TOKEN");
            if (token != null) {
                rc.response().end(token);
            } else {
                rc.response().end();
            }
        });
        CountDownLatch latch = new CountDownLatch(1);
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            resp.bodyHandler(buffer -> {
                this.cookieJar.put("XSRF-TOKEN", buffer.toString());
                latch.countDown();
            });
            this.assertEquals(1L, resp.headers().getAll("set-cookie").size());
        }, 200, "OK", null);
        this.awaitLatch(latch);
        this.testRequest(HttpMethod.POST, "/", req -> {
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            Buffer buffer = Buffer.buffer();
            String str = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"" + "X-XSRF-TOKEN" + "\"\r\n\r\n" + this.cookieJar.get("XSRF-TOKEN") + "\r\n--" + boundary + "--\r\n";
            buffer.appendString(str);
            req.headers().set("content-length", String.valueOf(buffer.length()));
            req.headers().set("content-type", "multipart/form-data; boundary=" + boundary);
            req.write((Object)buffer);
        }, null, 403, "Forbidden", null);
    }

    @Test
    public void testPostWithCustomResponseBody() throws Exception {
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra").setTimeout(1L));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.POST, "/", req -> req.putHeader("X-XSRF-TOKEN", "4CYp9vQsr2VSQEsi/oVsMu35Ho9TlR0EovcYovlbiBw=.1437037602082.41jwU0FPl/n7ZNZAZEA07GyIUnpKSTKQ8Eju7Nicb34="), null, 403, "Forbidden", "Forbidden");
    }

    @Test
    public void testGetCookieWithSession() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)SessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.get().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            this.storeCookies((HttpClientResponse)resp);
            this.assertEquals(2L, this.cookieJar.size());
        }, 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().set("cookie", this.encodeCookies()), resp -> this.assertTrue(resp.headers().getAll("set-cookie").isEmpty()), 200, "OK", null);
    }

    @Test
    public void testGetCookieWithSessionReplay() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            this.storeCookies((HttpClientResponse)resp);
            this.assertEquals(2L, this.cookieJar.size());
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.putHeader("cookie", this.encodeCookies());
            req.putHeader("X-XSRF-TOKEN", this.cookieJar.get("XSRF-TOKEN"));
        }, res -> {
            List cookies = res.headers().getAll("set-cookie");
            this.assertEquals(1L, cookies.size());
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.putHeader("cookie", this.encodeCookies());
            req.putHeader("X-XSRF-TOKEN", this.cookieJar.get("XSRF-TOKEN"));
        }, res -> {}, 403, "Forbidden", null);
    }

    @Test
    public void testGetCookieWithSessionMultipleGetSameToken() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            this.storeCookies((HttpClientResponse)resp);
            this.assertEquals(2L, this.cookieJar.size());
        }, 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("cookie", this.encodeCookies()), res -> {
            List cookies = res.headers().getAll("set-cookie");
            this.assertEquals(0L, cookies.size());
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.putHeader("cookie", this.encodeCookies());
            req.putHeader("X-XSRF-TOKEN", this.cookieJar.get("XSRF-TOKEN"));
        }, null, 200, "OK", null);
    }

    @Test
    public void testPostWithHeaderAndOrigin() throws Exception {
        this.router.route().handler((Handler)StaticHandler.create());
        this.router.route("/xsrf").handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra").setOrigin("http://myserver.com"));
        this.router.route("/xsrf").handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/xsrf", req -> req.putHeader("Origin", "http://myserver.com"), this::storeCookies, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/xsrf", req -> {
            req.putHeader("Origin", "http://myserver.com");
            req.putHeader("X-XSRF-TOKEN", this.cookieJar.get("XSRF-TOKEN"));
            req.putHeader("Cookie", this.encodeCookies());
        }, null, 200, "OK", null);
    }

    @Test
    public void testPostWithHeaderAndWrongOrigin() throws Exception {
        this.router.route().handler((Handler)StaticHandler.create());
        this.router.route("/xsrf").handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra").setOrigin("http://myserver.com"));
        this.router.route("/xsrf").handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/xsrf", req -> req.putHeader("Origin", "https://myserver.com"), null, 403, "Forbidden", null);
        this.testRequest(HttpMethod.GET, "/xsrf", req -> req.putHeader("Origin", "http://myserver.com/"), null, 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/xsrf", req -> req.putHeader("Origin", "http://myserver.com:80"), null, 200, "OK", null);
    }

    @Test
    public void testPostAfterPost() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            this.storeCookies((HttpClientResponse)resp);
            this.assertEquals(2L, this.cookieJar.size());
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.putHeader("cookie", this.encodeCookies());
            req.putHeader("X-XSRF-TOKEN", this.cookieJar.get("XSRF-TOKEN"));
        }, resp -> {
            HashMap<String, String> oldState = new HashMap<String, String>(this.cookieJar);
            this.cookieJar.clear();
            this.storeCookies((HttpClientResponse)resp);
            this.assertEquals(1L, this.cookieJar.size());
            this.assertTrue(this.cookieJar.containsKey("XSRF-TOKEN"));
            this.assertFalse(this.cookieJar.get("XSRF-TOKEN").equals(oldState.get("XSRF-TOKEN")));
            oldState.remove("XSRF-TOKEN");
            this.cookieJar.putAll(oldState);
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.putHeader("cookie", this.encodeCookies());
            req.putHeader("X-XSRF-TOKEN", this.cookieJar.get("XSRF-TOKEN"));
        }, null, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.putHeader("cookie", this.encodeCookies());
            req.putHeader("X-XSRF-TOKEN", this.cookieJar.get("XSRF-TOKEN"));
        }, null, 403, "Forbidden", null);
    }

    @Test
    public void testPostAfterPostNoState() throws Exception {
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, this::storeCookies, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.putHeader("cookie", this.encodeCookies());
            req.putHeader("X-XSRF-TOKEN", this.cookieJar.get("XSRF-TOKEN"));
        }, resp -> {
            HashMap<String, String> oldState = new HashMap<String, String>(this.cookieJar);
            this.cookieJar.clear();
            this.storeCookies((HttpClientResponse)resp);
            this.assertEquals(1L, this.cookieJar.size());
            this.assertTrue(this.cookieJar.containsKey("XSRF-TOKEN"));
            this.assertFalse(this.cookieJar.get("XSRF-TOKEN").equals(oldState.get("XSRF-TOKEN")));
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.putHeader("cookie", this.encodeCookies());
            req.putHeader("X-XSRF-TOKEN", this.cookieJar.get("XSRF-TOKEN"));
        }, null, 200, "OK", null);
    }

    @Test
    public void testMultipleGetWithSessionSameToken() throws Exception {
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            this.storeCookies((HttpClientResponse)resp);
            this.assertEquals(2L, this.cookieJar.size());
        }, 200, "OK", null);
        for (int i = 0; i < 5; ++i) {
            this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("cookie", this.encodeCookies()), resp -> {
                List cookies = resp.headers().getAll("set-cookie");
                this.assertEquals(0L, cookies.size());
            }, 200, "OK", null);
        }
    }

    @Test
    public void testPostWithNoResponse() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route("/working").handler(rc -> rc.response().end());
        this.router.route("/broken").handler(rc -> rc.request().connection().close());
        this.testRequest(HttpMethod.GET, "/working", null, this::storeCookies, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/working", req -> {
            req.putHeader("cookie", this.encodeCookies());
            req.putHeader("X-XSRF-TOKEN", this.cookieJar.get("XSRF-TOKEN"));
        }, this::storeCookies, 200, "OK", null);
        CountDownLatch latch = new CountDownLatch(1);
        this.client.request(new RequestOptions().setMethod(HttpMethod.POST).setHost("localhost").setPort(Integer.valueOf(8080)).setURI("/broken").putHeader("X-XSRF-TOKEN", this.cookieJar.get("XSRF-TOKEN")).putHeader("Cookie", this.encodeCookies())).onComplete(this.onSuccess(req -> req.send().onComplete(this.onFailure(throwable -> latch.countDown()))));
        this.awaitLatch(latch);
        this.testRequest(HttpMethod.GET, "/working", null, this::storeCookies, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/working", req -> {
            req.putHeader("X-XSRF-TOKEN", this.cookieJar.get("XSRF-TOKEN"));
            req.putHeader("Cookie", this.encodeCookies());
        }, null, 200, "OK", null);
    }

    @Test
    public void simultaneousGetAndPostDoesNotOverrideTokenInSession() throws Exception {
        LocalSessionStore store = LocalSessionStore.create((Vertx)this.vertx);
        Promise firstRequestReceived = Promise.promise();
        Promise delayedResponse = Promise.promise();
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)store));
        this.router.route("/csrf/*").handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route("/csrf/basic").handler(rc -> rc.response().end());
        this.router.route("/csrf/first").handler(rc -> {
            firstRequestReceived.complete();
            delayedResponse.future().onComplete(v -> rc.response().end());
        });
        this.router.route("/csrf/second").handler(rc -> {
            rc.response().end();
            delayedResponse.complete();
        });
        this.testRequest(HttpMethod.GET, "/csrf/basic", null, this::storeCookies, 200, "OK", null);
        CountDownLatch latch = new CountDownLatch(2);
        this.client.request(new RequestOptions().setMethod(HttpMethod.GET).putHeader("Cookie", this.encodeCookies()).setHost("localhost").setPort(Integer.valueOf(8080)).setURI("/csrf/first")).compose(HttpClientRequest::send).onComplete(this.onSuccess(res -> {
            this.assertThat("Should not send set-cookie header", res.headers().get("set-cookie"), CoreMatchers.nullValue());
            latch.countDown();
        }));
        firstRequestReceived.future().onComplete(ar -> this.client.request(new RequestOptions().setMethod(HttpMethod.POST).putHeader("Cookie", this.encodeCookies()).putHeader("X-XSRF-TOKEN", this.cookieJar.get("XSRF-TOKEN")).setHost("localhost").setPort(Integer.valueOf(8080)).setURI("/csrf/second")).compose(HttpClientRequest::send).onComplete(this.onSuccess(res -> {
            HashMap<String, String> oldState = new HashMap<String, String>(this.cookieJar);
            this.cookieJar.clear();
            this.storeCookies((HttpClientResponse)res);
            this.assertEquals("Should only have one set-cookie", 1L, this.cookieJar.size());
            this.assertTrue("Should be token cookie", this.cookieJar.containsKey("XSRF-TOKEN"));
            oldState.remove("XSRF-TOKEN");
            this.cookieJar.putAll(oldState);
            latch.countDown();
        })));
        this.awaitLatch(latch);
        this.testRequest(HttpMethod.POST, "/csrf/basic", req -> {
            req.putHeader("X-XSRF-TOKEN", this.cookieJar.get("XSRF-TOKEN"));
            req.putHeader("Cookie", this.encodeCookies());
        }, null, 200, "OK", null);
    }

    @Test
    public void testRerouteRequest() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.router.route("/home").handler(rc -> rc.end("home"));
        this.router.route("/protected/*").handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route("/protected/initial").handler(rc -> rc.reroute("/protected/rerouted"));
        this.router.route("/protected/rerouted").handler(rc -> rc.end("done"));
        this.testRequest(HttpMethod.GET, "/home", null, this::storeCookies, 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/protected/initial", req -> req.putHeader("cookie", this.encodeCookies()), resp -> {
            HashMap<String, String> oldState = new HashMap<String, String>(this.cookieJar);
            this.cookieJar.clear();
            this.storeCookies((HttpClientResponse)resp);
            this.assertEquals(1L, this.cookieJar.size());
            this.cookieJar.forEach(oldState::remove);
            this.cookieJar.putAll(oldState);
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/protected/rerouted", req -> {
            req.putHeader("cookie", this.encodeCookies());
            req.putHeader("X-XSRF-TOKEN", this.cookieJar.get("XSRF-TOKEN"));
        }, null, 200, "OK", null);
    }
}

