/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.properties.PropertyFileAuthentication;
import io.vertx.ext.web.handler.AuthHandlerTestBase;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.BasicAuthHandler;
import org.junit.Test;

public class AuthXRequestedWithTest
extends AuthHandlerTestBase {
    @Test
    public void testNoWwwAuthenticateForAjaxCalls() throws Exception {
        String realm = "vertx-web";
        Handler handler = rc -> {
            this.assertNotNull(rc.user());
            this.assertEquals("tim", rc.user().principal().getString("username"));
            rc.response().end("Welcome to the protected resource!");
        };
        PropertyFileAuthentication authProvider = PropertyFileAuthentication.create((Vertx)this.vertx, (String)"login/loginusers.properties");
        this.router.route("/protected/*").handler((Handler)BasicAuthHandler.create((AuthenticationProvider)authProvider, (String)realm));
        this.router.route("/protected/somepage").handler(handler);
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNotNull(wwwAuth);
            this.assertEquals("Basic realm=\"" + realm + "\"", wwwAuth);
        }, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("X-Requested-With", "XMLHttpRequest"), resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNull(wwwAuth);
        }, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("Authorization", "Basic dGltOmRlbGljaW91czpzYXVzYWdlcw=="), resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNull(wwwAuth);
        }, 200, "OK", "Welcome to the protected resource!");
    }

    @Override
    protected AuthenticationHandler createAuthHandler(AuthenticationProvider authProvider) {
        return BasicAuthHandler.create((AuthenticationProvider)authProvider);
    }
}

