/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.PlatformHandler;
import io.vertx.ext.web.handler.ProtocolUpgradeHandler;
import io.vertx.test.core.TestUtils;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class UpgradeTest {
    @Rule
    public final RunTestOnContext rule = new RunTestOnContext();
    final Router router = Router.router((Vertx)this.rule.vertx());
    HttpServer server;
    HttpClient client;

    @Before
    public void setup(TestContext should) {
        Async setup = should.async();
        this.rule.vertx().createHttpServer().requestHandler((Handler)this.router).listen(0).onSuccess(server -> {
            this.server = server;
            this.client = this.rule.vertx().createHttpClient(new HttpClientOptions().setDefaultPort(server.actualPort()).setDefaultHost("localhost"));
            setup.complete();
        }).onFailure(arg_0 -> ((TestContext)should).fail(arg_0));
    }

    @Test
    public void testUpgradeWithAsyncInBetween(TestContext should) {
        Async test = should.async();
        this.router.route().handler((Handler)((PlatformHandler)ctx -> {
            ctx.request().pause();
            this.rule.vertx().setTimer(5L, v -> {
                ctx.request().resume();
                ctx.next();
            });
        })).handler((Handler)((PlatformHandler)ctx -> {
            ctx.request().pause();
            this.rule.vertx().setTimer(5L, v -> {
                ctx.request().resume();
                ctx.next();
            });
        })).handler((Handler)((ProtocolUpgradeHandler)ctx -> ctx.request().toWebSocket().onFailure(arg_0 -> ((RoutingContext)ctx).fail(arg_0)).onSuccess(webSocket -> webSocket.write((Object)Buffer.buffer((String)"OK")).onSuccess(ok -> webSocket.close()).onFailure(arg_0 -> ((RoutingContext)ctx).fail(arg_0)))));
        this.client.webSocket("/").onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(webSocket -> {
            webSocket.frameHandler(System.out::println);
            webSocket.closeHandler(ok -> test.complete());
        });
    }

    @Test
    public void testUpgradeWithLongAwait(TestContext should) {
        Async test = should.async();
        this.router.route().handler((Handler)((PlatformHandler)ctx -> {
            ctx.request().pause();
            ctx.response().removeCookie("session", false);
            this.rule.vertx().setTimer(500L, v -> {
                ctx.request().resume();
                ctx.next();
            });
        })).handler((Handler)((ProtocolUpgradeHandler)ctx -> ctx.request().toWebSocket().onFailure(arg_0 -> ((RoutingContext)ctx).fail(arg_0)).onSuccess(webSocket -> webSocket.write((Object)Buffer.buffer((String)"OK")).onSuccess(ok -> webSocket.close()).onFailure(arg_0 -> ((RoutingContext)ctx).fail(arg_0)))));
        WebSocketConnectOptions options = new WebSocketConnectOptions().setURI("/").addHeader("cookie", "session=" + TestUtils.randomAlphaString((int)32));
        this.client.webSocket(options).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(webSocket -> {
            webSocket.frameHandler(System.out::println);
            webSocket.closeHandler(ok -> test.complete());
        });
    }
}

