/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.sockjs.SockJSTestBase;
import org.junit.Test;

public class SockJSAsyncHandlerTest
extends SockJSTestBase {
    @Override
    public void setUp() throws Exception {
        this.numServers = 2;
        this.preSockJSHandlerSetup = router -> {
            router.route().handler((Handler)BodyHandler.create());
            router.route().handler(rtx -> rtx.vertx().executeBlocking(f -> f.complete((Object)true), r -> rtx.next()));
        };
        super.setUp();
    }

    @Test
    public void testHandleMessageFromXhrTransportWithAsyncHandler() throws Exception {
        this.waitFor(2);
        this.socketHandler = () -> socket -> socket.handler(buf -> {
            this.assertEquals("Hello World", buf.toString());
            this.complete();
        });
        this.startServers();
        this.client.request(HttpMethod.POST, "/test/400/8ne8e94a/xhr").compose(req1 -> req1.send(Buffer.buffer()).onComplete(this.onSuccess(resp1 -> {
            this.assertEquals(200L, resp1.statusCode());
            this.client.request(HttpMethod.POST, "/test/400/8ne8e94a/xhr_send").compose(req2 -> req2.send(Buffer.buffer((String)"\"Hello World\""))).onComplete(this.onSuccess(resp2 -> {
                this.assertEquals(204L, resp2.statusCode());
                this.complete();
            }));
        })));
        this.await();
    }
}

