/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class Router100ContinueTest {
    @Rule
    public final RunTestOnContext rule = new RunTestOnContext();
    final Router router = Router.router((Vertx)this.rule.vertx());
    HttpServer server;
    HttpClient client;

    @Before
    public void setup(TestContext should) {
        Async setup = should.async();
        this.rule.vertx().createHttpServer().requestHandler((Handler)this.router).listen(0).onSuccess(server -> {
            this.server = server;
            this.client = this.rule.vertx().createHttpClient(new HttpClientOptions().setDefaultPort(server.actualPort()).setDefaultHost("localhost"));
            setup.complete();
        }).onFailure(arg_0 -> ((TestContext)should).fail(arg_0));
    }

    @Test
    public void testContinue(TestContext should) {
        Async test = should.async();
        this.router.route().handler((Handler)BodyHandler.create()).handler(ctx -> {
            should.assertEquals((Object)"DATA", (Object)ctx.body().asString());
            ctx.end();
        });
        this.client.request(HttpMethod.POST, "/").onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(req -> {
            req.response().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(res -> {
                should.assertEquals((Object)200, (Object)res.statusCode());
                test.complete();
            });
            req.putHeader(HttpHeaders.EXPECT, (CharSequence)"100-continue").setChunked(true).continueHandler(v -> req.end("DATA").onFailure(arg_0 -> ((TestContext)should).fail(arg_0))).sendHead().onFailure(arg_0 -> ((TestContext)should).fail(arg_0));
        });
    }

    @Test
    public void testBadExpectation(TestContext should) {
        Async test = should.async();
        this.router.route().handler((Handler)BodyHandler.create()).handler(ctx -> {
            should.assertEquals((Object)"DATA", (Object)ctx.body().asString());
            ctx.end();
        });
        this.client.request(HttpMethod.POST, "/").onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(req -> {
            req.response().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(res -> {
                should.assertEquals((Object)417, (Object)res.statusCode());
                test.complete();
            });
            req.putHeader(HttpHeaders.EXPECT, (CharSequence)"lets-go").setChunked(true).continueHandler(v -> req.end("DATA").onFailure(arg_0 -> ((TestContext)should).fail(arg_0))).sendHead().onFailure(arg_0 -> ((TestContext)should).fail(arg_0));
        });
    }

    @Test
    public void testExpectButTooLarge(TestContext should) {
        Async test = should.async();
        this.router.route().handler((Handler)BodyHandler.create().setBodyLimit(1L)).handler(ctx -> {
            should.assertEquals((Object)"DATA", (Object)ctx.body().asString());
            ctx.end();
        });
        this.client.request(HttpMethod.POST, "/").onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(req -> {
            req.response().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(res -> {
                should.assertEquals((Object)413, (Object)res.statusCode());
                test.complete();
            });
            req.putHeader(HttpHeaders.EXPECT, (CharSequence)"100-continue").setChunked(true).continueHandler(v -> req.end("DATA").onFailure(arg_0 -> ((TestContext)should).fail(arg_0))).sendHead().onFailure(arg_0 -> ((TestContext)should).fail(arg_0));
        });
    }
}

