/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.WebSocketBase;
import io.vertx.ext.web.handler.sockjs.SockJSTestBase;
import io.vertx.test.core.TestUtils;
import org.junit.Test;

public class SockJSWriteTest
extends SockJSTestBase {
    @Test
    public void testRaw() throws Exception {
        this.waitFor(2);
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> socket.write(Buffer.buffer((String)expected), this.onSuccess(v -> this.complete()));
        this.startServers();
        this.client.websocket("/test/websocket", ws -> ws.handler(buffer -> {
            if (buffer.toString().equals(expected)) {
                this.complete();
            }
        }));
        this.await();
    }

    @Test
    public void testRawFailure() throws Exception {
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> socket.endHandler(v -> socket.write(Buffer.buffer((String)expected), this.onFailure(err -> this.testComplete())));
        this.startServers();
        this.client.websocket("/test/websocket", WebSocketBase::close);
        this.await();
    }

    @Test
    public void testWebSocket() throws Exception {
        this.waitFor(2);
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> socket.write(Buffer.buffer((String)expected), this.onSuccess(v -> this.complete()));
        this.startServers();
        this.client.websocket("/test/400/8ne8e94a/websocket", ws -> ws.handler(buffer -> {
            if (buffer.toString().equals("a[\"" + expected + "\"]")) {
                this.complete();
            }
        }));
        this.await();
    }

    @Test
    public void testWebSocketFailure() throws Exception {
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> socket.endHandler(v -> socket.write(Buffer.buffer((String)expected), this.onFailure(err -> this.testComplete())));
        this.startServers();
        this.client.websocket("/test/400/8ne8e94a/websocket", WebSocketBase::close);
        this.await();
    }

    @Test
    public void testEventSource() throws Exception {
        this.waitFor(2);
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> socket.write(Buffer.buffer((String)expected), this.onSuccess(v -> this.complete()));
        this.startServers();
        this.client.get("/test/400/8ne8e94a/eventsource", resp -> resp.handler(buffer -> {
            if (buffer.toString().equals("data: a[\"" + expected + "\"]\r\n\r\n")) {
                this.complete();
            }
        })).end();
        this.await();
    }

    @Test
    public void testEventSourceFailure() throws Exception {
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> socket.endHandler(v -> socket.write(Buffer.buffer((String)expected), this.onFailure(err -> this.testComplete())));
        this.startServers();
        this.client.get("/test/400/8ne8e94a/eventsource", resp -> resp.request().connection().close()).end();
        this.await();
    }

    @Test
    public void testXHRStreaming() throws Exception {
        this.waitFor(2);
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> socket.write(Buffer.buffer((String)expected), this.onSuccess(v -> this.complete()));
        this.startServers();
        this.client.post("/test/400/8ne8e94a/xhr_streaming", resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.handler(buffer -> {
                if (buffer.toString().equals("a[\"" + expected + "\"]\n")) {
                    this.complete();
                }
            });
        }).end();
        this.await();
    }

    @Test
    public void testXHRStreamingFailure() throws Exception {
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> socket.endHandler(v -> socket.write(Buffer.buffer((String)expected), this.onFailure(err -> this.testComplete())));
        this.startServers();
        this.client.post("/test/400/8ne8e94a/xhr_streaming", resp -> resp.request().connection().close()).end();
        this.await();
    }

    @Test
    public void testXHRPolling() throws Exception {
        Runnable[] task;
        this.waitFor(2);
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> socket.write(Buffer.buffer((String)expected), this.onSuccess(v -> this.complete()));
        this.startServers();
        task = new Runnable[]{() -> this.client.post("/test/400/8ne8e94a/xhr", resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.handler(buffer -> {
                if (buffer.toString().equals("a[\"" + expected + "\"]\n")) {
                    this.complete();
                } else {
                    task[0].run();
                }
            });
        }).end()};
        task[0].run();
        this.await();
    }

    @Test
    public void testXHRPollingClose() throws Exception {
        this.waitFor(2);
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> {
            socket.write(Buffer.buffer((String)expected), this.onFailure(err -> this.complete()));
            socket.endHandler(v -> socket.write(Buffer.buffer((String)expected), this.onFailure(err -> this.complete())));
            socket.close();
        };
        this.startServers();
        this.client.post("/test/400/8ne8e94a/xhr", resp -> this.assertEquals(200L, resp.statusCode())).end();
        this.await();
    }

    @Test
    public void testXHRPollingShutdown() throws Exception {
        this.waitFor(2);
        String expected = TestUtils.randomAlphaString((int)64);
        this.socketHandler = () -> socket -> {
            socket.write(Buffer.buffer((String)expected), this.onFailure(err -> this.complete()));
            socket.endHandler(v -> socket.write(Buffer.buffer((String)expected), this.onFailure(err -> this.complete())));
        };
        this.startServers();
        this.client.post("/test/400/8ne8e94a/xhr", resp -> this.assertEquals(200L, resp.statusCode())).end();
        this.await();
    }
}

