/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.jwt.JWK;
import io.vertx.ext.jwt.JWT;
import io.vertx.ext.jwt.JWTOptions;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.ext.web.handler.OAuth2AuthHandler;
import java.util.Base64;
import java.util.concurrent.CountDownLatch;
import org.junit.Test;

public class OAuth2AuthHandlerTest
extends WebTestBase {
    private static final JsonObject fixture = new JsonObject("{  \"access_token\": \"4adc339e0\",  \"refresh_token\": \"ec1a59d298\",  \"token_type\": \"bearer\",  \"expires_in\": 7200}");
    private String redirectURL = null;

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testAuthCodeFlow() throws Exception {
        OAuth2Auth oauth2 = OAuth2Auth.create((Vertx)this.vertx, (OAuth2FlowType)OAuth2FlowType.AUTH_CODE, (OAuth2ClientOptions)new OAuth2ClientOptions().setClientID("client-id").setClientSecret("client-secret").setSite("http://localhost:10000"));
        CountDownLatch latch = new CountDownLatch(1);
        HttpServer server = this.vertx.createHttpServer().requestHandler(req -> {
            if (req.method() == HttpMethod.POST && "/oauth/token".equals(req.path())) {
                req.setExpectMultipart(true).bodyHandler(buffer -> req.response().putHeader("Content-Type", "application/json").end(fixture.encode()));
            } else if (req.method() == HttpMethod.POST && "/oauth/revoke".equals(req.path())) {
                req.setExpectMultipart(true).bodyHandler(buffer -> req.response().end());
            } else {
                req.response().setStatusCode(400).end();
            }
        }).listen(10000, ready -> {
            if (ready.failed()) {
                throw new RuntimeException(ready.cause());
            }
            latch.countDown();
        });
        latch.await();
        OAuth2AuthHandler oauth2Handler = OAuth2AuthHandler.create((OAuth2Auth)oauth2, (String)"http://localhost:8080/callback");
        oauth2Handler.setupCallback(this.router.route());
        this.router.route("/protected/*").handler((Handler)oauth2Handler);
        this.router.route("/protected/somepage").handler(rc -> {
            this.assertNotNull(rc.user());
            rc.response().end("Welcome to the protected resource!");
        });
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, resp -> {
            this.redirectURL = resp.getHeader("Location");
            this.assertNotNull(this.redirectURL);
        }, 302, "Found", null);
        this.testRequest(HttpMethod.GET, "/callback?state=/protected/somepage&code=1", null, resp -> {}, 200, "OK", "Welcome to the protected resource!");
        server.close();
    }

    @Test
    public void testAuthCodeFlowBadSetup() throws Exception {
        OAuth2Auth oauth2 = OAuth2Auth.create((Vertx)this.vertx, (OAuth2FlowType)OAuth2FlowType.AUTH_CODE, (OAuth2ClientOptions)new OAuth2ClientOptions().setClientID("client-id").setClientSecret("client-secret").setSite("http://localhost:10000"));
        CountDownLatch latch = new CountDownLatch(1);
        HttpServer server = this.vertx.createHttpServer().requestHandler(req -> {
            if (req.method() == HttpMethod.POST && "/oauth/token".equals(req.path())) {
                req.setExpectMultipart(true).bodyHandler(buffer -> req.response().putHeader("Content-Type", "application/json").end(fixture.encode()));
            } else if (req.method() == HttpMethod.POST && "/oauth/revoke".equals(req.path())) {
                req.setExpectMultipart(true).bodyHandler(buffer -> req.response().end());
            } else {
                req.response().setStatusCode(400).end();
            }
        }).listen(10000, ready -> {
            if (ready.failed()) {
                throw new RuntimeException(ready.cause());
            }
            latch.countDown();
        });
        latch.await();
        this.router.route().handler((Handler)OAuth2AuthHandler.create((OAuth2Auth)oauth2, (String)"http://localhost:8080/callback").setupCallback(this.router.route()));
        this.router.route("/protected/somepage").handler(rc -> {
            this.assertNotNull(rc.user());
            rc.response().end("Welcome to the protected resource!");
        });
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, resp -> {
            this.redirectURL = resp.getHeader("Location");
            this.assertNotNull(this.redirectURL);
        }, 302, "Found", null);
        this.testRequest(HttpMethod.GET, "/callback?state=/protected/somepage&code=1", null, resp -> {}, 500, "Internal Server Error", "Internal Server Error");
        this.router.clear();
        OAuth2AuthHandler oauth2Handler = OAuth2AuthHandler.create((OAuth2Auth)oauth2, (String)"http://localhost:8080/callback").setupCallback(this.router.route());
        this.router.route().handler((Handler)oauth2Handler);
        this.router.route("/protected/somepage").handler(rc -> {
            this.assertNotNull(rc.user());
            rc.response().end("Welcome to the protected resource!");
        });
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, resp -> {
            this.redirectURL = resp.getHeader("Location");
            this.assertNotNull(this.redirectURL);
        }, 302, "Found", null);
        this.testRequest(HttpMethod.GET, "/callback?state=/protected/somepage&code=1", null, resp -> {}, 200, "OK", "Welcome to the protected resource!");
        server.close();
    }

    @Test
    public void testPasswordFlow() throws Exception {
        OAuth2Auth oauth2 = OAuth2Auth.create((Vertx)this.vertx, (OAuth2FlowType)OAuth2FlowType.PASSWORD, (OAuth2ClientOptions)new OAuth2ClientOptions().setClientID("client-id").setClientSecret("client-secret").setSite("http://localhost:10000"));
        CountDownLatch latch = new CountDownLatch(1);
        HttpServer server = this.vertx.createHttpServer().requestHandler(req -> {
            if (req.method() == HttpMethod.POST && "/oauth/token".equals(req.path())) {
                req.setExpectMultipart(true).bodyHandler(buffer -> {
                    String queryString = buffer.toString();
                    this.assertTrue(queryString.contains("username=paulo"));
                    this.assertTrue(queryString.contains("password=bananas"));
                    this.assertTrue(queryString.contains("grant_type=password"));
                    req.response().putHeader("Content-Type", "application/json").end(fixture.encode());
                });
            } else if (req.method() == HttpMethod.POST && "/oauth/revoke".equals(req.path())) {
                req.setExpectMultipart(true).bodyHandler(buffer -> req.response().end());
            } else {
                req.response().setStatusCode(400).end();
            }
        }).listen(10000, ready -> {
            if (ready.failed()) {
                throw new RuntimeException(ready.cause());
            }
            latch.countDown();
        });
        latch.await();
        AuthHandler oauth2Handler = BasicAuthHandler.create((AuthProvider)oauth2);
        this.router.route("/protected/*").handler((Handler)oauth2Handler);
        this.router.route("/protected/somepage").handler(rc -> {
            this.assertNotNull(rc.user());
            rc.response().end("Welcome to the protected resource!");
        });
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString("paulo:bananas".getBytes())), res -> {}, 200, "OK", "Welcome to the protected resource!");
        this.testRequest(HttpMethod.GET, "/protected/somepage", 401, "Unauthorized");
        server.close();
    }

    @Test
    public void testBearerOnly() throws Exception {
        OAuth2Auth oauth2 = OAuth2Auth.create((Vertx)this.vertx, (OAuth2FlowType)OAuth2FlowType.AUTH_CODE, (OAuth2ClientOptions)new OAuth2ClientOptions().setClientID("client-id"));
        OAuth2AuthHandler oauth2Handler = OAuth2AuthHandler.create((OAuth2Auth)oauth2);
        this.router.route("/protected/*").handler((Handler)oauth2Handler);
        this.router.route("/protected/somepage").handler(rc -> {
            this.assertNotNull(rc.user());
            rc.response().end("Welcome to the protected resource!");
        });
        this.testRequest(HttpMethod.GET, "/protected/somepage", 401, "Unauthorized");
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("Authorization", "Bearer 4adc339e0"), 401, "Unauthorized", "Unauthorized");
    }

    @Test
    public void testBearerOnlyWithJWT() throws Exception {
        OAuth2Auth oauth = OAuth2Auth.create((Vertx)this.vertx, (OAuth2ClientOptions)new OAuth2ClientOptions().setClientID("dummy-client").addPubSecKey(new PubSecKeyOptions().setAlgorithm("RS256").setPublicKey("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAmuIC9Qvwoe/3tUpHkcUp\nvWmzQqnZtz3HBKbxzc/jBTxUHefJDs88Xjw5nNXhl4tXkHzFRAZHtDnwX074/2oc\nPRSWaBjHYXB771af91UPrc9fb4lh3W1a8hmQU6sgKlQVwDnUuePDkCmwKCsuyX0M\nwxuwOwEUo4r15NBh/H7FvuHVPnqWK1/kliYtQukF3svQkpZT6/puQ0bEOefROLB+\nEAPM0OAaDyknjxCZJenk9FIyC6skOKVaxW7CcE54lIUjS1GKFQc44/+T+u0VKSmh\nrRdBNcAhXmdpwjLoDTy/I8z+uqkKitdEVczCdleNqeb6b1kjPWS3VbLXxY/LIYlz\nuQIDAQAB")));
        this.assertNotNull(oauth);
        JWT jwt = new JWT().addJWK(new JWK("RS256", null, "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCa4gL1C/Ch7/e1\nSkeRxSm9abNCqdm3PccEpvHNz+MFPFQd58kOzzxePDmc1eGXi1eQfMVEBke0OfBf\nTvj/ahw9FJZoGMdhcHvvVp/3VQ+tz19viWHdbVryGZBTqyAqVBXAOdS548OQKbAo\nKy7JfQzDG7A7ARSjivXk0GH8fsW+4dU+epYrX+SWJi1C6QXey9CSllPr+m5DRsQ5\n59E4sH4QA8zQ4BoPKSePEJkl6eT0UjILqyQ4pVrFbsJwTniUhSNLUYoVBzjj/5P6\n7RUpKaGtF0E1wCFeZ2nCMugNPL8jzP66qQqK10RVzMJ2V42p5vpvWSM9ZLdVstfF\nj8shiXO5AgMBAAECggEAIriwOQcoNuV4/qdcTA2LQe9ERJmXOUEcMKrMYntMRYw0\nv0+K/0ruGaIeuE4qeLLAOp/+CTXvNTQX8wXdREUhd3/6B/QmHm39GrasveHP1gM7\nPeHqkp1FWijo9hjS6SpYhfNxAQtSeCsgVqD3qCvkhIjchR3E5rTsUxN0JAq3ggb9\nWCJ2LUxOOTHAWL4cv7FIKfwU/bwjBdHbSLuh7em4IE8tzcFgh49281APprGb4a3d\nCPlIZC+CQmTFKPGzT0WDNc3EbPPKcx8ECRf1Zo94Tqnzv7FLgCmr0o4O9e6E3yss\nUwp7EKPUQyAwBkc+pHwqUmOPqHB+z28JUOwqoD0vQQKBgQDNiXSydWh9BUWAleQU\nfgSF0bjlt38HVcyMKGC1xQhi8VeAfLJxGCGbdxsPFNCtMPDLRRyd4xHBmsCmPPli\nCFHD1UbfNuKma6azl6A86geuTolgrHoxp57tZwoBpG9JHoTA53pfBPxb8q39YXKh\nDSXsJVldxsHwzFAklj3ZqzWq3QKBgQDA6M/VW3SXEt1NWwMI+WGa/QKHDjLDhZzF\nF3iQTtzDDmA4louAzX1cykNo6Y7SpORi0ralml65iwT2HZtE8w9vbw4LNmBiHmlX\nAvpZSHT6/7nQeiFtxZu9cyw4GGpNSaeqp4Cq6TGYmfbq4nIdryzUU2AgsqSZyrra\nxh7K+2I4jQKBgGjC8xQy+7sdgLt1qvc29B8xMkkEKl8WwFeADSsY7plf4fW/mURD\nxH11S/l35pUgKNuysk9Xealws1kIIyRwkRx8DM+hLg0dOa64Thg+QQP7S9JWl0HP\n6hWfO15y7bYbNBcO5TShWe+T1lMb5E1qYjXnI5HEyP1vZjn/yi60MXqRAoGAe6F4\n+QLIwL1dSOMoGctBS4QU55so23e41fNJ2CpCf1uqPPn2Y9DOI/aYpxbv6n20xMTI\nO2+of37h6h1lUhX38XGZ7YOm15sn5ZTJ/whZuDbFzh9HZ0N6oTq7vyOelPO8WblJ\n077pgyRBQ51mhzGqKFVayPnUVZ/Ais7oEyxycU0CgYEAzEUhmN22ykywh0My83z/\n7yl2tyrlv2hcZbaP7+9eHdUafGG8jMTVD7jxhzAbiSo2UeyHUnAItDnLetLh89K6\n0oF3/rZLqugtb+f48dgRE/SDF4Itgp5fDqWHLhEW7ZhWCFlFgZ3sq0XryIxzFof0\nO/Fd1NnotirzTnob5ReblIM="));
        this.assertNotNull(jwt);
        OAuth2AuthHandler oauth2Handler = OAuth2AuthHandler.create((OAuth2Auth)oauth);
        this.router.route("/protected/*").handler((Handler)oauth2Handler);
        this.router.route("/protected/somepage").handler(rc -> {
            this.assertNotNull(rc.user());
            rc.response().end("Welcome to the protected resource!");
        });
        this.testRequest(HttpMethod.GET, "/protected/somepage", 401, "Unauthorized");
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("Authorization", "Bearer 4adc339e0"), 401, "Unauthorized", "Unauthorized");
        String accessToken = jwt.sign(new JsonObject("{\n      \"iss\": \"https://server.example.com\",\n      \"aud\": \"s6BhdRkqt3\",\n      \"jti\": \"a-123\",\n      \"exp\": 999999999999,\n      \"iat\": 1311280970,\n      \"sub\": \"24400320\",\n      \"upn\": \"jdoe@server.example.com\",\n      \"groups\": [\"red-group\", \"green-group\", \"admin-group\", \"admin\"]\n}"), new JWTOptions().setAlgorithm("RS256"));
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("Authorization", "Bearer " + accessToken), 200, "OK", "Welcome to the protected resource!");
        String accessTokenExp = jwt.sign(new JsonObject("{\n      \"iss\": \"https://server.example.com\",\n      \"aud\": \"s6BhdRkqt3\",\n      \"jti\": \"a-123\",\n      \"exp\": 1311280970,\n      \"iat\": 1311280970,\n      \"sub\": \"24400320\",\n      \"upn\": \"jdoe@server.example.com\",\n      \"groups\": [\"red-group\", \"green-group\", \"admin-group\", \"admin\"]\n}"), new JWTOptions().setAlgorithm("RS256"));
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("Authorization", "Bearer " + accessTokenExp), 401, "Unauthorized", "Unauthorized");
    }
}

