/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.MultiTenantHandler;
import java.util.List;
import org.junit.Test;

public class MultiTenantHandlerTest
extends WebTestBase {
    @Test
    public void testHeader() throws Exception {
        this.router.clear();
        this.router.route().handler((Handler)MultiTenantHandler.create((String)"X-Tenant").addTenantHandler("tenant-1", ctx -> ctx.response().end("Hello from tenant-1")).addTenantHandler("tenant-2", ctx -> ctx.response().end("Hello from tenant-2")).addTenantHandler("tenant-3", ctx -> ctx.response().end("Hello from tenant-3")));
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("X-Tenant", "tenant-1"), null, 200, "OK", "Hello from tenant-1");
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("X-Tenant", "tenant-2"), null, 200, "OK", "Hello from tenant-2");
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("X-Tenant", "tenant-3"), null, 200, "OK", "Hello from tenant-3");
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("X-Tenant", "tenant-4"), null, 404, "Not Found", "<html><body><h1>Resource not found</h1></body></html>");
        this.testRequest(HttpMethod.GET, "/", null, null, 404, "Not Found", "<html><body><h1>Resource not found</h1></body></html>");
    }

    @Test
    public void testDefaultHeader() throws Exception {
        this.router.clear();
        this.router.route().handler((Handler)MultiTenantHandler.create((String)"X-Tenant").addTenantHandler("tenant-1", ctx -> ctx.response().end("Hello from tenant-1")).addTenantHandler("tenant-2", ctx -> ctx.response().end("Hello from tenant-2")).addTenantHandler("tenant-3", ctx -> ctx.response().end("Hello from tenant-3")).addDefaultHandler(ctx -> ctx.response().end("No valid tenant supplied")));
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("X-Tenant", "tenant-1"), null, 200, "OK", "Hello from tenant-1");
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("X-Tenant", "tenant-2"), null, 200, "OK", "Hello from tenant-2");
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("X-Tenant", "tenant-3"), null, 200, "OK", "Hello from tenant-3");
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("X-Tenant", "tenant-4"), null, 200, "OK", "No valid tenant supplied");
        this.testRequest(HttpMethod.GET, "/", null, null, 200, "OK", "No valid tenant supplied");
    }

    @Test
    public void testCustomExtractor() throws Exception {
        this.router.clear();
        this.router.route().handler((Handler)MultiTenantHandler.create(ctx -> {
            List params = ctx.queryParam("tenant");
            return params.size() > 0 ? (String)params.get(0) : null;
        }).addTenantHandler("t1", ctx -> {
            this.assertEquals("t1", ctx.get("tenant"));
            ctx.response().end("Hello from tenant-1");
        }).addTenantHandler("t2", ctx -> {
            this.assertEquals("t2", ctx.get("tenant"));
            ctx.response().end("Hello from tenant-2");
        }).addTenantHandler("t3", ctx -> {
            this.assertEquals("t3", ctx.get("tenant"));
            ctx.response().end("Hello from tenant-3");
        }).addDefaultHandler(ctx -> {
            this.assertEquals("default", ctx.get("tenant"));
            ctx.response().end("No valid tenant supplied");
        }));
        this.testRequest(HttpMethod.GET, "/?tenant=t1", 200, "OK", "Hello from tenant-1");
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("X-Tenant", "tenant-4"), null, 200, "OK", "No valid tenant supplied");
        this.testRequest(HttpMethod.GET, "/", null, null, 200, "OK", "No valid tenant supplied");
    }
}

