/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.CorsHandler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CORSHandlerTest
extends WebTestBase {
    @Test(expected=NullPointerException.class)
    public void testNullAllowedOrigin() throws Exception {
        CorsHandler.create(null);
    }

    @Test
    public void testNotCORSRequest() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"vertx\\.io"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> this.checkHeaders((HttpClientResponse)resp, null, null, null, null), 200, "OK", null);
    }

    @Test
    public void testAcceptAllAllowedOrigin() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"*"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "*", null, null, null), 200, "OK", null);
    }

    @Test
    public void testAcceptConstantOrigin() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"vertx\\.io"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "vertx.io", null, null, null), 200, "OK", null);
    }

    @Test
    public void testAcceptConstantOriginDenied1() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"vertx\\.io"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "foo.io"), resp -> this.checkHeaders((HttpClientResponse)resp, null, null, null, null), 403, "CORS Rejected - Invalid origin", null);
    }

    @Test
    public void testAcceptConstantOriginDenied2() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"vertx\\.io"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "fooxio"), resp -> this.checkHeaders((HttpClientResponse)resp, null, null, null, null), 403, "CORS Rejected - Invalid origin", null);
    }

    @Test
    public void testAcceptConstantOriginDeniedErrorHandler() throws Exception {
        Consumer handler = (Consumer)Mockito.mock(Consumer.class);
        this.router.route().handler((Handler)CorsHandler.create((String)"vertx\\.io"));
        this.router.route().handler(context -> context.response().end());
        this.router.errorHandler(403, handler::accept);
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "foo.io"), resp -> ((Consumer)Mockito.verify((Object)handler)).accept(ArgumentMatchers.any()), 403, "CORS Rejected - Invalid origin", null);
    }

    @Test
    public void testAcceptDotisAnyCharacter1() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"vertx.io"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "vertxxio"), resp -> this.checkHeaders((HttpClientResponse)resp, "vertxxio", null, null, null), 200, "OK", null);
    }

    @Test
    public void testAcceptDotisAnyCharacter2() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)"vertx.io"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "vertx.io", null, null, null), 200, "OK", null);
    }

    @Test
    public void testAcceptPattern() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)".*\\.vertx\\.io"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "foo.vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "foo.vertx.io", null, null, null), 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "bar.vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "bar.vertx.io", null, null, null), 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "wibble.bar.vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "wibble.bar.vertx.io", null, null, null), 200, "OK", null);
    }

    @Test
    public void testAcceptPatternDenied() throws Exception {
        this.router.route().handler((Handler)CorsHandler.create((String)".*\\.vertx\\.io"));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "foo.vertx.com"), resp -> this.checkHeaders((HttpClientResponse)resp, null, null, null, null), 403, "CORS Rejected - Invalid origin", null);
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "barxvertxxio"), resp -> this.checkHeaders((HttpClientResponse)resp, null, null, null, null), 403, "CORS Rejected - Invalid origin", null);
    }

    @Test
    public void testPreflightSimple() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        this.router.route().handler((Handler)CorsHandler.create((String)"vertx\\.io").allowedMethods(allowedMethods));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "vertx.io");
            req.headers().add("access-control-request-method", "PUT,DELETE");
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "vertx.io", "PUT,DELETE", null, null), 200, "OK", null);
    }

    @Test
    public void testPreflightAllowedHeaders() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        LinkedHashSet<String> allowedHeaders = new LinkedHashSet<String>(Arrays.asList("X-wibble", "X-blah"));
        this.router.route().handler((Handler)CorsHandler.create((String)"vertx\\.io").allowedMethods(allowedMethods).allowedHeaders(allowedHeaders));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "vertx.io");
            req.headers().add("access-control-request-method", "PUT,DELETE");
            req.headers().add("access-control-request-headers", (Iterable)allowedHeaders);
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "vertx.io", "PUT,DELETE", "X-wibble,X-blah", null), 200, "OK", null);
    }

    @Test
    public void testPreflightNoExposeHeaders() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        LinkedHashSet<String> exposeHeaders = new LinkedHashSet<String>(Arrays.asList("X-floob", "X-blurp"));
        this.router.route().handler((Handler)CorsHandler.create((String)"vertx\\.io").allowedMethods(allowedMethods).exposedHeaders(exposeHeaders));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "vertx.io");
            req.headers().add("access-control-request-method", "PUT,DELETE");
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "vertx.io", "PUT,DELETE", null, null), 200, "OK", null);
    }

    @Test
    public void testPreflightAllowCredentials() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        this.router.route().handler((Handler)CorsHandler.create((String)"vertx\\.io").allowedMethods(allowedMethods).allowCredentials(true));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "vertx.io");
            req.headers().add("access-control-request-method", "PUT,DELETE");
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "vertx.io", "PUT,DELETE", null, null, "true", null), 200, "OK", null);
    }

    @Test
    public void testPreflightAllowCredentialsNoWildcardOrigin() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        this.router.route().handler((Handler)CorsHandler.create((String)"vertx.*").allowedMethods(allowedMethods).allowCredentials(true));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "vertx.io");
            req.headers().add("access-control-request-method", "PUT,DELETE");
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "vertx.io", "PUT,DELETE", null, null, "true", null), 200, "OK", null);
    }

    @Test
    public void testPreflightMaxAge() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        int maxAge = 131233;
        this.router.route().handler((Handler)CorsHandler.create((String)"vertx\\.io").allowedMethods(allowedMethods).maxAgeSeconds(maxAge));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.OPTIONS, "/", req -> {
            req.headers().add("origin", "vertx.io");
            req.headers().add("access-control-request-method", "PUT,DELETE");
        }, resp -> this.checkHeaders((HttpClientResponse)resp, "vertx.io", "PUT,DELETE", null, null, null, String.valueOf(maxAge)), 200, "OK", null);
    }

    @Test
    public void testRealRequestAllowCredentials() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        this.router.route().handler((Handler)CorsHandler.create((String)"vertx\\.io").allowedMethods(allowedMethods).allowCredentials(true));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "vertx.io", null, null, null, "true", null), 200, "OK", null);
    }

    @Test
    public void testRealRequestCredentialsNoWildcardOrigin() throws Exception {
        LinkedHashSet<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(HttpMethod.PUT, HttpMethod.DELETE));
        this.router.route().handler((Handler)CorsHandler.create((String)"vertx.*").allowedMethods(allowedMethods).allowCredentials(true));
        this.router.route().handler(context -> context.response().end());
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().add("origin", "vertx.io"), resp -> this.checkHeaders((HttpClientResponse)resp, "vertx.io", null, null, null, "true", null), 200, "OK", null);
    }

    @Test
    public void testChaining() throws Exception {
        CorsHandler cors = CorsHandler.create((String)"*");
        this.assertNotNull(cors);
        this.assertSame(cors, cors.allowedMethod(HttpMethod.POST));
        this.assertSame(cors, cors.allowedMethod(HttpMethod.DELETE));
        this.assertSame(cors, cors.allowedMethods(new HashSet()));
        this.assertSame(cors, cors.allowedHeader("X-foo"));
        this.assertSame(cors, cors.allowedHeader("X-bar"));
        this.assertSame(cors, cors.allowedHeaders(new HashSet()));
        this.assertSame(cors, cors.exposedHeader("X-wibble"));
        this.assertSame(cors, cors.exposedHeader("X-blah"));
        this.assertSame(cors, cors.exposedHeaders(new HashSet()));
    }

    @Test
    public void testUnsecureCorsShouldNotBeAllowed() throws Exception {
        try {
            CorsHandler.create((String)"*").allowCredentials(true);
            this.fail("Should not be allowed!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void checkHeaders(HttpClientResponse resp, String accessControlAllowOrigin, String accessControlAllowMethods, String accessControlAllowHeaders, String accessControlExposeHeaders) {
        this.checkHeaders(resp, accessControlAllowOrigin, accessControlAllowMethods, accessControlAllowHeaders, accessControlExposeHeaders, null, null);
    }

    private void checkHeaders(HttpClientResponse resp, String accessControlAllowOrigin, String accessControlAllowMethods, String accessControlAllowHeaders, String accessControlExposeHeaders, String allowCredentials, String maxAgeSeconds) {
        this.assertEquals(accessControlAllowOrigin, resp.headers().get("access-control-allow-origin"));
        this.assertEquals(accessControlAllowMethods, resp.headers().get("access-control-allow-methods"));
        this.assertEquals(accessControlAllowHeaders, resp.headers().get("access-control-allow-headers"));
        this.assertEquals(accessControlExposeHeaders, resp.headers().get("access-control-expose-headers"));
        this.assertEquals(allowCredentials, resp.headers().get("access-control-allow-credentials"));
        this.assertEquals(maxAgeSeconds, resp.headers().get("access-control-max-age"));
    }
}

