/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.ext.web.Router;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class RoutingContextNullCurrentRouteTest {
    static final int PORT = 9091;
    private Vertx vertx;

    @Before
    public void before(TestContext context) {
        this.vertx = Vertx.vertx();
        Async async = context.async();
        this.vertx.deployVerticle(TestVerticle.class.getName(), context.asyncAssertSuccess(event -> async.complete()));
    }

    @Test
    public void test(TestContext testContext) {
        HttpClient client = this.vertx.createHttpClient(new HttpClientOptions().setConnectTimeout(10000));
        Async async = testContext.async();
        HttpClientRequest httpClientRequest = client.get(9091, "127.0.0.1", "/test", httpClientResponse -> {
            testContext.assertEquals((Object)204, (Object)httpClientResponse.statusCode());
            async.complete();
        }).exceptionHandler(arg_0 -> ((TestContext)testContext).fail(arg_0));
        httpClientRequest.end();
    }

    @After
    public void after(TestContext context) {
        this.vertx.close(context.asyncAssertSuccess());
    }

    public static class TestVerticle
    extends AbstractVerticle {
        public void start(Promise<Void> startFuture) throws Exception {
            Router router = Router.router((Vertx)this.vertx);
            router.get("/test").handler(routingCount -> this.vertx.setTimer(5000L, timerId -> {
                HttpServerResponse response = routingCount.response();
                if (routingCount.currentRoute() == null) {
                    response.setStatusCode(500).end();
                } else {
                    response.setStatusCode(204).end();
                }
            }));
            this.vertx.createHttpServer().requestHandler((Handler)router).listen(9091, asyncResult -> {
                if (asyncResult.succeeded()) {
                    startFuture.complete();
                } else {
                    startFuture.fail(asyncResult.cause());
                }
            });
        }
    }
}

