/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.shiro.ShiroAuth;
import io.vertx.ext.auth.shiro.ShiroAuthRealmType;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.ext.web.handler.AuthHandlerTestBase;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CookieHandler;
import io.vertx.ext.web.handler.FormLoginHandler;
import io.vertx.ext.web.handler.LoggerHandler;
import io.vertx.ext.web.handler.RedirectAuthHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.UserSessionHandler;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.junit.Test;

public class RedirectAuthHandlerTest
extends AuthHandlerTestBase {
    protected AtomicReference<String> sessionCookie = new AtomicReference();
    protected FormLoginHandler formLoginHandler;
    protected AuthProvider authProvider;
    protected String usernameParam;
    protected String passwordParam;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        JsonObject authConfig = new JsonObject().put("properties_path", "classpath:login/loginusers.properties");
        this.authProvider = ShiroAuth.create((Vertx)this.vertx, (ShiroAuthRealmType)ShiroAuthRealmType.PROPERTIES, (JsonObject)authConfig);
        this.usernameParam = "username";
        this.passwordParam = "password";
    }

    @Test
    public void testLogin() throws Exception {
        this.doLogin((Handler<RoutingContext>)((Handler)rc -> {
            Session sess = rc.session();
            this.assertNotNull(sess);
            this.assertEquals(this.sessionCookie.get().substring(18, 54), sess.id());
            this.assertNotNull(rc.user());
            rc.response().end("Welcome to the protected resource!");
        }));
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("cookie", this.sessionCookie.get()), resp -> {}, 200, "OK", "Welcome to the protected resource!");
        this.router.route("/logout").handler(rc -> {
            rc.clearUser();
            rc.response().end("logged out");
        });
        this.testRequest(HttpMethod.GET, "/logout", req -> req.putHeader("cookie", this.sessionCookie.get()), resp -> {}, 200, "OK", "logged out");
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("cookie", this.sessionCookie.get()), resp -> {
            String location = resp.headers().get("location");
            this.assertNotNull(location);
            this.assertEquals("/loginpage", location);
        }, 302, "Found", null);
    }

    @Test
    public void testLoginChangeFormLoginHandlerParams() throws Exception {
        this.formLoginHandler = FormLoginHandler.create((AuthProvider)this.authProvider);
        this.usernameParam = "username2";
        this.passwordParam = "password2";
        this.formLoginHandler.setUsernameParam(this.usernameParam).setPasswordParam(this.passwordParam);
        this.testLogin();
    }

    @Test
    public void testFormLoginHandlerDirectDefaultResponse() throws Exception {
        this.formLoginHandler = FormLoginHandler.create((AuthProvider)this.authProvider);
        this.usernameParam = "username2";
        this.passwordParam = "password2";
        this.formLoginHandler.setUsernameParam(this.usernameParam).setPasswordParam(this.passwordParam);
        this.router.route().handler((Handler)LoggerHandler.create());
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route("/login").handler((Handler)this.formLoginHandler);
        this.testRequest(HttpMethod.POST, "/login", this.sendLoginRequestConsumer(), resp -> {}, 200, "OK", "<html><body><h1>Login successful</h1></body></html>");
    }

    @Test
    public void testFormLoginHandlerDirectSpecifyLoggedInURL() throws Exception {
        this.formLoginHandler = FormLoginHandler.create((AuthProvider)this.authProvider);
        this.usernameParam = "username2";
        this.passwordParam = "password2";
        String loggedInDirectOKPage = "/youloggedinokpage.html";
        this.formLoginHandler.setUsernameParam(this.usernameParam).setPasswordParam(this.passwordParam).setDirectLoggedInOKURL(loggedInDirectOKPage);
        this.router.route().handler((Handler)LoggerHandler.create());
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route("/login").handler((Handler)this.formLoginHandler);
        this.testRequest(HttpMethod.POST, "/login", this.sendLoginRequestConsumer(), resp -> {
            String location = resp.headers().get("location");
            this.assertNotNull(location);
            this.assertEquals(loggedInDirectOKPage, location);
        }, 302, "Found", null);
    }

    private Consumer<HttpClientRequest> sendLoginRequestConsumer() {
        return req -> {
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            Buffer buffer = Buffer.buffer();
            String str = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"" + this.usernameParam + "\"\r\n\r\ntim\r\n--" + boundary + "\r\nContent-Disposition: form-data; name=\"" + this.passwordParam + "\"\r\n\r\ndelicious:sausages\r\n--" + boundary + "--\r\n";
            buffer.appendString(str);
            req.putHeader("content-length", String.valueOf(buffer.length()));
            req.putHeader("content-type", "multipart/form-data; boundary=" + boundary);
            if (this.sessionCookie.get() != null) {
                req.putHeader("cookie", this.sessionCookie.get());
            }
            req.write(buffer);
        };
    }

    @Test
    public void testLoginFailBadUser() throws Exception {
        this.testLoginFail(true);
    }

    @Test
    public void testLoginFailBadPassword() throws Exception {
        this.testLoginFail(false);
    }

    @Test
    public void testRedirectWithParams() throws Exception {
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.route().handler((Handler)CookieHandler.create());
        LocalSessionStore store = LocalSessionStore.create((Vertx)this.vertx);
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)store));
        this.router.route().handler((Handler)UserSessionHandler.create((AuthProvider)this.authProvider));
        AuthHandler authHandler = RedirectAuthHandler.create((AuthProvider)this.authProvider);
        this.router.route("/protected/*").handler((Handler)authHandler);
        this.router.route("/protected/somepage").handler(ctx -> {
            this.assertEquals("1", ctx.request().getParam("param"));
            ctx.response().end("Welcome to the protected resource!");
        });
        this.router.route("/loginpage").handler(rc -> rc.response().putHeader("content-type", "text/html").end(this.createloginHTML()));
        this.router.route("/login").handler((Handler)FormLoginHandler.create((AuthProvider)this.authProvider));
        this.testRequest(HttpMethod.GET, "/protected/somepage?param=1", null, resp -> {
            String location = resp.headers().get("location");
            this.assertNotNull(location);
            this.assertEquals("/loginpage", location);
            String setCookie = resp.headers().get("set-cookie");
            this.assertNotNull(setCookie);
            this.sessionCookie.set(setCookie);
        }, 302, "Found", null);
        this.testRequest(HttpMethod.GET, "/loginpage", req -> req.putHeader("cookie", this.sessionCookie.get()), resp -> {}, 200, "OK", this.createloginHTML());
        this.testRequest(HttpMethod.POST, "/login", this.sendLoginRequestConsumer(), resp -> {
            String location = resp.headers().get("location");
            this.assertNotNull(location);
            this.assertEquals("/protected/somepage?param=1", location);
        }, 302, "Found", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage?param=1", req -> req.putHeader("cookie", this.sessionCookie.get()), resp -> {}, 200, "OK", "Welcome to the protected resource!");
    }

    @Override
    protected AuthHandler createAuthHandler(AuthProvider authProvider) {
        return RedirectAuthHandler.create((AuthProvider)authProvider);
    }

    @Override
    protected boolean requiresSession() {
        return true;
    }

    private void testLoginFail(boolean badUser) throws Exception {
        this.doLoginFail(badUser, (Handler<RoutingContext>)((Handler)rc -> {
            Session sess = rc.session();
            this.assertNotNull(sess);
            this.assertEquals(this.sessionCookie.get().substring(18, 54), sess.id());
            this.assertNotNull(rc.user());
            rc.response().end("Welcome to the protected resource!");
        }));
    }

    private void doLogin(Handler<RoutingContext> handler) throws Exception {
        this.doLoginCommon(handler);
        this.testRequest(HttpMethod.POST, "/login", this.sendLoginRequestConsumer(), resp -> {
            String location = resp.headers().get("location");
            this.assertNotNull(location);
            this.assertEquals("/protected/somepage", location);
        }, 302, "Found", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("cookie", this.sessionCookie.get()), resp -> {}, 200, "OK", "Welcome to the protected resource!");
    }

    private void doLoginCommon(Handler<RoutingContext> handler) throws Exception {
        this.doLoginCommon(handler, null);
    }

    private void doLoginCommon(Handler<RoutingContext> handler, Set<String> authorities) throws Exception {
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.route().handler((Handler)CookieHandler.create());
        LocalSessionStore store = LocalSessionStore.create((Vertx)this.vertx);
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)store));
        this.router.route().handler((Handler)UserSessionHandler.create((AuthProvider)this.authProvider));
        AuthHandler authHandler = RedirectAuthHandler.create((AuthProvider)this.authProvider);
        if (authorities != null) {
            authHandler.addAuthorities(authorities);
        }
        this.router.route("/protected/*").handler((Handler)authHandler);
        this.router.route("/protected/somepage").handler(handler);
        String loginHTML = this.createloginHTML();
        this.router.route("/loginpage").handler(rc -> rc.response().putHeader("content-type", "text/html").end(loginHTML));
        if (this.formLoginHandler == null) {
            this.formLoginHandler = FormLoginHandler.create((AuthProvider)this.authProvider);
        }
        this.router.route("/login").handler((Handler)this.formLoginHandler);
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, resp -> {
            String location = resp.headers().get("location");
            this.assertNotNull(location);
            this.assertEquals("/loginpage", location);
            String setCookie = resp.headers().get("set-cookie");
            this.assertNotNull(setCookie);
            this.sessionCookie.set(setCookie);
        }, 302, "Found", null);
        this.testRequest(HttpMethod.GET, "/loginpage", req -> req.putHeader("cookie", this.sessionCookie.get()), resp -> {}, 200, "OK", loginHTML);
    }

    private void doLoginFail(boolean badUser, Handler<RoutingContext> handler) throws Exception {
        this.doLoginCommon(handler);
        this.testRequest(HttpMethod.POST, "/login", req -> {
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            Buffer buffer = Buffer.buffer();
            String username = badUser ? "jim" : "tim";
            String password = badUser ? "delicious:sausages" : "fishfingers";
            String str = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"username\"\r\n\r\n" + username + "\r\n--" + boundary + "\r\nContent-Disposition: form-data; name=\"password\"\r\n\r\n" + password + "\r\n--" + boundary + "--\r\n";
            buffer.appendString(str);
            req.putHeader("content-length", String.valueOf(buffer.length()));
            req.putHeader("content-type", "multipart/form-data; boundary=" + boundary);
            req.putHeader("cookie", this.sessionCookie.get());
            req.write(buffer);
        }, resp -> {}, 403, "Forbidden", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("cookie", this.sessionCookie.get()), resp -> {
            String location = resp.headers().get("location");
            this.assertNotNull(location);
            this.assertEquals("/loginpage", location);
        }, 302, "Found", null);
    }

    protected String createloginHTML() {
        return "<html>\n<body>\n<h2>Please login {{foo}}</h2><br>\n<form action=\"/login\" method=\"post\">\n  <div>\n    <label>Username:</label>\n    <input type=\"text\" name=\"" + this.usernameParam + "\"/>\n  </div>\n  <div>\n    <label>Password:</label>\n    <input type=\"password\" name=\"" + this.passwordParam + "\"/>\n  </div>\n  <div>\n    <input type=\"submit\" value=\"Log In\"/>\n  </div>\n</form>\n</body>\n</html>";
    }
}

