/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.test.core.TestUtils;
import java.io.File;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BodyHandlerTest
extends WebTestBase {
    @Rule
    public TemporaryFolder tempUploads = new TemporaryFolder();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.router.route().handler((Handler)BodyHandler.create());
    }

    @AfterClass
    public static void oneTimeTearDown() {
        Vertx vertx = Vertx.vertx();
        if (vertx.fileSystem().existsBlocking("file-uploads")) {
            vertx.fileSystem().deleteRecursiveBlocking("file-uploads", true);
        }
    }

    @Test
    public void testGETWithBody() throws Exception {
        this.router.route().handler(rc -> {
            this.assertNotNull(rc.getBody());
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
    }

    @Test
    public void testHEADWithBody() throws Exception {
        this.router.route().handler(rc -> {
            this.assertNotNull(rc.getBody());
            rc.response().end();
        });
        this.testRequest(HttpMethod.HEAD, "/", 200, "OK");
    }

    @Test
    public void testBodyBuffer() throws Exception {
        Buffer buff = TestUtils.randomBuffer((int)1000);
        this.router.route().handler(rc -> {
            this.assertEquals(buff, rc.getBody());
            rc.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.setChunked(true);
            req.write(buff);
        }, 200, "OK", null);
    }

    @Test
    public void testBodyString() throws Exception {
        String str = "sausages";
        this.router.route().handler(rc -> {
            this.assertEquals(str, rc.getBodyAsString());
            rc.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.setChunked(true);
            req.write(str);
        }, 200, "OK", null);
    }

    @Test
    public void testBodyStringEncoding() throws Exception {
        String str = TestUtils.randomUnicodeString((int)100);
        String enc = "UTF-16";
        this.router.route().handler(rc -> {
            this.assertEquals(str, rc.getBodyAsString(enc));
            rc.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.setChunked(true);
            req.write(str, enc);
        }, 200, "OK", null);
    }

    @Test
    public void testBodyJson() throws Exception {
        JsonObject json = new JsonObject().put("foo", "bar").put("blah", Integer.valueOf(123));
        this.router.route().handler(rc -> {
            this.assertEquals(json, rc.getBodyAsJson());
            rc.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.setChunked(true);
            req.write(json.encode());
        }, 200, "OK", null);
    }

    @Test
    public void testBodyTooBig() throws Exception {
        this.router.clear();
        this.router.route().handler((Handler)BodyHandler.create().setBodyLimit(5000L));
        Buffer buff = TestUtils.randomBuffer((int)10000);
        this.router.route().handler(rc -> this.fail("Should not be called"));
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.setChunked(true);
            req.write(buff);
        }, 413, "Request Entity Too Large", null);
    }

    @Test
    public void testBodyTooBig2() throws Exception {
        this.router.clear();
        this.router.route().handler((Handler)BodyHandler.create().setBodyLimit(500L));
        Buffer buff = TestUtils.randomBuffer((int)1000);
        this.router.route().handler(rc -> this.fail("Should not be called"));
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.setChunked(true);
            req.write(buff);
        }, 413, "Request Entity Too Large", null);
    }

    @Test
    public void testFileUploadSmallUpload() throws Exception {
        this.testFileUpload("file-uploads", 50);
    }

    @Test
    public void testFileUpload7990Upload() throws Exception {
        this.testFileUpload("file-uploads", 7990);
    }

    @Test
    public void testFileUploadLargeUpload() throws Exception {
        this.testFileUpload("file-uploads", 20000);
    }

    @Test
    public void testFileUploadDefaultUploadsDir() throws Exception {
        this.testFileUpload("file-uploads", 5000);
    }

    @Test
    public void testFileUploadOtherUploadsDir() throws Exception {
        this.router.clear();
        File dir = this.tempUploads.newFolder();
        this.router.route().handler((Handler)BodyHandler.create().setUploadsDirectory(dir.getPath()));
        this.testFileUpload(dir.getPath(), 5000);
    }

    private void testFileUpload(String uploadsDir, int size) throws Exception {
        String name = "somename";
        String fileName = "somefile.dat";
        String contentType = "application/octet-stream";
        Buffer fileData = TestUtils.randomBuffer((int)size);
        this.router.route().handler(rc -> {
            Set fileUploads = rc.fileUploads();
            this.assertNotNull(fileUploads);
            this.assertEquals(1L, fileUploads.size());
            FileUpload upload = (FileUpload)fileUploads.iterator().next();
            this.assertEquals(name, upload.name());
            this.assertEquals(fileName, upload.fileName());
            this.assertEquals(contentType, upload.contentType());
            this.assertEquals("binary", upload.contentTransferEncoding());
            this.assertEquals(fileData.length(), upload.size());
            String uploadedFileName = upload.uploadedFileName();
            this.assertTrue(uploadedFileName.startsWith(uploadsDir + File.separator));
            Buffer uploaded = this.vertx.fileSystem().readFileBlocking(uploadedFileName);
            this.assertEquals(fileData, uploaded);
            Buffer rawBody = rc.getBody();
            this.assertEquals(0L, rawBody.length());
            rc.response().end();
        });
        this.sendFileUploadRequest(fileData, 200, "OK");
    }

    @Test
    public void testFileUploadTooBig() throws Exception {
        this.router.clear();
        this.router.route().handler((Handler)BodyHandler.create().setBodyLimit(20000L));
        Buffer fileData = TestUtils.randomBuffer((int)50000);
        this.router.route().handler(rc -> this.fail("Should not be called"));
        this.sendFileUploadRequest(fileData, 413, "Request Entity Too Large");
    }

    @Test
    public void testFileUploadTooBig2() throws Exception {
        this.router.clear();
        this.router.route().handler((Handler)BodyHandler.create().setBodyLimit(20000L));
        Buffer fileData = TestUtils.randomBuffer((int)50000);
        this.router.route().handler(rc -> this.fail("Should not be called"));
        this.sendFileUploadRequest(fileData, 413, "Request Entity Too Large");
    }

    @Test
    public void testFileUploadNoFileRemovalOnEnd() throws Exception {
        this.testFileUploadFileRemoval((Handler<RoutingContext>)((Handler)rc -> rc.response().end()), false, 200, "OK");
    }

    @Test
    public void testFileUploadFileRemovalOnEnd() throws Exception {
        this.testFileUploadFileRemoval((Handler<RoutingContext>)((Handler)rc -> rc.response().end()), true, 200, "OK");
    }

    @Test
    public void testFileUploadFileRemovalOnError() throws Exception {
        this.testFileUploadFileRemoval((Handler<RoutingContext>)((Handler)rc -> {
            throw new IllegalStateException();
        }), true, 500, "Internal Server Error");
    }

    @Test
    public void testFileUploadFileRemovalIfAlreadyRemoved() throws Exception {
        this.testFileUploadFileRemoval((Handler<RoutingContext>)((Handler)rc -> {
            this.vertx.fileSystem().deleteBlocking(((FileUpload)rc.fileUploads().iterator().next()).uploadedFileName());
            rc.response().end();
        }), true, 200, "OK");
    }

    private void testFileUploadFileRemoval(Handler<RoutingContext> requestHandler, boolean deletedUploadedFilesOnEnd, int statusCode, String statusMessage) throws Exception {
        String uploadsDirectory = this.tempUploads.newFolder().getPath();
        this.router.clear();
        this.router.route().handler((Handler)BodyHandler.create().setDeleteUploadedFilesOnEnd(deletedUploadedFilesOnEnd).setUploadsDirectory(uploadsDirectory));
        this.router.route().handler(requestHandler);
        this.sendFileUploadRequest(TestUtils.randomBuffer((int)50), statusCode, statusMessage);
        Thread.sleep(100L);
        int uploadedFilesAfterEnd = deletedUploadedFilesOnEnd ? 0 : 1;
        this.assertEquals(uploadedFilesAfterEnd, this.vertx.fileSystem().readDirBlocking(uploadsDirectory).size());
    }

    private void sendFileUploadRequest(Buffer fileData, int statusCode, String statusMessage) throws Exception {
        String name = "somename";
        String fileName = "somefile.dat";
        String contentType = "application/octet-stream";
        this.testRequest(HttpMethod.POST, "/", req -> {
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            Buffer buffer = Buffer.buffer();
            String header = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"" + name + "\"; filename=\"" + fileName + "\"\r\nContent-Type: " + contentType + "\r\nContent-Transfer-Encoding: binary\r\n\r\n";
            buffer.appendString(header);
            buffer.appendBuffer(fileData);
            String footer = "\r\n--" + boundary + "--\r\n";
            buffer.appendString(footer);
            req.headers().set("content-length", String.valueOf(buffer.length()));
            req.headers().set("content-type", "multipart/form-data; boundary=" + boundary);
            req.write(buffer);
        }, statusCode, statusMessage, null);
    }

    @Test
    public void testFormURLEncoded() throws Exception {
        this.router.route().handler(rc -> {
            MultiMap attrs = rc.request().formAttributes();
            this.assertNotNull(attrs);
            this.assertEquals(3L, attrs.size());
            this.assertEquals("junit-testUserAlias", attrs.get("origin"));
            this.assertEquals("admin@foo.bar", attrs.get("login"));
            this.assertEquals("admin", attrs.get("pass word"));
            rc.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", req -> {
            Buffer buffer = Buffer.buffer();
            buffer.appendString("origin=junit-testUserAlias&login=admin%40foo.bar&pass+word=admin");
            req.headers().set("content-length", String.valueOf(buffer.length()));
            req.headers().set("content-type", "application/x-www-form-urlencoded");
            req.write(buffer);
        }, 200, "OK", null);
    }

    @Test
    public void testFormMultipartFormDataMergeAttributesDefault() throws Exception {
        this.testFormMultipartFormData(true);
    }

    @Test
    public void testFormMultipartFormDataMergeAttributes() throws Exception {
        this.router.clear();
        this.router.route().handler((Handler)BodyHandler.create().setMergeFormAttributes(true));
        this.testFormMultipartFormData(true);
    }

    @Test
    public void testFormMultipartFormDataNoMergeAttributes() throws Exception {
        this.router.clear();
        this.router.route().handler((Handler)BodyHandler.create().setMergeFormAttributes(false));
        this.testFormMultipartFormData(false);
    }

    @Test
    public void testMultiFileUpload() throws Exception {
        int uploads = 1000;
        this.router.route().handler(rc -> {
            this.assertEquals(uploads, rc.fileUploads().size());
            rc.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", req -> {
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            Buffer buffer = Buffer.buffer();
            for (int i = 0; i < uploads; ++i) {
                String header = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"file" + i + "\"; filename=\"file" + i + "\"\r\nContent-Type: application/octet-stream\r\nContent-Transfer-Encoding: binary\r\n\r\n";
                buffer.appendString(header);
                buffer.appendBuffer(TestUtils.randomBuffer((int)65536));
                buffer.appendString("\r\n");
            }
            buffer.appendString("--" + boundary + "\r\n");
            req.headers().set("content-length", String.valueOf(buffer.length()));
            req.headers().set("content-type", "multipart/form-data; boundary=" + boundary);
            req.write(buffer);
        }, 200, "OK", null);
    }

    private void testFormMultipartFormData(boolean mergeAttributes) throws Exception {
        this.router.route().handler(rc -> {
            MultiMap attrs = rc.request().formAttributes();
            this.assertNotNull(attrs);
            this.assertEquals(2L, attrs.size());
            this.assertEquals("Tim", attrs.get("attr1"));
            this.assertEquals("Julien", attrs.get("attr2"));
            MultiMap params = rc.request().params();
            if (mergeAttributes) {
                this.assertNotNull(params);
                this.assertEquals(3L, params.size());
                this.assertEquals("Tim", params.get("attr1"));
                this.assertEquals("Julien", params.get("attr2"));
                this.assertEquals("foo", params.get("p1"));
            } else {
                this.assertNotNull(params);
                this.assertEquals(1L, params.size());
                this.assertEquals("foo", params.get("p1"));
            }
            rc.response().end();
        });
        this.testRequest(HttpMethod.POST, "/?p1=foo", req -> {
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            Buffer buffer = Buffer.buffer();
            String str = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"attr1\"\r\n\r\nTim\r\n--" + boundary + "\r\nContent-Disposition: form-data; name=\"attr2\"\r\n\r\nJulien\r\n--" + boundary + "--\r\n";
            buffer.appendString(str);
            req.headers().set("content-length", String.valueOf(buffer.length()));
            req.headers().set("content-type", "multipart/form-data; boundary=" + boundary);
            req.write(buffer);
        }, 200, "OK", null);
    }

    @Test
    public void testMixedUploadAndForm() throws Exception {
        String uploadsDirectory = this.tempUploads.newFolder().getPath();
        this.router.clear();
        this.router.route().handler((Handler)BodyHandler.create().setUploadsDirectory(uploadsDirectory));
        this.router.route().handler(ctx -> {
            this.assertEquals(0L, ctx.getBody().length());
            this.assertEquals(1L, ctx.fileUploads().size());
            ctx.response().end();
        });
        String name = "somename";
        String fileName = "somefile.dat";
        String contentType = "application/octet-stream";
        this.testRequest(HttpMethod.POST, "/", req -> {
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            Buffer buffer = Buffer.buffer();
            String header = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"" + name + "\"; filename=\"" + fileName + "\"\r\nContent-Type: " + contentType + "\r\nContent-Transfer-Encoding: binary\r\n\r\n";
            buffer.appendString(header);
            buffer.appendBuffer(TestUtils.randomBuffer((int)50));
            String footer = "\r\n--" + boundary + "--\r\n";
            buffer.appendString(footer);
            req.headers().set("content-length", String.valueOf(buffer.length()));
            req.headers().set("content-type", "multipart/form-data; boundary=" + boundary);
            req.write(buffer);
        }, 200, "OK", "");
    }
}

