/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Context;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import org.junit.Test;

public class BlockingHandlerTest
extends WebTestBase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testBlockingHandler() throws Exception {
        ArrayList threads = new ArrayList();
        ArrayList contexts = new ArrayList();
        this.router.route().handler(rc -> {
            threads.add(Thread.currentThread());
            contexts.add(rc.vertx().getOrCreateContext());
            this.assertTrue(rc.currentRoute() != null);
            rc.response().setChunked(true);
            rc.response().write("A");
            rc.next();
        });
        this.router.route().blockingHandler(rc -> {
            this.assertTrue(!((Thread)threads.get(0)).equals(Thread.currentThread()));
            this.assertTrue(((Context)contexts.get(0)).equals(rc.vertx().getOrCreateContext()));
            this.assertTrue(rc.currentRoute() != null);
            rc.response().write("B");
            rc.next();
        });
        this.router.route().blockingHandler(rc -> {
            this.assertTrue(!((Thread)threads.get(0)).equals(Thread.currentThread()));
            this.assertTrue(((Context)contexts.get(0)).equals(rc.vertx().getOrCreateContext()));
            this.assertTrue(rc.currentRoute() != null);
            rc.response().write("C");
            rc.next();
        });
        this.router.route().handler(rc -> {
            this.assertTrue(((Thread)threads.get(0)).equals(Thread.currentThread()));
            this.assertTrue(((Context)contexts.get(0)).equals(rc.vertx().getOrCreateContext()));
            this.assertTrue(rc.currentRoute() != null);
            rc.response().write("D");
            rc.next();
        });
        this.router.route().handler(rc -> {
            this.assertTrue(((Thread)threads.get(0)).equals(Thread.currentThread()));
            this.assertTrue(((Context)contexts.get(0)).equals(rc.vertx().getOrCreateContext()));
            this.assertTrue(rc.currentRoute() != null);
            rc.response().write("E");
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK", "ABCDE");
    }

    @Test
    public void testBlockingHandlerFailure() throws Exception {
        ArrayList threads = new ArrayList();
        ArrayList contexts = new ArrayList();
        this.router.route().handler(rc -> {
            threads.add(Thread.currentThread());
            contexts.add(rc.vertx().getOrCreateContext());
            rc.response().setChunked(true);
            rc.next();
        });
        this.router.route().blockingHandler(rc -> {
            this.assertTrue(!((Thread)threads.get(0)).equals(Thread.currentThread()));
            this.assertTrue(((Context)contexts.get(0)).equals(rc.vertx().getOrCreateContext()));
            this.assertTrue(rc.currentRoute() != null);
            rc.fail(501);
        });
        this.router.route().failureHandler(rc -> {
            this.assertTrue(((Thread)threads.get(0)).equals(Thread.currentThread()));
            this.assertTrue(((Context)contexts.get(0)).equals(rc.vertx().getOrCreateContext()));
            this.assertTrue(rc.currentRoute() != null);
            rc.response().setStatusCode(rc.statusCode()).end();
        });
        this.testRequest(HttpMethod.GET, "/", 501, "Not Implemented");
    }

    @Test
    public void testBlockingHandlerFailureThrowException() throws Exception {
        ArrayList threads = new ArrayList();
        ArrayList contexts = new ArrayList();
        this.router.route().handler(rc -> {
            threads.add(Thread.currentThread());
            contexts.add(rc.vertx().getOrCreateContext());
            rc.next();
        });
        this.router.route().blockingHandler(rc -> {
            this.assertTrue(!((Thread)threads.get(0)).equals(Thread.currentThread()));
            this.assertTrue(((Context)contexts.get(0)).equals(rc.vertx().getOrCreateContext()));
            this.assertTrue(rc.currentRoute() != null);
            throw new RuntimeException("foo");
        });
        this.router.route().failureHandler(rc -> {
            this.assertTrue(((Thread)threads.get(0)).equals(Thread.currentThread()));
            this.assertTrue(((Context)contexts.get(0)).equals(rc.vertx().getOrCreateContext()));
            this.assertTrue(rc.currentRoute() != null);
            Throwable t = rc.failure();
            this.assertNotNull(t);
            this.assertTrue(t instanceof RuntimeException);
            this.assertEquals("foo", t.getMessage());
            rc.response().setStatusCode(500).end();
        });
        this.testRequest(HttpMethod.GET, "/", 500, "Internal Server Error");
    }

    @Test
    public void testExecuteBlockingParallel() throws Exception {
        long start = System.currentTimeMillis();
        int numExecBlocking = 5;
        long pause = 1000L;
        this.router.route().blockingHandler(rc -> {
            System.out.println("In blocking handler");
            try {
                Thread.sleep(pause);
            }
            catch (Exception exception) {
                // empty catch block
            }
            rc.response().end();
        }, false);
        CountDownLatch latch = new CountDownLatch(numExecBlocking);
        for (int i = 0; i < numExecBlocking; ++i) {
            this.client.getNow("/", resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.assertEquals("OK", resp.statusMessage());
                latch.countDown();
            });
        }
        this.awaitLatch(latch);
        long now = System.currentTimeMillis();
        long leeway = 2000L;
        this.assertTrue(now - start < pause + leeway);
    }
}

