package io.grpc.examples.helloworld;

import io.vertx.core.Future;
import io.vertx.core.Completable;
import io.vertx.core.Handler;
import io.vertx.core.net.SocketAddress;
import io.vertx.grpc.client.GrpcClient;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.common.ServiceMethod;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;

/**
 * <p>A client for invoking the Greeter gRPC service.</p>
 */
@io.vertx.codegen.annotations.VertxGen
public interface GreeterClient extends Greeter {

  /**
   * Calls the SayHello RPC service method.
   *
   * @param request the io.grpc.examples.helloworld.HelloRequest request message
   * @return a future of the io.grpc.examples.helloworld.HelloReply response message
   */
  @io.vertx.codegen.annotations.GenIgnore(io.vertx.codegen.annotations.GenIgnore.PERMITTED_TYPE)
  Future<io.grpc.examples.helloworld.HelloReply> sayHello(io.grpc.examples.helloworld.HelloRequest request);

  /**
   * Calls the SayHelloStreaming RPC service method.
   *
   * @param compltable a completable that will be passed a stream to which the io.grpc.examples.helloworld.HelloRequest request messages can be written to.
   * @return a future of the io.grpc.examples.helloworld.HelloReply response messages
   */
  @io.vertx.codegen.annotations.GenIgnore
  Future<ReadStream<io.grpc.examples.helloworld.HelloReply>> sayHelloStreaming(Completable<WriteStream<io.grpc.examples.helloworld.HelloRequest>> completable);

  /**
   * Calls the SayHelloStreaming RPC service method.
   *
    * @param streamOfMessages a stream of messages to be sent to the service
   * @return a future of the io.grpc.examples.helloworld.HelloReply response messages
   */
  @io.vertx.codegen.annotations.GenIgnore(io.vertx.codegen.annotations.GenIgnore.PERMITTED_TYPE)
  default Future<ReadStream<io.grpc.examples.helloworld.HelloReply>> sayHelloStreaming(ReadStream<io.grpc.examples.helloworld.HelloRequest> streamOfMessages) {
    io.vertx.core.streams.Pipe<io.grpc.examples.helloworld.HelloRequest> pipe = streamOfMessages.pipe();
    return sayHelloStreaming((result, error) -> {
        if (error == null) {
          pipe.to(result);
        } else {
          pipe.close();
        }
    });
  }
}
