/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.amqp;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.proton.ProtonConnection;
import io.vertx.reactivex.amqp.AmqpReceiver;
import io.vertx.reactivex.amqp.AmqpSender;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;

@RxGen(value=io.vertx.amqp.AmqpConnection.class)
public class AmqpConnection
implements RxDelegate {
    public static final TypeArg<AmqpConnection> __TYPE_ARG = new TypeArg(obj -> new AmqpConnection((io.vertx.amqp.AmqpConnection)obj), AmqpConnection::getDelegate);
    private final io.vertx.amqp.AmqpConnection delegate;
    private static final TypeArg<AmqpReceiver> TYPE_ARG_0 = new TypeArg(o1 -> AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)o1), o1 -> o1.getDelegate());
    private static final TypeArg<AmqpReceiver> TYPE_ARG_1 = new TypeArg(o1 -> AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)o1), o1 -> o1.getDelegate());
    private static final TypeArg<AmqpReceiver> TYPE_ARG_2 = new TypeArg(o1 -> AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)o1), o1 -> o1.getDelegate());
    private static final TypeArg<AmqpSender> TYPE_ARG_3 = new TypeArg(o1 -> AmqpSender.newInstance((io.vertx.amqp.AmqpSender)o1), o1 -> o1.getDelegate());
    private static final TypeArg<AmqpSender> TYPE_ARG_4 = new TypeArg(o1 -> AmqpSender.newInstance((io.vertx.amqp.AmqpSender)o1), o1 -> o1.getDelegate());
    private static final TypeArg<AmqpSender> TYPE_ARG_5 = new TypeArg(o1 -> AmqpSender.newInstance((io.vertx.amqp.AmqpSender)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmqpConnection that = (AmqpConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AmqpConnection(io.vertx.amqp.AmqpConnection delegate) {
        this.delegate = delegate;
    }

    public AmqpConnection(Object delegate) {
        this.delegate = (io.vertx.amqp.AmqpConnection)delegate;
    }

    public io.vertx.amqp.AmqpConnection getDelegate() {
        return this.delegate;
    }

    public AmqpConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    public Future<AmqpReceiver> createReceiver(String address) {
        Future ret = this.delegate.createReceiver(address).map(val -> AmqpReceiver.newInstance(val));
        return ret;
    }

    public Single<AmqpReceiver> rxCreateReceiver(String address) {
        return AsyncResultSingle.toSingle($handler -> this.createReceiver(address).onComplete($handler));
    }

    public Future<AmqpReceiver> createReceiver(String address, AmqpReceiverOptions receiverOptions) {
        Future ret = this.delegate.createReceiver(address, receiverOptions).map(val -> AmqpReceiver.newInstance(val));
        return ret;
    }

    public Single<AmqpReceiver> rxCreateReceiver(String address, AmqpReceiverOptions receiverOptions) {
        return AsyncResultSingle.toSingle($handler -> this.createReceiver(address, receiverOptions).onComplete($handler));
    }

    public Future<AmqpReceiver> createDynamicReceiver() {
        Future ret = this.delegate.createDynamicReceiver().map(val -> AmqpReceiver.newInstance(val));
        return ret;
    }

    public Single<AmqpReceiver> rxCreateDynamicReceiver() {
        return AsyncResultSingle.toSingle($handler -> this.createDynamicReceiver().onComplete($handler));
    }

    public Future<AmqpSender> createSender(String address) {
        Future ret = this.delegate.createSender(address).map(val -> AmqpSender.newInstance(val));
        return ret;
    }

    public Single<AmqpSender> rxCreateSender(String address) {
        return AsyncResultSingle.toSingle($handler -> this.createSender(address).onComplete($handler));
    }

    public Future<AmqpSender> createSender(String address, AmqpSenderOptions options) {
        Future ret = this.delegate.createSender(address, options).map(val -> AmqpSender.newInstance(val));
        return ret;
    }

    public Single<AmqpSender> rxCreateSender(String address, AmqpSenderOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.createSender(address, options).onComplete($handler));
    }

    public Future<AmqpSender> createAnonymousSender() {
        Future ret = this.delegate.createAnonymousSender().map(val -> AmqpSender.newInstance(val));
        return ret;
    }

    public Single<AmqpSender> rxCreateAnonymousSender() {
        return AsyncResultSingle.toSingle($handler -> this.createAnonymousSender().onComplete($handler));
    }

    public boolean isDisconnected() {
        boolean ret = this.delegate.isDisconnected();
        return ret;
    }

    public Future<Void> closeFuture() {
        Future ret = this.delegate.closeFuture().map(val -> val);
        return ret;
    }

    public Completable rxCloseFuture() {
        return AsyncResultCompletable.toCompletable($handler -> this.closeFuture().onComplete($handler));
    }

    public ProtonConnection unwrap() {
        ProtonConnection ret = this.delegate.unwrap();
        return ret;
    }

    public static AmqpConnection newInstance(io.vertx.amqp.AmqpConnection arg) {
        return arg != null ? new AmqpConnection(arg) : null;
    }
}

