/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.grpc.examples.reactivex.helloworld;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * <p>A client for invoking the Greeter gRPC service.</p>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.grpc.examples.helloworld.GreeterGrpcClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.grpc.examples.helloworld.GreeterGrpcClient.class)
public class GreeterGrpcClient extends io.grpc.examples.reactivex.helloworld.GreeterClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GreeterGrpcClient that = (GreeterGrpcClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GreeterGrpcClient> __TYPE_ARG = new TypeArg<>(    obj -> new GreeterGrpcClient((io.grpc.examples.helloworld.GreeterGrpcClient) obj),
    GreeterGrpcClient::getDelegate
  );

  private final io.grpc.examples.helloworld.GreeterGrpcClient delegate;
  
  public GreeterGrpcClient(io.grpc.examples.helloworld.GreeterGrpcClient delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public GreeterGrpcClient(Object delegate) {
    super((io.grpc.examples.helloworld.GreeterGrpcClient)delegate);
    this.delegate = (io.grpc.examples.helloworld.GreeterGrpcClient)delegate;
  }

  @Override 
  public io.grpc.examples.helloworld.GreeterGrpcClient getDelegate() {
    return delegate;
  }

  /**
   * Create and return a Greeter gRPC service client. The assumed wire format is Protobuf.
   * @param client the gRPC client
   * @param host the host providing the service
   * @return the configured client
   */
  public static io.grpc.examples.reactivex.helloworld.GreeterGrpcClient create(io.vertx.reactivex.grpc.client.GrpcClient client, io.vertx.core.net.SocketAddress host) { 
    io.grpc.examples.reactivex.helloworld.GreeterGrpcClient ret = io.grpc.examples.reactivex.helloworld.GreeterGrpcClient.newInstance((io.grpc.examples.helloworld.GreeterGrpcClient)io.grpc.examples.helloworld.GreeterGrpcClient.create(client.getDelegate(), host));
    return ret;
  }

  /**
   * Create and return a Greeter gRPC service client.
   * @param client the gRPC client
   * @param host the host providing the service
   * @param wireFormat the wire format
   * @return the configured client
   */
  public static io.grpc.examples.reactivex.helloworld.GreeterGrpcClient create(io.vertx.reactivex.grpc.client.GrpcClient client, io.vertx.core.net.SocketAddress host, io.vertx.grpc.common.WireFormat wireFormat) { 
    io.grpc.examples.reactivex.helloworld.GreeterGrpcClient ret = io.grpc.examples.reactivex.helloworld.GreeterGrpcClient.newInstance((io.grpc.examples.helloworld.GreeterGrpcClient)io.grpc.examples.helloworld.GreeterGrpcClient.create(client.getDelegate(), host, wireFormat));
    return ret;
  }

  /**
   * SayHello protobuf RPC client service method.
   */
  public static final io.vertx.grpc.common.ServiceMethod<io.grpc.examples.helloworld.HelloReply,io.grpc.examples.helloworld.HelloRequest> SayHello = io.grpc.examples.helloworld.GreeterGrpcClient.SayHello;
  /**
   * SayHelloStreaming protobuf RPC client service method.
   */
  public static final io.vertx.grpc.common.ServiceMethod<io.grpc.examples.helloworld.HelloReply,io.grpc.examples.helloworld.HelloRequest> SayHelloStreaming = io.grpc.examples.helloworld.GreeterGrpcClient.SayHelloStreaming;
  public static GreeterGrpcClient newInstance(io.grpc.examples.helloworld.GreeterGrpcClient arg) {
    return arg != null ? new GreeterGrpcClient(arg) : null;
  }

}
