/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient.templates;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An SQL template.
 *
 * <p>SQL templates are useful for interacting with a relational database.
 *
 * <p>SQL templates execute queries using named instead of positional parameters. Query execution is parameterized
 * by a map of string to objects instead of a {@link io.vertx.reactivex.sqlclient.Tuple}. The default source of parameters is a
 * simple map, a user defined mapping can be used instead given it maps the source to such a map.
 *
 * <p>SQL template default results are , a user defined mapping can be used instead, mapping the
 * result set  to a  of the mapped type.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.templates.SqlTemplate original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.templates.SqlTemplate.class)
public class SqlTemplate<I,R> implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlTemplate that = (SqlTemplate) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SqlTemplate> __TYPE_ARG = new TypeArg<>(    obj -> new SqlTemplate((io.vertx.sqlclient.templates.SqlTemplate) obj),
    SqlTemplate::getDelegate
  );

  private final io.vertx.sqlclient.templates.SqlTemplate<I,R> delegate;
  public final TypeArg<I> __typeArg_0;
  public final TypeArg<R> __typeArg_1;
  
  public SqlTemplate(io.vertx.sqlclient.templates.SqlTemplate delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public SqlTemplate(Object delegate, TypeArg<I> typeArg_0, TypeArg<R> typeArg_1) {
    this.delegate = (io.vertx.sqlclient.templates.SqlTemplate)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  @Override 
  public io.vertx.sqlclient.templates.SqlTemplate getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>(o1 -> io.vertx.reactivex.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.reactivex.sqlclient.Row>(o2 -> io.vertx.reactivex.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.sqlclient.SqlResult<java.lang.Void>> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.sqlclient.SqlResult<java.lang.Void>>(o1 -> io.vertx.reactivex.sqlclient.SqlResult.newInstance((io.vertx.sqlclient.SqlResult)o1, TypeArg.unknown()), o1 -> o1.getDelegate());

  /**
   * Create an SQL template for query purpose consuming map parameters and returning .
   * @param client the wrapped SQL client
   * @param template the template query string
   * @return the template
   */
  public static io.vertx.reactivex.sqlclient.templates.SqlTemplate<java.util.Map<java.lang.String,java.lang.Object>,io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> forQuery(io.vertx.reactivex.sqlclient.SqlClient client, java.lang.String template) { 
    io.vertx.reactivex.sqlclient.templates.SqlTemplate<java.util.Map<java.lang.String,java.lang.Object>,io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> ret = io.vertx.reactivex.sqlclient.templates.SqlTemplate.newInstance((io.vertx.sqlclient.templates.SqlTemplate)io.vertx.sqlclient.templates.SqlTemplate.forQuery(client.getDelegate(), template), TypeArg.unknown(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Create an SQL template for query purpose consuming map parameters and returning void.
   * @param client the wrapped SQL client
   * @param template the template update string
   * @return the template
   */
  public static io.vertx.reactivex.sqlclient.templates.SqlTemplate<java.util.Map<java.lang.String,java.lang.Object>,io.vertx.reactivex.sqlclient.SqlResult<java.lang.Void>> forUpdate(io.vertx.reactivex.sqlclient.SqlClient client, java.lang.String template) { 
    io.vertx.reactivex.sqlclient.templates.SqlTemplate<java.util.Map<java.lang.String,java.lang.Object>,io.vertx.reactivex.sqlclient.SqlResult<java.lang.Void>> ret = io.vertx.reactivex.sqlclient.templates.SqlTemplate.newInstance((io.vertx.sqlclient.templates.SqlTemplate)io.vertx.sqlclient.templates.SqlTemplate.forUpdate(client.getDelegate(), template), TypeArg.unknown(), TYPE_ARG_1);
    return ret;
  }

  /**
   * Set a parameters user defined mapping function.
   *
   * <p> At query execution, the <code>mapper</code> is called to map the parameters object
   * to a <code>Tuple</code> that configures the prepared query.
   * @param mapper the mapping function
   * @return a new template
   */
  public <T> io.vertx.reactivex.sqlclient.templates.SqlTemplate<T,R> mapFrom(io.vertx.reactivex.sqlclient.templates.TupleMapper<T> mapper) { 
    io.vertx.reactivex.sqlclient.templates.SqlTemplate<T,R> ret = io.vertx.reactivex.sqlclient.templates.SqlTemplate.newInstance((io.vertx.sqlclient.templates.SqlTemplate)delegate.mapFrom(mapper.getDelegate()), mapper.__typeArg_0, __typeArg_1);
    return ret;
  }

  /**
   * Set a parameters user defined class mapping.
   *
   * <p> At query execution, the parameters object is is mapped to a <code>Map<String, Object></code> that
   * configures the prepared query.
   *
   * <p> This feature relies on {@link io.vertx.core.json.JsonObject} feature. This likely requires
   * to use Jackson databind in the project.
   * @param type the mapping type
   * @return a new template
   */
  public <T> io.vertx.reactivex.sqlclient.templates.SqlTemplate<T,R> mapFrom(java.lang.Class<T> type) { 
    io.vertx.reactivex.sqlclient.templates.SqlTemplate<T,R> ret = io.vertx.reactivex.sqlclient.templates.SqlTemplate.newInstance((io.vertx.sqlclient.templates.SqlTemplate)delegate.mapFrom(io.vertx.lang.reactivex.Helper.unwrap(type)), TypeArg.of(type), __typeArg_1);
    return ret;
  }

  /**
   * Set a row user defined mapping function.
   *
   * <p> When the query execution completes, the <code>mapper</code> function is called to map the resulting
   * rows to objects.
   * @param mapper the mapping function
   * @return a new template
   */
  public <U> io.vertx.reactivex.sqlclient.templates.SqlTemplate<I,io.vertx.reactivex.sqlclient.RowSet<U>> mapTo(io.vertx.reactivex.sqlclient.templates.RowMapper<U> mapper) { 
    io.vertx.reactivex.sqlclient.templates.SqlTemplate<I,io.vertx.reactivex.sqlclient.RowSet<U>> ret = io.vertx.reactivex.sqlclient.templates.SqlTemplate.newInstance((io.vertx.sqlclient.templates.SqlTemplate)delegate.mapTo(mapper.getDelegate()), __typeArg_0, new TypeArg<io.vertx.reactivex.sqlclient.RowSet<U>>(o0 -> io.vertx.reactivex.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o0, mapper.__typeArg_0), o0 -> o0.getDelegate()));
    return ret;
  }

  /**
   * Set a row user defined mapping function.
   *
   * <p> When the query execution completes, resulting rows are mapped to <code>type</code> instances.
   *
   * <p> This feature relies on {@link io.vertx.core.json.JsonObject} feature. This likely requires
   * to use Jackson databind in the project.
   * @param type the mapping type
   * @return a new template
   */
  public <U> io.vertx.reactivex.sqlclient.templates.SqlTemplate<I,io.vertx.reactivex.sqlclient.RowSet<U>> mapTo(java.lang.Class<U> type) { 
    io.vertx.reactivex.sqlclient.templates.SqlTemplate<I,io.vertx.reactivex.sqlclient.RowSet<U>> ret = io.vertx.reactivex.sqlclient.templates.SqlTemplate.newInstance((io.vertx.sqlclient.templates.SqlTemplate)delegate.mapTo(io.vertx.lang.reactivex.Helper.unwrap(type)), __typeArg_0, new TypeArg<io.vertx.reactivex.sqlclient.RowSet<U>>(o0 -> io.vertx.reactivex.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o0, TypeArg.of(type)), o0 -> o0.getDelegate()));
    return ret;
  }

  /**
   * Execute the query with the <code>parameters</code>
   * @param params the query parameters
   * @return a future notified with the result
   */
  public io.vertx.core.Future<R> execute(I params) { 
    io.vertx.core.Future<R> ret = delegate.execute(__typeArg_0.<I>unwrap(params)).map(val -> (R)__typeArg_1.wrap(val));
    return ret;
  }

  /**
   * Execute the query with the <code>parameters</code>
   * @param params the query parameters
   * @return a future notified with the result
   */
  public io.reactivex.Single<R> rxExecute(I params) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.execute(params).onComplete($handler);
    });
  }

  /**
   * Execute a batch query with the <code>batch</code>.
   *
   * <p>Each item in the batch is mapped to a tuple.
   * @param batch the batch
   * @return a future notified with the result
   */
  public io.vertx.core.Future<R> executeBatch(java.util.List<I> batch) { 
    io.vertx.core.Future<R> ret = delegate.executeBatch(batch.stream().map(elt -> __typeArg_0.<I>unwrap(elt)).collect(Collectors.toList())).map(val -> (R)__typeArg_1.wrap(val));
    return ret;
  }

  /**
   * Execute a batch query with the <code>batch</code>.
   *
   * <p>Each item in the batch is mapped to a tuple.
   * @param batch the batch
   * @return a future notified with the result
   */
  public io.reactivex.Single<R> rxExecuteBatch(java.util.List<I> batch) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.executeBatch(batch).onComplete($handler);
    });
  }

  public static <I,R> SqlTemplate<I,R> newInstance(io.vertx.sqlclient.templates.SqlTemplate arg) {
    return arg != null ? new SqlTemplate<I,R>(arg) : null;
  }

  public static <I,R> SqlTemplate<I,R> newInstance(io.vertx.sqlclient.templates.SqlTemplate arg, TypeArg<I> __typeArg_I, TypeArg<R> __typeArg_R) {
    return arg != null ? new SqlTemplate<I,R>(arg, __typeArg_I, __typeArg_R) : null;
  }

}
