/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A transaction.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Transaction original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.Transaction.class)
public class Transaction implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Transaction that = (Transaction) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Transaction> __TYPE_ARG = new TypeArg<>(    obj -> new Transaction((io.vertx.sqlclient.Transaction) obj),
    Transaction::getDelegate
  );

  private final io.vertx.sqlclient.Transaction delegate;
  
  public Transaction(io.vertx.sqlclient.Transaction delegate) {
    this.delegate = delegate;
  }

  public Transaction(Object delegate) {
    this.delegate = (io.vertx.sqlclient.Transaction)delegate;
  }

  @Override 
  public io.vertx.sqlclient.Transaction getDelegate() {
    return delegate;
  }


  /**
   * Commit the current transaction.
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> commit() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.commit().map(val -> val);
    return ret;
  }

  /**
   * Commit the current transaction.
   * @return 
   */
  public io.reactivex.Completable rxCommit() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.commit().onComplete($handler);
    });
  }

  /**
   * Rollback the transaction and release the associated resources.
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> rollback() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.rollback().map(val -> val);
    return ret;
  }

  /**
   * Rollback the transaction and release the associated resources.
   * @return 
   */
  public io.reactivex.Completable rxRollback() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.rollback().onComplete($handler);
    });
  }

  /**
   * Return the transaction completion <code>Future</code> that
   * succeeds when the transaction commits and
   * fails with {@link io.vertx.sqlclient.TransactionRollbackException} when the transaction rolls back.
   * @return the transaction result
   */
  public io.vertx.core.Future<java.lang.Void> completion() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.completion().map(val -> val);
    return ret;
  }

  /**
   * Return the transaction completion <code>Future</code> that
   * succeeds when the transaction commits and
   * fails with {@link io.vertx.sqlclient.TransactionRollbackException} when the transaction rolls back.
   * @return the transaction result
   */
  public io.reactivex.Completable rxCompletion() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.completion().onComplete($handler);
    });
  }

  public static Transaction newInstance(io.vertx.sqlclient.Transaction arg) {
    return arg != null ? new Transaction(arg) : null;
  }

}
