/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A connection to the database server.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.SqlConnection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.SqlConnection.class)
public class SqlConnection extends io.vertx.reactivex.sqlclient.SqlClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlConnection that = (SqlConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SqlConnection> __TYPE_ARG = new TypeArg<>(    obj -> new SqlConnection((io.vertx.sqlclient.SqlConnection) obj),
    SqlConnection::getDelegate
  );

  private final io.vertx.sqlclient.SqlConnection delegate;
  
  public SqlConnection(io.vertx.sqlclient.SqlConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public SqlConnection(Object delegate) {
    super((io.vertx.sqlclient.SqlConnection)delegate);
    this.delegate = (io.vertx.sqlclient.SqlConnection)delegate;
  }

  @Override 
  public io.vertx.sqlclient.SqlConnection getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.sqlclient.PreparedStatement> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.sqlclient.PreparedStatement>(o1 -> io.vertx.reactivex.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.sqlclient.PreparedStatement> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.sqlclient.PreparedStatement>(o1 -> io.vertx.reactivex.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.sqlclient.Transaction> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.sqlclient.Transaction>(o1 -> io.vertx.reactivex.sqlclient.Transaction.newInstance((io.vertx.sqlclient.Transaction)o1), o1 -> o1.getDelegate());

  /**
   * Create a prepared statement using the given <code>sql</code> string.
   * @param sql the sql
   * @return a future notified with the prepared statement
   */
  public io.vertx.core.Future<io.vertx.reactivex.sqlclient.PreparedStatement> prepare(java.lang.String sql) { 
    io.vertx.core.Future<io.vertx.reactivex.sqlclient.PreparedStatement> ret = delegate.prepare(sql).map(val -> io.vertx.reactivex.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)val));
    return ret;
  }

  /**
   * Create a prepared statement using the given <code>sql</code> string.
   * @param sql the sql
   * @return a future notified with the prepared statement
   */
  public io.reactivex.Single<io.vertx.reactivex.sqlclient.PreparedStatement> rxPrepare(java.lang.String sql) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.prepare(sql).onComplete($handler);
    });
  }

  /**
   * Create a prepared statement using the given <code>sql</code> string.
   * @param sql the sql
   * @param options 
   * @return a future notified with the prepared statement
   */
  public io.vertx.core.Future<io.vertx.reactivex.sqlclient.PreparedStatement> prepare(java.lang.String sql, io.vertx.sqlclient.PrepareOptions options) { 
    io.vertx.core.Future<io.vertx.reactivex.sqlclient.PreparedStatement> ret = delegate.prepare(sql, options).map(val -> io.vertx.reactivex.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)val));
    return ret;
  }

  /**
   * Create a prepared statement using the given <code>sql</code> string.
   * @param sql the sql
   * @param options 
   * @return a future notified with the prepared statement
   */
  public io.reactivex.Single<io.vertx.reactivex.sqlclient.PreparedStatement> rxPrepare(java.lang.String sql, io.vertx.sqlclient.PrepareOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.prepare(sql, options).onComplete($handler);
    });
  }

  /**
   * Set an handler called with connection errors.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.SqlConnection exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Set an handler called when the connection is closed.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.SqlConnection closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Begin a transaction and returns a {@link io.vertx.reactivex.sqlclient.Transaction} for controlling and tracking
   * this transaction.
   * <p/>
   * When the connection is explicitely closed, any inflight transaction is rollbacked.
   * @return a future notified with the transactino
   */
  public io.vertx.core.Future<io.vertx.reactivex.sqlclient.Transaction> begin() { 
    io.vertx.core.Future<io.vertx.reactivex.sqlclient.Transaction> ret = delegate.begin().map(val -> io.vertx.reactivex.sqlclient.Transaction.newInstance((io.vertx.sqlclient.Transaction)val));
    return ret;
  }

  /**
   * Begin a transaction and returns a {@link io.vertx.reactivex.sqlclient.Transaction} for controlling and tracking
   * this transaction.
   * <p/>
   * When the connection is explicitely closed, any inflight transaction is rollbacked.
   * @return a future notified with the transactino
   */
  public io.reactivex.Single<io.vertx.reactivex.sqlclient.Transaction> rxBegin() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.begin().onComplete($handler);
    });
  }

  /**
   * @return the current transaction if it exists, otherwise null
   */
  public io.vertx.reactivex.sqlclient.Transaction transaction() { 
    io.vertx.reactivex.sqlclient.Transaction ret = io.vertx.reactivex.sqlclient.Transaction.newInstance((io.vertx.sqlclient.Transaction)delegate.transaction());
    return ret;
  }

  /**
   * @return whether the connection uses SSL
   */
  public boolean isSSL() { 
    boolean ret = delegate.isSSL();
    return ret;
  }

  /**
   * @return The static metadata about the backend database server for this connection
   */
  public io.vertx.reactivex.sqlclient.spi.DatabaseMetadata databaseMetadata() { 
    io.vertx.reactivex.sqlclient.spi.DatabaseMetadata ret = io.vertx.reactivex.sqlclient.spi.DatabaseMetadata.newInstance((io.vertx.sqlclient.spi.DatabaseMetadata)delegate.databaseMetadata());
    return ret;
  }

  public static SqlConnection newInstance(io.vertx.sqlclient.SqlConnection arg) {
    return arg != null ? new SqlConnection(arg) : null;
  }

}
