/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A cursor that reads progressively rows from the database, it is useful for reading very large result sets.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Cursor original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.Cursor.class)
public class Cursor implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Cursor that = (Cursor) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Cursor> __TYPE_ARG = new TypeArg<>(    obj -> new Cursor((io.vertx.sqlclient.Cursor) obj),
    Cursor::getDelegate
  );

  private final io.vertx.sqlclient.Cursor delegate;
  
  public Cursor(io.vertx.sqlclient.Cursor delegate) {
    this.delegate = delegate;
  }

  public Cursor(Object delegate) {
    this.delegate = (io.vertx.sqlclient.Cursor)delegate;
  }

  @Override 
  public io.vertx.sqlclient.Cursor getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>(o1 -> io.vertx.reactivex.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.reactivex.sqlclient.Row>(o2 -> io.vertx.reactivex.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());

  /**
   * Read rows from the cursor, the result is provided asynchronously to the <code>handler</code>.
   * @param count the amount of rows to read
   * @return a future notified with the result
   */
  public io.vertx.core.Future<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> read(int count) { 
    io.vertx.core.Future<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> ret = delegate.read(count).map(val -> io.vertx.reactivex.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)val, new TypeArg<io.vertx.reactivex.sqlclient.Row>(o0 -> io.vertx.reactivex.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o0), o0 -> o0.getDelegate())));
    return ret;
  }

  /**
   * Read rows from the cursor, the result is provided asynchronously to the <code>handler</code>.
   * @param count the amount of rows to read
   * @return a future notified with the result
   */
  public io.reactivex.Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxRead(int count) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.read(count).onComplete($handler);
    });
  }

  /**
   * Returns <code>true</code> when the cursor has results in progress and the {@link io.vertx.reactivex.sqlclient.Cursor#read} should be called to retrieve
   * them.
   * @return whether the cursor has more results,
   */
  public boolean hasMore() { 
    boolean ret = delegate.hasMore();
    return ret;
  }

  /**
   * Release the cursor.
   * <p/>
   * It should be called for prepared queries executed with a fetch size.
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Release the cursor.
   * <p/>
   * It should be called for prepared queries executed with a fetch size.
   * @return 
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * @return whether the cursor is closed
   */
  public boolean isClosed() { 
    boolean ret = delegate.isClosed();
    return ret;
  }

  public static Cursor newInstance(io.vertx.sqlclient.Cursor arg) {
    return arg != null ? new Cursor(arg) : null;
  }

}
