/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.servicediscovery.types;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.types.MongoDataSource original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.servicediscovery.types.MongoDataSource.class)
public class MongoDataSource implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoDataSource that = (MongoDataSource) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MongoDataSource> __TYPE_ARG = new TypeArg<>(    obj -> new MongoDataSource((io.vertx.servicediscovery.types.MongoDataSource) obj),
    MongoDataSource::getDelegate
  );

  private final io.vertx.servicediscovery.types.MongoDataSource delegate;
  
  public MongoDataSource(io.vertx.servicediscovery.types.MongoDataSource delegate) {
    this.delegate = delegate;
  }

  public MongoDataSource(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.types.MongoDataSource)delegate;
  }

  @Override 
  public io.vertx.servicediscovery.types.MongoDataSource getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.ext.mongo.MongoClient> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.ext.mongo.MongoClient>(o1 -> io.vertx.reactivex.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.ext.mongo.MongoClient> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.ext.mongo.MongoClient>(o1 -> io.vertx.reactivex.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.ext.mongo.MongoClient> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.ext.mongo.MongoClient>(o1 -> io.vertx.reactivex.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)o1), o1 -> o1.getDelegate());

  /**
   * Convenient method to create a record for a Mongo data source.
   * @param name the service name
   * @param location the location of the service (e.g. url, port...)
   * @param metadata additional metadata
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(java.lang.String name, io.vertx.core.json.JsonObject location, io.vertx.core.json.JsonObject metadata) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.MongoDataSource.createRecord(name, location, metadata);
    return ret;
  }

  /**
   * Convenient method that looks for a Mongo datasource source and provides the configured {@link io.vertx.reactivex.ext.mongo.MongoClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return a future notified with the client
   */
  public static io.vertx.core.Future<io.vertx.reactivex.ext.mongo.MongoClient> getMongoClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter) { 
    io.vertx.core.Future<io.vertx.reactivex.ext.mongo.MongoClient> ret = io.vertx.servicediscovery.types.MongoDataSource.getMongoClient(discovery.getDelegate(), filter).map(val -> io.vertx.reactivex.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)val));
    return ret;
  }

  /**
   * Convenient method that looks for a Mongo datasource source and provides the configured {@link io.vertx.reactivex.ext.mongo.MongoClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return a future notified with the client
   */
  public static io.reactivex.Single<io.vertx.reactivex.ext.mongo.MongoClient> rxGetMongoClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter) { 
    return AsyncResultSingle.toSingle($handler -> {
      io.vertx.reactivex.servicediscovery.types.MongoDataSource.getMongoClient(discovery, filter).onComplete($handler);
    });
  }

  /**
   * Convenient method that looks for a Mongo datasource source and provides the configured
   * {@link io.vertx.reactivex.ext.mongo.MongoClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @return a future notified with the client
   */
  public static io.vertx.core.Future<io.vertx.reactivex.ext.mongo.MongoClient> getMongoClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter) { 
    io.vertx.core.Future<io.vertx.reactivex.ext.mongo.MongoClient> ret = io.vertx.servicediscovery.types.MongoDataSource.getMongoClient(discovery.getDelegate(), filter).map(val -> io.vertx.reactivex.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)val));
    return ret;
  }

  /**
   * Convenient method that looks for a Mongo datasource source and provides the configured
   * {@link io.vertx.reactivex.ext.mongo.MongoClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @return a future notified with the client
   */
  public static io.reactivex.Single<io.vertx.reactivex.ext.mongo.MongoClient> rxGetMongoClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter) { 
    return AsyncResultSingle.toSingle($handler -> {
      io.vertx.reactivex.servicediscovery.types.MongoDataSource.getMongoClient(discovery, filter).onComplete($handler);
    });
  }

  /**
   * Convenient method that looks for a Mongo datasource source and provides the configured {@link io.vertx.reactivex.ext.mongo.MongoClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration the consumer configuration
   * @return a future notified with the client
   */
  public static io.vertx.core.Future<io.vertx.reactivex.ext.mongo.MongoClient> getMongoClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter, io.vertx.core.json.JsonObject consumerConfiguration) { 
    io.vertx.core.Future<io.vertx.reactivex.ext.mongo.MongoClient> ret = io.vertx.servicediscovery.types.MongoDataSource.getMongoClient(discovery.getDelegate(), filter, consumerConfiguration).map(val -> io.vertx.reactivex.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)val));
    return ret;
  }

  /**
   * Convenient method that looks for a Mongo datasource source and provides the configured {@link io.vertx.reactivex.ext.mongo.MongoClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration the consumer configuration
   * @return a future notified with the client
   */
  public static io.reactivex.Single<io.vertx.reactivex.ext.mongo.MongoClient> rxGetMongoClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter, io.vertx.core.json.JsonObject consumerConfiguration) { 
    return AsyncResultSingle.toSingle($handler -> {
      io.vertx.reactivex.servicediscovery.types.MongoDataSource.getMongoClient(discovery, filter, consumerConfiguration).onComplete($handler);
    });
  }

  /**
   * Unknown type.
   */
  public static final java.lang.String UNKNOWN = io.vertx.servicediscovery.types.MongoDataSource.UNKNOWN;
  public static final java.lang.String TYPE = io.vertx.servicediscovery.types.MongoDataSource.TYPE;
  public static MongoDataSource newInstance(io.vertx.servicediscovery.types.MongoDataSource arg) {
    return arg != null ? new MongoDataSource(arg) : null;
  }

}
