/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.servicediscovery;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Service Discovery main entry point.
 * <p>
 * The service discovery is an infrastructure that let you publish and find `services`. A `service` is a discoverable
 * functionality. It can be qualified by its type, metadata, and location. So a `service` can be a database, a
 * service proxy, a HTTP endpoint. It does not have to be a vert.x entity, but can be anything. Each service is
 * described by a {@link io.vertx.servicediscovery.Record}.
 * <p>
 * The service discovery implements the interactions defined in the service-oriented computing. And to some extend,
 * also provides the dynamic service-oriented computing interaction. So, application can react to arrival and
 * departure of services.
 * <p>
 * A service provider can:
 * <p>
 * * publish a service record
 * * un-publish a published record
 * * update the status of a published service (down, out of service...)
 * <p>
 * A service consumer can:
 * <p>
 * * lookup for services
 * * bind to a selected service (it gets a {@link io.vertx.reactivex.servicediscovery.ServiceReference}) and use it
 * * release the service once the consumer is done with it
 * * listen for arrival, departure and modification of services.
 * <p>
 * Consumer would 1) lookup for service record matching their need, 2) retrieve the {@link io.vertx.reactivex.servicediscovery.ServiceReference} that give access
 * to the service, 3) get a service object to access the service, 4) release the service object once done.
 * <p>
 * A state above, the central piece of information shared by the providers and consumers are {@link io.vertx.servicediscovery.Record}.
 * <p>
 * Providers and consumers must create their own {@link io.vertx.reactivex.servicediscovery.ServiceDiscovery} instance. These instances are collaborating
 * in background (distributed structure) to keep the set of services in sync.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.ServiceDiscovery original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.servicediscovery.ServiceDiscovery.class)
public class ServiceDiscovery implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceDiscovery that = (ServiceDiscovery) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ServiceDiscovery> __TYPE_ARG = new TypeArg<>(    obj -> new ServiceDiscovery((io.vertx.servicediscovery.ServiceDiscovery) obj),
    ServiceDiscovery::getDelegate
  );

  private final io.vertx.servicediscovery.ServiceDiscovery delegate;
  
  public ServiceDiscovery(io.vertx.servicediscovery.ServiceDiscovery delegate) {
    this.delegate = delegate;
  }

  public ServiceDiscovery(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.ServiceDiscovery)delegate;
  }

  @Override 
  public io.vertx.servicediscovery.ServiceDiscovery getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.servicediscovery.ServiceReference> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.servicediscovery.ServiceReference>(o1 -> io.vertx.reactivex.servicediscovery.ServiceReference.newInstance((io.vertx.servicediscovery.ServiceReference)o1), o1 -> o1.getDelegate());

  /**
   * Creates an instance of {@link io.vertx.reactivex.servicediscovery.ServiceDiscovery}.
   * @param vertx the vert.x instance
   * @param options the discovery options
   * @return the created service discovery instance.
   */
  public static io.vertx.reactivex.servicediscovery.ServiceDiscovery create(io.vertx.reactivex.core.Vertx vertx, io.vertx.servicediscovery.ServiceDiscoveryOptions options) { 
    io.vertx.reactivex.servicediscovery.ServiceDiscovery ret = io.vertx.reactivex.servicediscovery.ServiceDiscovery.newInstance((io.vertx.servicediscovery.ServiceDiscovery)io.vertx.servicediscovery.ServiceDiscovery.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Creates a new instance of {@link io.vertx.reactivex.servicediscovery.ServiceDiscovery} using the default configuration.
   * @param vertx the vert.x instance
   * @return the created instance
   */
  public static io.vertx.reactivex.servicediscovery.ServiceDiscovery create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.servicediscovery.ServiceDiscovery ret = io.vertx.reactivex.servicediscovery.ServiceDiscovery.newInstance((io.vertx.servicediscovery.ServiceDiscovery)io.vertx.servicediscovery.ServiceDiscovery.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Gets a service reference from the given record.
   * @param record the chosen record
   * @return the service reference, that allows retrieving the service object. Once called the service reference is cached, and need to be released.
   */
  public io.vertx.reactivex.servicediscovery.ServiceReference getReference(io.vertx.servicediscovery.Record record) { 
    io.vertx.reactivex.servicediscovery.ServiceReference ret = io.vertx.reactivex.servicediscovery.ServiceReference.newInstance((io.vertx.servicediscovery.ServiceReference)delegate.getReference(record));
    return ret;
  }

  /**
   * Gets a service reference from the given record, the reference is configured with the given json object.
   * @param record the chosen record
   * @param configuration the configuration
   * @return the service reference, that allows retrieving the service object. Once called the service reference is cached, and need to be released.
   */
  public io.vertx.reactivex.servicediscovery.ServiceReference getReferenceWithConfiguration(io.vertx.servicediscovery.Record record, io.vertx.core.json.JsonObject configuration) { 
    io.vertx.reactivex.servicediscovery.ServiceReference ret = io.vertx.reactivex.servicediscovery.ServiceReference.newInstance((io.vertx.servicediscovery.ServiceReference)delegate.getReferenceWithConfiguration(record, configuration));
    return ret;
  }

  /**
   * Releases the service reference.
   * @param reference the reference to release, must not be <code>null</code>
   * @return whether or not the reference has been released.
   */
  public boolean release(io.vertx.reactivex.servicediscovery.ServiceReference reference) { 
    boolean ret = delegate.release(reference.getDelegate());
    return ret;
  }

  /**
   * Registers a discovery service importer. Importers let you integrate other discovery technologies in this service
   * discovery.
   * @param importer the service importer
   * @param configuration the optional configuration
   * @return a future notified when the importer has finished its initialization and initial imports
   */
  public io.vertx.core.Future<java.lang.Void> registerServiceImporter(io.vertx.reactivex.servicediscovery.spi.ServiceImporter importer, io.vertx.core.json.JsonObject configuration) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.registerServiceImporter(importer.getDelegate(), configuration).map(val -> val);
    return ret;
  }

  /**
   * Registers a discovery service importer. Importers let you integrate other discovery technologies in this service
   * discovery.
   * @param importer the service importer
   * @param configuration the optional configuration
   * @return a future notified when the importer has finished its initialization and initial imports
   */
  public io.reactivex.Completable rxRegisterServiceImporter(io.vertx.reactivex.servicediscovery.spi.ServiceImporter importer, io.vertx.core.json.JsonObject configuration) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.registerServiceImporter(importer, configuration).onComplete($handler);
    });
  }

  /**
   * Registers a discovery bridge. Exporters let you integrate other discovery technologies in this service
   * discovery.
   * @param exporter the service exporter
   * @param configuration the optional configuration
   * @return a future notified when the exporter has been correctly initialized.
   */
  public io.vertx.core.Future<java.lang.Void> registerServiceExporter(io.vertx.reactivex.servicediscovery.spi.ServiceExporter exporter, io.vertx.core.json.JsonObject configuration) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.registerServiceExporter(exporter.getDelegate(), configuration).map(val -> val);
    return ret;
  }

  /**
   * Registers a discovery bridge. Exporters let you integrate other discovery technologies in this service
   * discovery.
   * @param exporter the service exporter
   * @param configuration the optional configuration
   * @return a future notified when the exporter has been correctly initialized.
   */
  public io.reactivex.Completable rxRegisterServiceExporter(io.vertx.reactivex.servicediscovery.spi.ServiceExporter exporter, io.vertx.core.json.JsonObject configuration) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.registerServiceExporter(exporter, configuration).onComplete($handler);
    });
  }

  /**
   * Closes the service discovery
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Publishes a record.
   * @param record the record
   * @return a future notified when the operation has completed (successfully or not). In case of success, the passed record has a registration id required to modify and un-register the service.
   */
  public io.vertx.core.Future<io.vertx.servicediscovery.Record> publish(io.vertx.servicediscovery.Record record) { 
    io.vertx.core.Future<io.vertx.servicediscovery.Record> ret = delegate.publish(record).map(val -> val);
    return ret;
  }

  /**
   * Publishes a record.
   * @param record the record
   * @return a future notified when the operation has completed (successfully or not). In case of success, the passed record has a registration id required to modify and un-register the service.
   */
  public io.reactivex.Single<io.vertx.servicediscovery.Record> rxPublish(io.vertx.servicediscovery.Record record) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.publish(record).onComplete($handler);
    });
  }

  /**
   * Un-publishes a record.
   * @param id the registration id
   * @return a future notified when the operation has completed (successfully or not).
   */
  public io.vertx.core.Future<java.lang.Void> unpublish(java.lang.String id) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.unpublish(id).map(val -> val);
    return ret;
  }

  /**
   * Un-publishes a record.
   * @param id the registration id
   * @return a future notified when the operation has completed (successfully or not).
   */
  public io.reactivex.Completable rxUnpublish(java.lang.String id) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.unpublish(id).onComplete($handler);
    });
  }

  /**
   * Lookups for a single record.
   * <p>
   * Filters are expressed using a Json object. Each entry of the given filter will be checked against the record.
   * All entry must match exactly the record. The entry can use the special "*" value to denotes a requirement on the
   * key, but not on the value.
   * <p>
   * Let's take some example:
   * <pre>
   *   { "name" = "a" } => matches records with name set fo "a"
   *   { "color" = "*" } => matches records with "color" set
   *   { "color" = "red" } => only matches records with "color" set to "red"
   *   { "color" = "red", "name" = "a"} => only matches records with name set to "a", and color set to "red"
   * </pre>
   * <p>
   * If the filter is not set (<code>null</code> or empty), it accepts all records.
   * <p>
   * This method returns the first matching record.
   * @param filter the filter.
   * @return a future notified when the lookup has been completed. When there are no matching record, the operation succeeds, but the async result has no result (<code>null</code>).
   */
  public io.vertx.core.Future<io.vertx.servicediscovery.Record> getRecord(io.vertx.core.json.JsonObject filter) { 
    io.vertx.core.Future<io.vertx.servicediscovery.Record> ret = delegate.getRecord(filter).map(val -> val);
    return ret;
  }

  /**
   * Lookups for a single record.
   * <p>
   * Filters are expressed using a Json object. Each entry of the given filter will be checked against the record.
   * All entry must match exactly the record. The entry can use the special "*" value to denotes a requirement on the
   * key, but not on the value.
   * <p>
   * Let's take some example:
   * <pre>
   *   { "name" = "a" } => matches records with name set fo "a"
   *   { "color" = "*" } => matches records with "color" set
   *   { "color" = "red" } => only matches records with "color" set to "red"
   *   { "color" = "red", "name" = "a"} => only matches records with name set to "a", and color set to "red"
   * </pre>
   * <p>
   * If the filter is not set (<code>null</code> or empty), it accepts all records.
   * <p>
   * This method returns the first matching record.
   * @param filter the filter.
   * @return a future notified when the lookup has been completed. When there are no matching record, the operation succeeds, but the async result has no result (<code>null</code>).
   */
  public io.reactivex.Maybe<io.vertx.servicediscovery.Record> rxGetRecord(io.vertx.core.json.JsonObject filter) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.getRecord(filter).onComplete($handler);
    });
  }

  /**
   * Looks up for a single record by its registration <code>id</code>.
   * <p>
   * When there are no matching record, the operation succeeds, but the async result has no result (<code>null</code>).
   * @param id the registration id
   * @return a future notified when the lookup has been completed
   */
  public io.vertx.core.Future<io.vertx.servicediscovery.Record> getRecord(java.lang.String id) { 
    io.vertx.core.Future<io.vertx.servicediscovery.Record> ret = delegate.getRecord(id).map(val -> val);
    return ret;
  }

  /**
   * Looks up for a single record by its registration <code>id</code>.
   * <p>
   * When there are no matching record, the operation succeeds, but the async result has no result (<code>null</code>).
   * @param id the registration id
   * @return a future notified when the lookup has been completed
   */
  public io.reactivex.Maybe<io.vertx.servicediscovery.Record> rxGetRecord(java.lang.String id) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.getRecord(id).onComplete($handler);
    });
  }

  /**
   * Lookups for a single record.
   * <p>
   * The filter is a  taking a {@link io.vertx.servicediscovery.Record} as argument and returning a boolean. You should see it
   * as an <code>accept</code> method of a filter. This method return a record passing the filter.
   * <p>
   * This method only looks for records with a <code>UP</code> status.
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   * @return a future notified when the lookup has been completed. When there are no matching record, the operation succeed, but the async result has no result.
   */
  public io.vertx.core.Future<io.vertx.servicediscovery.Record> getRecord(java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter) { 
    io.vertx.core.Future<io.vertx.servicediscovery.Record> ret = delegate.getRecord(filter).map(val -> val);
    return ret;
  }

  /**
   * Lookups for a single record.
   * <p>
   * The filter is a  taking a {@link io.vertx.servicediscovery.Record} as argument and returning a boolean. You should see it
   * as an <code>accept</code> method of a filter. This method return a record passing the filter.
   * <p>
   * This method only looks for records with a <code>UP</code> status.
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   * @return a future notified when the lookup has been completed. When there are no matching record, the operation succeed, but the async result has no result.
   */
  public io.reactivex.Maybe<io.vertx.servicediscovery.Record> rxGetRecord(java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.getRecord(filter).onComplete($handler);
    });
  }

  /**
   * Lookups for a single record.
   * <p>
   * The filter is a  taking a {@link io.vertx.servicediscovery.Record} as argument and returning a boolean. You should see it
   * as an <code>accept</code> method of a filter. This method return a record passing the filter.
   * <p>
   * Unlike {@link io.vertx.reactivex.servicediscovery.ServiceDiscovery#getRecord}, this method may accept records with a <code>OUT OF SERVICE</code>
   * status, if the <code>includeOutOfService</code> parameter is set to <code>true</code>.
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   * @param includeOutOfService whether or not the filter accepts <code>OUT OF SERVICE</code> records
   * @return a future notified when the lookup has been completed. When there are no matching record, the operation succeed, but the async result has no result.
   */
  public io.vertx.core.Future<io.vertx.servicediscovery.Record> getRecord(java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter, boolean includeOutOfService) { 
    io.vertx.core.Future<io.vertx.servicediscovery.Record> ret = delegate.getRecord(filter, includeOutOfService).map(val -> val);
    return ret;
  }

  /**
   * Lookups for a single record.
   * <p>
   * The filter is a  taking a {@link io.vertx.servicediscovery.Record} as argument and returning a boolean. You should see it
   * as an <code>accept</code> method of a filter. This method return a record passing the filter.
   * <p>
   * Unlike {@link io.vertx.reactivex.servicediscovery.ServiceDiscovery#getRecord}, this method may accept records with a <code>OUT OF SERVICE</code>
   * status, if the <code>includeOutOfService</code> parameter is set to <code>true</code>.
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   * @param includeOutOfService whether or not the filter accepts <code>OUT OF SERVICE</code> records
   * @return a future notified when the lookup has been completed. When there are no matching record, the operation succeed, but the async result has no result.
   */
  public io.reactivex.Maybe<io.vertx.servicediscovery.Record> rxGetRecord(java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter, boolean includeOutOfService) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.getRecord(filter, includeOutOfService).onComplete($handler);
    });
  }

  /**
   * Lookups for a set of records. Unlike {@link io.vertx.reactivex.servicediscovery.ServiceDiscovery#getRecord}, this method returns all matching
   * records.
   * @param filter the filter - see {@link io.vertx.reactivex.servicediscovery.ServiceDiscovery#getRecord}
   * @return a future notified when the lookup has been completed. When there are no matching record, the operation succeed, but the async result has an empty list as result.
   */
  public io.vertx.core.Future<java.util.List<io.vertx.servicediscovery.Record>> getRecords(io.vertx.core.json.JsonObject filter) { 
    io.vertx.core.Future<java.util.List<io.vertx.servicediscovery.Record>> ret = delegate.getRecords(filter).map(val -> val);
    return ret;
  }

  /**
   * Lookups for a set of records. Unlike {@link io.vertx.reactivex.servicediscovery.ServiceDiscovery#getRecord}, this method returns all matching
   * records.
   * @param filter the filter - see {@link io.vertx.reactivex.servicediscovery.ServiceDiscovery#getRecord}
   * @return a future notified when the lookup has been completed. When there are no matching record, the operation succeed, but the async result has an empty list as result.
   */
  public io.reactivex.Single<java.util.List<io.vertx.servicediscovery.Record>> rxGetRecords(io.vertx.core.json.JsonObject filter) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getRecords(filter).onComplete($handler);
    });
  }

  /**
   * Lookups for a set of records. Unlike {@link io.vertx.reactivex.servicediscovery.ServiceDiscovery#getRecord}, this method returns all matching
   * records.
   * <p>
   * The filter is a  taking a {@link io.vertx.servicediscovery.Record} as argument and returning a boolean. You should see it
   * as an <code>accept</code> method of a filter. This method return a record passing the filter.
   * <p>
   * This method only looks for records with a <code>UP</code> status.
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   * @return a future notified when the lookup has been completed. When there are no matching record, the operation succeed, but the async result has an empty list as result.
   */
  public io.vertx.core.Future<java.util.List<io.vertx.servicediscovery.Record>> getRecords(java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter) { 
    io.vertx.core.Future<java.util.List<io.vertx.servicediscovery.Record>> ret = delegate.getRecords(filter).map(val -> val);
    return ret;
  }

  /**
   * Lookups for a set of records. Unlike {@link io.vertx.reactivex.servicediscovery.ServiceDiscovery#getRecord}, this method returns all matching
   * records.
   * <p>
   * The filter is a  taking a {@link io.vertx.servicediscovery.Record} as argument and returning a boolean. You should see it
   * as an <code>accept</code> method of a filter. This method return a record passing the filter.
   * <p>
   * This method only looks for records with a <code>UP</code> status.
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   * @return a future notified when the lookup has been completed. When there are no matching record, the operation succeed, but the async result has an empty list as result.
   */
  public io.reactivex.Single<java.util.List<io.vertx.servicediscovery.Record>> rxGetRecords(java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getRecords(filter).onComplete($handler);
    });
  }

  /**
   * Lookups for a set of records. Unlike {@link io.vertx.reactivex.servicediscovery.ServiceDiscovery#getRecord}, this method returns all matching
   * records.
   * <p>
   * The filter is a  taking a {@link io.vertx.servicediscovery.Record} as argument and returning a boolean. You should see it
   * as an <code>accept</code> method of a filter. This method return a record passing the filter.
   * <p>
   * Unlike {@link io.vertx.reactivex.servicediscovery.ServiceDiscovery#getRecords}, this method may accept records with a <code>OUT OF SERVICE</code>
   * status, if the <code>includeOutOfService</code> parameter is set to <code>true</code>.
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   * @param includeOutOfService whether the filter accepts <code>OUT OF SERVICE</code> records
   * @return a future notified when the lookup has been completed. When there are no matching record, the operation succeed, but the async result has an empty list as result.
   */
  public io.vertx.core.Future<java.util.List<io.vertx.servicediscovery.Record>> getRecords(java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter, boolean includeOutOfService) { 
    io.vertx.core.Future<java.util.List<io.vertx.servicediscovery.Record>> ret = delegate.getRecords(filter, includeOutOfService).map(val -> val);
    return ret;
  }

  /**
   * Lookups for a set of records. Unlike {@link io.vertx.reactivex.servicediscovery.ServiceDiscovery#getRecord}, this method returns all matching
   * records.
   * <p>
   * The filter is a  taking a {@link io.vertx.servicediscovery.Record} as argument and returning a boolean. You should see it
   * as an <code>accept</code> method of a filter. This method return a record passing the filter.
   * <p>
   * Unlike {@link io.vertx.reactivex.servicediscovery.ServiceDiscovery#getRecords}, this method may accept records with a <code>OUT OF SERVICE</code>
   * status, if the <code>includeOutOfService</code> parameter is set to <code>true</code>.
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   * @param includeOutOfService whether the filter accepts <code>OUT OF SERVICE</code> records
   * @return a future notified when the lookup has been completed. When there are no matching record, the operation succeed, but the async result has an empty list as result.
   */
  public io.reactivex.Single<java.util.List<io.vertx.servicediscovery.Record>> rxGetRecords(java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter, boolean includeOutOfService) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getRecords(filter, includeOutOfService).onComplete($handler);
    });
  }

  /**
   * Updates the given record. The record must has been published, and has it's registration id set.
   * @param record the updated record
   * @return a future notified when the lookup has been completed.
   */
  public io.vertx.core.Future<io.vertx.servicediscovery.Record> update(io.vertx.servicediscovery.Record record) { 
    io.vertx.core.Future<io.vertx.servicediscovery.Record> ret = delegate.update(record).map(val -> val);
    return ret;
  }

  /**
   * Updates the given record. The record must has been published, and has it's registration id set.
   * @param record the updated record
   * @return a future notified when the lookup has been completed.
   */
  public io.reactivex.Single<io.vertx.servicediscovery.Record> rxUpdate(io.vertx.servicediscovery.Record record) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.update(record).onComplete($handler);
    });
  }

  /**
   * @return the set of service references retrieved by this service discovery.
   */
  public java.util.Set<io.vertx.reactivex.servicediscovery.ServiceReference> bindings() { 
    java.util.Set<io.vertx.reactivex.servicediscovery.ServiceReference> ret = delegate.bindings().stream().map(elt -> io.vertx.reactivex.servicediscovery.ServiceReference.newInstance((io.vertx.servicediscovery.ServiceReference)elt)).collect(Collectors.toSet());
    return ret;
  }

  /**
   * @return the discovery options. Modifying the returned object would not update the discovery service configuration. This object should be considered as read-only.
   */
  public io.vertx.servicediscovery.ServiceDiscoveryOptions options() { 
    io.vertx.servicediscovery.ServiceDiscoveryOptions ret = delegate.options();
    return ret;
  }

  /**
   * Release the service object retrieved using <code>get</code> methods from the service type interface.
   * It searches for the reference associated with the given object and release it.
   * @param discovery the service discovery
   * @param svcObject the service object
   */
  public static void releaseServiceObject(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, java.lang.Object svcObject) { 
    io.vertx.servicediscovery.ServiceDiscovery.releaseServiceObject(discovery.getDelegate(), svcObject);
  }

  /**
   * Constant for type field of usage events.
   */
  public static final java.lang.String EVENT_TYPE = io.vertx.servicediscovery.ServiceDiscovery.EVENT_TYPE;
  /**
   * Constant for event type `Bind`.
   */
  public static final java.lang.String EVENT_TYPE_BIND = io.vertx.servicediscovery.ServiceDiscovery.EVENT_TYPE_BIND;
  /**
   * Constant for event type `Release`.
   */
  public static final java.lang.String EVENT_TYPE_RELEASE = io.vertx.servicediscovery.ServiceDiscovery.EVENT_TYPE_RELEASE;
  /**
   * Constant for record field of usage events.
   */
  public static final java.lang.String EVENT_RECORD = io.vertx.servicediscovery.ServiceDiscovery.EVENT_RECORD;
  /**
   * Constant for id field of usage events.
   */
  public static final java.lang.String EVENT_ID = io.vertx.servicediscovery.ServiceDiscovery.EVENT_ID;
  public static ServiceDiscovery newInstance(io.vertx.servicediscovery.ServiceDiscovery arg) {
    return arg != null ? new ServiceDiscovery(arg) : null;
  }

}
