/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.redis.client;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Utilities for Redis cluster. Calling <code>create()</code> with an instance of {@link io.vertx.reactivex.redis.client.Redis}
 * or {@link io.vertx.reactivex.redis.client.RedisConnection} that are not Redis cluster client/connection leads to
 * an exception.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.RedisCluster original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.redis.client.RedisCluster.class)
public class RedisCluster implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisCluster that = (RedisCluster) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RedisCluster> __TYPE_ARG = new TypeArg<>(    obj -> new RedisCluster((io.vertx.redis.client.RedisCluster) obj),
    RedisCluster::getDelegate
  );

  private final io.vertx.redis.client.RedisCluster delegate;
  
  public RedisCluster(io.vertx.redis.client.RedisCluster delegate) {
    this.delegate = delegate;
  }

  public RedisCluster(Object delegate) {
    this.delegate = (io.vertx.redis.client.RedisCluster)delegate;
  }

  @Override 
  public io.vertx.redis.client.RedisCluster getDelegate() {
    return delegate;
  }


  public static io.vertx.reactivex.redis.client.RedisCluster create(io.vertx.reactivex.redis.client.Redis client) { 
    io.vertx.reactivex.redis.client.RedisCluster ret = io.vertx.reactivex.redis.client.RedisCluster.newInstance((io.vertx.redis.client.RedisCluster)io.vertx.redis.client.RedisCluster.create(client.getDelegate()));
    return ret;
  }

  public static io.vertx.reactivex.redis.client.RedisCluster create(io.vertx.reactivex.redis.client.RedisConnection connection) { 
    io.vertx.reactivex.redis.client.RedisCluster ret = io.vertx.reactivex.redis.client.RedisCluster.newInstance((io.vertx.redis.client.RedisCluster)io.vertx.redis.client.RedisCluster.create(connection.getDelegate()));
    return ret;
  }

  /**
   * Runs the <code>request</code> against all nodes in the cluster.
   * Returns a future that completes with a list of responses, one from each
   * node, or failure when one of the operations fails. Note that in case
   * of a failure, there are no guarantees that the request was or wasn't
   * executed successfully on other Redis cluster nodes. No result order
   * is guaranteed either.
   * @param request the request, must not be <code>null</code>
   * @return the future result, never <code>null</code>
   */
  public io.vertx.core.Future<java.util.List<io.vertx.redis.client.Response>> onAllNodes(io.vertx.redis.client.Request request) { 
    io.vertx.core.Future<java.util.List<io.vertx.redis.client.Response>> ret = delegate.onAllNodes(request).map(val -> val);
    return ret;
  }

  /**
   * Runs the <code>request</code> against all nodes in the cluster.
   * Returns a future that completes with a list of responses, one from each
   * node, or failure when one of the operations fails. Note that in case
   * of a failure, there are no guarantees that the request was or wasn't
   * executed successfully on other Redis cluster nodes. No result order
   * is guaranteed either.
   * @param request the request, must not be <code>null</code>
   * @return the future result, never <code>null</code>
   */
  public io.reactivex.Single<java.util.List<io.vertx.redis.client.Response>> rxOnAllNodes(io.vertx.redis.client.Request request) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.onAllNodes(request).onComplete($handler);
    });
  }

  /**
   * Runs the <code>request</code> against all <em>master</em> nodes in the cluster.
   * Returns a future that completes with a list of responses, one from each
   * master node, or failure when one of the operations fails. Note that in case
   * of a failure, there are no guarantees that the request was or wasn't
   * executed successfully on other Redis cluster master nodes. No result order
   * is guaranteed either.
   * @param request the request, must not be <code>null</code>
   * @return the future result, never <code>null</code>
   */
  public io.vertx.core.Future<java.util.List<io.vertx.redis.client.Response>> onAllMasterNodes(io.vertx.redis.client.Request request) { 
    io.vertx.core.Future<java.util.List<io.vertx.redis.client.Response>> ret = delegate.onAllMasterNodes(request).map(val -> val);
    return ret;
  }

  /**
   * Runs the <code>request</code> against all <em>master</em> nodes in the cluster.
   * Returns a future that completes with a list of responses, one from each
   * master node, or failure when one of the operations fails. Note that in case
   * of a failure, there are no guarantees that the request was or wasn't
   * executed successfully on other Redis cluster master nodes. No result order
   * is guaranteed either.
   * @param request the request, must not be <code>null</code>
   * @return the future result, never <code>null</code>
   */
  public io.reactivex.Single<java.util.List<io.vertx.redis.client.Response>> rxOnAllMasterNodes(io.vertx.redis.client.Request request) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.onAllMasterNodes(request).onComplete($handler);
    });
  }

  /**
   * Groups the <code>requests</code> into a {@link io.vertx.redis.client.RequestGrouping}, which contains:
   * <ul>
   * <li><em>keyed</em> requests: requests that include a key and it is therefore possible
   * to determine to which master node they should be sent; all requests in each inner list
   * in the <code>keyed</code> collection are guaranteed to be sent to the same <em>master</em> node;</li>
   * <li><em>unkeyed</em> requests: requests that do not include a key and it is therefore
   * <em>not</em> possible to determine to which master node they should be sent.</li>
   * </ul>
   * If any of the <code>requests</code> includes multiple keys that belong to different master nodes,
   * the resulting future will fail.
   * <p>
   * If the cluster client was created with  or 
   * and the commands are executed individually (using ,
   * not ), it is possible that the commands will be spread
   * across different replicas of the same master node.
   * <p>
   * Note that this method is only reliable in case the Redis cluster is in a stable
   * state. In case of resharding, failover or in general any change of cluster topology,
   * there are no guarantees on the validity of the result.
   * @param requests the requests, must not be <code>null</code>
   * @return the requests grouped by the cluster node assignment
   */
  public io.vertx.core.Future<io.vertx.redis.client.RequestGrouping> groupByNodes(java.util.List<io.vertx.redis.client.Request> requests) { 
    io.vertx.core.Future<io.vertx.redis.client.RequestGrouping> ret = delegate.groupByNodes(requests).map(val -> val);
    return ret;
  }

  /**
   * Groups the <code>requests</code> into a {@link io.vertx.redis.client.RequestGrouping}, which contains:
   * <ul>
   * <li><em>keyed</em> requests: requests that include a key and it is therefore possible
   * to determine to which master node they should be sent; all requests in each inner list
   * in the <code>keyed</code> collection are guaranteed to be sent to the same <em>master</em> node;</li>
   * <li><em>unkeyed</em> requests: requests that do not include a key and it is therefore
   * <em>not</em> possible to determine to which master node they should be sent.</li>
   * </ul>
   * If any of the <code>requests</code> includes multiple keys that belong to different master nodes,
   * the resulting future will fail.
   * <p>
   * If the cluster client was created with  or 
   * and the commands are executed individually (using ,
   * not ), it is possible that the commands will be spread
   * across different replicas of the same master node.
   * <p>
   * Note that this method is only reliable in case the Redis cluster is in a stable
   * state. In case of resharding, failover or in general any change of cluster topology,
   * there are no guarantees on the validity of the result.
   * @param requests the requests, must not be <code>null</code>
   * @return the requests grouped by the cluster node assignment
   */
  public io.reactivex.Single<io.vertx.redis.client.RequestGrouping> rxGroupByNodes(java.util.List<io.vertx.redis.client.Request> requests) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.groupByNodes(requests).onComplete($handler);
    });
  }

  public static RedisCluster newInstance(io.vertx.redis.client.RedisCluster arg) {
    return arg != null ? new RedisCluster(arg) : null;
  }

}
