/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.redis.client;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * <b>Auto generated</b> Redis API client wrapper.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.RedisAPI original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.redis.client.RedisAPI.class)
public class RedisAPI implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisAPI that = (RedisAPI) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RedisAPI> __TYPE_ARG = new TypeArg<>(    obj -> new RedisAPI((io.vertx.redis.client.RedisAPI) obj),
    RedisAPI::getDelegate
  );

  private final io.vertx.redis.client.RedisAPI delegate;
  
  public RedisAPI(io.vertx.redis.client.RedisAPI delegate) {
    this.delegate = delegate;
  }

  public RedisAPI(Object delegate) {
    this.delegate = (io.vertx.redis.client.RedisAPI)delegate;
  }

  @Override 
  public io.vertx.redis.client.RedisAPI getDelegate() {
    return delegate;
  }


  public void close() { 
    delegate.close();
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.add/">FT.ADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftAdd(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftAdd(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.add/">FT.ADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftAdd(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aggregate/">FT.AGGREGATE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftAggregate(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftAggregate(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aggregate/">FT.AGGREGATE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtAggregate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftAggregate(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasadd/">FT.ALIASADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftAliasadd(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftAliasadd(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasadd/">FT.ALIASADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtAliasadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftAliasadd(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasdel/">FT.ALIASDEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftAliasdel(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftAliasdel(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasdel/">FT.ALIASDEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtAliasdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftAliasdel(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasupdate/">FT.ALIASUPDATE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftAliasupdate(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftAliasupdate(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasupdate/">FT.ALIASUPDATE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtAliasupdate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftAliasupdate(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.alter/">FT.ALTER</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftAlter(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftAlter(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.alter/">FT.ALTER</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtAlter(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftAlter(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.config/">FT.CONFIG</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftConfig(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftConfig(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.config/">FT.CONFIG</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtConfig(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftConfig(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.create/">FT.CREATE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftCreate(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftCreate(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.create/">FT.CREATE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtCreate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftCreate(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.cursor/">FT.CURSOR</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftCursor(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftCursor(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.cursor/">FT.CURSOR</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtCursor(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftCursor(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.debug/">FT.DEBUG</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftDebug(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftDebug(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.debug/">FT.DEBUG</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftDebug(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.del/">FT.DEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftDel(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftDel(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.del/">FT.DEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftDel(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictadd/">FT.DICTADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftDictadd(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftDictadd(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictadd/">FT.DICTADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtDictadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftDictadd(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictdel/">FT.DICTDEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftDictdel(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftDictdel(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictdel/">FT.DICTDEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtDictdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftDictdel(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictdump/">FT.DICTDUMP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftDictdump(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftDictdump(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictdump/">FT.DICTDUMP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtDictdump(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftDictdump(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.drop/">FT.DROP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftDrop(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftDrop(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.drop/">FT.DROP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtDrop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftDrop(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dropindex/">FT.DROPINDEX</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftDropindex(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftDropindex(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dropindex/">FT.DROPINDEX</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtDropindex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftDropindex(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.explain/">FT.EXPLAIN</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftExplain(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftExplain(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.explain/">FT.EXPLAIN</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtExplain(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftExplain(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.explaincli/">FT.EXPLAINCLI</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftExplaincli(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftExplaincli(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.explaincli/">FT.EXPLAINCLI</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtExplaincli(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftExplaincli(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.get/">FT.GET</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftGet(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftGet(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.get/">FT.GET</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtGet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftGet(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.info/">FT.INFO</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftInfo(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftInfo(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.info/">FT.INFO</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftInfo(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.mget/">FT.MGET</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftMget(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftMget(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.mget/">FT.MGET</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtMget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftMget(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.profile/">FT.PROFILE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftProfile(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftProfile(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.profile/">FT.PROFILE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtProfile(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftProfile(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.safeadd/">FT.SAFEADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftSafeadd(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftSafeadd(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.safeadd/">FT.SAFEADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtSafeadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftSafeadd(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.search/">FT.SEARCH</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftSearch(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftSearch(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.search/">FT.SEARCH</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtSearch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftSearch(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.spellcheck/">FT.SPELLCHECK</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftSpellcheck(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftSpellcheck(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.spellcheck/">FT.SPELLCHECK</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtSpellcheck(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftSpellcheck(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugadd/">FT.SUGADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftSugadd(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftSugadd(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugadd/">FT.SUGADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtSugadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftSugadd(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugdel/">FT.SUGDEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftSugdel(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftSugdel(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugdel/">FT.SUGDEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtSugdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftSugdel(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugget/">FT.SUGGET</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftSugget(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftSugget(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugget/">FT.SUGGET</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtSugget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftSugget(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.suglen/">FT.SUGLEN</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftSuglen(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftSuglen(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.suglen/">FT.SUGLEN</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtSuglen(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftSuglen(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.synadd/">FT.SYNADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftSynadd(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftSynadd(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.synadd/">FT.SYNADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtSynadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftSynadd(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.syndump/">FT.SYNDUMP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftSyndump(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftSyndump(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.syndump/">FT.SYNDUMP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtSyndump(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftSyndump(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.synupdate/">FT.SYNUPDATE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftSynupdate(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftSynupdate(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.synupdate/">FT.SYNUPDATE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtSynupdate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftSynupdate(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.tagvals/">FT.TAGVALS</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftTagvals(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftTagvals(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.tagvals/">FT.TAGVALS</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtTagvals(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftTagvals(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._aliasaddifnx/">FT._ALIASADDIFNX</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftAliasaddifnx(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftAliasaddifnx(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._aliasaddifnx/">FT._ALIASADDIFNX</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtAliasaddifnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftAliasaddifnx(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._aliasdelifx/">FT._ALIASDELIFX</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftAliasdelifx(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftAliasdelifx(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._aliasdelifx/">FT._ALIASDELIFX</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtAliasdelifx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftAliasdelifx(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._alterifnx/">FT._ALTERIFNX</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftAlterifnx(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftAlterifnx(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._alterifnx/">FT._ALTERIFNX</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtAlterifnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftAlterifnx(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._createifnx/">FT._CREATEIFNX</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftCreateifnx(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftCreateifnx(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._createifnx/">FT._CREATEIFNX</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtCreateifnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftCreateifnx(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._dropifx/">FT._DROPIFX</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftDropifx(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftDropifx(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._dropifx/">FT._DROPIFX</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtDropifx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftDropifx(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._dropindexifx/">FT._DROPINDEXIFX</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftDropindexifx(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftDropindexifx(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._dropindexifx/">FT._DROPINDEXIFX</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtDropindexifx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftDropindexifx(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._list/">FT._LIST</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ftList(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ftList(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._list/">FT._LIST</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFtList(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ftList(args).onComplete($handler);
    });
  }

  /**
   * A container for Access List Control commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/acl/">ACL</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> acl(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.acl(args).map(val -> val);
    return ret;
  }

  /**
   * A container for Access List Control commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/acl/">ACL</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxAcl(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.acl(args).onComplete($handler);
    });
  }

  /**
   * Append a value to a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/append/">APPEND</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> append(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.append(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Append a value to a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/append/">APPEND</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxAppend(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.append(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Sent by cluster clients after an -ASK redirect.
   * <p>
   * Redis command <a href="https://redis.io/commands/asking/">ASKING</a>.
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> asking() { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.asking().map(val -> val);
    return ret;
  }

  /**
   * Sent by cluster clients after an -ASK redirect.
   * <p>
   * Redis command <a href="https://redis.io/commands/asking/">ASKING</a>.
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxAsking() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.asking().onComplete($handler);
    });
  }

  /**
   * Authenticate to the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/auth/">AUTH</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> auth(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.auth(args).map(val -> val);
    return ret;
  }

  /**
   * Authenticate to the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/auth/">AUTH</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxAuth(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.auth(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.add/">BF.ADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bfAdd(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bfAdd(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.add/">BF.ADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBfAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bfAdd(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.card/">BF.CARD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bfCard(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bfCard(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.card/">BF.CARD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBfCard(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bfCard(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.debug/">BF.DEBUG</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bfDebug(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bfDebug(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.debug/">BF.DEBUG</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBfDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bfDebug(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.exists/">BF.EXISTS</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bfExists(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bfExists(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.exists/">BF.EXISTS</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBfExists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bfExists(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.info/">BF.INFO</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bfInfo(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bfInfo(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.info/">BF.INFO</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBfInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bfInfo(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.insert/">BF.INSERT</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bfInsert(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bfInsert(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.insert/">BF.INSERT</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBfInsert(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bfInsert(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.loadchunk/">BF.LOADCHUNK</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bfLoadchunk(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bfLoadchunk(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.loadchunk/">BF.LOADCHUNK</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBfLoadchunk(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bfLoadchunk(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.madd/">BF.MADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bfMadd(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bfMadd(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.madd/">BF.MADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBfMadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bfMadd(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.mexists/">BF.MEXISTS</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bfMexists(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bfMexists(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.mexists/">BF.MEXISTS</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBfMexists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bfMexists(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.reserve/">BF.RESERVE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bfReserve(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bfReserve(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.reserve/">BF.RESERVE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBfReserve(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bfReserve(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.scandump/">BF.SCANDUMP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bfScandump(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bfScandump(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.scandump/">BF.SCANDUMP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBfScandump(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bfScandump(args).onComplete($handler);
    });
  }

  /**
   * Asynchronously rewrite the append-only file.
   * <p>
   * Redis command <a href="https://redis.io/commands/bgrewriteaof/">BGREWRITEAOF</a>.
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bgrewriteaof() { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bgrewriteaof().map(val -> val);
    return ret;
  }

  /**
   * Asynchronously rewrite the append-only file.
   * <p>
   * Redis command <a href="https://redis.io/commands/bgrewriteaof/">BGREWRITEAOF</a>.
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBgrewriteaof() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bgrewriteaof().onComplete($handler);
    });
  }

  /**
   * Asynchronously save the dataset to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/bgsave/">BGSAVE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bgsave(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bgsave(args).map(val -> val);
    return ret;
  }

  /**
   * Asynchronously save the dataset to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/bgsave/">BGSAVE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBgsave(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bgsave(args).onComplete($handler);
    });
  }

  /**
   * Count set bits in a string.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitcount/">BITCOUNT</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bitcount(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bitcount(args).map(val -> val);
    return ret;
  }

  /**
   * Count set bits in a string.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitcount/">BITCOUNT</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBitcount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bitcount(args).onComplete($handler);
    });
  }

  /**
   * Perform arbitrary bitfield integer operations on strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitfield/">BITFIELD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bitfield(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bitfield(args).map(val -> val);
    return ret;
  }

  /**
   * Perform arbitrary bitfield integer operations on strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitfield/">BITFIELD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBitfield(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bitfield(args).onComplete($handler);
    });
  }

  /**
   * Perform arbitrary bitfield integer operations on strings. Read-only variant of BITFIELD.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitfield_ro/">BITFIELD_RO</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bitfieldRo(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bitfieldRo(args).map(val -> val);
    return ret;
  }

  /**
   * Perform arbitrary bitfield integer operations on strings. Read-only variant of BITFIELD.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitfield_ro/">BITFIELD_RO</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBitfieldRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bitfieldRo(args).onComplete($handler);
    });
  }

  /**
   * Perform bitwise operations between strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitop/">BITOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bitop(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bitop(args).map(val -> val);
    return ret;
  }

  /**
   * Perform bitwise operations between strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitop/">BITOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBitop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bitop(args).onComplete($handler);
    });
  }

  /**
   * Find first bit set or clear in a string.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitpos/">BITPOS</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bitpos(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bitpos(args).map(val -> val);
    return ret;
  }

  /**
   * Find first bit set or clear in a string.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitpos/">BITPOS</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBitpos(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bitpos(args).onComplete($handler);
    });
  }

  /**
   * Pop an element from a list, push it to another list and return it; or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blmove/">BLMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param arg4 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> blmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.blmove(arg0, arg1, arg2, arg3, arg4).map(val -> val);
    return ret;
  }

  /**
   * Pop an element from a list, push it to another list and return it; or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blmove/">BLMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param arg4 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBlmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.blmove(arg0, arg1, arg2, arg3, arg4).onComplete($handler);
    });
  }

  /**
   * Pop elements from a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blmpop/">BLMPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> blmpop(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.blmpop(args).map(val -> val);
    return ret;
  }

  /**
   * Pop elements from a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blmpop/">BLMPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBlmpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.blmpop(args).onComplete($handler);
    });
  }

  /**
   * Remove and get the first element in a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blpop/">BLPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> blpop(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.blpop(args).map(val -> val);
    return ret;
  }

  /**
   * Remove and get the first element in a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blpop/">BLPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBlpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.blpop(args).onComplete($handler);
    });
  }

  /**
   * Remove and get the last element in a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/brpop/">BRPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> brpop(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.brpop(args).map(val -> val);
    return ret;
  }

  /**
   * Remove and get the last element in a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/brpop/">BRPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBrpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.brpop(args).onComplete($handler);
    });
  }

  /**
   * Pop an element from a list, push it to another list and return it; or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/brpoplpush/">BRPOPLPUSH</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  @Deprecated()
  public io.vertx.core.Future<io.vertx.redis.client.Response> brpoplpush(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.brpoplpush(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Pop an element from a list, push it to another list and return it; or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/brpoplpush/">BRPOPLPUSH</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  @Deprecated()
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBrpoplpush(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.brpoplpush(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Remove and return members with scores in a sorted set or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzmpop/">BZMPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bzmpop(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bzmpop(args).map(val -> val);
    return ret;
  }

  /**
   * Remove and return members with scores in a sorted set or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzmpop/">BZMPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBzmpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bzmpop(args).onComplete($handler);
    });
  }

  /**
   * Remove and return the member with the highest score from one or more sorted sets, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzpopmax/">BZPOPMAX</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bzpopmax(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bzpopmax(args).map(val -> val);
    return ret;
  }

  /**
   * Remove and return the member with the highest score from one or more sorted sets, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzpopmax/">BZPOPMAX</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBzpopmax(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bzpopmax(args).onComplete($handler);
    });
  }

  /**
   * Remove and return the member with the lowest score from one or more sorted sets, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzpopmin/">BZPOPMIN</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> bzpopmin(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.bzpopmin(args).map(val -> val);
    return ret;
  }

  /**
   * Remove and return the member with the lowest score from one or more sorted sets, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzpopmin/">BZPOPMIN</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxBzpopmin(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bzpopmin(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.add/">CF.ADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cfAdd(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cfAdd(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.add/">CF.ADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCfAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cfAdd(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.addnx/">CF.ADDNX</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cfAddnx(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cfAddnx(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.addnx/">CF.ADDNX</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCfAddnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cfAddnx(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.compact/">CF.COMPACT</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cfCompact(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cfCompact(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.compact/">CF.COMPACT</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCfCompact(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cfCompact(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.count/">CF.COUNT</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cfCount(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cfCount(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.count/">CF.COUNT</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCfCount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cfCount(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.debug/">CF.DEBUG</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cfDebug(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cfDebug(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.debug/">CF.DEBUG</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCfDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cfDebug(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.del/">CF.DEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cfDel(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cfDel(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.del/">CF.DEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCfDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cfDel(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.exists/">CF.EXISTS</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cfExists(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cfExists(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.exists/">CF.EXISTS</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCfExists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cfExists(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.info/">CF.INFO</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cfInfo(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cfInfo(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.info/">CF.INFO</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCfInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cfInfo(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insert/">CF.INSERT</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cfInsert(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cfInsert(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insert/">CF.INSERT</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCfInsert(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cfInsert(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insertnx/">CF.INSERTNX</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cfInsertnx(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cfInsertnx(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insertnx/">CF.INSERTNX</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCfInsertnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cfInsertnx(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.loadchunk/">CF.LOADCHUNK</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cfLoadchunk(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cfLoadchunk(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.loadchunk/">CF.LOADCHUNK</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCfLoadchunk(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cfLoadchunk(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.mexists/">CF.MEXISTS</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cfMexists(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cfMexists(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.mexists/">CF.MEXISTS</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCfMexists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cfMexists(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.reserve/">CF.RESERVE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cfReserve(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cfReserve(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.reserve/">CF.RESERVE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCfReserve(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cfReserve(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.scandump/">CF.SCANDUMP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cfScandump(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cfScandump(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.scandump/">CF.SCANDUMP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCfScandump(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cfScandump(args).onComplete($handler);
    });
  }

  /**
   * A container for client connection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/client/">CLIENT</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> client(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.client(args).map(val -> val);
    return ret;
  }

  /**
   * A container for client connection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/client/">CLIENT</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxClient(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.client(args).onComplete($handler);
    });
  }

  /**
   * A container for cluster commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/cluster/">CLUSTER</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cluster(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cluster(args).map(val -> val);
    return ret;
  }

  /**
   * A container for cluster commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/cluster/">CLUSTER</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCluster(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cluster(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.incrby/">CMS.INCRBY</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cmsIncrby(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cmsIncrby(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.incrby/">CMS.INCRBY</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCmsIncrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cmsIncrby(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.info/">CMS.INFO</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cmsInfo(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cmsInfo(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.info/">CMS.INFO</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCmsInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cmsInfo(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbydim/">CMS.INITBYDIM</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cmsInitbydim(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cmsInitbydim(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbydim/">CMS.INITBYDIM</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCmsInitbydim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cmsInitbydim(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbyprob/">CMS.INITBYPROB</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cmsInitbyprob(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cmsInitbyprob(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbyprob/">CMS.INITBYPROB</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCmsInitbyprob(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cmsInitbyprob(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.merge/">CMS.MERGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cmsMerge(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cmsMerge(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.merge/">CMS.MERGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCmsMerge(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cmsMerge(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.query/">CMS.QUERY</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> cmsQuery(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.cmsQuery(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.query/">CMS.QUERY</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCmsQuery(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.cmsQuery(args).onComplete($handler);
    });
  }

  /**
   * Get array of Redis command details.
   * <p>
   * Redis command <a href="https://redis.io/commands/command/">COMMAND</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> command(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.command(args).map(val -> val);
    return ret;
  }

  /**
   * Get array of Redis command details.
   * <p>
   * Redis command <a href="https://redis.io/commands/command/">COMMAND</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCommand(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.command(args).onComplete($handler);
    });
  }

  /**
   * A container for server configuration commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/config/">CONFIG</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> config(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.config(args).map(val -> val);
    return ret;
  }

  /**
   * A container for server configuration commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/config/">CONFIG</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxConfig(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.config(args).onComplete($handler);
    });
  }

  /**
   * Copy a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/copy/">COPY</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> copy(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.copy(args).map(val -> val);
    return ret;
  }

  /**
   * Copy a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/copy/">COPY</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxCopy(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.copy(args).onComplete($handler);
    });
  }

  /**
   * Return the number of keys in the selected database.
   * <p>
   * Redis command <a href="https://redis.io/commands/dbsize/">DBSIZE</a>.
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> dbsize() { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.dbsize().map(val -> val);
    return ret;
  }

  /**
   * Return the number of keys in the selected database.
   * <p>
   * Redis command <a href="https://redis.io/commands/dbsize/">DBSIZE</a>.
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxDbsize() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.dbsize().onComplete($handler);
    });
  }

  /**
   * A container for debugging commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/debug/">DEBUG</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> debug(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.debug(args).map(val -> val);
    return ret;
  }

  /**
   * A container for debugging commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/debug/">DEBUG</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.debug(args).onComplete($handler);
    });
  }

  /**
   * Decrement the integer value of a key by one.
   * <p>
   * Redis command <a href="https://redis.io/commands/decr/">DECR</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> decr(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.decr(arg0).map(val -> val);
    return ret;
  }

  /**
   * Decrement the integer value of a key by one.
   * <p>
   * Redis command <a href="https://redis.io/commands/decr/">DECR</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxDecr(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.decr(arg0).onComplete($handler);
    });
  }

  /**
   * Decrement the integer value of a key by the given number.
   * <p>
   * Redis command <a href="https://redis.io/commands/decrby/">DECRBY</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> decrby(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.decrby(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Decrement the integer value of a key by the given number.
   * <p>
   * Redis command <a href="https://redis.io/commands/decrby/">DECRBY</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxDecrby(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.decrby(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Delete a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/del/">DEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> del(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.del(args).map(val -> val);
    return ret;
  }

  /**
   * Delete a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/del/">DEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.del(args).onComplete($handler);
    });
  }

  /**
   * Discard all commands issued after MULTI.
   * <p>
   * Redis command <a href="https://redis.io/commands/discard/">DISCARD</a>.
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> discard() { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.discard().map(val -> val);
    return ret;
  }

  /**
   * Discard all commands issued after MULTI.
   * <p>
   * Redis command <a href="https://redis.io/commands/discard/">DISCARD</a>.
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxDiscard() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.discard().onComplete($handler);
    });
  }

  /**
   * Return a serialized version of the value stored at the specified key.
   * <p>
   * Redis command <a href="https://redis.io/commands/dump/">DUMP</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> dump(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.dump(arg0).map(val -> val);
    return ret;
  }

  /**
   * Return a serialized version of the value stored at the specified key.
   * <p>
   * Redis command <a href="https://redis.io/commands/dump/">DUMP</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxDump(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.dump(arg0).onComplete($handler);
    });
  }

  /**
   * Echo the given string.
   * <p>
   * Redis command <a href="https://redis.io/commands/echo/">ECHO</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> echo(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.echo(arg0).map(val -> val);
    return ret;
  }

  /**
   * Echo the given string.
   * <p>
   * Redis command <a href="https://redis.io/commands/echo/">ECHO</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxEcho(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.echo(arg0).onComplete($handler);
    });
  }

  /**
   * Execute a Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/eval/">EVAL</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> eval(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.eval(args).map(val -> val);
    return ret;
  }

  /**
   * Execute a Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/eval/">EVAL</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxEval(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.eval(args).onComplete($handler);
    });
  }

  /**
   * Execute a read-only Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/eval_ro/">EVAL_RO</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> evalRo(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.evalRo(args).map(val -> val);
    return ret;
  }

  /**
   * Execute a read-only Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/eval_ro/">EVAL_RO</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxEvalRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.evalRo(args).onComplete($handler);
    });
  }

  /**
   * Execute a Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/evalsha/">EVALSHA</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> evalsha(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.evalsha(args).map(val -> val);
    return ret;
  }

  /**
   * Execute a Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/evalsha/">EVALSHA</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxEvalsha(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.evalsha(args).onComplete($handler);
    });
  }

  /**
   * Execute a read-only Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/evalsha_ro/">EVALSHA_RO</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> evalshaRo(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.evalshaRo(args).map(val -> val);
    return ret;
  }

  /**
   * Execute a read-only Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/evalsha_ro/">EVALSHA_RO</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxEvalshaRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.evalshaRo(args).onComplete($handler);
    });
  }

  /**
   * Execute all commands issued after MULTI.
   * <p>
   * Redis command <a href="https://redis.io/commands/exec/">EXEC</a>.
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> exec() { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.exec().map(val -> val);
    return ret;
  }

  /**
   * Execute all commands issued after MULTI.
   * <p>
   * Redis command <a href="https://redis.io/commands/exec/">EXEC</a>.
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxExec() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.exec().onComplete($handler);
    });
  }

  /**
   * Determine if a key exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/exists/">EXISTS</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> exists(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.exists(args).map(val -> val);
    return ret;
  }

  /**
   * Determine if a key exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/exists/">EXISTS</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxExists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.exists(args).onComplete($handler);
    });
  }

  /**
   * Set a key&#x27;s time to live in seconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/expire/">EXPIRE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> expire(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.expire(args).map(val -> val);
    return ret;
  }

  /**
   * Set a key&#x27;s time to live in seconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/expire/">EXPIRE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxExpire(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.expire(args).onComplete($handler);
    });
  }

  /**
   * Set the expiration for a key as a UNIX timestamp.
   * <p>
   * Redis command <a href="https://redis.io/commands/expireat/">EXPIREAT</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> expireat(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.expireat(args).map(val -> val);
    return ret;
  }

  /**
   * Set the expiration for a key as a UNIX timestamp.
   * <p>
   * Redis command <a href="https://redis.io/commands/expireat/">EXPIREAT</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxExpireat(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.expireat(args).onComplete($handler);
    });
  }

  /**
   * Get the expiration Unix timestamp for a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/expiretime/">EXPIRETIME</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> expiretime(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.expiretime(arg0).map(val -> val);
    return ret;
  }

  /**
   * Get the expiration Unix timestamp for a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/expiretime/">EXPIRETIME</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxExpiretime(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.expiretime(arg0).onComplete($handler);
    });
  }

  /**
   * Start a coordinated failover between this server and one of its replicas.
   * <p>
   * Redis command <a href="https://redis.io/commands/failover/">FAILOVER</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> failover(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.failover(args).map(val -> val);
    return ret;
  }

  /**
   * Start a coordinated failover between this server and one of its replicas.
   * <p>
   * Redis command <a href="https://redis.io/commands/failover/">FAILOVER</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFailover(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.failover(args).onComplete($handler);
    });
  }

  /**
   * Invoke a function.
   * <p>
   * Redis command <a href="https://redis.io/commands/fcall/">FCALL</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> fcall(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.fcall(args).map(val -> val);
    return ret;
  }

  /**
   * Invoke a function.
   * <p>
   * Redis command <a href="https://redis.io/commands/fcall/">FCALL</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFcall(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.fcall(args).onComplete($handler);
    });
  }

  /**
   * Invoke a read-only function.
   * <p>
   * Redis command <a href="https://redis.io/commands/fcall_ro/">FCALL_RO</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> fcallRo(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.fcallRo(args).map(val -> val);
    return ret;
  }

  /**
   * Invoke a read-only function.
   * <p>
   * Redis command <a href="https://redis.io/commands/fcall_ro/">FCALL_RO</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFcallRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.fcallRo(args).onComplete($handler);
    });
  }

  /**
   * Remove all keys from all databases.
   * <p>
   * Redis command <a href="https://redis.io/commands/flushall/">FLUSHALL</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> flushall(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.flushall(args).map(val -> val);
    return ret;
  }

  /**
   * Remove all keys from all databases.
   * <p>
   * Redis command <a href="https://redis.io/commands/flushall/">FLUSHALL</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFlushall(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.flushall(args).onComplete($handler);
    });
  }

  /**
   * Remove all keys from the current database.
   * <p>
   * Redis command <a href="https://redis.io/commands/flushdb/">FLUSHDB</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> flushdb(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.flushdb(args).map(val -> val);
    return ret;
  }

  /**
   * Remove all keys from the current database.
   * <p>
   * Redis command <a href="https://redis.io/commands/flushdb/">FLUSHDB</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFlushdb(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.flushdb(args).onComplete($handler);
    });
  }

  /**
   * A container for function commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/function/">FUNCTION</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> function(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.function(args).map(val -> val);
    return ret;
  }

  /**
   * A container for function commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/function/">FUNCTION</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxFunction(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.function(args).onComplete($handler);
    });
  }

  /**
   * Add one or more geospatial items in the geospatial index represented using a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/geoadd/">GEOADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> geoadd(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.geoadd(args).map(val -> val);
    return ret;
  }

  /**
   * Add one or more geospatial items in the geospatial index represented using a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/geoadd/">GEOADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGeoadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.geoadd(args).onComplete($handler);
    });
  }

  /**
   * Returns the distance between two members of a geospatial index.
   * <p>
   * Redis command <a href="https://redis.io/commands/geodist/">GEODIST</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> geodist(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.geodist(args).map(val -> val);
    return ret;
  }

  /**
   * Returns the distance between two members of a geospatial index.
   * <p>
   * Redis command <a href="https://redis.io/commands/geodist/">GEODIST</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGeodist(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.geodist(args).onComplete($handler);
    });
  }

  /**
   * Returns members of a geospatial index as standard geohash strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/geohash/">GEOHASH</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> geohash(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.geohash(args).map(val -> val);
    return ret;
  }

  /**
   * Returns members of a geospatial index as standard geohash strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/geohash/">GEOHASH</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGeohash(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.geohash(args).onComplete($handler);
    });
  }

  /**
   * Returns longitude and latitude of members of a geospatial index.
   * <p>
   * Redis command <a href="https://redis.io/commands/geopos/">GEOPOS</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> geopos(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.geopos(args).map(val -> val);
    return ret;
  }

  /**
   * Returns longitude and latitude of members of a geospatial index.
   * <p>
   * Redis command <a href="https://redis.io/commands/geopos/">GEOPOS</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGeopos(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.geopos(args).onComplete($handler);
    });
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a point.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadius/">GEORADIUS</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.vertx.core.Future<io.vertx.redis.client.Response> georadius(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.georadius(args).map(val -> val);
    return ret;
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a point.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadius/">GEORADIUS</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGeoradius(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.georadius(args).onComplete($handler);
    });
  }

  /**
   * A read-only variant for GEORADIUS.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadius_ro/">GEORADIUS_RO</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.vertx.core.Future<io.vertx.redis.client.Response> georadiusRo(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.georadiusRo(args).map(val -> val);
    return ret;
  }

  /**
   * A read-only variant for GEORADIUS.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadius_ro/">GEORADIUS_RO</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGeoradiusRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.georadiusRo(args).onComplete($handler);
    });
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a member.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadiusbymember/">GEORADIUSBYMEMBER</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.vertx.core.Future<io.vertx.redis.client.Response> georadiusbymember(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.georadiusbymember(args).map(val -> val);
    return ret;
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a member.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadiusbymember/">GEORADIUSBYMEMBER</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGeoradiusbymember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.georadiusbymember(args).onComplete($handler);
    });
  }

  /**
   * A read-only variant for GEORADIUSBYMEMBER.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro/">GEORADIUSBYMEMBER_RO</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.vertx.core.Future<io.vertx.redis.client.Response> georadiusbymemberRo(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.georadiusbymemberRo(args).map(val -> val);
    return ret;
  }

  /**
   * A read-only variant for GEORADIUSBYMEMBER.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro/">GEORADIUSBYMEMBER_RO</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGeoradiusbymemberRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.georadiusbymemberRo(args).onComplete($handler);
    });
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members inside an area of a box or a circle.
   * <p>
   * Redis command <a href="https://redis.io/commands/geosearch/">GEOSEARCH</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> geosearch(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.geosearch(args).map(val -> val);
    return ret;
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members inside an area of a box or a circle.
   * <p>
   * Redis command <a href="https://redis.io/commands/geosearch/">GEOSEARCH</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGeosearch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.geosearch(args).onComplete($handler);
    });
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members inside an area of a box or a circle, and store the result in another key.
   * <p>
   * Redis command <a href="https://redis.io/commands/geosearchstore/">GEOSEARCHSTORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> geosearchstore(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.geosearchstore(args).map(val -> val);
    return ret;
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members inside an area of a box or a circle, and store the result in another key.
   * <p>
   * Redis command <a href="https://redis.io/commands/geosearchstore/">GEOSEARCHSTORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGeosearchstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.geosearchstore(args).onComplete($handler);
    });
  }

  /**
   * Get the value of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/get/">GET</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> get(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.get(arg0).map(val -> val);
    return ret;
  }

  /**
   * Get the value of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/get/">GET</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGet(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.get(arg0).onComplete($handler);
    });
  }

  /**
   * Returns the bit value at offset in the string value stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getbit/">GETBIT</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> getbit(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.getbit(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Returns the bit value at offset in the string value stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getbit/">GETBIT</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGetbit(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.getbit(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Get the value of a key and delete the key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getdel/">GETDEL</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> getdel(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.getdel(arg0).map(val -> val);
    return ret;
  }

  /**
   * Get the value of a key and delete the key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getdel/">GETDEL</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGetdel(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.getdel(arg0).onComplete($handler);
    });
  }

  /**
   * Get the value of a key and optionally set its expiration.
   * <p>
   * Redis command <a href="https://redis.io/commands/getex/">GETEX</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> getex(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.getex(args).map(val -> val);
    return ret;
  }

  /**
   * Get the value of a key and optionally set its expiration.
   * <p>
   * Redis command <a href="https://redis.io/commands/getex/">GETEX</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGetex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.getex(args).onComplete($handler);
    });
  }

  /**
   * Get a substring of the string stored at a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getrange/">GETRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> getrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.getrange(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Get a substring of the string stored at a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getrange/">GETRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGetrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.getrange(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Set the string value of a key and return its old value.
   * <p>
   * Redis command <a href="https://redis.io/commands/getset/">GETSET</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  @Deprecated()
  public io.vertx.core.Future<io.vertx.redis.client.Response> getset(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.getset(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Set the string value of a key and return its old value.
   * <p>
   * Redis command <a href="https://redis.io/commands/getset/">GETSET</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  @Deprecated()
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGetset(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.getset(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.bulk/">GRAPH.BULK</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> graphBulk(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.graphBulk(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.bulk/">GRAPH.BULK</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGraphBulk(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.graphBulk(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.config/">GRAPH.CONFIG</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> graphConfig(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.graphConfig(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.config/">GRAPH.CONFIG</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGraphConfig(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.graphConfig(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.debug/">GRAPH.DEBUG</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> graphDebug(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.graphDebug(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.debug/">GRAPH.DEBUG</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGraphDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.graphDebug(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.delete/">GRAPH.DELETE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> graphDelete(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.graphDelete(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.delete/">GRAPH.DELETE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGraphDelete(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.graphDelete(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.explain/">GRAPH.EXPLAIN</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> graphExplain(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.graphExplain(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.explain/">GRAPH.EXPLAIN</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGraphExplain(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.graphExplain(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.list/">GRAPH.LIST</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> graphList(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.graphList(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.list/">GRAPH.LIST</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGraphList(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.graphList(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.profile/">GRAPH.PROFILE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> graphProfile(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.graphProfile(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.profile/">GRAPH.PROFILE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGraphProfile(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.graphProfile(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.query/">GRAPH.QUERY</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> graphQuery(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.graphQuery(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.query/">GRAPH.QUERY</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGraphQuery(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.graphQuery(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.ro_query/">GRAPH.RO_QUERY</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> graphRoQuery(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.graphRoQuery(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.ro_query/">GRAPH.RO_QUERY</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGraphRoQuery(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.graphRoQuery(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.slowlog/">GRAPH.SLOWLOG</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> graphSlowlog(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.graphSlowlog(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.slowlog/">GRAPH.SLOWLOG</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxGraphSlowlog(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.graphSlowlog(args).onComplete($handler);
    });
  }

  /**
   * Delete one or more hash fields.
   * <p>
   * Redis command <a href="https://redis.io/commands/hdel/">HDEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> hdel(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.hdel(args).map(val -> val);
    return ret;
  }

  /**
   * Delete one or more hash fields.
   * <p>
   * Redis command <a href="https://redis.io/commands/hdel/">HDEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxHdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.hdel(args).onComplete($handler);
    });
  }

  /**
   * Handshake with Redis.
   * <p>
   * Redis command <a href="https://redis.io/commands/hello/">HELLO</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> hello(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.hello(args).map(val -> val);
    return ret;
  }

  /**
   * Handshake with Redis.
   * <p>
   * Redis command <a href="https://redis.io/commands/hello/">HELLO</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxHello(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.hello(args).onComplete($handler);
    });
  }

  /**
   * Determine if a hash field exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/hexists/">HEXISTS</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> hexists(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.hexists(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Determine if a hash field exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/hexists/">HEXISTS</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxHexists(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.hexists(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Get the value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hget/">HGET</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> hget(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.hget(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Get the value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hget/">HGET</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxHget(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.hget(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Get all the fields and values in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hgetall/">HGETALL</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> hgetall(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.hgetall(arg0).map(val -> val);
    return ret;
  }

  /**
   * Get all the fields and values in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hgetall/">HGETALL</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxHgetall(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.hgetall(arg0).onComplete($handler);
    });
  }

  /**
   * Increment the integer value of a hash field by the given number.
   * <p>
   * Redis command <a href="https://redis.io/commands/hincrby/">HINCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> hincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.hincrby(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Increment the integer value of a hash field by the given number.
   * <p>
   * Redis command <a href="https://redis.io/commands/hincrby/">HINCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxHincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.hincrby(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Increment the float value of a hash field by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/hincrbyfloat/">HINCRBYFLOAT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> hincrbyfloat(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.hincrbyfloat(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Increment the float value of a hash field by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/hincrbyfloat/">HINCRBYFLOAT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxHincrbyfloat(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.hincrbyfloat(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Get all the fields in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hkeys/">HKEYS</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> hkeys(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.hkeys(arg0).map(val -> val);
    return ret;
  }

  /**
   * Get all the fields in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hkeys/">HKEYS</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxHkeys(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.hkeys(arg0).onComplete($handler);
    });
  }

  /**
   * Get the number of fields in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hlen/">HLEN</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> hlen(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.hlen(arg0).map(val -> val);
    return ret;
  }

  /**
   * Get the number of fields in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hlen/">HLEN</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxHlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.hlen(arg0).onComplete($handler);
    });
  }

  /**
   * Get the values of all the given hash fields.
   * <p>
   * Redis command <a href="https://redis.io/commands/hmget/">HMGET</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> hmget(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.hmget(args).map(val -> val);
    return ret;
  }

  /**
   * Get the values of all the given hash fields.
   * <p>
   * Redis command <a href="https://redis.io/commands/hmget/">HMGET</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxHmget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.hmget(args).onComplete($handler);
    });
  }

  /**
   * Set multiple hash fields to multiple values.
   * <p>
   * Redis command <a href="https://redis.io/commands/hmset/">HMSET</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.vertx.core.Future<io.vertx.redis.client.Response> hmset(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.hmset(args).map(val -> val);
    return ret;
  }

  /**
   * Set multiple hash fields to multiple values.
   * <p>
   * Redis command <a href="https://redis.io/commands/hmset/">HMSET</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxHmset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.hmset(args).onComplete($handler);
    });
  }

  /**
   * Get one or multiple random fields from a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hrandfield/">HRANDFIELD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> hrandfield(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.hrandfield(args).map(val -> val);
    return ret;
  }

  /**
   * Get one or multiple random fields from a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hrandfield/">HRANDFIELD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxHrandfield(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.hrandfield(args).onComplete($handler);
    });
  }

  /**
   * Incrementally iterate hash fields and associated values.
   * <p>
   * Redis command <a href="https://redis.io/commands/hscan/">HSCAN</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> hscan(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.hscan(args).map(val -> val);
    return ret;
  }

  /**
   * Incrementally iterate hash fields and associated values.
   * <p>
   * Redis command <a href="https://redis.io/commands/hscan/">HSCAN</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxHscan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.hscan(args).onComplete($handler);
    });
  }

  /**
   * Set the string value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hset/">HSET</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> hset(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.hset(args).map(val -> val);
    return ret;
  }

  /**
   * Set the string value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hset/">HSET</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxHset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.hset(args).onComplete($handler);
    });
  }

  /**
   * Set the value of a hash field, only if the field does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/hsetnx/">HSETNX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> hsetnx(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.hsetnx(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Set the value of a hash field, only if the field does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/hsetnx/">HSETNX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxHsetnx(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.hsetnx(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Get the length of the value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hstrlen/">HSTRLEN</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> hstrlen(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.hstrlen(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Get the length of the value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hstrlen/">HSTRLEN</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxHstrlen(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.hstrlen(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Get all the values in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hvals/">HVALS</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> hvals(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.hvals(arg0).map(val -> val);
    return ret;
  }

  /**
   * Get all the values in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hvals/">HVALS</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxHvals(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.hvals(arg0).onComplete($handler);
    });
  }

  /**
   * Increment the integer value of a key by one.
   * <p>
   * Redis command <a href="https://redis.io/commands/incr/">INCR</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> incr(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.incr(arg0).map(val -> val);
    return ret;
  }

  /**
   * Increment the integer value of a key by one.
   * <p>
   * Redis command <a href="https://redis.io/commands/incr/">INCR</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxIncr(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.incr(arg0).onComplete($handler);
    });
  }

  /**
   * Increment the integer value of a key by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/incrby/">INCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> incrby(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.incrby(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Increment the integer value of a key by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/incrby/">INCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxIncrby(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.incrby(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Increment the float value of a key by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/incrbyfloat/">INCRBYFLOAT</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> incrbyfloat(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.incrbyfloat(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Increment the float value of a key by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/incrbyfloat/">INCRBYFLOAT</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxIncrbyfloat(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.incrbyfloat(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Get information and statistics about the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/info/">INFO</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> info(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.info(args).map(val -> val);
    return ret;
  }

  /**
   * Get information and statistics about the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/info/">INFO</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.info(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrappend/">JSON.ARRAPPEND</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonArrappend(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonArrappend(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrappend/">JSON.ARRAPPEND</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonArrappend(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonArrappend(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrindex/">JSON.ARRINDEX</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonArrindex(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonArrindex(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrindex/">JSON.ARRINDEX</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonArrindex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonArrindex(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrinsert/">JSON.ARRINSERT</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonArrinsert(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonArrinsert(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrinsert/">JSON.ARRINSERT</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonArrinsert(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonArrinsert(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrlen/">JSON.ARRLEN</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonArrlen(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonArrlen(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrlen/">JSON.ARRLEN</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonArrlen(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonArrlen(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrpop/">JSON.ARRPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonArrpop(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonArrpop(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrpop/">JSON.ARRPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonArrpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonArrpop(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrtrim/">JSON.ARRTRIM</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonArrtrim(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonArrtrim(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrtrim/">JSON.ARRTRIM</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonArrtrim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonArrtrim(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.clear/">JSON.CLEAR</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonClear(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonClear(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.clear/">JSON.CLEAR</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonClear(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonClear(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.debug/">JSON.DEBUG</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonDebug(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonDebug(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.debug/">JSON.DEBUG</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonDebug(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.del/">JSON.DEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonDel(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonDel(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.del/">JSON.DEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonDel(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.forget/">JSON.FORGET</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonForget(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonForget(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.forget/">JSON.FORGET</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonForget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonForget(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.get/">JSON.GET</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonGet(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonGet(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.get/">JSON.GET</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonGet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonGet(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.mget/">JSON.MGET</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonMget(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonMget(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.mget/">JSON.MGET</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonMget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonMget(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numincrby/">JSON.NUMINCRBY</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonNumincrby(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonNumincrby(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numincrby/">JSON.NUMINCRBY</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonNumincrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonNumincrby(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.nummultby/">JSON.NUMMULTBY</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonNummultby(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonNummultby(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.nummultby/">JSON.NUMMULTBY</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonNummultby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonNummultby(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numpowby/">JSON.NUMPOWBY</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonNumpowby(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonNumpowby(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numpowby/">JSON.NUMPOWBY</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonNumpowby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonNumpowby(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objkeys/">JSON.OBJKEYS</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonObjkeys(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonObjkeys(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objkeys/">JSON.OBJKEYS</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonObjkeys(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonObjkeys(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objlen/">JSON.OBJLEN</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonObjlen(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonObjlen(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objlen/">JSON.OBJLEN</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonObjlen(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonObjlen(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.resp/">JSON.RESP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonResp(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonResp(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.resp/">JSON.RESP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonResp(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonResp(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.set/">JSON.SET</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonSet(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonSet(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.set/">JSON.SET</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonSet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonSet(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strappend/">JSON.STRAPPEND</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonStrappend(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonStrappend(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strappend/">JSON.STRAPPEND</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonStrappend(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonStrappend(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strlen/">JSON.STRLEN</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonStrlen(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonStrlen(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strlen/">JSON.STRLEN</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonStrlen(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonStrlen(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.toggle/">JSON.TOGGLE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonToggle(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonToggle(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.toggle/">JSON.TOGGLE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonToggle(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonToggle(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.type/">JSON.TYPE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> jsonType(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.jsonType(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.type/">JSON.TYPE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxJsonType(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.jsonType(args).onComplete($handler);
    });
  }

  /**
   * Find all keys matching the given pattern.
   * <p>
   * Redis command <a href="https://redis.io/commands/keys/">KEYS</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> keys(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.keys(arg0).map(val -> val);
    return ret;
  }

  /**
   * Find all keys matching the given pattern.
   * <p>
   * Redis command <a href="https://redis.io/commands/keys/">KEYS</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxKeys(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.keys(arg0).onComplete($handler);
    });
  }

  /**
   * Get the UNIX time stamp of the last successful save to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/lastsave/">LASTSAVE</a>.
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> lastsave() { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.lastsave().map(val -> val);
    return ret;
  }

  /**
   * Get the UNIX time stamp of the last successful save to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/lastsave/">LASTSAVE</a>.
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxLastsave() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.lastsave().onComplete($handler);
    });
  }

  /**
   * A container for latency diagnostics commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/latency/">LATENCY</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> latency(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.latency(args).map(val -> val);
    return ret;
  }

  /**
   * A container for latency diagnostics commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/latency/">LATENCY</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxLatency(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.latency(args).onComplete($handler);
    });
  }

  /**
   * Find longest common substring.
   * <p>
   * Redis command <a href="https://redis.io/commands/lcs/">LCS</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> lcs(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.lcs(args).map(val -> val);
    return ret;
  }

  /**
   * Find longest common substring.
   * <p>
   * Redis command <a href="https://redis.io/commands/lcs/">LCS</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxLcs(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.lcs(args).onComplete($handler);
    });
  }

  /**
   * Get an element from a list by its index.
   * <p>
   * Redis command <a href="https://redis.io/commands/lindex/">LINDEX</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> lindex(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.lindex(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Get an element from a list by its index.
   * <p>
   * Redis command <a href="https://redis.io/commands/lindex/">LINDEX</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxLindex(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.lindex(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Insert an element before or after another element in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/linsert/">LINSERT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> linsert(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.linsert(arg0, arg1, arg2, arg3).map(val -> val);
    return ret;
  }

  /**
   * Insert an element before or after another element in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/linsert/">LINSERT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxLinsert(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.linsert(arg0, arg1, arg2, arg3).onComplete($handler);
    });
  }

  /**
   * Get the length of a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/llen/">LLEN</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> llen(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.llen(arg0).map(val -> val);
    return ret;
  }

  /**
   * Get the length of a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/llen/">LLEN</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxLlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.llen(arg0).onComplete($handler);
    });
  }

  /**
   * Pop an element from a list, push it to another list and return it.
   * <p>
   * Redis command <a href="https://redis.io/commands/lmove/">LMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> lmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.lmove(arg0, arg1, arg2, arg3).map(val -> val);
    return ret;
  }

  /**
   * Pop an element from a list, push it to another list and return it.
   * <p>
   * Redis command <a href="https://redis.io/commands/lmove/">LMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxLmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.lmove(arg0, arg1, arg2, arg3).onComplete($handler);
    });
  }

  /**
   * Pop elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lmpop/">LMPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> lmpop(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.lmpop(args).map(val -> val);
    return ret;
  }

  /**
   * Pop elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lmpop/">LMPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxLmpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.lmpop(args).onComplete($handler);
    });
  }

  /**
   * Display some computer art and the Redis version.
   * <p>
   * Redis command <a href="https://redis.io/commands/lolwut/">LOLWUT</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> lolwut(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.lolwut(args).map(val -> val);
    return ret;
  }

  /**
   * Display some computer art and the Redis version.
   * <p>
   * Redis command <a href="https://redis.io/commands/lolwut/">LOLWUT</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxLolwut(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.lolwut(args).onComplete($handler);
    });
  }

  /**
   * Remove and get the first elements in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpop/">LPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> lpop(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.lpop(args).map(val -> val);
    return ret;
  }

  /**
   * Remove and get the first elements in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpop/">LPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxLpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.lpop(args).onComplete($handler);
    });
  }

  /**
   * Return the index of matching elements on a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpos/">LPOS</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> lpos(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.lpos(args).map(val -> val);
    return ret;
  }

  /**
   * Return the index of matching elements on a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpos/">LPOS</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxLpos(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.lpos(args).onComplete($handler);
    });
  }

  /**
   * Prepend one or multiple elements to a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpush/">LPUSH</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> lpush(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.lpush(args).map(val -> val);
    return ret;
  }

  /**
   * Prepend one or multiple elements to a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpush/">LPUSH</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxLpush(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.lpush(args).onComplete($handler);
    });
  }

  /**
   * Prepend an element to a list, only if the list exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpushx/">LPUSHX</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> lpushx(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.lpushx(args).map(val -> val);
    return ret;
  }

  /**
   * Prepend an element to a list, only if the list exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpushx/">LPUSHX</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxLpushx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.lpushx(args).onComplete($handler);
    });
  }

  /**
   * Get a range of elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lrange/">LRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> lrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.lrange(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Get a range of elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lrange/">LRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxLrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.lrange(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Remove elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lrem/">LREM</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> lrem(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.lrem(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Remove elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lrem/">LREM</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxLrem(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.lrem(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Set the value of an element in a list by its index.
   * <p>
   * Redis command <a href="https://redis.io/commands/lset/">LSET</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> lset(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.lset(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Set the value of an element in a list by its index.
   * <p>
   * Redis command <a href="https://redis.io/commands/lset/">LSET</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxLset(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.lset(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Trim a list to the specified range.
   * <p>
   * Redis command <a href="https://redis.io/commands/ltrim/">LTRIM</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ltrim(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ltrim(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Trim a list to the specified range.
   * <p>
   * Redis command <a href="https://redis.io/commands/ltrim/">LTRIM</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxLtrim(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ltrim(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * A container for memory diagnostics commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/memory/">MEMORY</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> memory(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.memory(args).map(val -> val);
    return ret;
  }

  /**
   * A container for memory diagnostics commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/memory/">MEMORY</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxMemory(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.memory(args).onComplete($handler);
    });
  }

  /**
   * Get the values of all the given keys.
   * <p>
   * Redis command <a href="https://redis.io/commands/mget/">MGET</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> mget(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.mget(args).map(val -> val);
    return ret;
  }

  /**
   * Get the values of all the given keys.
   * <p>
   * Redis command <a href="https://redis.io/commands/mget/">MGET</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxMget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.mget(args).onComplete($handler);
    });
  }

  /**
   * Atomically transfer a key from a Redis instance to another one.
   * <p>
   * Redis command <a href="https://redis.io/commands/migrate/">MIGRATE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> migrate(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.migrate(args).map(val -> val);
    return ret;
  }

  /**
   * Atomically transfer a key from a Redis instance to another one.
   * <p>
   * Redis command <a href="https://redis.io/commands/migrate/">MIGRATE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxMigrate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.migrate(args).onComplete($handler);
    });
  }

  /**
   * A container for module commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/module/">MODULE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> module(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.module(args).map(val -> val);
    return ret;
  }

  /**
   * A container for module commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/module/">MODULE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxModule(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.module(args).onComplete($handler);
    });
  }

  /**
   * Listen for all requests received by the server in real time.
   * <p>
   * Redis command <a href="https://redis.io/commands/monitor/">MONITOR</a>.
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> monitor() { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.monitor().map(val -> val);
    return ret;
  }

  /**
   * Listen for all requests received by the server in real time.
   * <p>
   * Redis command <a href="https://redis.io/commands/monitor/">MONITOR</a>.
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxMonitor() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.monitor().onComplete($handler);
    });
  }

  /**
   * Move a key to another database.
   * <p>
   * Redis command <a href="https://redis.io/commands/move/">MOVE</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> move(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.move(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Move a key to another database.
   * <p>
   * Redis command <a href="https://redis.io/commands/move/">MOVE</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxMove(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.move(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Set multiple keys to multiple values.
   * <p>
   * Redis command <a href="https://redis.io/commands/mset/">MSET</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> mset(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.mset(args).map(val -> val);
    return ret;
  }

  /**
   * Set multiple keys to multiple values.
   * <p>
   * Redis command <a href="https://redis.io/commands/mset/">MSET</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxMset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.mset(args).onComplete($handler);
    });
  }

  /**
   * Set multiple keys to multiple values, only if none of the keys exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/msetnx/">MSETNX</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> msetnx(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.msetnx(args).map(val -> val);
    return ret;
  }

  /**
   * Set multiple keys to multiple values, only if none of the keys exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/msetnx/">MSETNX</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxMsetnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.msetnx(args).onComplete($handler);
    });
  }

  /**
   * Mark the start of a transaction block.
   * <p>
   * Redis command <a href="https://redis.io/commands/multi/">MULTI</a>.
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> multi() { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.multi().map(val -> val);
    return ret;
  }

  /**
   * Mark the start of a transaction block.
   * <p>
   * Redis command <a href="https://redis.io/commands/multi/">MULTI</a>.
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxMulti() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.multi().onComplete($handler);
    });
  }

  /**
   * A container for object introspection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/object/">OBJECT</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> object(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.object(args).map(val -> val);
    return ret;
  }

  /**
   * A container for object introspection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/object/">OBJECT</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxObject(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.object(args).onComplete($handler);
    });
  }

  /**
   * Remove the expiration from a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/persist/">PERSIST</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> persist(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.persist(arg0).map(val -> val);
    return ret;
  }

  /**
   * Remove the expiration from a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/persist/">PERSIST</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxPersist(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.persist(arg0).onComplete($handler);
    });
  }

  /**
   * Set a key&#x27;s time to live in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpire/">PEXPIRE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> pexpire(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.pexpire(args).map(val -> val);
    return ret;
  }

  /**
   * Set a key&#x27;s time to live in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpire/">PEXPIRE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxPexpire(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.pexpire(args).onComplete($handler);
    });
  }

  /**
   * Set the expiration for a key as a UNIX timestamp specified in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpireat/">PEXPIREAT</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> pexpireat(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.pexpireat(args).map(val -> val);
    return ret;
  }

  /**
   * Set the expiration for a key as a UNIX timestamp specified in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpireat/">PEXPIREAT</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxPexpireat(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.pexpireat(args).onComplete($handler);
    });
  }

  /**
   * Get the expiration Unix timestamp for a key in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpiretime/">PEXPIRETIME</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> pexpiretime(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.pexpiretime(arg0).map(val -> val);
    return ret;
  }

  /**
   * Get the expiration Unix timestamp for a key in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpiretime/">PEXPIRETIME</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxPexpiretime(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.pexpiretime(arg0).onComplete($handler);
    });
  }

  /**
   * Adds the specified elements to the specified HyperLogLog.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfadd/">PFADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> pfadd(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.pfadd(args).map(val -> val);
    return ret;
  }

  /**
   * Adds the specified elements to the specified HyperLogLog.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfadd/">PFADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxPfadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.pfadd(args).onComplete($handler);
    });
  }

  /**
   * Return the approximated cardinality of the set(s) observed by the HyperLogLog at key(s).
   * <p>
   * Redis command <a href="https://redis.io/commands/pfcount/">PFCOUNT</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> pfcount(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.pfcount(args).map(val -> val);
    return ret;
  }

  /**
   * Return the approximated cardinality of the set(s) observed by the HyperLogLog at key(s).
   * <p>
   * Redis command <a href="https://redis.io/commands/pfcount/">PFCOUNT</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxPfcount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.pfcount(args).onComplete($handler);
    });
  }

  /**
   * Internal commands for debugging HyperLogLog values.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfdebug/">PFDEBUG</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> pfdebug(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.pfdebug(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Internal commands for debugging HyperLogLog values.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfdebug/">PFDEBUG</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxPfdebug(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.pfdebug(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Merge N different HyperLogLogs into a single one.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfmerge/">PFMERGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> pfmerge(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.pfmerge(args).map(val -> val);
    return ret;
  }

  /**
   * Merge N different HyperLogLogs into a single one.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfmerge/">PFMERGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxPfmerge(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.pfmerge(args).onComplete($handler);
    });
  }

  /**
   * An internal command for testing HyperLogLog values.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfselftest/">PFSELFTEST</a>.
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> pfselftest() { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.pfselftest().map(val -> val);
    return ret;
  }

  /**
   * An internal command for testing HyperLogLog values.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfselftest/">PFSELFTEST</a>.
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxPfselftest() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.pfselftest().onComplete($handler);
    });
  }

  /**
   * Ping the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/ping/">PING</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ping(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ping(args).map(val -> val);
    return ret;
  }

  /**
   * Ping the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/ping/">PING</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxPing(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ping(args).onComplete($handler);
    });
  }

  /**
   * Set the value and expiration in milliseconds of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/psetex/">PSETEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> psetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.psetex(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Set the value and expiration in milliseconds of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/psetex/">PSETEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxPsetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.psetex(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Listen for messages published to channels matching the given patterns.
   * <p>
   * Redis command <a href="https://redis.io/commands/psubscribe/">PSUBSCRIBE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> psubscribe(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.psubscribe(args).map(val -> val);
    return ret;
  }

  /**
   * Listen for messages published to channels matching the given patterns.
   * <p>
   * Redis command <a href="https://redis.io/commands/psubscribe/">PSUBSCRIBE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxPsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.psubscribe(args).onComplete($handler);
    });
  }

  /**
   * Internal command used for replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/psync/">PSYNC</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> psync(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.psync(args).map(val -> val);
    return ret;
  }

  /**
   * Internal command used for replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/psync/">PSYNC</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxPsync(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.psync(args).onComplete($handler);
    });
  }

  /**
   * Get the time to live for a key in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pttl/">PTTL</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> pttl(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.pttl(arg0).map(val -> val);
    return ret;
  }

  /**
   * Get the time to live for a key in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pttl/">PTTL</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxPttl(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.pttl(arg0).onComplete($handler);
    });
  }

  /**
   * Post a message to a channel.
   * <p>
   * Redis command <a href="https://redis.io/commands/publish/">PUBLISH</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> publish(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.publish(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Post a message to a channel.
   * <p>
   * Redis command <a href="https://redis.io/commands/publish/">PUBLISH</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxPublish(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.publish(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * A container for Pub/Sub commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/pubsub/">PUBSUB</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> pubsub(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.pubsub(args).map(val -> val);
    return ret;
  }

  /**
   * A container for Pub/Sub commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/pubsub/">PUBSUB</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxPubsub(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.pubsub(args).onComplete($handler);
    });
  }

  /**
   * Stop listening for messages posted to channels matching the given patterns.
   * <p>
   * Redis command <a href="https://redis.io/commands/punsubscribe/">PUNSUBSCRIBE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> punsubscribe(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.punsubscribe(args).map(val -> val);
    return ret;
  }

  /**
   * Stop listening for messages posted to channels matching the given patterns.
   * <p>
   * Redis command <a href="https://redis.io/commands/punsubscribe/">PUNSUBSCRIBE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxPunsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.punsubscribe(args).onComplete($handler);
    });
  }

  /**
   * Close the connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/quit/">QUIT</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> quit(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.quit(args).map(val -> val);
    return ret;
  }

  /**
   * Close the connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/quit/">QUIT</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxQuit(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.quit(args).onComplete($handler);
    });
  }

  /**
   * Return a random key from the keyspace.
   * <p>
   * Redis command <a href="https://redis.io/commands/randomkey/">RANDOMKEY</a>.
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> randomkey() { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.randomkey().map(val -> val);
    return ret;
  }

  /**
   * Return a random key from the keyspace.
   * <p>
   * Redis command <a href="https://redis.io/commands/randomkey/">RANDOMKEY</a>.
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxRandomkey() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.randomkey().onComplete($handler);
    });
  }

  /**
   * Enables read queries for a connection to a cluster replica node.
   * <p>
   * Redis command <a href="https://redis.io/commands/readonly/">READONLY</a>.
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> readonly() { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.readonly().map(val -> val);
    return ret;
  }

  /**
   * Enables read queries for a connection to a cluster replica node.
   * <p>
   * Redis command <a href="https://redis.io/commands/readonly/">READONLY</a>.
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxReadonly() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.readonly().onComplete($handler);
    });
  }

  /**
   * Disables read queries for a connection to a cluster replica node.
   * <p>
   * Redis command <a href="https://redis.io/commands/readwrite/">READWRITE</a>.
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> readwrite() { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.readwrite().map(val -> val);
    return ret;
  }

  /**
   * Disables read queries for a connection to a cluster replica node.
   * <p>
   * Redis command <a href="https://redis.io/commands/readwrite/">READWRITE</a>.
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxReadwrite() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.readwrite().onComplete($handler);
    });
  }

  /**
   * Rename a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/rename/">RENAME</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> rename(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.rename(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Rename a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/rename/">RENAME</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxRename(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.rename(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Rename a key, only if the new key does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/renamenx/">RENAMENX</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> renamenx(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.renamenx(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Rename a key, only if the new key does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/renamenx/">RENAMENX</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxRenamenx(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.renamenx(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * An internal command for configuring the replication stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/replconf/">REPLCONF</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> replconf(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.replconf(args).map(val -> val);
    return ret;
  }

  /**
   * An internal command for configuring the replication stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/replconf/">REPLCONF</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxReplconf(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.replconf(args).onComplete($handler);
    });
  }

  /**
   * Make the server a replica of another instance, or promote it as master.
   * <p>
   * Redis command <a href="https://redis.io/commands/replicaof/">REPLICAOF</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> replicaof(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.replicaof(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Make the server a replica of another instance, or promote it as master.
   * <p>
   * Redis command <a href="https://redis.io/commands/replicaof/">REPLICAOF</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxReplicaof(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.replicaof(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Reset the connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/reset/">RESET</a>.
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> reset() { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.reset().map(val -> val);
    return ret;
  }

  /**
   * Reset the connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/reset/">RESET</a>.
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxReset() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.reset().onComplete($handler);
    });
  }

  /**
   * Create a key using the provided serialized value, previously obtained using DUMP.
   * <p>
   * Redis command <a href="https://redis.io/commands/restore/">RESTORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> restore(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.restore(args).map(val -> val);
    return ret;
  }

  /**
   * Create a key using the provided serialized value, previously obtained using DUMP.
   * <p>
   * Redis command <a href="https://redis.io/commands/restore/">RESTORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxRestore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.restore(args).onComplete($handler);
    });
  }

  /**
   * An internal command for migrating keys in a cluster.
   * <p>
   * Redis command <a href="https://redis.io/commands/restore asking/">RESTORE-ASKING</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> restoreAsking(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.restoreAsking(args).map(val -> val);
    return ret;
  }

  /**
   * An internal command for migrating keys in a cluster.
   * <p>
   * Redis command <a href="https://redis.io/commands/restore asking/">RESTORE-ASKING</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxRestoreAsking(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.restoreAsking(args).onComplete($handler);
    });
  }

  /**
   * Return the role of the instance in the context of replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/role/">ROLE</a>.
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> role() { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.role().map(val -> val);
    return ret;
  }

  /**
   * Return the role of the instance in the context of replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/role/">ROLE</a>.
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxRole() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.role().onComplete($handler);
    });
  }

  /**
   * Remove and get the last elements in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpop/">RPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> rpop(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.rpop(args).map(val -> val);
    return ret;
  }

  /**
   * Remove and get the last elements in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpop/">RPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxRpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.rpop(args).onComplete($handler);
    });
  }

  /**
   * Remove the last element in a list, prepend it to another list and return it.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpoplpush/">RPOPLPUSH</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  @Deprecated()
  public io.vertx.core.Future<io.vertx.redis.client.Response> rpoplpush(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.rpoplpush(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Remove the last element in a list, prepend it to another list and return it.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpoplpush/">RPOPLPUSH</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  @Deprecated()
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxRpoplpush(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.rpoplpush(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Append one or multiple elements to a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpush/">RPUSH</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> rpush(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.rpush(args).map(val -> val);
    return ret;
  }

  /**
   * Append one or multiple elements to a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpush/">RPUSH</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxRpush(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.rpush(args).onComplete($handler);
    });
  }

  /**
   * Append an element to a list, only if the list exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpushx/">RPUSHX</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> rpushx(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.rpushx(args).map(val -> val);
    return ret;
  }

  /**
   * Append an element to a list, only if the list exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpushx/">RPUSHX</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxRpushx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.rpushx(args).onComplete($handler);
    });
  }

  /**
   * Add one or more members to a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sadd/">SADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> sadd(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.sadd(args).map(val -> val);
    return ret;
  }

  /**
   * Add one or more members to a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sadd/">SADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.sadd(args).onComplete($handler);
    });
  }

  /**
   * Synchronously save the dataset to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/save/">SAVE</a>.
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> save() { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.save().map(val -> val);
    return ret;
  }

  /**
   * Synchronously save the dataset to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/save/">SAVE</a>.
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSave() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.save().onComplete($handler);
    });
  }

  /**
   * Incrementally iterate the keys space.
   * <p>
   * Redis command <a href="https://redis.io/commands/scan/">SCAN</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> scan(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.scan(args).map(val -> val);
    return ret;
  }

  /**
   * Incrementally iterate the keys space.
   * <p>
   * Redis command <a href="https://redis.io/commands/scan/">SCAN</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxScan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.scan(args).onComplete($handler);
    });
  }

  /**
   * Get the number of members in a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/scard/">SCARD</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> scard(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.scard(arg0).map(val -> val);
    return ret;
  }

  /**
   * Get the number of members in a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/scard/">SCARD</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxScard(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.scard(arg0).onComplete($handler);
    });
  }

  /**
   * A container for Lua scripts management commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/script/">SCRIPT</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> script(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.script(args).map(val -> val);
    return ret;
  }

  /**
   * A container for Lua scripts management commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/script/">SCRIPT</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxScript(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.script(args).onComplete($handler);
    });
  }

  /**
   * Subtract multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sdiff/">SDIFF</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> sdiff(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.sdiff(args).map(val -> val);
    return ret;
  }

  /**
   * Subtract multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sdiff/">SDIFF</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSdiff(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.sdiff(args).onComplete($handler);
    });
  }

  /**
   * Subtract multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sdiffstore/">SDIFFSTORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> sdiffstore(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.sdiffstore(args).map(val -> val);
    return ret;
  }

  /**
   * Subtract multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sdiffstore/">SDIFFSTORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSdiffstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.sdiffstore(args).onComplete($handler);
    });
  }

  /**
   * Change the selected database for the current connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/select/">SELECT</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> select(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.select(arg0).map(val -> val);
    return ret;
  }

  /**
   * Change the selected database for the current connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/select/">SELECT</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSelect(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.select(arg0).onComplete($handler);
    });
  }

  /**
   * Set the string value of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/set/">SET</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> set(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.set(args).map(val -> val);
    return ret;
  }

  /**
   * Set the string value of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/set/">SET</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.set(args).onComplete($handler);
    });
  }

  /**
   * Sets or clears the bit at offset in the string value stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/setbit/">SETBIT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> setbit(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.setbit(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Sets or clears the bit at offset in the string value stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/setbit/">SETBIT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSetbit(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.setbit(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Set the value and expiration of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/setex/">SETEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> setex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.setex(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Set the value and expiration of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/setex/">SETEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.setex(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Set the value of a key, only if the key does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/setnx/">SETNX</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> setnx(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.setnx(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Set the value of a key, only if the key does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/setnx/">SETNX</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSetnx(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.setnx(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Overwrite part of a string at key starting at the specified offset.
   * <p>
   * Redis command <a href="https://redis.io/commands/setrange/">SETRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> setrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.setrange(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Overwrite part of a string at key starting at the specified offset.
   * <p>
   * Redis command <a href="https://redis.io/commands/setrange/">SETRANGE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSetrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.setrange(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Synchronously save the dataset to disk and then shut down the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/shutdown/">SHUTDOWN</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> shutdown(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.shutdown(args).map(val -> val);
    return ret;
  }

  /**
   * Synchronously save the dataset to disk and then shut down the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/shutdown/">SHUTDOWN</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxShutdown(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.shutdown(args).onComplete($handler);
    });
  }

  /**
   * Intersect multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sinter/">SINTER</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> sinter(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.sinter(args).map(val -> val);
    return ret;
  }

  /**
   * Intersect multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sinter/">SINTER</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSinter(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.sinter(args).onComplete($handler);
    });
  }

  /**
   * Intersect multiple sets and return the cardinality of the result.
   * <p>
   * Redis command <a href="https://redis.io/commands/sintercard/">SINTERCARD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> sintercard(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.sintercard(args).map(val -> val);
    return ret;
  }

  /**
   * Intersect multiple sets and return the cardinality of the result.
   * <p>
   * Redis command <a href="https://redis.io/commands/sintercard/">SINTERCARD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSintercard(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.sintercard(args).onComplete($handler);
    });
  }

  /**
   * Intersect multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sinterstore/">SINTERSTORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> sinterstore(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.sinterstore(args).map(val -> val);
    return ret;
  }

  /**
   * Intersect multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sinterstore/">SINTERSTORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSinterstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.sinterstore(args).onComplete($handler);
    });
  }

  /**
   * Determine if a given value is a member of a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sismember/">SISMEMBER</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> sismember(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.sismember(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Determine if a given value is a member of a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sismember/">SISMEMBER</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSismember(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.sismember(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Make the server a replica of another instance, or promote it as master.
   * <p>
   * Redis command <a href="https://redis.io/commands/slaveof/">SLAVEOF</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  @Deprecated()
  public io.vertx.core.Future<io.vertx.redis.client.Response> slaveof(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.slaveof(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Make the server a replica of another instance, or promote it as master.
   * <p>
   * Redis command <a href="https://redis.io/commands/slaveof/">SLAVEOF</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  @Deprecated()
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSlaveof(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.slaveof(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * A container for slow log commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/slowlog/">SLOWLOG</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> slowlog(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.slowlog(args).map(val -> val);
    return ret;
  }

  /**
   * A container for slow log commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/slowlog/">SLOWLOG</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSlowlog(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.slowlog(args).onComplete($handler);
    });
  }

  /**
   * Get all the members in a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/smembers/">SMEMBERS</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> smembers(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.smembers(arg0).map(val -> val);
    return ret;
  }

  /**
   * Get all the members in a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/smembers/">SMEMBERS</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSmembers(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.smembers(arg0).onComplete($handler);
    });
  }

  /**
   * Returns the membership associated with the given elements for a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/smismember/">SMISMEMBER</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> smismember(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.smismember(args).map(val -> val);
    return ret;
  }

  /**
   * Returns the membership associated with the given elements for a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/smismember/">SMISMEMBER</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSmismember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.smismember(args).onComplete($handler);
    });
  }

  /**
   * Move a member from one set to another.
   * <p>
   * Redis command <a href="https://redis.io/commands/smove/">SMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> smove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.smove(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Move a member from one set to another.
   * <p>
   * Redis command <a href="https://redis.io/commands/smove/">SMOVE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.smove(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Sort the elements in a list, set or sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sort/">SORT</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> sort(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.sort(args).map(val -> val);
    return ret;
  }

  /**
   * Sort the elements in a list, set or sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sort/">SORT</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSort(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.sort(args).onComplete($handler);
    });
  }

  /**
   * Sort the elements in a list, set or sorted set. Read-only variant of SORT.
   * <p>
   * Redis command <a href="https://redis.io/commands/sort_ro/">SORT_RO</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> sortRo(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.sortRo(args).map(val -> val);
    return ret;
  }

  /**
   * Sort the elements in a list, set or sorted set. Read-only variant of SORT.
   * <p>
   * Redis command <a href="https://redis.io/commands/sort_ro/">SORT_RO</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSortRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.sortRo(args).onComplete($handler);
    });
  }

  /**
   * Remove and return one or multiple random members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/spop/">SPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> spop(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.spop(args).map(val -> val);
    return ret;
  }

  /**
   * Remove and return one or multiple random members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/spop/">SPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.spop(args).onComplete($handler);
    });
  }

  /**
   * Post a message to a shard channel.
   * <p>
   * Redis command <a href="https://redis.io/commands/spublish/">SPUBLISH</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> spublish(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.spublish(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Post a message to a shard channel.
   * <p>
   * Redis command <a href="https://redis.io/commands/spublish/">SPUBLISH</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSpublish(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.spublish(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Get one or multiple random members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/srandmember/">SRANDMEMBER</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> srandmember(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.srandmember(args).map(val -> val);
    return ret;
  }

  /**
   * Get one or multiple random members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/srandmember/">SRANDMEMBER</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSrandmember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.srandmember(args).onComplete($handler);
    });
  }

  /**
   * Remove one or more members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/srem/">SREM</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> srem(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.srem(args).map(val -> val);
    return ret;
  }

  /**
   * Remove one or more members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/srem/">SREM</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSrem(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.srem(args).onComplete($handler);
    });
  }

  /**
   * Incrementally iterate Set elements.
   * <p>
   * Redis command <a href="https://redis.io/commands/sscan/">SSCAN</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> sscan(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.sscan(args).map(val -> val);
    return ret;
  }

  /**
   * Incrementally iterate Set elements.
   * <p>
   * Redis command <a href="https://redis.io/commands/sscan/">SSCAN</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSscan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.sscan(args).onComplete($handler);
    });
  }

  /**
   * Listen for messages published to the given shard channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/ssubscribe/">SSUBSCRIBE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ssubscribe(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ssubscribe(args).map(val -> val);
    return ret;
  }

  /**
   * Listen for messages published to the given shard channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/ssubscribe/">SSUBSCRIBE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ssubscribe(args).onComplete($handler);
    });
  }

  /**
   * Get the length of the value stored in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/strlen/">STRLEN</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> strlen(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.strlen(arg0).map(val -> val);
    return ret;
  }

  /**
   * Get the length of the value stored in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/strlen/">STRLEN</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxStrlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.strlen(arg0).onComplete($handler);
    });
  }

  /**
   * Listen for messages published to the given channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/subscribe/">SUBSCRIBE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> subscribe(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.subscribe(args).map(val -> val);
    return ret;
  }

  /**
   * Listen for messages published to the given channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/subscribe/">SUBSCRIBE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.subscribe(args).onComplete($handler);
    });
  }

  /**
   * Get a substring of the string stored at a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/substr/">SUBSTR</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  @Deprecated()
  public io.vertx.core.Future<io.vertx.redis.client.Response> substr(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.substr(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Get a substring of the string stored at a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/substr/">SUBSTR</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  @Deprecated()
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSubstr(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.substr(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Add multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunion/">SUNION</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> sunion(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.sunion(args).map(val -> val);
    return ret;
  }

  /**
   * Add multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunion/">SUNION</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSunion(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.sunion(args).onComplete($handler);
    });
  }

  /**
   * Add multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunionstore/">SUNIONSTORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> sunionstore(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.sunionstore(args).map(val -> val);
    return ret;
  }

  /**
   * Add multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunionstore/">SUNIONSTORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSunionstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.sunionstore(args).onComplete($handler);
    });
  }

  /**
   * Stop listening for messages posted to the given shard channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunsubscribe/">SUNSUBSCRIBE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> sunsubscribe(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.sunsubscribe(args).map(val -> val);
    return ret;
  }

  /**
   * Stop listening for messages posted to the given shard channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunsubscribe/">SUNSUBSCRIBE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSunsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.sunsubscribe(args).onComplete($handler);
    });
  }

  /**
   * Swaps two Redis databases.
   * <p>
   * Redis command <a href="https://redis.io/commands/swapdb/">SWAPDB</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> swapdb(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.swapdb(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Swaps two Redis databases.
   * <p>
   * Redis command <a href="https://redis.io/commands/swapdb/">SWAPDB</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSwapdb(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.swapdb(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Internal command used for replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/sync/">SYNC</a>.
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> sync() { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.sync().map(val -> val);
    return ret;
  }

  /**
   * Internal command used for replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/sync/">SYNC</a>.
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSync() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.sync().onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.add/">TDIGEST.ADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tdigestAdd(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tdigestAdd(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.add/">TDIGEST.ADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTdigestAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tdigestAdd(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.byrank/">TDIGEST.BYRANK</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tdigestByrank(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tdigestByrank(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.byrank/">TDIGEST.BYRANK</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTdigestByrank(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tdigestByrank(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.byrevrank/">TDIGEST.BYREVRANK</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tdigestByrevrank(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tdigestByrevrank(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.byrevrank/">TDIGEST.BYREVRANK</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTdigestByrevrank(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tdigestByrevrank(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.cdf/">TDIGEST.CDF</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tdigestCdf(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tdigestCdf(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.cdf/">TDIGEST.CDF</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTdigestCdf(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tdigestCdf(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.create/">TDIGEST.CREATE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tdigestCreate(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tdigestCreate(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.create/">TDIGEST.CREATE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTdigestCreate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tdigestCreate(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.info/">TDIGEST.INFO</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tdigestInfo(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tdigestInfo(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.info/">TDIGEST.INFO</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTdigestInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tdigestInfo(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.max/">TDIGEST.MAX</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tdigestMax(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tdigestMax(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.max/">TDIGEST.MAX</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTdigestMax(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tdigestMax(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.merge/">TDIGEST.MERGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tdigestMerge(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tdigestMerge(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.merge/">TDIGEST.MERGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTdigestMerge(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tdigestMerge(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.min/">TDIGEST.MIN</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tdigestMin(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tdigestMin(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.min/">TDIGEST.MIN</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTdigestMin(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tdigestMin(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.quantile/">TDIGEST.QUANTILE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tdigestQuantile(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tdigestQuantile(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.quantile/">TDIGEST.QUANTILE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTdigestQuantile(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tdigestQuantile(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.rank/">TDIGEST.RANK</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tdigestRank(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tdigestRank(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.rank/">TDIGEST.RANK</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTdigestRank(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tdigestRank(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.reset/">TDIGEST.RESET</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tdigestReset(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tdigestReset(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.reset/">TDIGEST.RESET</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTdigestReset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tdigestReset(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.revrank/">TDIGEST.REVRANK</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tdigestRevrank(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tdigestRevrank(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.revrank/">TDIGEST.REVRANK</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTdigestRevrank(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tdigestRevrank(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.trimmed_mean/">TDIGEST.TRIMMED_MEAN</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tdigestTrimmedMean(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tdigestTrimmedMean(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.trimmed_mean/">TDIGEST.TRIMMED_MEAN</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTdigestTrimmedMean(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tdigestTrimmedMean(args).onComplete($handler);
    });
  }

  /**
   * Return the current server time.
   * <p>
   * Redis command <a href="https://redis.io/commands/time/">TIME</a>.
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> time() { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.time().map(val -> val);
    return ret;
  }

  /**
   * Return the current server time.
   * <p>
   * Redis command <a href="https://redis.io/commands/time/">TIME</a>.
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTime() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.time().onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.clusterset/">TIMESERIES.CLUSTERSET</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> timeseriesClusterset(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.timeseriesClusterset(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.clusterset/">TIMESERIES.CLUSTERSET</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTimeseriesClusterset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.timeseriesClusterset(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.clustersetfromshard/">TIMESERIES.CLUSTERSETFROMSHARD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> timeseriesClustersetfromshard(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.timeseriesClustersetfromshard(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.clustersetfromshard/">TIMESERIES.CLUSTERSETFROMSHARD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTimeseriesClustersetfromshard(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.timeseriesClustersetfromshard(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.hello/">TIMESERIES.HELLO</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> timeseriesHello(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.timeseriesHello(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.hello/">TIMESERIES.HELLO</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTimeseriesHello(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.timeseriesHello(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.infocluster/">TIMESERIES.INFOCLUSTER</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> timeseriesInfocluster(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.timeseriesInfocluster(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.infocluster/">TIMESERIES.INFOCLUSTER</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTimeseriesInfocluster(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.timeseriesInfocluster(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.innercommunication/">TIMESERIES.INNERCOMMUNICATION</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> timeseriesInnercommunication(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.timeseriesInnercommunication(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.innercommunication/">TIMESERIES.INNERCOMMUNICATION</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTimeseriesInnercommunication(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.timeseriesInnercommunication(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.networktest/">TIMESERIES.NETWORKTEST</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> timeseriesNetworktest(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.timeseriesNetworktest(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.networktest/">TIMESERIES.NETWORKTEST</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTimeseriesNetworktest(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.timeseriesNetworktest(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.refreshcluster/">TIMESERIES.REFRESHCLUSTER</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> timeseriesRefreshcluster(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.timeseriesRefreshcluster(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.refreshcluster/">TIMESERIES.REFRESHCLUSTER</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTimeseriesRefreshcluster(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.timeseriesRefreshcluster(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.add/">TOPK.ADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> topkAdd(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.topkAdd(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.add/">TOPK.ADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTopkAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.topkAdd(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.count/">TOPK.COUNT</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> topkCount(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.topkCount(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.count/">TOPK.COUNT</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTopkCount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.topkCount(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.incrby/">TOPK.INCRBY</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> topkIncrby(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.topkIncrby(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.incrby/">TOPK.INCRBY</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTopkIncrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.topkIncrby(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.info/">TOPK.INFO</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> topkInfo(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.topkInfo(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.info/">TOPK.INFO</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTopkInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.topkInfo(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.list/">TOPK.LIST</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> topkList(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.topkList(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.list/">TOPK.LIST</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTopkList(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.topkList(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.query/">TOPK.QUERY</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> topkQuery(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.topkQuery(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.query/">TOPK.QUERY</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTopkQuery(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.topkQuery(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.reserve/">TOPK.RESERVE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> topkReserve(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.topkReserve(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.reserve/">TOPK.RESERVE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTopkReserve(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.topkReserve(args).onComplete($handler);
    });
  }

  /**
   * Alters the last access time of a key(s). Returns the number of existing keys specified.
   * <p>
   * Redis command <a href="https://redis.io/commands/touch/">TOUCH</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> touch(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.touch(args).map(val -> val);
    return ret;
  }

  /**
   * Alters the last access time of a key(s). Returns the number of existing keys specified.
   * <p>
   * Redis command <a href="https://redis.io/commands/touch/">TOUCH</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTouch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.touch(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.add/">TS.ADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tsAdd(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tsAdd(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.add/">TS.ADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTsAdd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tsAdd(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.alter/">TS.ALTER</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tsAlter(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tsAlter(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.alter/">TS.ALTER</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTsAlter(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tsAlter(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.create/">TS.CREATE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tsCreate(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tsCreate(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.create/">TS.CREATE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTsCreate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tsCreate(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.createrule/">TS.CREATERULE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tsCreaterule(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tsCreaterule(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.createrule/">TS.CREATERULE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTsCreaterule(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tsCreaterule(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.decrby/">TS.DECRBY</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tsDecrby(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tsDecrby(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.decrby/">TS.DECRBY</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTsDecrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tsDecrby(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.del/">TS.DEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tsDel(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tsDel(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.del/">TS.DEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTsDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tsDel(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.deleterule/">TS.DELETERULE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tsDeleterule(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tsDeleterule(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.deleterule/">TS.DELETERULE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTsDeleterule(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tsDeleterule(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.get/">TS.GET</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tsGet(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tsGet(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.get/">TS.GET</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTsGet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tsGet(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.incrby/">TS.INCRBY</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tsIncrby(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tsIncrby(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.incrby/">TS.INCRBY</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTsIncrby(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tsIncrby(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.info/">TS.INFO</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tsInfo(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tsInfo(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.info/">TS.INFO</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTsInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tsInfo(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.madd/">TS.MADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tsMadd(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tsMadd(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.madd/">TS.MADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTsMadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tsMadd(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mget/">TS.MGET</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tsMget(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tsMget(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mget/">TS.MGET</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTsMget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tsMget(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrange/">TS.MRANGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tsMrange(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tsMrange(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrange/">TS.MRANGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTsMrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tsMrange(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrevrange/">TS.MREVRANGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tsMrevrange(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tsMrevrange(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrevrange/">TS.MREVRANGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTsMrevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tsMrevrange(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.queryindex/">TS.QUERYINDEX</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tsQueryindex(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tsQueryindex(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.queryindex/">TS.QUERYINDEX</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTsQueryindex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tsQueryindex(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.range/">TS.RANGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tsRange(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tsRange(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.range/">TS.RANGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTsRange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tsRange(args).onComplete($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.revrange/">TS.REVRANGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> tsRevrange(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.tsRevrange(args).map(val -> val);
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.revrange/">TS.REVRANGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTsRevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.tsRevrange(args).onComplete($handler);
    });
  }

  /**
   * Get the time to live for a key in seconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/ttl/">TTL</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> ttl(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.ttl(arg0).map(val -> val);
    return ret;
  }

  /**
   * Get the time to live for a key in seconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/ttl/">TTL</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxTtl(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.ttl(arg0).onComplete($handler);
    });
  }

  /**
   * Determine the type stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/type/">TYPE</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> type(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.type(arg0).map(val -> val);
    return ret;
  }

  /**
   * Determine the type stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/type/">TYPE</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxType(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.type(arg0).onComplete($handler);
    });
  }

  /**
   * Delete a key asynchronously in another thread. Otherwise it is just as DEL, but non blocking.
   * <p>
   * Redis command <a href="https://redis.io/commands/unlink/">UNLINK</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> unlink(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.unlink(args).map(val -> val);
    return ret;
  }

  /**
   * Delete a key asynchronously in another thread. Otherwise it is just as DEL, but non blocking.
   * <p>
   * Redis command <a href="https://redis.io/commands/unlink/">UNLINK</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxUnlink(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.unlink(args).onComplete($handler);
    });
  }

  /**
   * Stop listening for messages posted to the given channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/unsubscribe/">UNSUBSCRIBE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> unsubscribe(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.unsubscribe(args).map(val -> val);
    return ret;
  }

  /**
   * Stop listening for messages posted to the given channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/unsubscribe/">UNSUBSCRIBE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxUnsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.unsubscribe(args).onComplete($handler);
    });
  }

  /**
   * Forget about all watched keys.
   * <p>
   * Redis command <a href="https://redis.io/commands/unwatch/">UNWATCH</a>.
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> unwatch() { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.unwatch().map(val -> val);
    return ret;
  }

  /**
   * Forget about all watched keys.
   * <p>
   * Redis command <a href="https://redis.io/commands/unwatch/">UNWATCH</a>.
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxUnwatch() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.unwatch().onComplete($handler);
    });
  }

  /**
   * Wait for the synchronous replication of all the write commands sent in the context of the current connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/wait/">WAIT</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> wait(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.wait(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Wait for the synchronous replication of all the write commands sent in the context of the current connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/wait/">WAIT</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxWait(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.wait(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Watch the given keys to determine execution of the MULTI/EXEC block.
   * <p>
   * Redis command <a href="https://redis.io/commands/watch/">WATCH</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> watch(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.watch(args).map(val -> val);
    return ret;
  }

  /**
   * Watch the given keys to determine execution of the MULTI/EXEC block.
   * <p>
   * Redis command <a href="https://redis.io/commands/watch/">WATCH</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxWatch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.watch(args).onComplete($handler);
    });
  }

  /**
   * Marks a pending message as correctly processed, effectively removing it from the pending entries list of the consumer group. Return value of the command is the number of messages successfully acknowledged, that is, the IDs we were actually able to resolve in the PEL.
   * <p>
   * Redis command <a href="https://redis.io/commands/xack/">XACK</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> xack(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.xack(args).map(val -> val);
    return ret;
  }

  /**
   * Marks a pending message as correctly processed, effectively removing it from the pending entries list of the consumer group. Return value of the command is the number of messages successfully acknowledged, that is, the IDs we were actually able to resolve in the PEL.
   * <p>
   * Redis command <a href="https://redis.io/commands/xack/">XACK</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxXack(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.xack(args).onComplete($handler);
    });
  }

  /**
   * Appends a new entry to a stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/xadd/">XADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> xadd(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.xadd(args).map(val -> val);
    return ret;
  }

  /**
   * Appends a new entry to a stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/xadd/">XADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxXadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.xadd(args).onComplete($handler);
    });
  }

  /**
   * Changes (or acquires) ownership of messages in a consumer group, as if the messages were delivered to the specified consumer.
   * <p>
   * Redis command <a href="https://redis.io/commands/xautoclaim/">XAUTOCLAIM</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> xautoclaim(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.xautoclaim(args).map(val -> val);
    return ret;
  }

  /**
   * Changes (or acquires) ownership of messages in a consumer group, as if the messages were delivered to the specified consumer.
   * <p>
   * Redis command <a href="https://redis.io/commands/xautoclaim/">XAUTOCLAIM</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxXautoclaim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.xautoclaim(args).onComplete($handler);
    });
  }

  /**
   * Changes (or acquires) ownership of a message in a consumer group, as if the message was delivered to the specified consumer.
   * <p>
   * Redis command <a href="https://redis.io/commands/xclaim/">XCLAIM</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> xclaim(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.xclaim(args).map(val -> val);
    return ret;
  }

  /**
   * Changes (or acquires) ownership of a message in a consumer group, as if the message was delivered to the specified consumer.
   * <p>
   * Redis command <a href="https://redis.io/commands/xclaim/">XCLAIM</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxXclaim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.xclaim(args).onComplete($handler);
    });
  }

  /**
   * Removes the specified entries from the stream. Returns the number of items actually deleted, that may be different from the number of IDs passed in case certain IDs do not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/xdel/">XDEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> xdel(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.xdel(args).map(val -> val);
    return ret;
  }

  /**
   * Removes the specified entries from the stream. Returns the number of items actually deleted, that may be different from the number of IDs passed in case certain IDs do not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/xdel/">XDEL</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxXdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.xdel(args).onComplete($handler);
    });
  }

  /**
   * A container for consumer groups commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/xgroup/">XGROUP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> xgroup(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.xgroup(args).map(val -> val);
    return ret;
  }

  /**
   * A container for consumer groups commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/xgroup/">XGROUP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxXgroup(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.xgroup(args).onComplete($handler);
    });
  }

  /**
   * A container for stream introspection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/xinfo/">XINFO</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> xinfo(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.xinfo(args).map(val -> val);
    return ret;
  }

  /**
   * A container for stream introspection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/xinfo/">XINFO</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxXinfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.xinfo(args).onComplete($handler);
    });
  }

  /**
   * Return the number of entries in a stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/xlen/">XLEN</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> xlen(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.xlen(arg0).map(val -> val);
    return ret;
  }

  /**
   * Return the number of entries in a stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/xlen/">XLEN</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxXlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.xlen(arg0).onComplete($handler);
    });
  }

  /**
   * Return information and entries from a stream consumer group pending entries list, that are messages fetched but never acknowledged.
   * <p>
   * Redis command <a href="https://redis.io/commands/xpending/">XPENDING</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> xpending(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.xpending(args).map(val -> val);
    return ret;
  }

  /**
   * Return information and entries from a stream consumer group pending entries list, that are messages fetched but never acknowledged.
   * <p>
   * Redis command <a href="https://redis.io/commands/xpending/">XPENDING</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxXpending(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.xpending(args).onComplete($handler);
    });
  }

  /**
   * Return a range of elements in a stream, with IDs matching the specified IDs interval.
   * <p>
   * Redis command <a href="https://redis.io/commands/xrange/">XRANGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> xrange(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.xrange(args).map(val -> val);
    return ret;
  }

  /**
   * Return a range of elements in a stream, with IDs matching the specified IDs interval.
   * <p>
   * Redis command <a href="https://redis.io/commands/xrange/">XRANGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxXrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.xrange(args).onComplete($handler);
    });
  }

  /**
   * Return never seen elements in multiple streams, with IDs greater than the ones reported by the caller for each stream. Can block.
   * <p>
   * Redis command <a href="https://redis.io/commands/xread/">XREAD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> xread(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.xread(args).map(val -> val);
    return ret;
  }

  /**
   * Return never seen elements in multiple streams, with IDs greater than the ones reported by the caller for each stream. Can block.
   * <p>
   * Redis command <a href="https://redis.io/commands/xread/">XREAD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxXread(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.xread(args).onComplete($handler);
    });
  }

  /**
   * Return new entries from a stream using a consumer group, or access the history of the pending entries for a given consumer. Can block.
   * <p>
   * Redis command <a href="https://redis.io/commands/xreadgroup/">XREADGROUP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> xreadgroup(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.xreadgroup(args).map(val -> val);
    return ret;
  }

  /**
   * Return new entries from a stream using a consumer group, or access the history of the pending entries for a given consumer. Can block.
   * <p>
   * Redis command <a href="https://redis.io/commands/xreadgroup/">XREADGROUP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxXreadgroup(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.xreadgroup(args).onComplete($handler);
    });
  }

  /**
   * Return a range of elements in a stream, with IDs matching the specified IDs interval, in reverse order (from greater to smaller IDs) compared to XRANGE.
   * <p>
   * Redis command <a href="https://redis.io/commands/xrevrange/">XREVRANGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> xrevrange(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.xrevrange(args).map(val -> val);
    return ret;
  }

  /**
   * Return a range of elements in a stream, with IDs matching the specified IDs interval, in reverse order (from greater to smaller IDs) compared to XRANGE.
   * <p>
   * Redis command <a href="https://redis.io/commands/xrevrange/">XREVRANGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxXrevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.xrevrange(args).onComplete($handler);
    });
  }

  /**
   * An internal command for replicating stream values.
   * <p>
   * Redis command <a href="https://redis.io/commands/xsetid/">XSETID</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> xsetid(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.xsetid(args).map(val -> val);
    return ret;
  }

  /**
   * An internal command for replicating stream values.
   * <p>
   * Redis command <a href="https://redis.io/commands/xsetid/">XSETID</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxXsetid(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.xsetid(args).onComplete($handler);
    });
  }

  /**
   * Trims the stream to (approximately if &#x27;~&#x27; is passed) a certain size.
   * <p>
   * Redis command <a href="https://redis.io/commands/xtrim/">XTRIM</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> xtrim(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.xtrim(args).map(val -> val);
    return ret;
  }

  /**
   * Trims the stream to (approximately if &#x27;~&#x27; is passed) a certain size.
   * <p>
   * Redis command <a href="https://redis.io/commands/xtrim/">XTRIM</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxXtrim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.xtrim(args).onComplete($handler);
    });
  }

  /**
   * Add one or more members to a sorted set, or update its score if it already exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/zadd/">ZADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zadd(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zadd(args).map(val -> val);
    return ret;
  }

  /**
   * Add one or more members to a sorted set, or update its score if it already exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/zadd/">ZADD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zadd(args).onComplete($handler);
    });
  }

  /**
   * Get the number of members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zcard/">ZCARD</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zcard(java.lang.String arg0) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zcard(arg0).map(val -> val);
    return ret;
  }

  /**
   * Get the number of members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zcard/">ZCARD</a>.
   * @param arg0 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZcard(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zcard(arg0).onComplete($handler);
    });
  }

  /**
   * Count the members in a sorted set with scores within the given values.
   * <p>
   * Redis command <a href="https://redis.io/commands/zcount/">ZCOUNT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zcount(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Count the members in a sorted set with scores within the given values.
   * <p>
   * Redis command <a href="https://redis.io/commands/zcount/">ZCOUNT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zcount(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Subtract multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zdiff/">ZDIFF</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zdiff(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zdiff(args).map(val -> val);
    return ret;
  }

  /**
   * Subtract multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zdiff/">ZDIFF</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZdiff(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zdiff(args).onComplete($handler);
    });
  }

  /**
   * Subtract multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zdiffstore/">ZDIFFSTORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zdiffstore(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zdiffstore(args).map(val -> val);
    return ret;
  }

  /**
   * Subtract multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zdiffstore/">ZDIFFSTORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZdiffstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zdiffstore(args).onComplete($handler);
    });
  }

  /**
   * Increment the score of a member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zincrby/">ZINCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zincrby(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Increment the score of a member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zincrby/">ZINCRBY</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zincrby(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Intersect multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zinter/">ZINTER</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zinter(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zinter(args).map(val -> val);
    return ret;
  }

  /**
   * Intersect multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zinter/">ZINTER</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZinter(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zinter(args).onComplete($handler);
    });
  }

  /**
   * Intersect multiple sorted sets and return the cardinality of the result.
   * <p>
   * Redis command <a href="https://redis.io/commands/zintercard/">ZINTERCARD</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zintercard(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zintercard(args).map(val -> val);
    return ret;
  }

  /**
   * Intersect multiple sorted sets and return the cardinality of the result.
   * <p>
   * Redis command <a href="https://redis.io/commands/zintercard/">ZINTERCARD</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZintercard(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zintercard(args).onComplete($handler);
    });
  }

  /**
   * Intersect multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zinterstore/">ZINTERSTORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zinterstore(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zinterstore(args).map(val -> val);
    return ret;
  }

  /**
   * Intersect multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zinterstore/">ZINTERSTORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZinterstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zinterstore(args).onComplete($handler);
    });
  }

  /**
   * Count the number of members in a sorted set between a given lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zlexcount/">ZLEXCOUNT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zlexcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zlexcount(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Count the number of members in a sorted set between a given lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zlexcount/">ZLEXCOUNT</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZlexcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zlexcount(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Remove and return members with scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zmpop/">ZMPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zmpop(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zmpop(args).map(val -> val);
    return ret;
  }

  /**
   * Remove and return members with scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zmpop/">ZMPOP</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZmpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zmpop(args).onComplete($handler);
    });
  }

  /**
   * Get the score associated with the given members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zmscore/">ZMSCORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zmscore(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zmscore(args).map(val -> val);
    return ret;
  }

  /**
   * Get the score associated with the given members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zmscore/">ZMSCORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZmscore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zmscore(args).onComplete($handler);
    });
  }

  /**
   * Remove and return members with the highest scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zpopmax/">ZPOPMAX</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zpopmax(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zpopmax(args).map(val -> val);
    return ret;
  }

  /**
   * Remove and return members with the highest scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zpopmax/">ZPOPMAX</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZpopmax(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zpopmax(args).onComplete($handler);
    });
  }

  /**
   * Remove and return members with the lowest scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zpopmin/">ZPOPMIN</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zpopmin(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zpopmin(args).map(val -> val);
    return ret;
  }

  /**
   * Remove and return members with the lowest scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zpopmin/">ZPOPMIN</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZpopmin(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zpopmin(args).onComplete($handler);
    });
  }

  /**
   * Get one or multiple random elements from a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrandmember/">ZRANDMEMBER</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zrandmember(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zrandmember(args).map(val -> val);
    return ret;
  }

  /**
   * Get one or multiple random elements from a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrandmember/">ZRANDMEMBER</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZrandmember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zrandmember(args).onComplete($handler);
    });
  }

  /**
   * Return a range of members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrange/">ZRANGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zrange(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zrange(args).map(val -> val);
    return ret;
  }

  /**
   * Return a range of members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrange/">ZRANGE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zrange(args).onComplete($handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangebylex/">ZRANGEBYLEX</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.vertx.core.Future<io.vertx.redis.client.Response> zrangebylex(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zrangebylex(args).map(val -> val);
    return ret;
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangebylex/">ZRANGEBYLEX</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZrangebylex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zrangebylex(args).onComplete($handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by score.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangebyscore/">ZRANGEBYSCORE</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.vertx.core.Future<io.vertx.redis.client.Response> zrangebyscore(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zrangebyscore(args).map(val -> val);
    return ret;
  }

  /**
   * Return a range of members in a sorted set, by score.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangebyscore/">ZRANGEBYSCORE</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZrangebyscore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zrangebyscore(args).onComplete($handler);
    });
  }

  /**
   * Store a range of members from sorted set into another key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangestore/">ZRANGESTORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zrangestore(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zrangestore(args).map(val -> val);
    return ret;
  }

  /**
   * Store a range of members from sorted set into another key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangestore/">ZRANGESTORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZrangestore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zrangestore(args).onComplete($handler);
    });
  }

  /**
   * Determine the index of a member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrank/">ZRANK</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zrank(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zrank(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Determine the index of a member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrank/">ZRANK</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZrank(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zrank(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Remove one or more members from a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrem/">ZREM</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zrem(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zrem(args).map(val -> val);
    return ret;
  }

  /**
   * Remove one or more members from a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrem/">ZREM</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZrem(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zrem(args).onComplete($handler);
    });
  }

  /**
   * Remove all members in a sorted set between the given lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebylex/">ZREMRANGEBYLEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zremrangebylex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zremrangebylex(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Remove all members in a sorted set between the given lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebylex/">ZREMRANGEBYLEX</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZremrangebylex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zremrangebylex(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Remove all members in a sorted set within the given indexes.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebyrank/">ZREMRANGEBYRANK</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zremrangebyrank(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zremrangebyrank(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Remove all members in a sorted set within the given indexes.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebyrank/">ZREMRANGEBYRANK</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZremrangebyrank(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zremrangebyrank(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Remove all members in a sorted set within the given scores.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebyscore/">ZREMRANGEBYSCORE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zremrangebyscore(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zremrangebyscore(arg0, arg1, arg2).map(val -> val);
    return ret;
  }

  /**
   * Remove all members in a sorted set within the given scores.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebyscore/">ZREMRANGEBYSCORE</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZremrangebyscore(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zremrangebyscore(arg0, arg1, arg2).onComplete($handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by index, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrange/">ZREVRANGE</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.vertx.core.Future<io.vertx.redis.client.Response> zrevrange(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zrevrange(args).map(val -> val);
    return ret;
  }

  /**
   * Return a range of members in a sorted set, by index, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrange/">ZREVRANGE</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZrevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zrevrange(args).onComplete($handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range, ordered from higher to lower strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrangebylex/">ZREVRANGEBYLEX</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.vertx.core.Future<io.vertx.redis.client.Response> zrevrangebylex(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zrevrangebylex(args).map(val -> val);
    return ret;
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range, ordered from higher to lower strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrangebylex/">ZREVRANGEBYLEX</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZrevrangebylex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zrevrangebylex(args).onComplete($handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by score, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore/">ZREVRANGEBYSCORE</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.vertx.core.Future<io.vertx.redis.client.Response> zrevrangebyscore(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zrevrangebyscore(args).map(val -> val);
    return ret;
  }

  /**
   * Return a range of members in a sorted set, by score, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore/">ZREVRANGEBYSCORE</a>.
   * @param args 
   * @return Future response.
   */
  @Deprecated()
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZrevrangebyscore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zrevrangebyscore(args).onComplete($handler);
    });
  }

  /**
   * Determine the index of a member in a sorted set, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrank/">ZREVRANK</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zrevrank(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zrevrank(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Determine the index of a member in a sorted set, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrank/">ZREVRANK</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZrevrank(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zrevrank(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Incrementally iterate sorted sets elements and associated scores.
   * <p>
   * Redis command <a href="https://redis.io/commands/zscan/">ZSCAN</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zscan(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zscan(args).map(val -> val);
    return ret;
  }

  /**
   * Incrementally iterate sorted sets elements and associated scores.
   * <p>
   * Redis command <a href="https://redis.io/commands/zscan/">ZSCAN</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZscan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zscan(args).onComplete($handler);
    });
  }

  /**
   * Get the score associated with the given member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zscore/">ZSCORE</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zscore(java.lang.String arg0, java.lang.String arg1) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zscore(arg0, arg1).map(val -> val);
    return ret;
  }

  /**
   * Get the score associated with the given member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zscore/">ZSCORE</a>.
   * @param arg0 
   * @param arg1 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZscore(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zscore(arg0, arg1).onComplete($handler);
    });
  }

  /**
   * Add multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zunion/">ZUNION</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zunion(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zunion(args).map(val -> val);
    return ret;
  }

  /**
   * Add multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zunion/">ZUNION</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZunion(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zunion(args).onComplete($handler);
    });
  }

  /**
   * Add multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zunionstore/">ZUNIONSTORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> zunionstore(java.util.List<java.lang.String> args) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.zunionstore(args).map(val -> val);
    return ret;
  }

  /**
   * Add multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zunionstore/">ZUNIONSTORE</a>.
   * @param args 
   * @return Future response.
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxZunionstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.zunionstore(args).onComplete($handler);
    });
  }

  public static io.vertx.reactivex.redis.client.RedisAPI api(io.vertx.reactivex.redis.client.Redis client) { 
    io.vertx.reactivex.redis.client.RedisAPI ret = io.vertx.reactivex.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(client.getDelegate()));
    return ret;
  }

  public static io.vertx.reactivex.redis.client.RedisAPI api(io.vertx.reactivex.redis.client.RedisConnection connection) { 
    io.vertx.reactivex.redis.client.RedisAPI ret = io.vertx.reactivex.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(connection.getDelegate()));
    return ret;
  }

  public static RedisAPI newInstance(io.vertx.redis.client.RedisAPI arg) {
    return arg != null ? new RedisAPI(arg) : null;
  }

}
