/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.redis.client;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A simple Redis client.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.Redis original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.redis.client.Redis.class)
public class Redis implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Redis that = (Redis) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Redis> __TYPE_ARG = new TypeArg<>(    obj -> new Redis((io.vertx.redis.client.Redis) obj),
    Redis::getDelegate
  );

  private final io.vertx.redis.client.Redis delegate;
  
  public Redis(io.vertx.redis.client.Redis delegate) {
    this.delegate = delegate;
  }

  public Redis(Object delegate) {
    this.delegate = (io.vertx.redis.client.Redis)delegate;
  }

  @Override 
  public io.vertx.redis.client.Redis getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.redis.client.RedisConnection> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.redis.client.RedisConnection>(o1 -> io.vertx.reactivex.redis.client.RedisConnection.newInstance((io.vertx.redis.client.RedisConnection)o1), o1 -> o1.getDelegate());

  /**
   * Create a new Redis client using the default client options.
   * @param vertx the vertx instance
   * @return the client
   */
  public static io.vertx.reactivex.redis.client.Redis createClient(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.redis.client.Redis ret = io.vertx.reactivex.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createClient(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a new Redis client using the default client options. Does not support rediss (redis over ssl scheme) for now.
   * @param vertx the vertx instance
   * @param connectionString a string URI following the scheme: redis://[username:password@][host][:port][/database]
   * @return the client
   */
  public static io.vertx.reactivex.redis.client.Redis createClient(io.vertx.reactivex.core.Vertx vertx, java.lang.String connectionString) { 
    io.vertx.reactivex.redis.client.Redis ret = io.vertx.reactivex.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createClient(vertx.getDelegate(), connectionString));
    return ret;
  }

  /**
   * Create a new Redis client using the given client options.
   * @param vertx the Vert.x instance
   * @param options the user provided options
   * @return the client
   */
  public static io.vertx.reactivex.redis.client.Redis createClient(io.vertx.reactivex.core.Vertx vertx, io.vertx.redis.client.RedisOptions options) { 
    io.vertx.reactivex.redis.client.Redis ret = io.vertx.reactivex.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createClient(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Creates a new standalone Redis client. The <code>options</code> are used to obtain {@link io.vertx.redis.client.RedisOptions},
   * {@link io.vertx.redis.client.RedisOptions}, {@link io.vertx.redis.client.RedisOptions}
   * and {@link io.vertx.redis.client.RedisOptions}. The <code>connectOptions</code> are queried for every
   * connection attempt.
   * <p>
   * If <code>options.getType() != RedisClientType.STANDALONE</code>, an exception is thrown.
   * @param vertx the Vert.x instance
   * @param options the static options
   * @param connectOptions supplier of the dynamic options
   * @return the standalone client
   */
  public static io.vertx.reactivex.redis.client.Redis createStandaloneClient(io.vertx.reactivex.core.Vertx vertx, io.vertx.redis.client.RedisOptions options, java.util.function.Supplier<io.vertx.core.Future<io.vertx.redis.client.RedisStandaloneConnectOptions>> connectOptions) { 
    io.vertx.reactivex.redis.client.Redis ret = io.vertx.reactivex.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createStandaloneClient(vertx.getDelegate(), options, new Supplier<io.vertx.core.Future<io.vertx.redis.client.RedisStandaloneConnectOptions>>() {
      public io.vertx.core.Future<io.vertx.redis.client.RedisStandaloneConnectOptions> get() {
        io.vertx.core.Future<io.vertx.redis.client.RedisStandaloneConnectOptions> ret = connectOptions.get();
        return ret.map(val -> val);
      }
    }));
    return ret;
  }

  /**
   * Creates a new replication Redis client. The <code>options</code> are used to obtain {@link io.vertx.redis.client.RedisOptions},
   * {@link io.vertx.redis.client.RedisOptions}, {@link io.vertx.redis.client.RedisOptions}
   * and {@link io.vertx.redis.client.RedisOptions}. The <code>connectOptions</code> are queried for every
   * connection attempt.
   * <p>
   * If <code>options.getType() != RedisClientType.REPLICATION</code>, an exception is thrown.
   * @param vertx the Vert.x instance
   * @param options the static options
   * @param connectOptions supplier of the dynamic options
   * @return the replication client
   */
  public static io.vertx.reactivex.redis.client.Redis createReplicationClient(io.vertx.reactivex.core.Vertx vertx, io.vertx.redis.client.RedisOptions options, java.util.function.Supplier<io.vertx.core.Future<io.vertx.redis.client.RedisReplicationConnectOptions>> connectOptions) { 
    io.vertx.reactivex.redis.client.Redis ret = io.vertx.reactivex.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createReplicationClient(vertx.getDelegate(), options, new Supplier<io.vertx.core.Future<io.vertx.redis.client.RedisReplicationConnectOptions>>() {
      public io.vertx.core.Future<io.vertx.redis.client.RedisReplicationConnectOptions> get() {
        io.vertx.core.Future<io.vertx.redis.client.RedisReplicationConnectOptions> ret = connectOptions.get();
        return ret.map(val -> val);
      }
    }));
    return ret;
  }

  /**
   * Creates a new sentinel Redis client. The <code>options</code> are used to obtain {@link io.vertx.redis.client.RedisOptions},
   * {@link io.vertx.redis.client.RedisOptions}, {@link io.vertx.redis.client.RedisOptions}
   * and {@link io.vertx.redis.client.RedisOptions}. The <code>connectOptions</code> are queried for every
   * connection attempt.
   * <p>
   * If <code>options.getType() != RedisClientType.SENTINEL</code>, an exception is thrown.
   * @param vertx the Vert.x instance
   * @param options the static options
   * @param connectOptions supplier of the dynamic options
   * @return the sentinel client
   */
  public static io.vertx.reactivex.redis.client.Redis createSentinelClient(io.vertx.reactivex.core.Vertx vertx, io.vertx.redis.client.RedisOptions options, java.util.function.Supplier<io.vertx.core.Future<io.vertx.redis.client.RedisSentinelConnectOptions>> connectOptions) { 
    io.vertx.reactivex.redis.client.Redis ret = io.vertx.reactivex.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createSentinelClient(vertx.getDelegate(), options, new Supplier<io.vertx.core.Future<io.vertx.redis.client.RedisSentinelConnectOptions>>() {
      public io.vertx.core.Future<io.vertx.redis.client.RedisSentinelConnectOptions> get() {
        io.vertx.core.Future<io.vertx.redis.client.RedisSentinelConnectOptions> ret = connectOptions.get();
        return ret.map(val -> val);
      }
    }));
    return ret;
  }

  /**
   * Creates a new cluster Redis client. The <code>options</code> are used to obtain {@link io.vertx.redis.client.RedisOptions},
   * {@link io.vertx.redis.client.RedisOptions}, {@link io.vertx.redis.client.RedisOptions}
   * and {@link io.vertx.redis.client.RedisOptions}. The <code>connectOptions</code> are queried for every
   * connection attempt.
   * <p>
   * If <code>options.getType() != RedisClientType.CLUSTER</code>, an exception is thrown.
   * @param vertx the Vert.x instance
   * @param options the static options
   * @param connectOptions supplier of the dynamic options
   * @return the cluster client
   */
  public static io.vertx.reactivex.redis.client.Redis createClusterClient(io.vertx.reactivex.core.Vertx vertx, io.vertx.redis.client.RedisOptions options, java.util.function.Supplier<io.vertx.core.Future<io.vertx.redis.client.RedisClusterConnectOptions>> connectOptions) { 
    io.vertx.reactivex.redis.client.Redis ret = io.vertx.reactivex.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createClusterClient(vertx.getDelegate(), options, new Supplier<io.vertx.core.Future<io.vertx.redis.client.RedisClusterConnectOptions>>() {
      public io.vertx.core.Future<io.vertx.redis.client.RedisClusterConnectOptions> get() {
        io.vertx.core.Future<io.vertx.redis.client.RedisClusterConnectOptions> ret = connectOptions.get();
        return ret.map(val -> val);
      }
    }));
    return ret;
  }

  /**
   * Connects to the Redis server.
   * @return a future with the result of the operation
   */
  public io.vertx.core.Future<io.vertx.reactivex.redis.client.RedisConnection> connect() { 
    io.vertx.core.Future<io.vertx.reactivex.redis.client.RedisConnection> ret = delegate.connect().map(val -> io.vertx.reactivex.redis.client.RedisConnection.newInstance((io.vertx.redis.client.RedisConnection)val));
    return ret;
  }

  /**
   * Connects to the Redis server.
   * @return a future with the result of the operation
   */
  public io.reactivex.Single<io.vertx.reactivex.redis.client.RedisConnection> rxConnect() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.connect().onComplete($handler);
    });
  }

  /**
   * Closes the client and terminates any connection.
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Closes the client and terminates any connection.
   * @return 
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * Send the given command to the Redis server or cluster.
   * @param command the command to send
   * @return a future with the result of the operation
   */
  public io.vertx.core.Future<io.vertx.redis.client.Response> send(io.vertx.redis.client.Request command) { 
    io.vertx.core.Future<io.vertx.redis.client.Response> ret = delegate.send(command).map(val -> val);
    return ret;
  }

  /**
   * Send the given command to the Redis server or cluster.
   * @param command the command to send
   * @return a future with the result of the operation
   */
  public io.reactivex.Maybe<io.vertx.redis.client.Response> rxSend(io.vertx.redis.client.Request command) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.send(command).onComplete($handler);
    });
  }

  /**
   * Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
   * client users.
   * @param commands list of command to send
   * @return a future with the result of the operation
   */
  public io.vertx.core.Future<java.util.List<io.vertx.redis.client.Response>> batch(java.util.List<io.vertx.redis.client.Request> commands) { 
    io.vertx.core.Future<java.util.List<io.vertx.redis.client.Response>> ret = delegate.batch(commands).map(val -> val);
    return ret;
  }

  /**
   * Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
   * client users.
   * @param commands list of command to send
   * @return a future with the result of the operation
   */
  public io.reactivex.Single<java.util.List<io.vertx.redis.client.Response>> rxBatch(java.util.List<io.vertx.redis.client.Request> commands) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.batch(commands).onComplete($handler);
    });
  }

  public static Redis newInstance(io.vertx.redis.client.Redis arg) {
    return arg != null ? new Redis(arg) : null;
  }

}
