/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.rabbitmq;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A stream of messages from a rabbitmq queue.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.rabbitmq.RabbitMQConsumer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.rabbitmq.RabbitMQConsumer.class)
public class RabbitMQConsumer implements RxDelegate, io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.rabbitmq.RabbitMQMessage> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RabbitMQConsumer that = (RabbitMQConsumer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RabbitMQConsumer> __TYPE_ARG = new TypeArg<>(    obj -> new RabbitMQConsumer((io.vertx.rabbitmq.RabbitMQConsumer) obj),
    RabbitMQConsumer::getDelegate
  );

  private final io.vertx.rabbitmq.RabbitMQConsumer delegate;
  
  public RabbitMQConsumer(io.vertx.rabbitmq.RabbitMQConsumer delegate) {
    this.delegate = delegate;
  }

  public RabbitMQConsumer(Object delegate) {
    this.delegate = (io.vertx.rabbitmq.RabbitMQConsumer)delegate;
  }

  @Override 
  public io.vertx.rabbitmq.RabbitMQConsumer getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.reactivex.rabbitmq.RabbitMQMessage> observable;
  private io.reactivex.Flowable<io.vertx.reactivex.rabbitmq.RabbitMQMessage> flowable;

  public synchronized io.reactivex.Observable<io.vertx.reactivex.rabbitmq.RabbitMQMessage> toObservable() {
    if (observable == null) {
      Function<io.vertx.rabbitmq.RabbitMQMessage, io.vertx.reactivex.rabbitmq.RabbitMQMessage> conv = io.vertx.reactivex.rabbitmq.RabbitMQMessage::newInstance;
      observable = ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.reactivex.rabbitmq.RabbitMQMessage> toFlowable() {
    if (flowable == null) {
      Function<io.vertx.rabbitmq.RabbitMQMessage, io.vertx.reactivex.rabbitmq.RabbitMQMessage> conv = io.vertx.reactivex.rabbitmq.RabbitMQMessage::newInstance;
      flowable = FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  private static final TypeArg<io.vertx.reactivex.rabbitmq.RabbitMQMessage> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.rabbitmq.RabbitMQMessage>(o1 -> io.vertx.reactivex.rabbitmq.RabbitMQMessage.newInstance((io.vertx.rabbitmq.RabbitMQMessage)o1), o1 -> o1.getDelegate());

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.rabbitmq.RabbitMQMessage> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.rabbitmq.RabbitMQMessage> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.vertx.core.Future<java.lang.Void> pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.rabbitmq.RabbitMQMessage> dst) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.pipeTo(dst.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.reactivex.Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.rabbitmq.RabbitMQMessage> dst) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.pipeTo(dst).onComplete($handler);
    });
  }

  /**
   * Set an exception handler on the read stream.
   * @param exceptionHandler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.rabbitmq.RabbitMQConsumer exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> exceptionHandler) { 
    delegate.exceptionHandler(exceptionHandler);
    return this;
  }

  /**
   * Set a message handler. As message appear in a queue, the handler will be called with the message.
   * @param messageArrived 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.rabbitmq.RabbitMQConsumer handler(io.vertx.core.Handler<io.vertx.reactivex.rabbitmq.RabbitMQMessage> messageArrived) { 
    delegate.handler(io.vertx.lang.reactivex.Helper.convertHandler(messageArrived, event -> io.vertx.reactivex.rabbitmq.RabbitMQMessage.newInstance((io.vertx.rabbitmq.RabbitMQMessage)event)));
    return this;
  }

  /**
   * Pause the stream of incoming messages from queue.
   * <p>
   * The messages will continue to arrive, but they will be stored in a internal queue.
   * If the queue size would exceed the limit provided by , then incoming messages will be discarded.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.rabbitmq.RabbitMQConsumer pause() { 
    delegate.pause();
    return this;
  }

  /**
   * Resume reading from a queue. Flushes internal queue.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.rabbitmq.RabbitMQConsumer resume() { 
    delegate.resume();
    return this;
  }

  /**
   * Set an end handler. Once the stream has canceled successfully, the handler will be called.
   * @param endHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.rabbitmq.RabbitMQConsumer endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * @return the name of the queue
   */
  public java.lang.String queueName() { 
    java.lang.String ret = delegate.queueName();
    return ret;
  }

  /**
   * Set the name of the queue.
   * This method is typically only required during a connectionEstablishedCallback when the queue name has changed.
   * @param name the name of the queue
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.rabbitmq.RabbitMQConsumer setQueueName(java.lang.String name) { 
    delegate.setQueueName(name);
    return this;
  }

  /**
   * @return a consumer tag
   */
  public java.lang.String consumerTag() { 
    java.lang.String ret = delegate.consumerTag();
    return ret;
  }

  /**
   * Stop message consumption from a queue.
   * <p>
   * The operation is asynchronous. When consumption is stopped, you can also be notified via {@link io.vertx.reactivex.rabbitmq.RabbitMQConsumer#endHandler}
   * @return a future through which you can find out the operation status.
   */
  public io.vertx.core.Future<java.lang.Void> cancel() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.cancel().map(val -> val);
    return ret;
  }

  /**
   * Stop message consumption from a queue.
   * <p>
   * The operation is asynchronous. When consumption is stopped, you can also be notified via {@link io.vertx.reactivex.rabbitmq.RabbitMQConsumer#endHandler}
   * @return a future through which you can find out the operation status.
   */
  public io.reactivex.Completable rxCancel() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.cancel().onComplete($handler);
    });
  }

  /**
   * Return <code>true</code> if cancel() has been called.
   * @return <code>true</code> if cancel() has been called.
   */
  public boolean isCancelled() { 
    boolean ret = delegate.isCancelled();
    return ret;
  }

  /**
   * @return is the stream paused?
   */
  public boolean isPaused() { 
    boolean ret = delegate.isPaused();
    return ret;
  }

  /**
   * Fetch the specified <code>amount</code> of elements. If the <code>ReadStream</code> has been paused, reading will
   * recommence with the specified <code>amount</code> of items, otherwise the specified <code>amount</code> will
   * be added to the current stream demand.
   * @param amount 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.rabbitmq.RabbitMQConsumer fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public static RabbitMQConsumer newInstance(io.vertx.rabbitmq.RabbitMQConsumer arg) {
    return arg != null ? new RabbitMQConsumer(arg) : null;
  }

}
