/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.rabbitmq;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.rabbitmq.RabbitMQClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.rabbitmq.RabbitMQClient.class)
public class RabbitMQClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RabbitMQClient that = (RabbitMQClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RabbitMQClient> __TYPE_ARG = new TypeArg<>(    obj -> new RabbitMQClient((io.vertx.rabbitmq.RabbitMQClient) obj),
    RabbitMQClient::getDelegate
  );

  private final io.vertx.rabbitmq.RabbitMQClient delegate;
  
  public RabbitMQClient(io.vertx.rabbitmq.RabbitMQClient delegate) {
    this.delegate = delegate;
  }

  public RabbitMQClient(Object delegate) {
    this.delegate = (io.vertx.rabbitmq.RabbitMQClient)delegate;
  }

  @Override 
  public io.vertx.rabbitmq.RabbitMQClient getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.rabbitmq.RabbitMQMessage> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.rabbitmq.RabbitMQMessage>(o1 -> io.vertx.reactivex.rabbitmq.RabbitMQMessage.newInstance((io.vertx.rabbitmq.RabbitMQMessage)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.rabbitmq.RabbitMQConsumer> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.rabbitmq.RabbitMQConsumer>(o1 -> io.vertx.reactivex.rabbitmq.RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.rabbitmq.RabbitMQConsumer> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.rabbitmq.RabbitMQConsumer>(o1 -> io.vertx.reactivex.rabbitmq.RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.streams.ReadStream<io.vertx.rabbitmq.RabbitMQConfirmation>> TYPE_ARG_3 = new TypeArg<io.vertx.reactivex.core.streams.ReadStream<io.vertx.rabbitmq.RabbitMQConfirmation>>(o1 -> io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)o1, TypeArg.unknown()), o1 -> o1.getDelegate());

  /**
   * Create and return a client configured with the default options.
   * @param vertx the vertx instance
   * @return the client
   */
  public static io.vertx.reactivex.rabbitmq.RabbitMQClient create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.rabbitmq.RabbitMQClient ret = io.vertx.reactivex.rabbitmq.RabbitMQClient.newInstance((io.vertx.rabbitmq.RabbitMQClient)io.vertx.rabbitmq.RabbitMQClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create and return a client.
   * @param vertx the vertx instance
   * @param config the client config
   * @return the client
   */
  public static io.vertx.reactivex.rabbitmq.RabbitMQClient create(io.vertx.reactivex.core.Vertx vertx, io.vertx.rabbitmq.RabbitMQOptions config) { 
    io.vertx.reactivex.rabbitmq.RabbitMQClient ret = io.vertx.reactivex.rabbitmq.RabbitMQClient.newInstance((io.vertx.rabbitmq.RabbitMQClient)io.vertx.rabbitmq.RabbitMQClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Acknowledge one or several received messages. Supply the deliveryTag from the AMQP.Basic.GetOk or AMQP.Basic.Deliver
   * method containing the received message being acknowledged.
   * @param deliveryTag 
   * @param multiple 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> basicAck(long deliveryTag, boolean multiple) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.basicAck(deliveryTag, multiple).map(val -> val);
    return ret;
  }

  /**
   * Acknowledge one or several received messages. Supply the deliveryTag from the AMQP.Basic.GetOk or AMQP.Basic.Deliver
   * method containing the received message being acknowledged.
   * @param deliveryTag 
   * @param multiple 
   * @return 
   */
  public io.reactivex.Completable rxBasicAck(long deliveryTag, boolean multiple) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.basicAck(deliveryTag, multiple).onComplete($handler);
    });
  }

  /**
   * Reject one or several received messages.
   * @param deliveryTag 
   * @param multiple 
   * @param requeue 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> basicNack(long deliveryTag, boolean multiple, boolean requeue) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.basicNack(deliveryTag, multiple, requeue).map(val -> val);
    return ret;
  }

  /**
   * Reject one or several received messages.
   * @param deliveryTag 
   * @param multiple 
   * @param requeue 
   * @return 
   */
  public io.reactivex.Completable rxBasicNack(long deliveryTag, boolean multiple, boolean requeue) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.basicNack(deliveryTag, multiple, requeue).onComplete($handler);
    });
  }

  /**
   * Retrieve a message from a queue using AMQP.Basic.Get
   * @param queue 
   * @param autoAck 
   * @return 
   */
  public io.vertx.core.Future<io.vertx.reactivex.rabbitmq.RabbitMQMessage> basicGet(java.lang.String queue, boolean autoAck) { 
    io.vertx.core.Future<io.vertx.reactivex.rabbitmq.RabbitMQMessage> ret = delegate.basicGet(queue, autoAck).map(val -> io.vertx.reactivex.rabbitmq.RabbitMQMessage.newInstance((io.vertx.rabbitmq.RabbitMQMessage)val));
    return ret;
  }

  /**
   * Retrieve a message from a queue using AMQP.Basic.Get
   * @param queue 
   * @param autoAck 
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.rabbitmq.RabbitMQMessage> rxBasicGet(java.lang.String queue, boolean autoAck) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.basicGet(queue, autoAck).onComplete($handler);
    });
  }

  /**
   * @param queue 
   * @return 
   */
  public io.vertx.core.Future<io.vertx.reactivex.rabbitmq.RabbitMQConsumer> basicConsumer(java.lang.String queue) { 
    io.vertx.core.Future<io.vertx.reactivex.rabbitmq.RabbitMQConsumer> ret = delegate.basicConsumer(queue).map(val -> io.vertx.reactivex.rabbitmq.RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)val));
    return ret;
  }

  /**
   * @param queue 
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.rabbitmq.RabbitMQConsumer> rxBasicConsumer(java.lang.String queue) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.basicConsumer(queue).onComplete($handler);
    });
  }

  /**
   * Create a consumer with the given <code>options</code>.
   * @param queue the name of a queue
   * @param options options for queue
   * @return a future completed with the operation status; if the operation succeeds you can begin to receive messages through an instance of {@link io.vertx.reactivex.rabbitmq.RabbitMQConsumer}
   */
  public io.vertx.core.Future<io.vertx.reactivex.rabbitmq.RabbitMQConsumer> basicConsumer(java.lang.String queue, io.vertx.rabbitmq.QueueOptions options) { 
    io.vertx.core.Future<io.vertx.reactivex.rabbitmq.RabbitMQConsumer> ret = delegate.basicConsumer(queue, options).map(val -> io.vertx.reactivex.rabbitmq.RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)val));
    return ret;
  }

  /**
   * Create a consumer with the given <code>options</code>.
   * @param queue the name of a queue
   * @param options options for queue
   * @return a future completed with the operation status; if the operation succeeds you can begin to receive messages through an instance of {@link io.vertx.reactivex.rabbitmq.RabbitMQConsumer}
   */
  public io.reactivex.Single<io.vertx.reactivex.rabbitmq.RabbitMQConsumer> rxBasicConsumer(java.lang.String queue, io.vertx.rabbitmq.QueueOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.basicConsumer(queue, options).onComplete($handler);
    });
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   * @param exchange 
   * @param routingKey 
   * @param body 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> basicPublish(java.lang.String exchange, java.lang.String routingKey, io.vertx.core.buffer.Buffer body) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.basicPublish(exchange, routingKey, body).map(val -> val);
    return ret;
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   * @param exchange 
   * @param routingKey 
   * @param body 
   * @return 
   */
  public io.reactivex.Completable rxBasicPublish(java.lang.String exchange, java.lang.String routingKey, io.vertx.core.buffer.Buffer body) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.basicPublish(exchange, routingKey, body).onComplete($handler);
    });
  }

  /**
   * Add a Confirm Listener to the channel.
   * Note that this will automatically call confirmSelect, it is not necessary to call that too.
   * @param maxQueueSize maximum size of the queue of confirmations
   * @return a future completed with a stream of confirmations if the operation succeeds
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.streams.ReadStream<io.vertx.rabbitmq.RabbitMQConfirmation>> addConfirmListener(int maxQueueSize) { 
    io.vertx.core.Future<io.vertx.reactivex.core.streams.ReadStream<io.vertx.rabbitmq.RabbitMQConfirmation>> ret = delegate.addConfirmListener(maxQueueSize).map(val -> io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)val, TypeArg.unknown()));
    return ret;
  }

  /**
   * Add a Confirm Listener to the channel.
   * Note that this will automatically call confirmSelect, it is not necessary to call that too.
   * @param maxQueueSize maximum size of the queue of confirmations
   * @return a future completed with a stream of confirmations if the operation succeeds
   */
  public io.reactivex.Flowable<io.vertx.rabbitmq.RabbitMQConfirmation> rxAddConfirmListener(int maxQueueSize) { 
    return AsyncResultFlowable.toFlowable($handler -> {
      this.addConfirmListener(maxQueueSize).map(stream_ -> (io.vertx.core.streams.ReadStream<io.vertx.rabbitmq.RabbitMQConfirmation>)stream_.getDelegate()).onComplete($handler);
    });
  }

  /**
   * Enables publisher acknowledgements on this channel. Can be called once during client initialisation. Calls to basicPublish()
   * will have to be confirmed.
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> confirmSelect() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.confirmSelect().map(val -> val);
    return ret;
  }

  /**
   * Enables publisher acknowledgements on this channel. Can be called once during client initialisation. Calls to basicPublish()
   * will have to be confirmed.
   * @return 
   */
  public io.reactivex.Completable rxConfirmSelect() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.confirmSelect().onComplete($handler);
    });
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker.
   * This will incur slight performance loss at the expense of higher write consistency.
   * If desired, multiple calls to basicPublish() can be batched before confirming.
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> waitForConfirms() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.waitForConfirms().map(val -> val);
    return ret;
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker.
   * This will incur slight performance loss at the expense of higher write consistency.
   * If desired, multiple calls to basicPublish() can be batched before confirming.
   * @return 
   */
  public io.reactivex.Completable rxWaitForConfirms() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.waitForConfirms().onComplete($handler);
    });
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker; or until timeout elapses. If the timeout expires a TimeoutException is thrown.
   * @param timeout 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> waitForConfirms(long timeout) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.waitForConfirms(timeout).map(val -> val);
    return ret;
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker; or until timeout elapses. If the timeout expires a TimeoutException is thrown.
   * @param timeout 
   * @return 
   */
  public io.reactivex.Completable rxWaitForConfirms(long timeout) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.waitForConfirms(timeout).onComplete($handler);
    });
  }

  /**
   * Request a specific prefetchCount "quality of service" settings
   * for this channel.
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> basicQos(int prefetchCount) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.basicQos(prefetchCount).map(val -> val);
    return ret;
  }

  /**
   * Request a specific prefetchCount "quality of service" settings
   * for this channel.
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @return 
   */
  public io.reactivex.Completable rxBasicQos(int prefetchCount) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.basicQos(prefetchCount).onComplete($handler);
    });
  }

  /**
   * Request a specific prefetchCount "quality of service" settings
   * for this channel.
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @param global true if the settings should be applied to the entire channel rather than each consumer
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> basicQos(int prefetchCount, boolean global) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.basicQos(prefetchCount, global).map(val -> val);
    return ret;
  }

  /**
   * Request a specific prefetchCount "quality of service" settings
   * for this channel.
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @param global true if the settings should be applied to the entire channel rather than each consumer
   * @return 
   */
  public io.reactivex.Completable rxBasicQos(int prefetchCount, boolean global) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.basicQos(prefetchCount, global).onComplete($handler);
    });
  }

  /**
   * Request specific "quality of service" settings.
   *
   * These settings impose limits on the amount of data the server
   * will deliver to consumers before requiring acknowledgements.
   * Thus they provide a means of consumer-initiated flow control.
   * @param prefetchSize maximum amount of content (measured in octets) that the server will deliver, 0 if unlimited
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @param global true if the settings should be applied to the entire channel rather than each consumer
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> basicQos(int prefetchSize, int prefetchCount, boolean global) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.basicQos(prefetchSize, prefetchCount, global).map(val -> val);
    return ret;
  }

  /**
   * Request specific "quality of service" settings.
   *
   * These settings impose limits on the amount of data the server
   * will deliver to consumers before requiring acknowledgements.
   * Thus they provide a means of consumer-initiated flow control.
   * @param prefetchSize maximum amount of content (measured in octets) that the server will deliver, 0 if unlimited
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @param global true if the settings should be applied to the entire channel rather than each consumer
   * @return 
   */
  public io.reactivex.Completable rxBasicQos(int prefetchSize, int prefetchCount, boolean global) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.basicQos(prefetchSize, prefetchCount, global).onComplete($handler);
    });
  }

  /**
   * Declare an exchange.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> exchangeDeclare(java.lang.String exchange, java.lang.String type, boolean durable, boolean autoDelete) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.exchangeDeclare(exchange, type, durable, autoDelete).map(val -> val);
    return ret;
  }

  /**
   * Declare an exchange.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @return 
   */
  public io.reactivex.Completable rxExchangeDeclare(java.lang.String exchange, java.lang.String type, boolean durable, boolean autoDelete) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.exchangeDeclare(exchange, type, durable, autoDelete).onComplete($handler);
    });
  }

  /**
   * Declare an exchange with additional parameters such as dead lettering, an alternate exchange or TTL.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @param config 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> exchangeDeclare(java.lang.String exchange, java.lang.String type, boolean durable, boolean autoDelete, io.vertx.core.json.JsonObject config) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.exchangeDeclare(exchange, type, durable, autoDelete, config).map(val -> val);
    return ret;
  }

  /**
   * Declare an exchange with additional parameters such as dead lettering, an alternate exchange or TTL.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @param config 
   * @return 
   */
  public io.reactivex.Completable rxExchangeDeclare(java.lang.String exchange, java.lang.String type, boolean durable, boolean autoDelete, io.vertx.core.json.JsonObject config) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.exchangeDeclare(exchange, type, durable, autoDelete, config).onComplete($handler);
    });
  }

  /**
   * Delete an exchange, without regard for whether it is in use or not.
   * @param exchange 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> exchangeDelete(java.lang.String exchange) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.exchangeDelete(exchange).map(val -> val);
    return ret;
  }

  /**
   * Delete an exchange, without regard for whether it is in use or not.
   * @param exchange 
   * @return 
   */
  public io.reactivex.Completable rxExchangeDelete(java.lang.String exchange) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.exchangeDelete(exchange).onComplete($handler);
    });
  }

  /**
   * Bind an exchange to an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> exchangeBind(java.lang.String destination, java.lang.String source, java.lang.String routingKey) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.exchangeBind(destination, source, routingKey).map(val -> val);
    return ret;
  }

  /**
   * Bind an exchange to an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @return 
   */
  public io.reactivex.Completable rxExchangeBind(java.lang.String destination, java.lang.String source, java.lang.String routingKey) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.exchangeBind(destination, source, routingKey).onComplete($handler);
    });
  }

  /**
   * Bind an exchange to an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param arguments 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> exchangeBind(java.lang.String destination, java.lang.String source, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.exchangeBind(destination, source, routingKey, arguments).map(val -> val);
    return ret;
  }

  /**
   * Bind an exchange to an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param arguments 
   * @return 
   */
  public io.reactivex.Completable rxExchangeBind(java.lang.String destination, java.lang.String source, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.exchangeBind(destination, source, routingKey, arguments).onComplete($handler);
    });
  }

  /**
   * Unbind an exchange from an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> exchangeUnbind(java.lang.String destination, java.lang.String source, java.lang.String routingKey) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.exchangeUnbind(destination, source, routingKey).map(val -> val);
    return ret;
  }

  /**
   * Unbind an exchange from an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @return 
   */
  public io.reactivex.Completable rxExchangeUnbind(java.lang.String destination, java.lang.String source, java.lang.String routingKey) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.exchangeUnbind(destination, source, routingKey).onComplete($handler);
    });
  }

  /**
   * Unbind an exchange from an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param arguments 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> exchangeUnbind(java.lang.String destination, java.lang.String source, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.exchangeUnbind(destination, source, routingKey, arguments).map(val -> val);
    return ret;
  }

  /**
   * Unbind an exchange from an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param arguments 
   * @return 
   */
  public io.reactivex.Completable rxExchangeUnbind(java.lang.String destination, java.lang.String source, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.exchangeUnbind(destination, source, routingKey, arguments).onComplete($handler);
    });
  }

  /**
   * Actively declare a server-named exclusive, autodelete, non-durable queue.
   * @return 
   */
  public io.vertx.core.Future<io.vertx.core.json.JsonObject> queueDeclareAuto() { 
    io.vertx.core.Future<io.vertx.core.json.JsonObject> ret = delegate.queueDeclareAuto().map(val -> val);
    return ret;
  }

  /**
   * Actively declare a server-named exclusive, autodelete, non-durable queue.
   * @return 
   */
  public io.reactivex.Single<io.vertx.core.json.JsonObject> rxQueueDeclareAuto() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.queueDeclareAuto().onComplete($handler);
    });
  }

  /**
   * Bind a queue to an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> queueBind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.queueBind(queue, exchange, routingKey).map(val -> val);
    return ret;
  }

  /**
   * Bind a queue to an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @return 
   */
  public io.reactivex.Completable rxQueueBind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.queueBind(queue, exchange, routingKey).onComplete($handler);
    });
  }

  /**
   * Bind a queue to an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param arguments 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> queueBind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.queueBind(queue, exchange, routingKey, arguments).map(val -> val);
    return ret;
  }

  /**
   * Bind a queue to an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param arguments 
   * @return 
   */
  public io.reactivex.Completable rxQueueBind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.queueBind(queue, exchange, routingKey, arguments).onComplete($handler);
    });
  }

  /**
   * Unbind a queue from an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> queueUnbind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.queueUnbind(queue, exchange, routingKey).map(val -> val);
    return ret;
  }

  /**
   * Unbind a queue from an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @return 
   */
  public io.reactivex.Completable rxQueueUnbind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.queueUnbind(queue, exchange, routingKey).onComplete($handler);
    });
  }

  /**
   * Unbind a queue from an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param arguments 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> queueUnbind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.queueUnbind(queue, exchange, routingKey, arguments).map(val -> val);
    return ret;
  }

  /**
   * Unbind a queue from an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param arguments 
   * @return 
   */
  public io.reactivex.Completable rxQueueUnbind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.queueUnbind(queue, exchange, routingKey, arguments).onComplete($handler);
    });
  }

  /**
   * Returns the number of messages in a queue ready to be delivered.
   * @param queue 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Long> messageCount(java.lang.String queue) { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.messageCount(queue).map(val -> val);
    return ret;
  }

  /**
   * Returns the number of messages in a queue ready to be delivered.
   * @param queue 
   * @return 
   */
  public io.reactivex.Single<java.lang.Long> rxMessageCount(java.lang.String queue) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.messageCount(queue).onComplete($handler);
    });
  }

  /**
   * Start the rabbitMQ client. Create the connection and the channel.
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> start() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.start().map(val -> val);
    return ret;
  }

  /**
   * Start the rabbitMQ client. Create the connection and the channel.
   * @return 
   */
  public io.reactivex.Completable rxStart() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.start().onComplete($handler);
    });
  }

  /**
   * Stop the rabbitMQ client. Close the connection and its channel.
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> stop() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.stop().map(val -> val);
    return ret;
  }

  /**
   * Stop the rabbitMQ client. Close the connection and its channel.
   * @return 
   */
  public io.reactivex.Completable rxStop() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.stop().onComplete($handler);
    });
  }

  /**
   * Check if a connection is open
   * @return true when the connection is open, false otherwise
   */
  public boolean isConnected() { 
    boolean ret = delegate.isConnected();
    return ret;
  }

  /**
   * restart the rabbitMQ connect.
   * @param attempts number of attempts
   * @return a future notified when the operation is done with a result of the operation
   */
  public io.vertx.core.Future<java.lang.Void> restartConnect(int attempts) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.restartConnect(attempts).map(val -> val);
    return ret;
  }

  /**
   * restart the rabbitMQ connect.
   * @param attempts number of attempts
   * @return a future notified when the operation is done with a result of the operation
   */
  public io.reactivex.Completable rxRestartConnect(int attempts) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.restartConnect(attempts).onComplete($handler);
    });
  }

  /**
   * Check if a channel is open
   * @return true when the connection is open, false otherwise
   */
  public boolean isOpenChannel() { 
    boolean ret = delegate.isOpenChannel();
    return ret;
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> basicPublish(java.lang.String exchange, java.lang.String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.core.buffer.Buffer body) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.basicPublish(exchange, routingKey, properties, body).map(val -> val);
    return ret;
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   * @return 
   */
  public io.reactivex.Completable rxBasicPublish(java.lang.String exchange, java.lang.String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.core.buffer.Buffer body) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.basicPublish(exchange, routingKey, properties, body).onComplete($handler);
    });
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   *
   * The deliveryTagHandler will be called before the message is sent, which is necessary because the confirmation may arrive
   * asynchronously before the resultHandler is called.
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   * @param deliveryTagHandler callback to capture the deliveryTag for this message. Note that this will be called synchronously in the context of the client before the result is known.
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> basicPublishWithDeliveryTag(java.lang.String exchange, java.lang.String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.core.buffer.Buffer body, io.vertx.core.Handler<java.lang.Long> deliveryTagHandler) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.basicPublishWithDeliveryTag(exchange, routingKey, properties, body, deliveryTagHandler).map(val -> val);
    return ret;
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   *
   * The deliveryTagHandler will be called before the message is sent, which is necessary because the confirmation may arrive
   * asynchronously before the resultHandler is called.
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   * @param deliveryTagHandler callback to capture the deliveryTag for this message. Note that this will be called synchronously in the context of the client before the result is known.
   * @return 
   */
  public io.reactivex.Completable rxBasicPublishWithDeliveryTag(java.lang.String exchange, java.lang.String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.core.buffer.Buffer body, io.vertx.core.Handler<java.lang.Long> deliveryTagHandler) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.basicPublishWithDeliveryTag(exchange, routingKey, properties, body, deliveryTagHandler).onComplete($handler);
    });
  }

  /**
   * Declare a queue
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @return 
   */
  public io.vertx.core.Future<com.rabbitmq.client.AMQP.Queue.DeclareOk> queueDeclare(java.lang.String queue, boolean durable, boolean exclusive, boolean autoDelete) { 
    io.vertx.core.Future<com.rabbitmq.client.AMQP.Queue.DeclareOk> ret = delegate.queueDeclare(queue, durable, exclusive, autoDelete).map(val -> val);
    return ret;
  }

  /**
   * Declare a queue
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @return 
   */
  public io.reactivex.Single<com.rabbitmq.client.AMQP.Queue.DeclareOk> rxQueueDeclare(java.lang.String queue, boolean durable, boolean exclusive, boolean autoDelete) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.queueDeclare(queue, durable, exclusive, autoDelete).onComplete($handler);
    });
  }

  /**
   * Declare a queue with config options
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @param config 
   * @return 
   */
  public io.vertx.core.Future<com.rabbitmq.client.AMQP.Queue.DeclareOk> queueDeclare(java.lang.String queue, boolean durable, boolean exclusive, boolean autoDelete, io.vertx.core.json.JsonObject config) { 
    io.vertx.core.Future<com.rabbitmq.client.AMQP.Queue.DeclareOk> ret = delegate.queueDeclare(queue, durable, exclusive, autoDelete, config).map(val -> val);
    return ret;
  }

  /**
   * Declare a queue with config options
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @param config 
   * @return 
   */
  public io.reactivex.Single<com.rabbitmq.client.AMQP.Queue.DeclareOk> rxQueueDeclare(java.lang.String queue, boolean durable, boolean exclusive, boolean autoDelete, io.vertx.core.json.JsonObject config) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.queueDeclare(queue, durable, exclusive, autoDelete, config).onComplete($handler);
    });
  }

  /**
   * Delete a queue, without regard for whether it is in use or has messages on it
   * @param queue 
   * @return 
   */
  public io.vertx.core.Future<com.rabbitmq.client.AMQP.Queue.DeleteOk> queueDelete(java.lang.String queue) { 
    io.vertx.core.Future<com.rabbitmq.client.AMQP.Queue.DeleteOk> ret = delegate.queueDelete(queue).map(val -> val);
    return ret;
  }

  /**
   * Delete a queue, without regard for whether it is in use or has messages on it
   * @param queue 
   * @return 
   */
  public io.reactivex.Single<com.rabbitmq.client.AMQP.Queue.DeleteOk> rxQueueDelete(java.lang.String queue) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.queueDelete(queue).onComplete($handler);
    });
  }

  /**
   * Delete a queue
   * @param queue 
   * @param ifUnused 
   * @param ifEmpty 
   * @return 
   */
  public io.vertx.core.Future<com.rabbitmq.client.AMQP.Queue.DeleteOk> queueDeleteIf(java.lang.String queue, boolean ifUnused, boolean ifEmpty) { 
    io.vertx.core.Future<com.rabbitmq.client.AMQP.Queue.DeleteOk> ret = delegate.queueDeleteIf(queue, ifUnused, ifEmpty).map(val -> val);
    return ret;
  }

  /**
   * Delete a queue
   * @param queue 
   * @param ifUnused 
   * @param ifEmpty 
   * @return 
   */
  public io.reactivex.Single<com.rabbitmq.client.AMQP.Queue.DeleteOk> rxQueueDeleteIf(java.lang.String queue, boolean ifUnused, boolean ifEmpty) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.queueDeleteIf(queue, ifUnused, ifEmpty).onComplete($handler);
    });
  }

  public static RabbitMQClient newInstance(io.vertx.rabbitmq.RabbitMQClient arg) {
    return arg != null ? new RabbitMQClient(arg) : null;
  }

}
