/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.pgclient.pubsub;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A channel to Postgres that tracks the subscription to a given Postgres channel using the <code>LISTEN/UNLISTEN</code> commands.
 * <p/>
 * When paused the channel discards the messages.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.pgclient.pubsub.PgChannel original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.pgclient.pubsub.PgChannel.class)
public class PgChannel implements RxDelegate, io.vertx.reactivex.core.streams.ReadStream<java.lang.String> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PgChannel that = (PgChannel) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PgChannel> __TYPE_ARG = new TypeArg<>(    obj -> new PgChannel((io.vertx.pgclient.pubsub.PgChannel) obj),
    PgChannel::getDelegate
  );

  private final io.vertx.pgclient.pubsub.PgChannel delegate;
  
  public PgChannel(io.vertx.pgclient.pubsub.PgChannel delegate) {
    this.delegate = delegate;
  }

  public PgChannel(Object delegate) {
    this.delegate = (io.vertx.pgclient.pubsub.PgChannel)delegate;
  }

  @Override 
  public io.vertx.pgclient.pubsub.PgChannel getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<java.lang.String> observable;
  private io.reactivex.Flowable<java.lang.String> flowable;

  public synchronized io.reactivex.Observable<java.lang.String> toObservable() {
    if (observable == null) {
      observable = ObservableHelper.toObservable(this.getDelegate());
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<java.lang.String> toFlowable() {
    if (flowable == null) {
      flowable = FlowableHelper.toFlowable(this.getDelegate());
    }
    return flowable;
  }


  /**
   * Fetch the specified <code>amount</code> of elements. If the <code>ReadStream</code> has been paused, reading will
   * recommence with the specified <code>amount</code> of items, otherwise the specified <code>amount</code> will
   * be added to the current stream demand.
   * @param amount 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.streams.ReadStream<java.lang.String> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<java.lang.String> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<java.lang.String> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TypeArg.unknown());
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.vertx.core.Future<java.lang.Void> pipeTo(io.vertx.reactivex.core.streams.WriteStream<java.lang.String> dst) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.pipeTo(dst.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.reactivex.Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<java.lang.String> dst) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.pipeTo(dst).onComplete($handler);
    });
  }

  /**
   * Set an handler called when the the channel get subscribed.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.pgclient.pubsub.PgChannel subscribeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.subscribeHandler(handler);
    return this;
  }

  /**
   * Set or unset an handler to be called when a the channel is notified by Postgres.
   * <p/>
   * <ul>
   *   <li>when the handler is set, the subscriber sends a <code>LISTEN</code> command if needed</li>
   *   <li>when the handler is unset, the subscriber sends a <code>UNLISTEN</code> command if needed</li>
   * </ul>
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.pgclient.pubsub.PgChannel handler(io.vertx.core.Handler<java.lang.String> handler) { 
    delegate.handler(handler);
    return this;
  }

  /**
   * Pause the channel, all notifications are discarded.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.pgclient.pubsub.PgChannel pause() { 
    delegate.pause();
    return this;
  }

  /**
   * Resume the channel.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.pgclient.pubsub.PgChannel resume() { 
    delegate.resume();
    return this;
  }

  /**
   * Set an handler to be called when no more notifications will be received.
   * @param endHandler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.pgclient.pubsub.PgChannel endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.reactivex.pgclient.pubsub.PgChannel exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public static PgChannel newInstance(io.vertx.pgclient.pubsub.PgChannel arg) {
    return arg != null ? new PgChannel(arg) : null;
  }

}
