/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.pgclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Entry point for building PostgreSQL clients.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.pgclient.PgBuilder original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.pgclient.PgBuilder.class)
public class PgBuilder implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PgBuilder that = (PgBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PgBuilder> __TYPE_ARG = new TypeArg<>(    obj -> new PgBuilder((io.vertx.pgclient.PgBuilder) obj),
    PgBuilder::getDelegate
  );

  private final io.vertx.pgclient.PgBuilder delegate;
  
  public PgBuilder(io.vertx.pgclient.PgBuilder delegate) {
    this.delegate = delegate;
  }

  public PgBuilder(Object delegate) {
    this.delegate = (io.vertx.pgclient.PgBuilder)delegate;
  }

  @Override 
  public io.vertx.pgclient.PgBuilder getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.sqlclient.Pool> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.sqlclient.Pool>(o1 -> io.vertx.reactivex.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.sqlclient.SqlClient> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.sqlclient.SqlClient>(o1 -> io.vertx.reactivex.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)o1), o1 -> o1.getDelegate());

  /**
   * Build a pool with the specified <code>block</code> argument.
   * The <code>block</code> argument is usually a lambda that configures the provided builder
   * <p>
   * Example usage: <code>Pool pool = PgBuilder.pool(builder -> builder.connectingTo(connectOptions));</code>
   * @param block 
   * @return the pool as configured by the code <code>block</code>
   */
  public static io.vertx.reactivex.sqlclient.Pool pool(io.vertx.core.Handler<io.vertx.reactivex.sqlclient.ClientBuilder<io.vertx.reactivex.sqlclient.Pool>> block) { 
    io.vertx.reactivex.sqlclient.Pool ret = io.vertx.reactivex.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)io.vertx.pgclient.PgBuilder.pool(io.vertx.lang.reactivex.Helper.convertHandler(block, event -> io.vertx.reactivex.sqlclient.ClientBuilder.newInstance((io.vertx.sqlclient.ClientBuilder)event, new TypeArg<io.vertx.reactivex.sqlclient.Pool>(o0 -> io.vertx.reactivex.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)o0), o0 -> o0.getDelegate())))));
    return ret;
  }

  /**
   * Provide a builder for PostgreSQL pool of connections
   * <p>
   * Example usage: <code>Pool pool = PgBuilder.pool().connectingTo(connectOptions).build()</code>
   * @return 
   */
  public static io.vertx.reactivex.sqlclient.ClientBuilder<io.vertx.reactivex.sqlclient.Pool> pool() { 
    io.vertx.reactivex.sqlclient.ClientBuilder<io.vertx.reactivex.sqlclient.Pool> ret = io.vertx.reactivex.sqlclient.ClientBuilder.newInstance((io.vertx.sqlclient.ClientBuilder)io.vertx.pgclient.PgBuilder.pool(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Build a client backed by a connection pool with the specified <code>block</code> argument.
   * The <code>block</code> argument is usually a lambda that configures the provided builder
   * <p>
   * Example usage: <code>SqlClient client = PgBuilder.client(builder -> builder.connectingTo(connectOptions));</code>
   * @param handler 
   * @return the client as configured by the code <code>block</code>
   */
  public static io.vertx.reactivex.sqlclient.SqlClient client(io.vertx.core.Handler<io.vertx.reactivex.sqlclient.ClientBuilder<io.vertx.reactivex.sqlclient.SqlClient>> handler) { 
    io.vertx.reactivex.sqlclient.SqlClient ret = io.vertx.reactivex.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgBuilder.client(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.sqlclient.ClientBuilder.newInstance((io.vertx.sqlclient.ClientBuilder)event, new TypeArg<io.vertx.reactivex.sqlclient.SqlClient>(o0 -> io.vertx.reactivex.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)o0), o0 -> o0.getDelegate())))));
    return ret;
  }

  /**
   * Provide a builder for PostgreSQL client backed by a connection pool.
   * <p>
   * Example usage: <code>SqlClient client = PgBuilder.client().connectingTo(connectOptions).build()</code>
   * @return 
   */
  public static io.vertx.reactivex.sqlclient.ClientBuilder<io.vertx.reactivex.sqlclient.SqlClient> client() { 
    io.vertx.reactivex.sqlclient.ClientBuilder<io.vertx.reactivex.sqlclient.SqlClient> ret = io.vertx.reactivex.sqlclient.ClientBuilder.newInstance((io.vertx.sqlclient.ClientBuilder)io.vertx.pgclient.PgBuilder.client(), TYPE_ARG_1);
    return ret;
  }

  public static PgBuilder newInstance(io.vertx.pgclient.PgBuilder arg) {
    return arg != null ? new PgBuilder(arg) : null;
  }

}
