/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.oracleclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An interface to define Oracle specific constants or behaviors.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.oracleclient.OracleClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.oracleclient.OracleClient.class)
public class OracleClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OracleClient that = (OracleClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OracleClient> __TYPE_ARG = new TypeArg<>(    obj -> new OracleClient((io.vertx.oracleclient.OracleClient) obj),
    OracleClient::getDelegate
  );

  private final io.vertx.oracleclient.OracleClient delegate;
  
  public OracleClient(io.vertx.oracleclient.OracleClient delegate) {
    this.delegate = delegate;
  }

  public OracleClient(Object delegate) {
    this.delegate = (io.vertx.oracleclient.OracleClient)delegate;
  }

  @Override 
  public io.vertx.oracleclient.OracleClient getDelegate() {
    return delegate;
  }

  /**
   * The property to be used to retrieve the generated keys
   */
  public static final io.vertx.reactivex.sqlclient.PropertyKind<io.vertx.reactivex.sqlclient.Row> GENERATED_KEYS = io.vertx.reactivex.sqlclient.PropertyKind.newInstance((io.vertx.sqlclient.PropertyKind)io.vertx.oracleclient.OracleClient.GENERATED_KEYS, new TypeArg<io.vertx.reactivex.sqlclient.Row>(o0 -> io.vertx.reactivex.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o0), o0 -> o0.getDelegate()));
  /**
   * The property to be used to retrieve the output of the callable statement
   */
  public static final io.vertx.reactivex.sqlclient.PropertyKind<java.lang.Boolean> OUTPUT = io.vertx.reactivex.sqlclient.PropertyKind.newInstance((io.vertx.sqlclient.PropertyKind)io.vertx.oracleclient.OracleClient.OUTPUT, TypeArg.unknown());
  public static OracleClient newInstance(io.vertx.oracleclient.OracleClient arg) {
    return arg != null ? new OracleClient(arg) : null;
  }

}
