/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.openapi.validation;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.openapi.validation.ValidatedResponse.class)
public class ValidatedResponse implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ValidatedResponse that = (ValidatedResponse) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ValidatedResponse> __TYPE_ARG = new TypeArg<>(    obj -> new ValidatedResponse((io.vertx.openapi.validation.ValidatedResponse) obj),
    ValidatedResponse::getDelegate
  );

  private final io.vertx.openapi.validation.ValidatedResponse delegate;
  
  public ValidatedResponse(io.vertx.openapi.validation.ValidatedResponse delegate) {
    this.delegate = delegate;
  }

  public ValidatedResponse(Object delegate) {
    this.delegate = (io.vertx.openapi.validation.ValidatedResponse)delegate;
  }

  @Override 
  public io.vertx.openapi.validation.ValidatedResponse getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.openapi.validation.ResponseParameter> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.openapi.validation.ResponseParameter>(o1 -> io.vertx.reactivex.openapi.validation.ResponseParameter.newInstance((io.vertx.openapi.validation.ResponseParameter)o1), o1 -> o1.getDelegate());

  /**
   * @return the header parameters.
   */
  public java.util.Map<java.lang.String,io.vertx.reactivex.openapi.validation.ResponseParameter> getHeaders() { 
    java.util.Map<java.lang.String,io.vertx.reactivex.openapi.validation.ResponseParameter> ret = delegate.getHeaders().entrySet().stream().collect(Collectors.toMap(_e -> _e.getKey(), _e -> io.vertx.reactivex.openapi.validation.ResponseParameter.newInstance((io.vertx.openapi.validation.ResponseParameter)_e.getValue())));
    return ret;
  }

  /**
   * @return the body.
   */
  public io.vertx.reactivex.openapi.validation.ResponseParameter getBody() { 
    io.vertx.reactivex.openapi.validation.ResponseParameter ret = io.vertx.reactivex.openapi.validation.ResponseParameter.newInstance((io.vertx.openapi.validation.ResponseParameter)delegate.getBody());
    return ret;
  }

  /**
   * Add all parameters from the validated response to the passed  and send it.
   * @param serverResponse The related response
   * @return A succeeded Future when the response was sent successfully, otherwise a failed one.
   */
  public io.vertx.core.Future<java.lang.Void> send(io.vertx.reactivex.core.http.HttpServerResponse serverResponse) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.send(serverResponse.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Add all parameters from the validated response to the passed  and send it.
   * @param serverResponse The related response
   * @return A succeeded Future when the response was sent successfully, otherwise a failed one.
   */
  public io.reactivex.Completable rxSend(io.vertx.reactivex.core.http.HttpServerResponse serverResponse) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.send(serverResponse).onComplete($handler);
    });
  }

  public static ValidatedResponse newInstance(io.vertx.openapi.validation.ValidatedResponse arg) {
    return arg != null ? new ValidatedResponse(arg) : null;
  }

}
