/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.openapi.validation;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.openapi.validation.ValidatedRequest.class)
public class ValidatedRequest implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ValidatedRequest that = (ValidatedRequest) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ValidatedRequest> __TYPE_ARG = new TypeArg<>(    obj -> new ValidatedRequest((io.vertx.openapi.validation.ValidatedRequest) obj),
    ValidatedRequest::getDelegate
  );

  private final io.vertx.openapi.validation.ValidatedRequest delegate;
  
  public ValidatedRequest(io.vertx.openapi.validation.ValidatedRequest delegate) {
    this.delegate = delegate;
  }

  public ValidatedRequest(Object delegate) {
    this.delegate = (io.vertx.openapi.validation.ValidatedRequest)delegate;
  }

  @Override 
  public io.vertx.openapi.validation.ValidatedRequest getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.openapi.validation.RequestParameter> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.openapi.validation.RequestParameter>(o1 -> io.vertx.reactivex.openapi.validation.RequestParameter.newInstance((io.vertx.openapi.validation.RequestParameter)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.openapi.validation.RequestParameter> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.openapi.validation.RequestParameter>(o1 -> io.vertx.reactivex.openapi.validation.RequestParameter.newInstance((io.vertx.openapi.validation.RequestParameter)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.openapi.validation.RequestParameter> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.openapi.validation.RequestParameter>(o1 -> io.vertx.reactivex.openapi.validation.RequestParameter.newInstance((io.vertx.openapi.validation.RequestParameter)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.openapi.validation.RequestParameter> TYPE_ARG_3 = new TypeArg<io.vertx.reactivex.openapi.validation.RequestParameter>(o1 -> io.vertx.reactivex.openapi.validation.RequestParameter.newInstance((io.vertx.openapi.validation.RequestParameter)o1), o1 -> o1.getDelegate());

  /**
   * @return the cookie parameters.
   */
  public java.util.Map<java.lang.String,io.vertx.reactivex.openapi.validation.RequestParameter> getCookies() { 
    java.util.Map<java.lang.String,io.vertx.reactivex.openapi.validation.RequestParameter> ret = delegate.getCookies().entrySet().stream().collect(Collectors.toMap(_e -> _e.getKey(), _e -> io.vertx.reactivex.openapi.validation.RequestParameter.newInstance((io.vertx.openapi.validation.RequestParameter)_e.getValue())));
    return ret;
  }

  /**
   * @return the path parameters.
   */
  public java.util.Map<java.lang.String,io.vertx.reactivex.openapi.validation.RequestParameter> getPathParameters() { 
    java.util.Map<java.lang.String,io.vertx.reactivex.openapi.validation.RequestParameter> ret = delegate.getPathParameters().entrySet().stream().collect(Collectors.toMap(_e -> _e.getKey(), _e -> io.vertx.reactivex.openapi.validation.RequestParameter.newInstance((io.vertx.openapi.validation.RequestParameter)_e.getValue())));
    return ret;
  }

  /**
   * @return the query parameters.
   */
  public java.util.Map<java.lang.String,io.vertx.reactivex.openapi.validation.RequestParameter> getQuery() { 
    java.util.Map<java.lang.String,io.vertx.reactivex.openapi.validation.RequestParameter> ret = delegate.getQuery().entrySet().stream().collect(Collectors.toMap(_e -> _e.getKey(), _e -> io.vertx.reactivex.openapi.validation.RequestParameter.newInstance((io.vertx.openapi.validation.RequestParameter)_e.getValue())));
    return ret;
  }

  /**
   * @return the header parameters.
   */
  public java.util.Map<java.lang.String,io.vertx.reactivex.openapi.validation.RequestParameter> getHeaders() { 
    java.util.Map<java.lang.String,io.vertx.reactivex.openapi.validation.RequestParameter> ret = delegate.getHeaders().entrySet().stream().collect(Collectors.toMap(_e -> _e.getKey(), _e -> io.vertx.reactivex.openapi.validation.RequestParameter.newInstance((io.vertx.openapi.validation.RequestParameter)_e.getValue())));
    return ret;
  }

  /**
   * @return the body.
   */
  public io.vertx.reactivex.openapi.validation.RequestParameter getBody() { 
    io.vertx.reactivex.openapi.validation.RequestParameter ret = io.vertx.reactivex.openapi.validation.RequestParameter.newInstance((io.vertx.openapi.validation.RequestParameter)delegate.getBody());
    return ret;
  }

  public static ValidatedRequest newInstance(io.vertx.openapi.validation.ValidatedRequest arg) {
    return arg != null ? new ValidatedRequest(arg) : null;
  }

}
