/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.openapi.validation;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.openapi.validation.Parameter.class)
public interface Parameter extends RxDelegate {

  @Override 
  io.vertx.openapi.validation.Parameter getDelegate();

  /**
   * @return null if value is not a {@link java.lang.String}, otherwise it returns value
   */
  public java.lang.String getString();

  /**
   * @param defaultValue 
   * @return the default if value is not a {@link java.lang.String} or is null, otherwise it returns the value.
   */
  public java.lang.String getString(java.lang.String defaultValue);

  /**
   * @return true if value of this instance is a {@link java.lang.String} instance
   */
  public boolean isString();

  /**
   * @return null if value is not a {@link java.lang.Number}, otherwise it returns value as {@link java.lang.Integer}
   */
  public java.lang.Integer getInteger();

  /**
   * @param defaultValue 
   * @return the default supplied if value is not a {@link java.lang.Number} or is null, otherwise it returns the value.
   */
  public java.lang.Integer getInteger(java.lang.Integer defaultValue);

  /**
   * @return null if value is not a {@link java.lang.Number}, otherwise it returns value as {@link java.lang.Long}
   */
  public java.lang.Long getLong();

  /**
   * @param defaultValue 
   * @return the default supplied if value is not a {@link java.lang.Number} or is null, otherwise it returns the value.
   */
  public java.lang.Long getLong(java.lang.Long defaultValue);

  /**
   * @return null if value is not a {@link java.lang.Number}, otherwise it returns value as {@link java.lang.Float}
   */
  public java.lang.Float getFloat();

  /**
   * @param defaultValue 
   * @return the default supplied if value is not a {@link java.lang.Number} or is null, otherwise it returns the value.
   */
  public java.lang.Float getFloat(java.lang.Float defaultValue);

  /**
   * @return null if value is not a {@link java.lang.Number}, otherwise it returns value as {@link java.lang.Double}
   */
  public java.lang.Double getDouble();

  /**
   * @param defaultValue 
   * @return the default supplied if value is not a {@link java.lang.Number} or is null, otherwise it returns the value.
   */
  public java.lang.Double getDouble(java.lang.Double defaultValue);

  /**
   * @return true if value of this instance is a {@link java.lang.Number} instance
   */
  public boolean isNumber();

  /**
   * @return null if value is not a {@link java.lang.Boolean}, otherwise it returns value
   */
  public java.lang.Boolean getBoolean();

  /**
   * @param defaultValue 
   * @return the default supplied if value is not a {@link java.lang.Boolean} or is null, otherwise it returns the value.
   */
  public java.lang.Boolean getBoolean(java.lang.Boolean defaultValue);

  /**
   * @return true if value of this instance is a {@link java.lang.Boolean} instance
   */
  public boolean isBoolean();

  /**
   * @return null if value is not a , otherwise it returns value
   */
  public io.vertx.core.json.JsonObject getJsonObject();

  /**
   * @param defaultValue 
   * @return the default supplied if value is not a  or is null, otherwise it returns the value.
   */
  public io.vertx.core.json.JsonObject getJsonObject(io.vertx.core.json.JsonObject defaultValue);

  /**
   * @return true if value of this instance is a  instance
   */
  public boolean isJsonObject();

  /**
   * @return null if value is not a , otherwise it returns value
   */
  public io.vertx.core.json.JsonArray getJsonArray();

  /**
   * @param defaultValue 
   * @return the default supplied if value is not a  or is null, otherwise it returns the value.
   */
  public io.vertx.core.json.JsonArray getJsonArray(io.vertx.core.json.JsonArray defaultValue);

  /**
   * @return true if value of this instance is a  instance
   */
  public boolean isJsonArray();

  /**
   * @return null if value is not a , otherwise it returns value
   */
  public io.vertx.core.buffer.Buffer getBuffer();

  /**
   * @param defaultValue 
   * @return the default suppliedif value is not a  or is null, otherwise it returns the value.
   */
  public io.vertx.core.buffer.Buffer getBuffer(io.vertx.core.buffer.Buffer defaultValue);

  /**
   * @return true if value of this instance is a  instance
   */
  public boolean isBuffer();

  /**
   * @return true if value is null
   */
  public boolean isNull();

  /**
   * @return true if it's an empty {@link java.lang.String}, an empty  / , an empty  or it's null
   */
  public boolean isEmpty();

  /**
   * @return the plain value
   */
  public java.lang.Object get();

  public static Parameter newInstance(io.vertx.openapi.validation.Parameter arg) {
    return arg != null ? new ParameterImpl(arg) : null;
  }

}

class ParameterImpl implements Parameter {
  private final io.vertx.openapi.validation.Parameter delegate;
  
  public ParameterImpl(io.vertx.openapi.validation.Parameter delegate) {
    this.delegate = delegate;
  }

  public ParameterImpl(Object delegate) {
    this.delegate = (io.vertx.openapi.validation.Parameter)delegate;
  }

  @Override 
  public io.vertx.openapi.validation.Parameter getDelegate() {
    return delegate;
  }

  /**
   * @return null if value is not a {@link java.lang.String}, otherwise it returns value
   */
  public java.lang.String getString() { 
    java.lang.String ret = delegate.getString();
    return ret;
  }

  /**
   * @param defaultValue 
   * @return the default if value is not a {@link java.lang.String} or is null, otherwise it returns the value.
   */
  public java.lang.String getString(java.lang.String defaultValue) { 
    java.lang.String ret = delegate.getString(defaultValue);
    return ret;
  }

  /**
   * @return true if value of this instance is a {@link java.lang.String} instance
   */
  public boolean isString() { 
    boolean ret = delegate.isString();
    return ret;
  }

  /**
   * @return null if value is not a {@link java.lang.Number}, otherwise it returns value as {@link java.lang.Integer}
   */
  public java.lang.Integer getInteger() { 
    java.lang.Integer ret = delegate.getInteger();
    return ret;
  }

  /**
   * @param defaultValue 
   * @return the default supplied if value is not a {@link java.lang.Number} or is null, otherwise it returns the value.
   */
  public java.lang.Integer getInteger(java.lang.Integer defaultValue) { 
    java.lang.Integer ret = delegate.getInteger(defaultValue);
    return ret;
  }

  /**
   * @return null if value is not a {@link java.lang.Number}, otherwise it returns value as {@link java.lang.Long}
   */
  public java.lang.Long getLong() { 
    java.lang.Long ret = delegate.getLong();
    return ret;
  }

  /**
   * @param defaultValue 
   * @return the default supplied if value is not a {@link java.lang.Number} or is null, otherwise it returns the value.
   */
  public java.lang.Long getLong(java.lang.Long defaultValue) { 
    java.lang.Long ret = delegate.getLong(defaultValue);
    return ret;
  }

  /**
   * @return null if value is not a {@link java.lang.Number}, otherwise it returns value as {@link java.lang.Float}
   */
  public java.lang.Float getFloat() { 
    java.lang.Float ret = delegate.getFloat();
    return ret;
  }

  /**
   * @param defaultValue 
   * @return the default supplied if value is not a {@link java.lang.Number} or is null, otherwise it returns the value.
   */
  public java.lang.Float getFloat(java.lang.Float defaultValue) { 
    java.lang.Float ret = delegate.getFloat(defaultValue);
    return ret;
  }

  /**
   * @return null if value is not a {@link java.lang.Number}, otherwise it returns value as {@link java.lang.Double}
   */
  public java.lang.Double getDouble() { 
    java.lang.Double ret = delegate.getDouble();
    return ret;
  }

  /**
   * @param defaultValue 
   * @return the default supplied if value is not a {@link java.lang.Number} or is null, otherwise it returns the value.
   */
  public java.lang.Double getDouble(java.lang.Double defaultValue) { 
    java.lang.Double ret = delegate.getDouble(defaultValue);
    return ret;
  }

  /**
   * @return true if value of this instance is a {@link java.lang.Number} instance
   */
  public boolean isNumber() { 
    boolean ret = delegate.isNumber();
    return ret;
  }

  /**
   * @return null if value is not a {@link java.lang.Boolean}, otherwise it returns value
   */
  public java.lang.Boolean getBoolean() { 
    java.lang.Boolean ret = delegate.getBoolean();
    return ret;
  }

  /**
   * @param defaultValue 
   * @return the default supplied if value is not a {@link java.lang.Boolean} or is null, otherwise it returns the value.
   */
  public java.lang.Boolean getBoolean(java.lang.Boolean defaultValue) { 
    java.lang.Boolean ret = delegate.getBoolean(defaultValue);
    return ret;
  }

  /**
   * @return true if value of this instance is a {@link java.lang.Boolean} instance
   */
  public boolean isBoolean() { 
    boolean ret = delegate.isBoolean();
    return ret;
  }

  /**
   * @return null if value is not a , otherwise it returns value
   */
  public io.vertx.core.json.JsonObject getJsonObject() { 
    io.vertx.core.json.JsonObject ret = delegate.getJsonObject();
    return ret;
  }

  /**
   * @param defaultValue 
   * @return the default supplied if value is not a  or is null, otherwise it returns the value.
   */
  public io.vertx.core.json.JsonObject getJsonObject(io.vertx.core.json.JsonObject defaultValue) { 
    io.vertx.core.json.JsonObject ret = delegate.getJsonObject(defaultValue);
    return ret;
  }

  /**
   * @return true if value of this instance is a  instance
   */
  public boolean isJsonObject() { 
    boolean ret = delegate.isJsonObject();
    return ret;
  }

  /**
   * @return null if value is not a , otherwise it returns value
   */
  public io.vertx.core.json.JsonArray getJsonArray() { 
    io.vertx.core.json.JsonArray ret = delegate.getJsonArray();
    return ret;
  }

  /**
   * @param defaultValue 
   * @return the default supplied if value is not a  or is null, otherwise it returns the value.
   */
  public io.vertx.core.json.JsonArray getJsonArray(io.vertx.core.json.JsonArray defaultValue) { 
    io.vertx.core.json.JsonArray ret = delegate.getJsonArray(defaultValue);
    return ret;
  }

  /**
   * @return true if value of this instance is a  instance
   */
  public boolean isJsonArray() { 
    boolean ret = delegate.isJsonArray();
    return ret;
  }

  /**
   * @return null if value is not a , otherwise it returns value
   */
  public io.vertx.core.buffer.Buffer getBuffer() { 
    io.vertx.core.buffer.Buffer ret = delegate.getBuffer();
    return ret;
  }

  /**
   * @param defaultValue 
   * @return the default suppliedif value is not a  or is null, otherwise it returns the value.
   */
  public io.vertx.core.buffer.Buffer getBuffer(io.vertx.core.buffer.Buffer defaultValue) { 
    io.vertx.core.buffer.Buffer ret = delegate.getBuffer(defaultValue);
    return ret;
  }

  /**
   * @return true if value of this instance is a  instance
   */
  public boolean isBuffer() { 
    boolean ret = delegate.isBuffer();
    return ret;
  }

  /**
   * @return true if value is null
   */
  public boolean isNull() { 
    boolean ret = delegate.isNull();
    return ret;
  }

  /**
   * @return true if it's an empty {@link java.lang.String}, an empty  / , an empty  or it's null
   */
  public boolean isEmpty() { 
    boolean ret = delegate.isEmpty();
    return ret;
  }

  /**
   * @return the plain value
   */
  public java.lang.Object get() { 
    if (cached_0 != null) {
      return cached_0;
    }
    java.lang.Object ret = (Object) delegate.get();
    cached_0 = ret;
    return ret;
  }

  private java.lang.Object cached_0;
}
