/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.openapi.contract;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * This interface represents the most important attributes of an OpenAPI Server.
 * <br>
 * <a href="https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.1.0.md#server-Object">Server V3.1</a>
 * <br>
 * <a href="https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.3.md#server-Object">Server V3.0</a>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.openapi.contract.Server original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.openapi.contract.Server.class)
public class Server implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Server that = (Server) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Server> __TYPE_ARG = new TypeArg<>(    obj -> new Server((io.vertx.openapi.contract.Server) obj),
    Server::getDelegate
  );

  private final io.vertx.openapi.contract.Server delegate;
  
  public Server(io.vertx.openapi.contract.Server delegate) {
    this.delegate = delegate;
  }

  public Server(Object delegate) {
    this.delegate = (io.vertx.openapi.contract.Server)delegate;
  }

  @Override 
  public io.vertx.openapi.contract.Server getDelegate() {
    return delegate;
  }

  /**
   * @return the URL of the related server
   */
  public java.lang.String getURL() { 
    java.lang.String ret = delegate.getURL();
    return ret;
  }

  /**
   * The base path is used to indicate that the location where the OpenAPI contract is served is different
   * from the path specified in the OpenAPI contract.
   * @return the related base path.
   */
  public java.lang.String getBasePath() { 
    java.lang.String ret = delegate.getBasePath();
    return ret;
  }

  public static Server newInstance(io.vertx.openapi.contract.Server arg) {
    return arg != null ? new Server(arg) : null;
  }

}
