/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.openapi.contract;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * This interface represents the most important attributes of an OpenAPI Operation.
 * <br>
 * <a href="https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.1.0.md#request-body-Object">Operation V3.1</a>
 * <br>
 * <a href="https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.3.md#request-body-Object">Operation V3.0</a>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.openapi.contract.RequestBody original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.openapi.contract.RequestBody.class)
public class RequestBody implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RequestBody that = (RequestBody) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RequestBody> __TYPE_ARG = new TypeArg<>(    obj -> new RequestBody((io.vertx.openapi.contract.RequestBody) obj),
    RequestBody::getDelegate
  );

  private final io.vertx.openapi.contract.RequestBody delegate;
  
  public RequestBody(io.vertx.openapi.contract.RequestBody delegate) {
    this.delegate = delegate;
  }

  public RequestBody(Object delegate) {
    this.delegate = (io.vertx.openapi.contract.RequestBody)delegate;
  }

  @Override 
  public io.vertx.openapi.contract.RequestBody getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.openapi.contract.MediaType> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.openapi.contract.MediaType>(o1 -> io.vertx.reactivex.openapi.contract.MediaType.newInstance((io.vertx.openapi.contract.MediaType)o1), o1 -> o1.getDelegate());

  /**
   * @return true if the request body is required in the request, otherwise false.
   */
  public boolean isRequired() { 
    boolean ret = delegate.isRequired();
    return ret;
  }

  /**
   * @return a map containing descriptions of potential request payloads. The key is a media type or media type range and the value describes it.
   */
  public java.util.Map<java.lang.String,io.vertx.reactivex.openapi.contract.MediaType> getContent() { 
    java.util.Map<java.lang.String,io.vertx.reactivex.openapi.contract.MediaType> ret = delegate.getContent().entrySet().stream().collect(Collectors.toMap(_e -> _e.getKey(), _e -> io.vertx.reactivex.openapi.contract.MediaType.newInstance((io.vertx.openapi.contract.MediaType)_e.getValue())));
    return ret;
  }

  /**
   * This method tries to determine the best fitting {@link io.vertx.reactivex.openapi.contract.MediaType} based on the passed content type.
   * <br>
   * <br>
   * This is necessary, to avoid that an incoming request of type <i>application/json; charset=utf-8</i> is failing,
   * because we only declared <i>application/json</i> in the OpenAPI spec.
   * <br>
   * <br>
   * <b>Important:</b> If <i>application/json</i> is declared in the contract, <i>application/json; charset=utf-8</i>
   * would fit, but not the other way around.
   * @param mediaTypeIdentifier 
   * @return A fitting media type, or null.
   */
  public io.vertx.reactivex.openapi.contract.MediaType determineContentType(java.lang.String mediaTypeIdentifier) { 
    io.vertx.reactivex.openapi.contract.MediaType ret = io.vertx.reactivex.openapi.contract.MediaType.newInstance((io.vertx.openapi.contract.MediaType)delegate.determineContentType(mediaTypeIdentifier));
    return ret;
  }

  public static RequestBody newInstance(io.vertx.openapi.contract.RequestBody arg) {
    return arg != null ? new RequestBody(arg) : null;
  }

}
