/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.openapi.contract;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * This interface represents the most important attributes of an OpenAPI Parameter.
 * <br>
 * <a href="https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.1.0.md#path-item-object">Parameter V3.1</a>
 * <br>
 * <a href="https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.3.md#path-item-object">Parameter V3.0</a>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.openapi.contract.Path original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.openapi.contract.Path.class)
public class Path implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Path that = (Path) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Path> __TYPE_ARG = new TypeArg<>(    obj -> new Path((io.vertx.openapi.contract.Path) obj),
    Path::getDelegate
  );

  private final io.vertx.openapi.contract.Path delegate;
  
  public Path(io.vertx.openapi.contract.Path delegate) {
    this.delegate = delegate;
  }

  public Path(Object delegate) {
    this.delegate = (io.vertx.openapi.contract.Path)delegate;
  }

  @Override 
  public io.vertx.openapi.contract.Path getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.openapi.contract.Operation> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.openapi.contract.Operation>(o1 -> io.vertx.reactivex.openapi.contract.Operation.newInstance((io.vertx.openapi.contract.Operation)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.openapi.contract.Parameter> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.openapi.contract.Parameter>(o1 -> io.vertx.reactivex.openapi.contract.Parameter.newInstance((io.vertx.openapi.contract.Parameter)o1), o1 -> o1.getDelegate());

  /**
   * @return the name of this path
   */
  public java.lang.String getName() { 
    java.lang.String ret = delegate.getName();
    return ret;
  }

  /**
   * @return operations of this path
   */
  public java.util.List<io.vertx.reactivex.openapi.contract.Operation> getOperations() { 
    java.util.List<io.vertx.reactivex.openapi.contract.Operation> ret = delegate.getOperations().stream().map(elt -> io.vertx.reactivex.openapi.contract.Operation.newInstance((io.vertx.openapi.contract.Operation)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * @return parameters of this path
   */
  public java.util.List<io.vertx.reactivex.openapi.contract.Parameter> getParameters() { 
    java.util.List<io.vertx.reactivex.openapi.contract.Parameter> ret = delegate.getParameters().stream().map(elt -> io.vertx.reactivex.openapi.contract.Parameter.newInstance((io.vertx.openapi.contract.Parameter)elt)).collect(Collectors.toList());
    return ret;
  }

  public static Path newInstance(io.vertx.openapi.contract.Path arg) {
    return arg != null ? new Path(arg) : null;
  }

}
