/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.mssqlclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A connection to Microsoft SQL Server.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mssqlclient.MSSQLConnection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mssqlclient.MSSQLConnection.class)
public class MSSQLConnection extends io.vertx.reactivex.sqlclient.SqlConnection implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MSSQLConnection that = (MSSQLConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MSSQLConnection> __TYPE_ARG = new TypeArg<>(    obj -> new MSSQLConnection((io.vertx.mssqlclient.MSSQLConnection) obj),
    MSSQLConnection::getDelegate
  );

  private final io.vertx.mssqlclient.MSSQLConnection delegate;
  
  public MSSQLConnection(io.vertx.mssqlclient.MSSQLConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MSSQLConnection(Object delegate) {
    super((io.vertx.mssqlclient.MSSQLConnection)delegate);
    this.delegate = (io.vertx.mssqlclient.MSSQLConnection)delegate;
  }

  @Override 
  public io.vertx.mssqlclient.MSSQLConnection getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.mssqlclient.MSSQLConnection> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.mssqlclient.MSSQLConnection>(o1 -> io.vertx.reactivex.mssqlclient.MSSQLConnection.newInstance((io.vertx.mssqlclient.MSSQLConnection)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.mssqlclient.MSSQLConnection> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.mssqlclient.MSSQLConnection>(o1 -> io.vertx.reactivex.mssqlclient.MSSQLConnection.newInstance((io.vertx.mssqlclient.MSSQLConnection)o1), o1 -> o1.getDelegate());

  /**
   * Create a connection to SQL Server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return a future notified with the connection or the failure
   */
  public static io.vertx.core.Future<io.vertx.reactivex.mssqlclient.MSSQLConnection> connect(io.vertx.reactivex.core.Vertx vertx, io.vertx.mssqlclient.MSSQLConnectOptions connectOptions) { 
    io.vertx.core.Future<io.vertx.reactivex.mssqlclient.MSSQLConnection> ret = io.vertx.mssqlclient.MSSQLConnection.connect(vertx.getDelegate(), connectOptions).map(val -> io.vertx.reactivex.mssqlclient.MSSQLConnection.newInstance((io.vertx.mssqlclient.MSSQLConnection)val));
    return ret;
  }

  /**
   * Create a connection to SQL Server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return a future notified with the connection or the failure
   */
  public static io.reactivex.Single<io.vertx.reactivex.mssqlclient.MSSQLConnection> rxConnect(io.vertx.reactivex.core.Vertx vertx, io.vertx.mssqlclient.MSSQLConnectOptions connectOptions) { 
    return AsyncResultSingle.toSingle($handler -> {
      io.vertx.reactivex.mssqlclient.MSSQLConnection.connect(vertx, connectOptions).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.mssqlclient.MSSQLConnection#connect} with options built from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.core.Future<io.vertx.reactivex.mssqlclient.MSSQLConnection> connect(io.vertx.reactivex.core.Vertx vertx, java.lang.String connectionUri) { 
    io.vertx.core.Future<io.vertx.reactivex.mssqlclient.MSSQLConnection> ret = io.vertx.mssqlclient.MSSQLConnection.connect(vertx.getDelegate(), connectionUri).map(val -> io.vertx.reactivex.mssqlclient.MSSQLConnection.newInstance((io.vertx.mssqlclient.MSSQLConnection)val));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.mssqlclient.MSSQLConnection#connect} with options built from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.mssqlclient.MSSQLConnection> rxConnect(io.vertx.reactivex.core.Vertx vertx, java.lang.String connectionUri) { 
    return AsyncResultSingle.toSingle($handler -> {
      io.vertx.reactivex.mssqlclient.MSSQLConnection.connect(vertx, connectionUri).onComplete($handler);
    });
  }

  /**
   * 
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.mssqlclient.MSSQLConnection exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * 
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.mssqlclient.MSSQLConnection closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Set a handler called when the connection receives an informational message from the server.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mssqlclient.MSSQLConnection infoHandler(io.vertx.core.Handler<io.vertx.mssqlclient.MSSQLInfo> handler) { 
    delegate.infoHandler(handler);
    return this;
  }

  /**
   * Cast a  to {@link io.vertx.reactivex.mssqlclient.MSSQLConnection}.
   *
   * This is mostly useful for Vert.x generated APIs like RxJava/Mutiny.
   * @param sqlConnection the connection to cast
   * @return a {@link io.vertx.reactivex.mssqlclient.MSSQLConnection instance}
   */
  public static io.vertx.reactivex.mssqlclient.MSSQLConnection cast(io.vertx.reactivex.sqlclient.SqlConnection sqlConnection) { 
    io.vertx.reactivex.mssqlclient.MSSQLConnection ret = io.vertx.reactivex.mssqlclient.MSSQLConnection.newInstance((io.vertx.mssqlclient.MSSQLConnection)io.vertx.mssqlclient.MSSQLConnection.cast(sqlConnection.getDelegate()));
    return ret;
  }

  public static MSSQLConnection newInstance(io.vertx.mssqlclient.MSSQLConnection arg) {
    return arg != null ? new MSSQLConnection(arg) : null;
  }

}
