/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.mssqlclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Entry point for building MSSQL clients.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mssqlclient.MSSQLBuilder original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mssqlclient.MSSQLBuilder.class)
public class MSSQLBuilder implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MSSQLBuilder that = (MSSQLBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MSSQLBuilder> __TYPE_ARG = new TypeArg<>(    obj -> new MSSQLBuilder((io.vertx.mssqlclient.MSSQLBuilder) obj),
    MSSQLBuilder::getDelegate
  );

  private final io.vertx.mssqlclient.MSSQLBuilder delegate;
  
  public MSSQLBuilder(io.vertx.mssqlclient.MSSQLBuilder delegate) {
    this.delegate = delegate;
  }

  public MSSQLBuilder(Object delegate) {
    this.delegate = (io.vertx.mssqlclient.MSSQLBuilder)delegate;
  }

  @Override 
  public io.vertx.mssqlclient.MSSQLBuilder getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.sqlclient.Pool> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.sqlclient.Pool>(o1 -> io.vertx.reactivex.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)o1), o1 -> o1.getDelegate());

  /**
   * Build a pool with the specified <code>block</code> argument.
   * The <code>block</code> argument is usually a lambda that configures the provided builder
   * <p>
   * Example usage: <code>Pool pool = PgBuilder.pool(builder -> builder.connectingTo(connectOptions));</code>
   * @param block 
   * @return the pool as configured by the code <code>block</code>
   */
  public static io.vertx.reactivex.sqlclient.Pool pool(io.vertx.core.Handler<io.vertx.reactivex.sqlclient.ClientBuilder<io.vertx.reactivex.sqlclient.Pool>> block) { 
    io.vertx.reactivex.sqlclient.Pool ret = io.vertx.reactivex.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)io.vertx.mssqlclient.MSSQLBuilder.pool(io.vertx.lang.reactivex.Helper.convertHandler(block, event -> io.vertx.reactivex.sqlclient.ClientBuilder.newInstance((io.vertx.sqlclient.ClientBuilder)event, new TypeArg<io.vertx.reactivex.sqlclient.Pool>(o0 -> io.vertx.reactivex.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)o0), o0 -> o0.getDelegate())))));
    return ret;
  }

  /**
   * Provide a builder for MSSQL pool of connections
   * <p>
   * Example usage: <code>Pool pool = PgBuilder.pool().connectingTo(connectOptions).build()</code>
   * @return 
   */
  public static io.vertx.reactivex.sqlclient.ClientBuilder<io.vertx.reactivex.sqlclient.Pool> pool() { 
    io.vertx.reactivex.sqlclient.ClientBuilder<io.vertx.reactivex.sqlclient.Pool> ret = io.vertx.reactivex.sqlclient.ClientBuilder.newInstance((io.vertx.sqlclient.ClientBuilder)io.vertx.mssqlclient.MSSQLBuilder.pool(), TYPE_ARG_0);
    return ret;
  }

  public static MSSQLBuilder newInstance(io.vertx.mssqlclient.MSSQLBuilder arg) {
    return arg != null ? new MSSQLBuilder(arg) : null;
  }

}
