/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.mqtt.messages;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represent the interface for each MQTT message
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttMessage original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mqtt.messages.MqttMessage.class)
public interface MqttMessage extends RxDelegate {

  @Override 
  io.vertx.mqtt.messages.MqttMessage getDelegate();

  /**
   * @return Message identifier
   */
  public int messageId();

  public static MqttMessage newInstance(io.vertx.mqtt.messages.MqttMessage arg) {
    return arg != null ? new MqttMessageImpl(arg) : null;
  }

}

class MqttMessageImpl implements MqttMessage {
  private final io.vertx.mqtt.messages.MqttMessage delegate;
  
  public MqttMessageImpl(io.vertx.mqtt.messages.MqttMessage delegate) {
    this.delegate = delegate;
  }

  public MqttMessageImpl(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttMessage)delegate;
  }

  @Override 
  public io.vertx.mqtt.messages.MqttMessage getDelegate() {
    return delegate;
  }

  /**
   * @return Message identifier
   */
  public int messageId() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.messageId();
    cached_0 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
}
