/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.mqtt.messages;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents an MQTT AUTH message
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttAuthenticationExchangeMessage original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mqtt.messages.MqttAuthenticationExchangeMessage.class)
public class MqttAuthenticationExchangeMessage implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttAuthenticationExchangeMessage that = (MqttAuthenticationExchangeMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MqttAuthenticationExchangeMessage> __TYPE_ARG = new TypeArg<>(    obj -> new MqttAuthenticationExchangeMessage((io.vertx.mqtt.messages.MqttAuthenticationExchangeMessage) obj),
    MqttAuthenticationExchangeMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttAuthenticationExchangeMessage delegate;
  
  public MqttAuthenticationExchangeMessage(io.vertx.mqtt.messages.MqttAuthenticationExchangeMessage delegate) {
    this.delegate = delegate;
  }

  public MqttAuthenticationExchangeMessage(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttAuthenticationExchangeMessage)delegate;
  }

  @Override 
  public io.vertx.mqtt.messages.MqttAuthenticationExchangeMessage getDelegate() {
    return delegate;
  }

  /**
   * @return authenticate reason code
   */
  public io.vertx.mqtt.messages.codes.MqttAuthenticateReasonCode reasonCode() { 
    io.vertx.mqtt.messages.codes.MqttAuthenticateReasonCode ret = delegate.reasonCode();
    return ret;
  }

  /**
   * @return authenticate method
   */
  public java.lang.String authenticationMethod() { 
    if (cached_0 != null) {
      return cached_0;
    }
    java.lang.String ret = delegate.authenticationMethod();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return authentication data
   */
  public io.vertx.core.buffer.Buffer authenticationData() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.core.buffer.Buffer ret = delegate.authenticationData();
    cached_1 = ret;
    return ret;
  }

  /**
   * Create a concrete instance of a Vert.x auth message
   * @param reasonCode authenticate reason code
   * @param properties mqtt properties.
   * @return Vert.x auth message
   */
  public static io.vertx.reactivex.mqtt.messages.MqttAuthenticationExchangeMessage create(io.vertx.mqtt.messages.codes.MqttAuthenticateReasonCode reasonCode, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    io.vertx.reactivex.mqtt.messages.MqttAuthenticationExchangeMessage ret = io.vertx.reactivex.mqtt.messages.MqttAuthenticationExchangeMessage.newInstance((io.vertx.mqtt.messages.MqttAuthenticationExchangeMessage)io.vertx.mqtt.messages.MqttAuthenticationExchangeMessage.create(reasonCode, properties));
    return ret;
  }

  /**
   * @return MQTT properties
   */
  public io.netty.handler.codec.mqtt.MqttProperties properties() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.netty.handler.codec.mqtt.MqttProperties ret = delegate.properties();
    cached_2 = ret;
    return ret;
  }

  private java.lang.String cached_0;
  private io.vertx.core.buffer.Buffer cached_1;
  private io.netty.handler.codec.mqtt.MqttProperties cached_2;
  public static MqttAuthenticationExchangeMessage newInstance(io.vertx.mqtt.messages.MqttAuthenticationExchangeMessage arg) {
    return arg != null ? new MqttAuthenticationExchangeMessage(arg) : null;
  }

}
