/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.micrometer;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An interface for creating handlers to expose Prometheus metrics via an HTTP endpoint.
 * <p>
 * This interface provides factory methods to create handlers that can scrape metrics from a
 * PrometheusMeterRegistry and serve them over HTTP. It allows for various configurations of
 * the metrics endpoint and the Prometheus registry.
 * </p>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.micrometer.PrometheusRequestHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.micrometer.PrometheusRequestHandler.class)
public class PrometheusRequestHandler implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PrometheusRequestHandler that = (PrometheusRequestHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PrometheusRequestHandler> __TYPE_ARG = new TypeArg<>(    obj -> new PrometheusRequestHandler((io.vertx.micrometer.PrometheusRequestHandler) obj),
    PrometheusRequestHandler::getDelegate
  );

  private final io.vertx.micrometer.PrometheusRequestHandler delegate;
  
  public PrometheusRequestHandler(io.vertx.micrometer.PrometheusRequestHandler delegate) {
    this.delegate = delegate;
  }

  public PrometheusRequestHandler(Object delegate) {
    this.delegate = (io.vertx.micrometer.PrometheusRequestHandler)delegate;
  }

  @Override 
  public io.vertx.micrometer.PrometheusRequestHandler getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.core.http.HttpServerRequest> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.http.HttpServerRequest>(o1 -> io.vertx.reactivex.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.http.HttpServerRequest> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.core.http.HttpServerRequest>(o1 -> io.vertx.reactivex.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.http.HttpServerRequest> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.core.http.HttpServerRequest>(o1 -> io.vertx.reactivex.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)o1), o1 -> o1.getDelegate());

  /**
   * Creates a handler with a new PrometheusMeterRegistry and the default metrics endpoint ("/metrics").
   * <p>
   * This handler scrapes metrics from a newly created PrometheusMeterRegistry and serves them
   * at the default endpoint "/metrics".
   * </p>
   * @return a handler for scraping Prometheus metrics
   */
  public static io.vertx.core.Handler<io.vertx.reactivex.core.http.HttpServerRequest> create() { 
    io.vertx.core.Handler<io.vertx.reactivex.core.http.HttpServerRequest> ret = new Handler<io.vertx.reactivex.core.http.HttpServerRequest>() {
      public void handle(io.vertx.reactivex.core.http.HttpServerRequest event) {
          io.vertx.micrometer.PrometheusRequestHandler.create().handle(event.getDelegate());
      }
    };
    return ret;
  }

  /**
   * Creates a handler with the specified PrometheusMeterRegistry and metrics endpoint.
   * <p>
   * This handler scrapes metrics from the given PrometheusMeterRegistry and serves them
   * at the specified endpoint.
   * </p>
   * @param registry the PrometheusMeterRegistry to use for scraping metrics
   * @param metricsEndpoint the endpoint to expose metrics
   * @return a handler for scraping Prometheus metrics
   */
  public static io.vertx.core.Handler<io.vertx.reactivex.core.http.HttpServerRequest> create(io.micrometer.prometheusmetrics.PrometheusMeterRegistry registry, java.lang.String metricsEndpoint) { 
    io.vertx.core.Handler<io.vertx.reactivex.core.http.HttpServerRequest> ret = new Handler<io.vertx.reactivex.core.http.HttpServerRequest>() {
      public void handle(io.vertx.reactivex.core.http.HttpServerRequest event) {
          io.vertx.micrometer.PrometheusRequestHandler.create(registry, metricsEndpoint).handle(event.getDelegate());
      }
    };
    return ret;
  }

  /**
   * Creates a handler with the specified PrometheusMeterRegistry and the default metrics endpoint ("/metrics").
   * <p>
   * This handler scrapes metrics from the given PrometheusMeterRegistry and serves them
   * at the default endpoint "/metrics".
   * </p>
   * @param registry the PrometheusMeterRegistry to use for scraping metrics
   * @return a handler for scraping Prometheus metrics
   */
  public static io.vertx.core.Handler<io.vertx.reactivex.core.http.HttpServerRequest> create(io.micrometer.prometheusmetrics.PrometheusMeterRegistry registry) { 
    io.vertx.core.Handler<io.vertx.reactivex.core.http.HttpServerRequest> ret = new Handler<io.vertx.reactivex.core.http.HttpServerRequest>() {
      public void handle(io.vertx.reactivex.core.http.HttpServerRequest event) {
          io.vertx.micrometer.PrometheusRequestHandler.create(registry).handle(event.getDelegate());
      }
    };
    return ret;
  }

  public static PrometheusRequestHandler newInstance(io.vertx.micrometer.PrometheusRequestHandler arg) {
    return arg != null ? new PrometheusRequestHandler(arg) : null;
  }

}
