/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.kafka.client.producer;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Vert.x Kafka producer.
 * <p>
 * The {@link io.vertx.reactivex.core.streams.WriteStream#write} provides global control over writing a record.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.client.producer.KafkaProducer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.kafka.client.producer.KafkaProducer.class)
public class KafkaProducer<K,V> implements RxDelegate, io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K,V>> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaProducer that = (KafkaProducer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<KafkaProducer> __TYPE_ARG = new TypeArg<>(    obj -> new KafkaProducer((io.vertx.kafka.client.producer.KafkaProducer) obj),
    KafkaProducer::getDelegate
  );

  private final io.vertx.kafka.client.producer.KafkaProducer<K,V> delegate;
  public final TypeArg<K> __typeArg_0;
  public final TypeArg<V> __typeArg_1;
  
  public KafkaProducer(io.vertx.kafka.client.producer.KafkaProducer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public KafkaProducer(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
    this.delegate = (io.vertx.kafka.client.producer.KafkaProducer)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  @Override 
  public io.vertx.kafka.client.producer.KafkaProducer getDelegate() {
    return delegate;
  }

  private WriteStreamObserver<io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K,V>> observer;
  private WriteStreamSubscriber<io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K,V>> subscriber;

  public synchronized WriteStreamObserver<io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K,V>> toObserver() {
    if (observer == null) {
      Function<io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord, io.vertx.kafka.client.producer.KafkaProducerRecord<K,V>> conv = io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K,V>::getDelegate;
      observer = RxHelper.toObserver(getDelegate(), conv);
    }
    return observer;
  }

  public synchronized WriteStreamSubscriber<io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K,V>> toSubscriber() {
    if (subscriber == null) {
      Function<io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord, io.vertx.kafka.client.producer.KafkaProducerRecord<K,V>> conv = io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K,V>::getDelegate;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }


  /**
   * Write some data to the stream.
   *
   * <p> The data is usually put on an internal write queue, and the write actually happens
   * asynchronously. To avoid running out of memory by putting too much on the write queue,
   * check the {@link io.vertx.reactivex.core.streams.WriteStream#writeQueueFull} method before writing. This is done automatically if
   * using a .
   *
   * <p> When the <code>data</code> is moved from the queue to the actual medium, the returned
   *  will be completed with the write result, e.g the future is succeeded
   * when a server HTTP response buffer is written to the socket and failed if the remote
   * client has closed the socket while the data was still pending for write.
   * @param data the data to write
   * @return a future completed with the write result
   */
  public io.vertx.core.Future<java.lang.Void> write(io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K,V> data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.write(data.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Write some data to the stream.
   *
   * <p> The data is usually put on an internal write queue, and the write actually happens
   * asynchronously. To avoid running out of memory by putting too much on the write queue,
   * check the {@link io.vertx.reactivex.core.streams.WriteStream#writeQueueFull} method before writing. This is done automatically if
   * using a .
   *
   * <p> When the <code>data</code> is moved from the queue to the actual medium, the returned
   *  will be completed with the write result, e.g the future is succeeded
   * when a server HTTP response buffer is written to the socket and failed if the remote
   * client has closed the socket while the data was still pending for write.
   * @param data the data to write
   * @return a future completed with the write result
   */
  public io.reactivex.Completable rxWrite(io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K,V> data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.write(data).onComplete($handler);
    });
  }

  /**
   * Ends the stream.
   * <p>
   * Once the stream has ended, it cannot be used any more.
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> end() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.end().map(val -> val);
    return ret;
  }

  /**
   * Ends the stream.
   * <p>
   * Once the stream has ended, it cannot be used any more.
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxEnd() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.end().onComplete($handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but writes some data to the stream before ending.
   * @param data the data to write
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> end(io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K,V> data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.end(data.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but writes some data to the stream before ending.
   * @param data the data to write
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxEnd(io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K,V> data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.end(data).onComplete($handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.reactivex.kafka.client.producer.KafkaProducer#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Get or create a KafkaProducer instance which shares its stream with any other KafkaProducer created with the same <code>name</code>
   * <p>
   * When <code>close</code> has been called for each shared producer the resources will be released.
   * Calling <code>end</code> closes all shared producers.
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param config Kafka producer configuration
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> createShared(io.vertx.reactivex.core.Vertx vertx, java.lang.String name, java.util.Map<java.lang.String,java.lang.String> config) { 
    io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.reactivex.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, config), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Get or create a KafkaProducer instance which shares its stream with any other KafkaProducer created with the same <code>name</code>
   * <p>
   * When <code>close</code> has been called for each shared producer the resources will be released.
   * Calling <code>end</code> closes all shared producers.
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param options Kafka producer options
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> createShared(io.vertx.reactivex.core.Vertx vertx, java.lang.String name, io.vertx.kafka.client.common.KafkaClientOptions options) { 
    io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.reactivex.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, options), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Get or create a KafkaProducer instance which shares its stream with any other KafkaProducer created with the same <code>name</code>
   * <p>
   * When <code>close</code> has been called for each shared producer the resources will be released.
   * Calling <code>end</code> closes all shared producers.
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param config Kafka producer configuration
   * @param keyType class type for the key serialization
   * @param valueType class type for the value serialization
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> createShared(io.vertx.reactivex.core.Vertx vertx, java.lang.String name, java.util.Map<java.lang.String,java.lang.String> config, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.reactivex.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, config, io.vertx.lang.reactivex.Helper.unwrap(keyType), io.vertx.lang.reactivex.Helper.unwrap(valueType)), TypeArg.of(keyType), TypeArg.of(valueType));
    return ret;
  }

  /**
   * Get or create a KafkaProducer instance which shares its stream with any other KafkaProducer created with the same <code>name</code>
   * <p>
   * When <code>close</code> has been called for each shared producer the resources will be released.
   * Calling <code>end</code> closes all shared producers.
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param options Kafka producer options
   * @param keyType class type for the key serialization
   * @param valueType class type for the value serialization
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> createShared(io.vertx.reactivex.core.Vertx vertx, java.lang.String name, io.vertx.kafka.client.common.KafkaClientOptions options, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.reactivex.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, options, io.vertx.lang.reactivex.Helper.unwrap(keyType), io.vertx.lang.reactivex.Helper.unwrap(valueType)), TypeArg.of(keyType), TypeArg.of(valueType));
    return ret;
  }

  /**
   * Create a new KafkaProducer instance
   * @param vertx Vert.x instance to use
   * @param config Kafka producer configuration
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> create(io.vertx.reactivex.core.Vertx vertx, java.util.Map<java.lang.String,java.lang.String> config) { 
    io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.reactivex.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.create(vertx.getDelegate(), config), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a new KafkaProducer instance
   * @param vertx Vert.x instance to use
   * @param config Kafka producer configuration
   * @param keyType class type for the key serialization
   * @param valueType class type for the value serialization
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> create(io.vertx.reactivex.core.Vertx vertx, java.util.Map<java.lang.String,java.lang.String> config, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.reactivex.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.create(vertx.getDelegate(), config, io.vertx.lang.reactivex.Helper.unwrap(keyType), io.vertx.lang.reactivex.Helper.unwrap(valueType)), TypeArg.of(keyType), TypeArg.of(valueType));
    return ret;
  }

  /**
   * Initializes the underlying kafka transactional producer. See {@link io.vertx.reactivex.kafka.client.producer.KafkaProducer#initTransactions} ()}
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.lang.Void> initTransactions() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.initTransactions().map(val -> val);
    return ret;
  }

  /**
   * Initializes the underlying kafka transactional producer. See {@link io.vertx.reactivex.kafka.client.producer.KafkaProducer#initTransactions} ()}
   * @return a future notified with the result
   */
  public io.reactivex.Completable rxInitTransactions() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.initTransactions().onComplete($handler);
    });
  }

  /**
   * Starts a new kafka transaction. See {@link io.vertx.reactivex.kafka.client.producer.KafkaProducer#beginTransaction}
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.lang.Void> beginTransaction() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.beginTransaction().map(val -> val);
    return ret;
  }

  /**
   * Starts a new kafka transaction. See {@link io.vertx.reactivex.kafka.client.producer.KafkaProducer#beginTransaction}
   * @return a future notified with the result
   */
  public io.reactivex.Completable rxBeginTransaction() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.beginTransaction().onComplete($handler);
    });
  }

  /**
   * Commits the ongoing transaction. See {@link io.vertx.reactivex.kafka.client.producer.KafkaProducer#commitTransaction}
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.lang.Void> commitTransaction() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.commitTransaction().map(val -> val);
    return ret;
  }

  /**
   * Commits the ongoing transaction. See {@link io.vertx.reactivex.kafka.client.producer.KafkaProducer#commitTransaction}
   * @return a future notified with the result
   */
  public io.reactivex.Completable rxCommitTransaction() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.commitTransaction().onComplete($handler);
    });
  }

  /**
   * Aborts the ongoing transaction. See {@link org.apache.kafka.clients.producer.KafkaProducer}
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.lang.Void> abortTransaction() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.abortTransaction().map(val -> val);
    return ret;
  }

  /**
   * Aborts the ongoing transaction. See {@link org.apache.kafka.clients.producer.KafkaProducer}
   * @return a future notified with the result
   */
  public io.reactivex.Completable rxAbortTransaction() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.abortTransaction().onComplete($handler);
    });
  }

  public io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> setWriteQueueMaxSize(int i) { 
    delegate.setWriteQueueMaxSize(i);
    return this;
  }

  public io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> drainHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * Asynchronously write a record to a topic
   * @param record record to write
   * @return a <code>Future</code> completed with the record metadata
   */
  public io.vertx.core.Future<io.vertx.kafka.client.producer.RecordMetadata> send(io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K,V> record) { 
    io.vertx.core.Future<io.vertx.kafka.client.producer.RecordMetadata> ret = delegate.send(record.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Asynchronously write a record to a topic
   * @param record record to write
   * @return a <code>Future</code> completed with the record metadata
   */
  public io.reactivex.Single<io.vertx.kafka.client.producer.RecordMetadata> rxSend(io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K,V> record) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.send(record).onComplete($handler);
    });
  }

  /**
   * Get the partition metadata for the give topic.
   * @param topic topic partition for which getting partitions info
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.util.List<io.vertx.kafka.client.common.PartitionInfo>> partitionsFor(java.lang.String topic) { 
    io.vertx.core.Future<java.util.List<io.vertx.kafka.client.common.PartitionInfo>> ret = delegate.partitionsFor(topic).map(val -> val);
    return ret;
  }

  /**
   * Get the partition metadata for the give topic.
   * @param topic topic partition for which getting partitions info
   * @return a future notified with the result
   */
  public io.reactivex.Single<java.util.List<io.vertx.kafka.client.common.PartitionInfo>> rxPartitionsFor(java.lang.String topic) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.partitionsFor(topic).onComplete($handler);
    });
  }

  /**
   * Invoking this method makes all buffered records immediately available to write
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.lang.Void> flush() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.flush().map(val -> val);
    return ret;
  }

  /**
   * Invoking this method makes all buffered records immediately available to write
   * @return a future notified with the result
   */
  public io.reactivex.Completable rxFlush() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.flush().onComplete($handler);
    });
  }

  /**
   * Close the producer
   * @return a <code>Future</code> completed with the operation result
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Close the producer
   * @return a <code>Future</code> completed with the operation result
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * Close the producer
   * @param timeout 
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.lang.Void> close(long timeout) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close(timeout).map(val -> val);
    return ret;
  }

  /**
   * Close the producer
   * @param timeout 
   * @return a future notified with the result
   */
  public io.reactivex.Completable rxClose(long timeout) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close(timeout).onComplete($handler);
    });
  }

  /**
   * Create a new KafkaProducer instance from a native .
   * @param vertx Vert.x instance to use
   * @param producer the Kafka producer to wrap
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> create(io.vertx.reactivex.core.Vertx vertx, org.apache.kafka.clients.producer.Producer<K,V> producer) { 
    io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.reactivex.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.create(vertx.getDelegate(), producer), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a new KafkaProducer instance from a native .
   * @param vertx Vert.x instance to use
   * @param producer the Kafka producer to wrap
   * @param options options used only for tracing settings
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> create(io.vertx.reactivex.core.Vertx vertx, org.apache.kafka.clients.producer.Producer<K,V> producer, io.vertx.kafka.client.common.KafkaClientOptions options) { 
    io.vertx.reactivex.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.reactivex.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.create(vertx.getDelegate(), producer, options), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  public static <K,V> KafkaProducer<K,V> newInstance(io.vertx.kafka.client.producer.KafkaProducer arg) {
    return arg != null ? new KafkaProducer<K,V>(arg) : null;
  }

  public static <K,V> KafkaProducer<K,V> newInstance(io.vertx.kafka.client.producer.KafkaProducer arg, TypeArg<K> __typeArg_K, TypeArg<V> __typeArg_V) {
    return arg != null ? new KafkaProducer<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
