/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.kafka.client.consumer;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Vert.x Kafka consumer.
 * <p>
 * You receive Kafka records by providing a {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#handler}. As messages arrive the handler
 * will be called with the records.
 * <p>
 * The {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#pause} and {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#resume} provides global control over reading the records from the consumer.
 * <p>
 * The {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#pause} and {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#resume} provides finer grained control over reading records
 * for specific Topic/Partition, these are Kafka's specific operations.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.client.consumer.KafkaConsumer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.kafka.client.consumer.KafkaConsumer.class)
public class KafkaConsumer<K,V> implements RxDelegate, io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord<K,V>> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaConsumer that = (KafkaConsumer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<KafkaConsumer> __TYPE_ARG = new TypeArg<>(    obj -> new KafkaConsumer((io.vertx.kafka.client.consumer.KafkaConsumer) obj),
    KafkaConsumer::getDelegate
  );

  private final io.vertx.kafka.client.consumer.KafkaConsumer<K,V> delegate;
  public final TypeArg<K> __typeArg_0;
  public final TypeArg<V> __typeArg_1;
  
  public KafkaConsumer(io.vertx.kafka.client.consumer.KafkaConsumer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public KafkaConsumer(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
    this.delegate = (io.vertx.kafka.client.consumer.KafkaConsumer)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  @Override 
  public io.vertx.kafka.client.consumer.KafkaConsumer getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord<K,V>> observable;
  private io.reactivex.Flowable<io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord<K,V>> flowable;

  public synchronized io.reactivex.Observable<io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord<K,V>> toObservable() {
    if (observable == null) {
      Function<io.vertx.kafka.client.consumer.KafkaConsumerRecord<K,V>, io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord<K,V>> conv = io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord::newInstance;
      observable = ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord<K,V>> toFlowable() {
    if (flowable == null) {
      Function<io.vertx.kafka.client.consumer.KafkaConsumerRecord<K,V>, io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord<K,V>> conv = io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord::newInstance;
      flowable = FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }


  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord<K,V>> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord<K,V>> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), new TypeArg<io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord<K,V>>(o0 -> io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord.newInstance((io.vertx.kafka.client.consumer.KafkaConsumerRecord)o0, __typeArg_0, __typeArg_1), o0 -> o0.getDelegate()));
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.vertx.core.Future<java.lang.Void> pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord<K,V>> dst) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.pipeTo(dst.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.reactivex.Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord<K,V>> dst) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.pipeTo(dst).onComplete($handler);
    });
  }

  /**
   * Create a new KafkaConsumer instance
   * @param vertx Vert.x instance to use
   * @param config Kafka consumer configuration
   * @return an instance of the KafkaConsumer
   */
  public static <K, V> io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> create(io.vertx.reactivex.core.Vertx vertx, java.util.Map<java.lang.String,java.lang.String> config) { 
    io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> ret = io.vertx.reactivex.kafka.client.consumer.KafkaConsumer.newInstance((io.vertx.kafka.client.consumer.KafkaConsumer)io.vertx.kafka.client.consumer.KafkaConsumer.create(vertx.getDelegate(), config), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a new KafkaConsumer instance
   * @param vertx Vert.x instance to use
   * @param config Kafka consumer configuration
   * @param keyType class type for the key deserialization
   * @param valueType class type for the value deserialization
   * @return an instance of the KafkaConsumer
   */
  public static <K, V> io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> create(io.vertx.reactivex.core.Vertx vertx, java.util.Map<java.lang.String,java.lang.String> config, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> ret = io.vertx.reactivex.kafka.client.consumer.KafkaConsumer.newInstance((io.vertx.kafka.client.consumer.KafkaConsumer)io.vertx.kafka.client.consumer.KafkaConsumer.create(vertx.getDelegate(), config, io.vertx.lang.reactivex.Helper.unwrap(keyType), io.vertx.lang.reactivex.Helper.unwrap(valueType)), TypeArg.of(keyType), TypeArg.of(valueType));
    return ret;
  }

  /**
   * Create a new KafkaConsumer instance
   * @param vertx Vert.x instance to use
   * @param options Kafka consumer options
   * @return an instance of the KafkaConsumer
   */
  public static <K, V> io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> create(io.vertx.reactivex.core.Vertx vertx, io.vertx.kafka.client.common.KafkaClientOptions options) { 
    io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> ret = io.vertx.reactivex.kafka.client.consumer.KafkaConsumer.newInstance((io.vertx.kafka.client.consumer.KafkaConsumer)io.vertx.kafka.client.consumer.KafkaConsumer.create(vertx.getDelegate(), options), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a new KafkaConsumer instance
   * @param vertx Vert.x instance to use
   * @param options Kafka consumer options
   * @param keyType class type for the key deserialization
   * @param valueType class type for the value deserialization
   * @return an instance of the KafkaConsumer
   */
  public static <K, V> io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> create(io.vertx.reactivex.core.Vertx vertx, io.vertx.kafka.client.common.KafkaClientOptions options, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> ret = io.vertx.reactivex.kafka.client.consumer.KafkaConsumer.newInstance((io.vertx.kafka.client.consumer.KafkaConsumer)io.vertx.kafka.client.consumer.KafkaConsumer.create(vertx.getDelegate(), options, io.vertx.lang.reactivex.Helper.unwrap(keyType), io.vertx.lang.reactivex.Helper.unwrap(valueType)), TypeArg.of(keyType), TypeArg.of(valueType));
    return ret;
  }

  public io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> handler(io.vertx.core.Handler<io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord<K,V>> handler) { 
    delegate.handler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord.newInstance((io.vertx.kafka.client.consumer.KafkaConsumerRecord)event, __typeArg_0, __typeArg_1)));
    return this;
  }

  public io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * Returns the current demand.
   *
   * <ul>
   *   <i>If the stream is in <i>flowing</i> mode will return {@link java.lang.Long}.</i>
   *   <li>If the stream is in <i>fetch</i> mode, will return the current number of elements still to be delivered or 0 if paused.</li>
   * </ul>
   * @return current demand
   */
  public long demand() { 
    long ret = delegate.demand();
    return ret;
  }

  /**
   * Subscribe to the given topic to get dynamically assigned partitions.
   * <p>
   * Due to internal buffering of messages, when changing the subscribed topic
   * the old topic may remain in effect
   * (as observed by the  record handler})
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new topic.
   * @param topic topic to subscribe to
   * @return a <code>Future</code> completed with the operation result
   */
  public io.vertx.core.Future<java.lang.Void> subscribe(java.lang.String topic) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.subscribe(topic).map(val -> val);
    return ret;
  }

  /**
   * Subscribe to the given topic to get dynamically assigned partitions.
   * <p>
   * Due to internal buffering of messages, when changing the subscribed topic
   * the old topic may remain in effect
   * (as observed by the  record handler})
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new topic.
   * @param topic topic to subscribe to
   * @return a <code>Future</code> completed with the operation result
   */
  public io.reactivex.Completable rxSubscribe(java.lang.String topic) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.subscribe(topic).onComplete($handler);
    });
  }

  /**
   * Subscribe to the given list of topics to get dynamically assigned partitions.
   * <p>
   * Due to internal buffering of messages, when changing the subscribed topics
   * the old set of topics may remain in effect
   * (as observed by the  record handler})
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new set of topics.
   * @param topics topics to subscribe to
   * @return a <code>Future</code> completed with the operation result
   */
  public io.vertx.core.Future<java.lang.Void> subscribe(java.util.Set<java.lang.String> topics) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.subscribe(topics).map(val -> val);
    return ret;
  }

  /**
   * Subscribe to the given list of topics to get dynamically assigned partitions.
   * <p>
   * Due to internal buffering of messages, when changing the subscribed topics
   * the old set of topics may remain in effect
   * (as observed by the  record handler})
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new set of topics.
   * @param topics topics to subscribe to
   * @return a <code>Future</code> completed with the operation result
   */
  public io.reactivex.Completable rxSubscribe(java.util.Set<java.lang.String> topics) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.subscribe(topics).onComplete($handler);
    });
  }

  /**
   * Manually assign a partition to this consumer.
   * <p>
   * Due to internal buffering of messages, when reassigning
   * the old partition may remain in effect
   * (as observed by the  record handler)}
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new partition.
   * @param topicPartition partition which want assigned
   * @return a <code>Future</code> completed with the operation result
   */
  public io.vertx.core.Future<java.lang.Void> assign(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.assign(topicPartition).map(val -> val);
    return ret;
  }

  /**
   * Manually assign a partition to this consumer.
   * <p>
   * Due to internal buffering of messages, when reassigning
   * the old partition may remain in effect
   * (as observed by the  record handler)}
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new partition.
   * @param topicPartition partition which want assigned
   * @return a <code>Future</code> completed with the operation result
   */
  public io.reactivex.Completable rxAssign(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.assign(topicPartition).onComplete($handler);
    });
  }

  /**
   * Manually assign a list of partition to this consumer.
   * <p>
   * Due to internal buffering of messages, when reassigning
   * the old set of partitions may remain in effect
   * (as observed by the  record handler)}
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new set of partitions.
   * @param topicPartitions partitions which want assigned
   * @return a <code>Future</code> completed with the operation result
   */
  public io.vertx.core.Future<java.lang.Void> assign(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.assign(topicPartitions).map(val -> val);
    return ret;
  }

  /**
   * Manually assign a list of partition to this consumer.
   * <p>
   * Due to internal buffering of messages, when reassigning
   * the old set of partitions may remain in effect
   * (as observed by the  record handler)}
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new set of partitions.
   * @param topicPartitions partitions which want assigned
   * @return a <code>Future</code> completed with the operation result
   */
  public io.reactivex.Completable rxAssign(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.assign(topicPartitions).onComplete($handler);
    });
  }

  /**
   * Get the set of partitions currently assigned to this consumer.
   * @return a future notified on operation completed
   */
  public io.vertx.core.Future<java.util.Set<io.vertx.kafka.client.common.TopicPartition>> assignment() { 
    io.vertx.core.Future<java.util.Set<io.vertx.kafka.client.common.TopicPartition>> ret = delegate.assignment().map(val -> val);
    return ret;
  }

  /**
   * Get the set of partitions currently assigned to this consumer.
   * @return a future notified on operation completed
   */
  public io.reactivex.Single<java.util.Set<io.vertx.kafka.client.common.TopicPartition>> rxAssignment() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.assignment().onComplete($handler);
    });
  }

  /**
   * Unsubscribe from topics currently subscribed with subscribe.
   * @return a <code>Future</code> completed with the operation result
   */
  public io.vertx.core.Future<java.lang.Void> unsubscribe() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.unsubscribe().map(val -> val);
    return ret;
  }

  /**
   * Unsubscribe from topics currently subscribed with subscribe.
   * @return a <code>Future</code> completed with the operation result
   */
  public io.reactivex.Completable rxUnsubscribe() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.unsubscribe().onComplete($handler);
    });
  }

  /**
   * Get the current subscription.
   * @return a future notified on operation completed
   */
  public io.vertx.core.Future<java.util.Set<java.lang.String>> subscription() { 
    io.vertx.core.Future<java.util.Set<java.lang.String>> ret = delegate.subscription().map(val -> val);
    return ret;
  }

  /**
   * Get the current subscription.
   * @return a future notified on operation completed
   */
  public io.reactivex.Single<java.util.Set<java.lang.String>> rxSubscription() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.subscription().onComplete($handler);
    });
  }

  /**
   * Suspend fetching from the requested partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages from the given <code>topicPartition</code>
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will not see messages
   * from the given <code>topicPartition</code>.
   * @param topicPartition topic partition from which suspend fetching
   * @return a <code>Future</code> completed with the operation result
   */
  public io.vertx.core.Future<java.lang.Void> pause(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.pause(topicPartition).map(val -> val);
    return ret;
  }

  /**
   * Suspend fetching from the requested partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages from the given <code>topicPartition</code>
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will not see messages
   * from the given <code>topicPartition</code>.
   * @param topicPartition topic partition from which suspend fetching
   * @return a <code>Future</code> completed with the operation result
   */
  public io.reactivex.Completable rxPause(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.pause(topicPartition).onComplete($handler);
    });
  }

  /**
   * Suspend fetching from the requested partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages from the given <code>topicPartitions</code>
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will not see messages
   * from the given <code>topicPartitions</code>.
   * @param topicPartitions topic partition from which suspend fetching
   * @return a <code>Future</code> completed with the operation result
   */
  public io.vertx.core.Future<java.lang.Void> pause(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.pause(topicPartitions).map(val -> val);
    return ret;
  }

  /**
   * Suspend fetching from the requested partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages from the given <code>topicPartitions</code>
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will not see messages
   * from the given <code>topicPartitions</code>.
   * @param topicPartitions topic partition from which suspend fetching
   * @return a <code>Future</code> completed with the operation result
   */
  public io.reactivex.Completable rxPause(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.pause(topicPartitions).onComplete($handler);
    });
  }

  /**
   * Get the set of partitions that were previously paused by a call to pause(Set).
   * @return a future notified on operation completed
   */
  public io.vertx.core.Future<java.util.Set<io.vertx.kafka.client.common.TopicPartition>> paused() { 
    io.vertx.core.Future<java.util.Set<io.vertx.kafka.client.common.TopicPartition>> ret = delegate.paused().map(val -> val);
    return ret;
  }

  /**
   * Get the set of partitions that were previously paused by a call to pause(Set).
   * @return a future notified on operation completed
   */
  public io.reactivex.Single<java.util.Set<io.vertx.kafka.client.common.TopicPartition>> rxPaused() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.paused().onComplete($handler);
    });
  }

  /**
   * Resume specified partition which have been paused with pause.
   * @param topicPartition topic partition from which resume fetching
   * @return a <code>Future</code> completed with the operation result
   */
  public io.vertx.core.Future<java.lang.Void> resume(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.resume(topicPartition).map(val -> val);
    return ret;
  }

  /**
   * Resume specified partition which have been paused with pause.
   * @param topicPartition topic partition from which resume fetching
   * @return a <code>Future</code> completed with the operation result
   */
  public io.reactivex.Completable rxResume(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.resume(topicPartition).onComplete($handler);
    });
  }

  /**
   * Resume specified partitions which have been paused with pause.
   * @param topicPartitions topic partition from which resume fetching
   * @return a <code>Future</code> completed with the operation result
   */
  public io.vertx.core.Future<java.lang.Void> resume(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.resume(topicPartitions).map(val -> val);
    return ret;
  }

  /**
   * Resume specified partitions which have been paused with pause.
   * @param topicPartitions topic partition from which resume fetching
   * @return a <code>Future</code> completed with the operation result
   */
  public io.reactivex.Completable rxResume(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.resume(topicPartitions).onComplete($handler);
    });
  }

  /**
   * Set the handler called when topic partitions are revoked to the consumer
   * @param handler handler called on revoked topic partitions
   * @return current KafkaConsumer instance
   */
  public io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> partitionsRevokedHandler(io.vertx.core.Handler<java.util.Set<io.vertx.kafka.client.common.TopicPartition>> handler) { 
    delegate.partitionsRevokedHandler(handler);
    return this;
  }

  /**
   * Set the handler called when topic partitions are assigned to the consumer
   * @param handler handler called on assigned topic partitions
   * @return current KafkaConsumer instance
   */
  public io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> partitionsAssignedHandler(io.vertx.core.Handler<java.util.Set<io.vertx.kafka.client.common.TopicPartition>> handler) { 
    delegate.partitionsAssignedHandler(handler);
    return this;
  }

  /**
   * Overrides the fetch offsets that the consumer will use on the next poll.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @param offset offset to seek inside the topic partition
   * @return a <code>Future</code> completed with the operation result
   */
  public io.vertx.core.Future<java.lang.Void> seek(io.vertx.kafka.client.common.TopicPartition topicPartition, long offset) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.seek(topicPartition, offset).map(val -> val);
    return ret;
  }

  /**
   * Overrides the fetch offsets that the consumer will use on the next poll.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @param offset offset to seek inside the topic partition
   * @return a <code>Future</code> completed with the operation result
   */
  public io.reactivex.Completable rxSeek(io.vertx.kafka.client.common.TopicPartition topicPartition, long offset) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.seek(topicPartition, offset).onComplete($handler);
    });
  }

  /**
   * Overrides the fetch offsets that the consumer will use on the next poll.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @param offsetAndMetadata offset to seek inside the topic partition
   * @return a <code>Future</code> completed with the operation result
   */
  public io.vertx.core.Future<java.lang.Void> seek(io.vertx.kafka.client.common.TopicPartition topicPartition, io.vertx.kafka.client.consumer.OffsetAndMetadata offsetAndMetadata) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.seek(topicPartition, offsetAndMetadata).map(val -> val);
    return ret;
  }

  /**
   * Overrides the fetch offsets that the consumer will use on the next poll.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @param offsetAndMetadata offset to seek inside the topic partition
   * @return a <code>Future</code> completed with the operation result
   */
  public io.reactivex.Completable rxSeek(io.vertx.kafka.client.common.TopicPartition topicPartition, io.vertx.kafka.client.consumer.OffsetAndMetadata offsetAndMetadata) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.seek(topicPartition, offsetAndMetadata).onComplete($handler);
    });
  }

  /**
   * Seek to the first offset for each of the given partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @return a <code>Future</code> completed with the operation result
   */
  public io.vertx.core.Future<java.lang.Void> seekToBeginning(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.seekToBeginning(topicPartition).map(val -> val);
    return ret;
  }

  /**
   * Seek to the first offset for each of the given partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @return a <code>Future</code> completed with the operation result
   */
  public io.reactivex.Completable rxSeekToBeginning(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.seekToBeginning(topicPartition).onComplete($handler);
    });
  }

  /**
   * Seek to the first offset for each of the given partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartitions topic partition for which seek
   * @return a <code>Future</code> completed with the operation result
   */
  public io.vertx.core.Future<java.lang.Void> seekToBeginning(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.seekToBeginning(topicPartitions).map(val -> val);
    return ret;
  }

  /**
   * Seek to the first offset for each of the given partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartitions topic partition for which seek
   * @return a <code>Future</code> completed with the operation result
   */
  public io.reactivex.Completable rxSeekToBeginning(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.seekToBeginning(topicPartitions).onComplete($handler);
    });
  }

  /**
   * Seek to the last offset for each of the given partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @return a <code>Future</code> completed with the operation result
   */
  public io.vertx.core.Future<java.lang.Void> seekToEnd(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.seekToEnd(topicPartition).map(val -> val);
    return ret;
  }

  /**
   * Seek to the last offset for each of the given partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @return a <code>Future</code> completed with the operation result
   */
  public io.reactivex.Completable rxSeekToEnd(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.seekToEnd(topicPartition).onComplete($handler);
    });
  }

  /**
   * Seek to the last offset for each of the given partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartitions topic partition for which seek
   * @return a <code>Future</code> completed with the operation result
   */
  public io.vertx.core.Future<java.lang.Void> seekToEnd(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.seekToEnd(topicPartitions).map(val -> val);
    return ret;
  }

  /**
   * Seek to the last offset for each of the given partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * @param topicPartitions topic partition for which seek
   * @return a <code>Future</code> completed with the operation result
   */
  public io.reactivex.Completable rxSeekToEnd(java.util.Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.seekToEnd(topicPartitions).onComplete($handler);
    });
  }

  /**
   * Commit current offsets for all the subscribed list of topics and partition.
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> commit() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.commit().map(val -> val);
    return ret;
  }

  /**
   * Commit current offsets for all the subscribed list of topics and partition.
   * @return 
   */
  public io.reactivex.Completable rxCommit() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.commit().onComplete($handler);
    });
  }

  /**
   * Get the last committed offset for the given partition (whether the commit happened by this process or another).
   * @param topicPartition topic partition for getting last committed offset
   * @return a future notified on operation completed
   */
  public io.vertx.core.Future<io.vertx.kafka.client.consumer.OffsetAndMetadata> committed(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    io.vertx.core.Future<io.vertx.kafka.client.consumer.OffsetAndMetadata> ret = delegate.committed(topicPartition).map(val -> val);
    return ret;
  }

  /**
   * Get the last committed offset for the given partition (whether the commit happened by this process or another).
   * @param topicPartition topic partition for getting last committed offset
   * @return a future notified on operation completed
   */
  public io.reactivex.Single<io.vertx.kafka.client.consumer.OffsetAndMetadata> rxCommitted(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.committed(topicPartition).onComplete($handler);
    });
  }

  /**
   * Get metadata about the partitions for a given topic.
   * @param topic topic partition for which getting partitions info
   * @return a future notified on operation completed
   */
  public io.vertx.core.Future<java.util.List<io.vertx.kafka.client.common.PartitionInfo>> partitionsFor(java.lang.String topic) { 
    io.vertx.core.Future<java.util.List<io.vertx.kafka.client.common.PartitionInfo>> ret = delegate.partitionsFor(topic).map(val -> val);
    return ret;
  }

  /**
   * Get metadata about the partitions for a given topic.
   * @param topic topic partition for which getting partitions info
   * @return a future notified on operation completed
   */
  public io.reactivex.Single<java.util.List<io.vertx.kafka.client.common.PartitionInfo>> rxPartitionsFor(java.lang.String topic) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.partitionsFor(topic).onComplete($handler);
    });
  }

  /**
   * Set the handler to be used when batches of messages are fetched
   * from the Kafka server. Batch handlers need to take care not to block
   * the event loop when dealing with large batches. It is better to process
   * records individually using the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer #handler(Handler) record handler}.
   * @param handler handler called when batches of messages are fetched
   * @return current KafkaConsumer instance
   */
  public io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> batchHandler(io.vertx.core.Handler<io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecords<K,V>> handler) { 
    delegate.batchHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecords.newInstance((io.vertx.kafka.client.consumer.KafkaConsumerRecords)event, __typeArg_0, __typeArg_1)));
    return this;
  }

  /**
   * Close the consumer
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Close the consumer
   * @return 
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * Get the offset of the next record that will be fetched (if a record with that offset exists).
   * @param partition The partition to get the position for
   * @return a future notified on operation completed
   */
  public io.vertx.core.Future<java.lang.Long> position(io.vertx.kafka.client.common.TopicPartition partition) { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.position(partition).map(val -> val);
    return ret;
  }

  /**
   * Get the offset of the next record that will be fetched (if a record with that offset exists).
   * @param partition The partition to get the position for
   * @return a future notified on operation completed
   */
  public io.reactivex.Single<java.lang.Long> rxPosition(io.vertx.kafka.client.common.TopicPartition partition) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.position(partition).onComplete($handler);
    });
  }

  /**
   * Look up the offset for the given partition by timestamp. Note: the result might be null in case
   * for the given timestamp no offset can be found -- e.g., when the timestamp refers to the future
   * @param topicPartition TopicPartition to query.
   * @param timestamp Timestamp to be used in the query.
   * @return a future notified on operation completed
   */
  public io.vertx.core.Future<io.vertx.kafka.client.consumer.OffsetAndTimestamp> offsetsForTimes(io.vertx.kafka.client.common.TopicPartition topicPartition, java.lang.Long timestamp) { 
    io.vertx.core.Future<io.vertx.kafka.client.consumer.OffsetAndTimestamp> ret = delegate.offsetsForTimes(topicPartition, timestamp).map(val -> val);
    return ret;
  }

  /**
   * Look up the offset for the given partition by timestamp. Note: the result might be null in case
   * for the given timestamp no offset can be found -- e.g., when the timestamp refers to the future
   * @param topicPartition TopicPartition to query.
   * @param timestamp Timestamp to be used in the query.
   * @return a future notified on operation completed
   */
  public io.reactivex.Single<io.vertx.kafka.client.consumer.OffsetAndTimestamp> rxOffsetsForTimes(io.vertx.kafka.client.common.TopicPartition topicPartition, java.lang.Long timestamp) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.offsetsForTimes(topicPartition, timestamp).onComplete($handler);
    });
  }

  /**
   * Get the first offset for the given partitions.
   * @param topicPartition the partition to get the earliest offset.
   * @return a future notified on operation completed
   */
  public io.vertx.core.Future<java.lang.Long> beginningOffsets(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.beginningOffsets(topicPartition).map(val -> val);
    return ret;
  }

  /**
   * Get the first offset for the given partitions.
   * @param topicPartition the partition to get the earliest offset.
   * @return a future notified on operation completed
   */
  public io.reactivex.Single<java.lang.Long> rxBeginningOffsets(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.beginningOffsets(topicPartition).onComplete($handler);
    });
  }

  /**
   * Get the last offset for the given partition. The last offset of a partition is the offset
   * of the upcoming message, i.e. the offset of the last available message + 1.
   * @param topicPartition the partition to get the end offset.
   * @return a future notified on operation completed
   */
  public io.vertx.core.Future<java.lang.Long> endOffsets(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.endOffsets(topicPartition).map(val -> val);
    return ret;
  }

  /**
   * Get the last offset for the given partition. The last offset of a partition is the offset
   * of the upcoming message, i.e. the offset of the last available message + 1.
   * @param topicPartition the partition to get the end offset.
   * @return a future notified on operation completed
   */
  public io.reactivex.Single<java.lang.Long> rxEndOffsets(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.endOffsets(topicPartition).onComplete($handler);
    });
  }

  /**
   * Create a new KafkaConsumer instance from a native .
   * @param vertx Vert.x instance to use
   * @param consumer the Kafka consumer to wrap
   * @return an instance of the KafkaConsumer
   */
  public static <K, V> io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> create(io.vertx.reactivex.core.Vertx vertx, org.apache.kafka.clients.consumer.Consumer<K,V> consumer) { 
    io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> ret = io.vertx.reactivex.kafka.client.consumer.KafkaConsumer.newInstance((io.vertx.kafka.client.consumer.KafkaConsumer)io.vertx.kafka.client.consumer.KafkaConsumer.create(vertx.getDelegate(), consumer), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a new KafkaConsumer instance from a native .
   * @param vertx Vert.x instance to use
   * @param consumer the Kafka consumer to wrap
   * @param options options used only for tracing settings
   * @return an instance of the KafkaConsumer
   */
  public static <K, V> io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> create(io.vertx.reactivex.core.Vertx vertx, org.apache.kafka.clients.consumer.Consumer<K,V> consumer, io.vertx.kafka.client.common.KafkaClientOptions options) { 
    io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> ret = io.vertx.reactivex.kafka.client.consumer.KafkaConsumer.newInstance((io.vertx.kafka.client.consumer.KafkaConsumer)io.vertx.kafka.client.consumer.KafkaConsumer.create(vertx.getDelegate(), consumer, options), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Subscribe to all topics matching specified pattern to get dynamically assigned partitions.
   * <p>
   * Due to internal buffering of messages, when changing the subscribed topics
   * the old set of topics may remain in effect
   * (as observed by the  record handler})
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new set of topics.
   * @param pattern Pattern to subscribe to
   * @return a <code>Future</code> completed with the operation result
   */
  public io.vertx.core.Future<java.lang.Void> subscribe(java.util.regex.Pattern pattern) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.subscribe(pattern).map(val -> val);
    return ret;
  }

  /**
   * Subscribe to all topics matching specified pattern to get dynamically assigned partitions.
   * <p>
   * Due to internal buffering of messages, when changing the subscribed topics
   * the old set of topics may remain in effect
   * (as observed by the  record handler})
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.reactivex.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new set of topics.
   * @param pattern Pattern to subscribe to
   * @return a <code>Future</code> completed with the operation result
   */
  public io.reactivex.Completable rxSubscribe(java.util.regex.Pattern pattern) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.subscribe(pattern).onComplete($handler);
    });
  }

  /**
   * Sets the poll timeout for the underlying native Kafka Consumer. Defaults to 1000ms.
   * Setting timeout to a lower value results in a more 'responsive' client, because it will block for a shorter period
   * if no data is available in the assigned partition and therefore allows subsequent actions to be executed with a shorter
   * delay. At the same time, the client will poll more frequently and thus will potentially create a higher load on the Kafka Broker.
   * @param timeout The time, spent waiting in poll if data is not available in the buffer. If 0, returns immediately with any records that are available currently in the native Kafka consumer's buffer, else returns empty. Must not be negative.
   * @return 
   */
  public io.vertx.reactivex.kafka.client.consumer.KafkaConsumer<K,V> pollTimeout(java.time.Duration timeout) { 
    delegate.pollTimeout(timeout);
    return this;
  }

  /**
   * Executes a poll for getting messages from Kafka.
   * @param timeout The maximum time to block (must not be greater than {@link java.lang.Long} milliseconds)
   * @return a future notified on operation completed
   */
  public io.vertx.core.Future<io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecords<K,V>> poll(java.time.Duration timeout) { 
    io.vertx.core.Future<io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecords<K,V>> ret = delegate.poll(timeout).map(val -> io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecords.newInstance((io.vertx.kafka.client.consumer.KafkaConsumerRecords)val, __typeArg_0, __typeArg_1));
    return ret;
  }

  /**
   * Executes a poll for getting messages from Kafka.
   * @param timeout The maximum time to block (must not be greater than {@link java.lang.Long} milliseconds)
   * @return a future notified on operation completed
   */
  public io.reactivex.Single<io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecords<K,V>> rxPoll(java.time.Duration timeout) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.poll(timeout).onComplete($handler);
    });
  }

  public static <K,V> KafkaConsumer<K,V> newInstance(io.vertx.kafka.client.consumer.KafkaConsumer arg) {
    return arg != null ? new KafkaConsumer<K,V>(arg) : null;
  }

  public static <K,V> KafkaConsumer<K,V> newInstance(io.vertx.kafka.client.consumer.KafkaConsumer arg, TypeArg<K> __typeArg_K, TypeArg<V> __typeArg_V) {
    return arg != null ? new KafkaConsumer<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
