/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.kafka.admin;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Vert.x Kafka Admin client implementation
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.admin.KafkaAdminClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.kafka.admin.KafkaAdminClient.class)
public class KafkaAdminClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaAdminClient that = (KafkaAdminClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<KafkaAdminClient> __TYPE_ARG = new TypeArg<>(    obj -> new KafkaAdminClient((io.vertx.kafka.admin.KafkaAdminClient) obj),
    KafkaAdminClient::getDelegate
  );

  private final io.vertx.kafka.admin.KafkaAdminClient delegate;
  
  public KafkaAdminClient(io.vertx.kafka.admin.KafkaAdminClient delegate) {
    this.delegate = delegate;
  }

  public KafkaAdminClient(Object delegate) {
    this.delegate = (io.vertx.kafka.admin.KafkaAdminClient)delegate;
  }

  @Override 
  public io.vertx.kafka.admin.KafkaAdminClient getDelegate() {
    return delegate;
  }


  /**
   * Create a new KafkaAdminClient instance
   * @param vertx Vert.x instance to use
   * @param config Kafka admin client configuration
   * @return an instance of the KafkaAdminClient
   */
  public static io.vertx.reactivex.kafka.admin.KafkaAdminClient create(io.vertx.reactivex.core.Vertx vertx, java.util.Map<java.lang.String,java.lang.String> config) { 
    io.vertx.reactivex.kafka.admin.KafkaAdminClient ret = io.vertx.reactivex.kafka.admin.KafkaAdminClient.newInstance((io.vertx.kafka.admin.KafkaAdminClient)io.vertx.kafka.admin.KafkaAdminClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * List the topics available in the cluster with the default options.
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.util.Set<java.lang.String>> listTopics() { 
    io.vertx.core.Future<java.util.Set<java.lang.String>> ret = delegate.listTopics().map(val -> val);
    return ret;
  }

  /**
   * List the topics available in the cluster with the default options.
   * @return a future notified with the result
   */
  public io.reactivex.Single<java.util.Set<java.lang.String>> rxListTopics() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listTopics().onComplete($handler);
    });
  }

  /**
   * Describe some topics in the cluster, with the default options.
   * @param topicNames the names of the topics to describe
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.util.Map<java.lang.String,io.vertx.kafka.admin.TopicDescription>> describeTopics(java.util.List<java.lang.String> topicNames) { 
    io.vertx.core.Future<java.util.Map<java.lang.String,io.vertx.kafka.admin.TopicDescription>> ret = delegate.describeTopics(topicNames).map(val -> val);
    return ret;
  }

  /**
   * Describe some topics in the cluster, with the default options.
   * @param topicNames the names of the topics to describe
   * @return a future notified with the result
   */
  public io.reactivex.Single<java.util.Map<java.lang.String,io.vertx.kafka.admin.TopicDescription>> rxDescribeTopics(java.util.List<java.lang.String> topicNames) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.describeTopics(topicNames).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.kafka.admin.KafkaAdminClient#describeTopics} but allows for customised otions
   * @param topicNames 
   * @param options 
   * @return 
   */
  public io.vertx.core.Future<java.util.Map<java.lang.String,io.vertx.kafka.admin.TopicDescription>> describeTopics(java.util.List<java.lang.String> topicNames, io.vertx.kafka.admin.DescribeTopicsOptions options) { 
    io.vertx.core.Future<java.util.Map<java.lang.String,io.vertx.kafka.admin.TopicDescription>> ret = delegate.describeTopics(topicNames, options).map(val -> val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.kafka.admin.KafkaAdminClient#describeTopics} but allows for customised otions
   * @param topicNames 
   * @param options 
   * @return 
   */
  public io.reactivex.Single<java.util.Map<java.lang.String,io.vertx.kafka.admin.TopicDescription>> rxDescribeTopics(java.util.List<java.lang.String> topicNames, io.vertx.kafka.admin.DescribeTopicsOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.describeTopics(topicNames, options).onComplete($handler);
    });
  }

  /**
   * Creates a batch of new Kafka topics
   * @param topics topics to create
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.lang.Void> createTopics(java.util.List<io.vertx.kafka.admin.NewTopic> topics) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.createTopics(topics).map(val -> val);
    return ret;
  }

  /**
   * Creates a batch of new Kafka topics
   * @param topics topics to create
   * @return a future notified with the result
   */
  public io.reactivex.Completable rxCreateTopics(java.util.List<io.vertx.kafka.admin.NewTopic> topics) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.createTopics(topics).onComplete($handler);
    });
  }

  /**
   * Deletes a batch of Kafka topics
   * @param topicNames the names of the topics to delete
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.lang.Void> deleteTopics(java.util.List<java.lang.String> topicNames) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.deleteTopics(topicNames).map(val -> val);
    return ret;
  }

  /**
   * Deletes a batch of Kafka topics
   * @param topicNames the names of the topics to delete
   * @return a future notified with the result
   */
  public io.reactivex.Completable rxDeleteTopics(java.util.List<java.lang.String> topicNames) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.deleteTopics(topicNames).onComplete($handler);
    });
  }

  /**
   * Creates a batch of new partitions in the Kafka topic
   * @param partitions partitions to create
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.lang.Void> createPartitions(java.util.Map<java.lang.String,io.vertx.kafka.admin.NewPartitions> partitions) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.createPartitions(partitions).map(val -> val);
    return ret;
  }

  /**
   * Creates a batch of new partitions in the Kafka topic
   * @param partitions partitions to create
   * @return a future notified with the result
   */
  public io.reactivex.Completable rxCreatePartitions(java.util.Map<java.lang.String,io.vertx.kafka.admin.NewPartitions> partitions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.createPartitions(partitions).onComplete($handler);
    });
  }

  /**
   * Get the the consumer groups available in the cluster with the default options
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.util.List<io.vertx.kafka.admin.ConsumerGroupListing>> listConsumerGroups() { 
    io.vertx.core.Future<java.util.List<io.vertx.kafka.admin.ConsumerGroupListing>> ret = delegate.listConsumerGroups().map(val -> val);
    return ret;
  }

  /**
   * Get the the consumer groups available in the cluster with the default options
   * @return a future notified with the result
   */
  public io.reactivex.Single<java.util.List<io.vertx.kafka.admin.ConsumerGroupListing>> rxListConsumerGroups() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listConsumerGroups().onComplete($handler);
    });
  }

  /**
   * Describe some group ids in the cluster, with the default options
   * @param groupIds the ids of the groups to describe
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.util.Map<java.lang.String,io.vertx.kafka.admin.ConsumerGroupDescription>> describeConsumerGroups(java.util.List<java.lang.String> groupIds) { 
    io.vertx.core.Future<java.util.Map<java.lang.String,io.vertx.kafka.admin.ConsumerGroupDescription>> ret = delegate.describeConsumerGroups(groupIds).map(val -> val);
    return ret;
  }

  /**
   * Describe some group ids in the cluster, with the default options
   * @param groupIds the ids of the groups to describe
   * @return a future notified with the result
   */
  public io.reactivex.Single<java.util.Map<java.lang.String,io.vertx.kafka.admin.ConsumerGroupDescription>> rxDescribeConsumerGroups(java.util.List<java.lang.String> groupIds) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.describeConsumerGroups(groupIds).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.kafka.admin.KafkaAdminClient#describeConsumerGroups} but allows customized options
   * @param groupIds 
   * @param options 
   * @return 
   */
  public io.vertx.core.Future<java.util.Map<java.lang.String,io.vertx.kafka.admin.ConsumerGroupDescription>> describeConsumerGroups(java.util.List<java.lang.String> groupIds, io.vertx.kafka.admin.DescribeConsumerGroupsOptions options) { 
    io.vertx.core.Future<java.util.Map<java.lang.String,io.vertx.kafka.admin.ConsumerGroupDescription>> ret = delegate.describeConsumerGroups(groupIds, options).map(val -> val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.kafka.admin.KafkaAdminClient#describeConsumerGroups} but allows customized options
   * @param groupIds 
   * @param options 
   * @return 
   */
  public io.reactivex.Single<java.util.Map<java.lang.String,io.vertx.kafka.admin.ConsumerGroupDescription>> rxDescribeConsumerGroups(java.util.List<java.lang.String> groupIds, io.vertx.kafka.admin.DescribeConsumerGroupsOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.describeConsumerGroups(groupIds, options).onComplete($handler);
    });
  }

  /**
   * Describe the nodes in the cluster with the default options
   * @return a future notified with the result
   */
  public io.vertx.core.Future<io.vertx.kafka.admin.ClusterDescription> describeCluster() { 
    io.vertx.core.Future<io.vertx.kafka.admin.ClusterDescription> ret = delegate.describeCluster().map(val -> val);
    return ret;
  }

  /**
   * Describe the nodes in the cluster with the default options
   * @return a future notified with the result
   */
  public io.reactivex.Single<io.vertx.kafka.admin.ClusterDescription> rxDescribeCluster() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.describeCluster().onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.kafka.admin.KafkaAdminClient#describeCluster} but allows customized options.
   * @param options 
   * @return 
   */
  public io.vertx.core.Future<io.vertx.kafka.admin.ClusterDescription> describeCluster(io.vertx.kafka.admin.DescribeClusterOptions options) { 
    io.vertx.core.Future<io.vertx.kafka.admin.ClusterDescription> ret = delegate.describeCluster(options).map(val -> val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.kafka.admin.KafkaAdminClient#describeCluster} but allows customized options.
   * @param options 
   * @return 
   */
  public io.reactivex.Single<io.vertx.kafka.admin.ClusterDescription> rxDescribeCluster(io.vertx.kafka.admin.DescribeClusterOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.describeCluster(options).onComplete($handler);
    });
  }

  /**
   * Delete consumer groups from the cluster.
   * @param groupIds the ids of the groups to delete
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.lang.Void> deleteConsumerGroups(java.util.List<java.lang.String> groupIds) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.deleteConsumerGroups(groupIds).map(val -> val);
    return ret;
  }

  /**
   * Delete consumer groups from the cluster.
   * @param groupIds the ids of the groups to delete
   * @return a future notified with the result
   */
  public io.reactivex.Completable rxDeleteConsumerGroups(java.util.List<java.lang.String> groupIds) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.deleteConsumerGroups(groupIds).onComplete($handler);
    });
  }

  /**
   * Delete committed offsets for a set of partitions in a consumer group. This will
   * succeed at the partition level only if the group is not actively subscribed
   * to the corresponding topic.
   * @param groupId The group id of the group whose offsets will be deleted
   * @param partitions 
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.lang.Void> deleteConsumerGroupOffsets(java.lang.String groupId, java.util.Set<io.vertx.kafka.client.common.TopicPartition> partitions) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.deleteConsumerGroupOffsets(groupId, partitions).map(val -> val);
    return ret;
  }

  /**
   * Delete committed offsets for a set of partitions in a consumer group. This will
   * succeed at the partition level only if the group is not actively subscribed
   * to the corresponding topic.
   * @param groupId The group id of the group whose offsets will be deleted
   * @param partitions 
   * @return a future notified with the result
   */
  public io.reactivex.Completable rxDeleteConsumerGroupOffsets(java.lang.String groupId, java.util.Set<io.vertx.kafka.client.common.TopicPartition> partitions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.deleteConsumerGroupOffsets(groupId, partitions).onComplete($handler);
    });
  }

  /**
   * Close the admin client
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Close the admin client
   * @return a future notified with the result
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * Close the admin client
   * @param timeout timeout to wait for closing
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.lang.Void> close(long timeout) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close(timeout).map(val -> val);
    return ret;
  }

  /**
   * Close the admin client
   * @param timeout timeout to wait for closing
   * @return a future notified with the result
   */
  public io.reactivex.Completable rxClose(long timeout) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close(timeout).onComplete($handler);
    });
  }

  /**
   * Describe the ACL rules.
   * @param aclBindingFilter The filter to use.
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.util.List<org.apache.kafka.common.acl.AclBinding>> describeAcls(org.apache.kafka.common.acl.AclBindingFilter aclBindingFilter) { 
    io.vertx.core.Future<java.util.List<org.apache.kafka.common.acl.AclBinding>> ret = delegate.describeAcls(aclBindingFilter).map(val -> val);
    return ret;
  }

  /**
   * Describe the ACL rules.
   * @param aclBindingFilter The filter to use.
   * @return a future notified with the result
   */
  public io.reactivex.Single<java.util.List<org.apache.kafka.common.acl.AclBinding>> rxDescribeAcls(org.apache.kafka.common.acl.AclBindingFilter aclBindingFilter) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.describeAcls(aclBindingFilter).onComplete($handler);
    });
  }

  /**
   * Create the ACL rules.
   * @param aclBindings The ACL to create.
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.util.List<org.apache.kafka.common.acl.AclBinding>> createAcls(java.util.List<org.apache.kafka.common.acl.AclBinding> aclBindings) { 
    io.vertx.core.Future<java.util.List<org.apache.kafka.common.acl.AclBinding>> ret = delegate.createAcls(aclBindings).map(val -> val);
    return ret;
  }

  /**
   * Create the ACL rules.
   * @param aclBindings The ACL to create.
   * @return a future notified with the result
   */
  public io.reactivex.Single<java.util.List<org.apache.kafka.common.acl.AclBinding>> rxCreateAcls(java.util.List<org.apache.kafka.common.acl.AclBinding> aclBindings) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.createAcls(aclBindings).onComplete($handler);
    });
  }

  /**
   * Delete the ACL rules.
   * @param aclBindings The filter to delete matching ACLs.
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.util.List<org.apache.kafka.common.acl.AclBinding>> deleteAcls(java.util.List<org.apache.kafka.common.acl.AclBindingFilter> aclBindings) { 
    io.vertx.core.Future<java.util.List<org.apache.kafka.common.acl.AclBinding>> ret = delegate.deleteAcls(aclBindings).map(val -> val);
    return ret;
  }

  /**
   * Delete the ACL rules.
   * @param aclBindings The filter to delete matching ACLs.
   * @return a future notified with the result
   */
  public io.reactivex.Single<java.util.List<org.apache.kafka.common.acl.AclBinding>> rxDeleteAcls(java.util.List<org.apache.kafka.common.acl.AclBindingFilter> aclBindings) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.deleteAcls(aclBindings).onComplete($handler);
    });
  }

  public static KafkaAdminClient newInstance(io.vertx.kafka.admin.KafkaAdminClient arg) {
    return arg != null ? new KafkaAdminClient(arg) : null;
  }

}
